/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.authorization;

import java.util.Arrays;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.identity.Group;
import org.eximeebpms.bpm.engine.identity.User;
import org.eximeebpms.bpm.engine.test.api.authorization.AuthorizationTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class DefaultUserPermissionsForTaskTest
extends AuthorizationTest {
    protected String userId2 = "demo";
    protected User user2;
    protected String groupId2 = "accounting2";
    protected Group group2;
    protected String defaultTaskPermissionValue;

    @Override
    @After
    public void tearDown() {
        this.processEngineConfiguration.setDefaultUserPermissionForTask((Permission)Permissions.UPDATE);
        super.tearDown();
    }

    @Test
    public void testShouldGrantTaskWorkOnAssign() {
        this.processEngineConfiguration.setDefaultUserPermissionForTask((Permission)Permissions.TASK_WORK);
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.processEngine.getTaskService().setAssignee(taskId, this.userId2);
        Assert.assertEquals((Object)true, (Object)this.authorizationService.isUserAuthorized(this.userId2, null, (Permission)Permissions.READ, (Resource)Resources.TASK, taskId));
        Assert.assertEquals((Object)true, (Object)this.authorizationService.isUserAuthorized(this.userId2, null, (Permission)Permissions.TASK_WORK, (Resource)Resources.TASK, taskId));
        Assert.assertEquals((Object)false, (Object)this.authorizationService.isUserAuthorized(this.userId2, null, (Permission)Permissions.UPDATE, (Resource)Resources.TASK, taskId));
        this.deleteTask(taskId, true);
    }

    @Test
    public void testShouldGrantUpdateOnAssign() {
        this.processEngineConfiguration.setDefaultUserPermissionForTask((Permission)Permissions.UPDATE);
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.processEngine.getTaskService().setAssignee(taskId, this.userId2);
        Assert.assertEquals((Object)true, (Object)this.authorizationService.isUserAuthorized(this.userId2, null, (Permission)Permissions.READ, (Resource)Resources.TASK, taskId));
        Assert.assertEquals((Object)true, (Object)this.authorizationService.isUserAuthorized(this.userId2, null, (Permission)Permissions.UPDATE, (Resource)Resources.TASK, taskId));
        this.deleteTask(taskId, true);
    }

    @Test
    public void testShouldGrantTaskWorkOnSetCandidateUser() {
        this.processEngineConfiguration.setDefaultUserPermissionForTask((Permission)Permissions.TASK_WORK);
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.processEngine.getTaskService().addCandidateUser(taskId, this.userId2);
        Assert.assertEquals((Object)true, (Object)this.authorizationService.isUserAuthorized(this.userId2, null, (Permission)Permissions.READ, (Resource)Resources.TASK, taskId));
        Assert.assertEquals((Object)true, (Object)this.authorizationService.isUserAuthorized(this.userId2, null, (Permission)Permissions.TASK_WORK, (Resource)Resources.TASK, taskId));
        Assert.assertEquals((Object)false, (Object)this.authorizationService.isUserAuthorized(this.userId2, null, (Permission)Permissions.UPDATE, (Resource)Resources.TASK, taskId));
        this.deleteTask(taskId, true);
    }

    @Test
    public void testShouldGrantUpdateOnSetCandidateUser() {
        this.processEngineConfiguration.setDefaultUserPermissionForTask((Permission)Permissions.UPDATE);
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.processEngine.getTaskService().addCandidateUser(taskId, this.userId2);
        Assert.assertEquals((Object)true, (Object)this.authorizationService.isUserAuthorized(this.userId2, null, (Permission)Permissions.READ, (Resource)Resources.TASK, taskId));
        Assert.assertEquals((Object)true, (Object)this.authorizationService.isUserAuthorized(this.userId2, null, (Permission)Permissions.UPDATE, (Resource)Resources.TASK, taskId));
        this.deleteTask(taskId, true);
    }

    @Test
    public void testShouldGrantTaskWorkOnSetOwner() {
        this.processEngineConfiguration.setDefaultUserPermissionForTask((Permission)Permissions.TASK_WORK);
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.processEngine.getTaskService().setOwner(taskId, this.userId2);
        Assert.assertEquals((Object)true, (Object)this.authorizationService.isUserAuthorized(this.userId2, null, (Permission)Permissions.READ, (Resource)Resources.TASK, taskId));
        Assert.assertEquals((Object)true, (Object)this.authorizationService.isUserAuthorized(this.userId2, null, (Permission)Permissions.TASK_WORK, (Resource)Resources.TASK, taskId));
        Assert.assertEquals((Object)false, (Object)this.authorizationService.isUserAuthorized(this.userId2, null, (Permission)Permissions.UPDATE, (Resource)Resources.TASK, taskId));
        this.deleteTask(taskId, true);
    }

    @Test
    public void testShouldGrantUpdateOnSetOwner() {
        this.processEngineConfiguration.setDefaultUserPermissionForTask((Permission)Permissions.UPDATE);
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.processEngine.getTaskService().setOwner(taskId, this.userId2);
        Assert.assertEquals((Object)true, (Object)this.authorizationService.isUserAuthorized(this.userId2, null, (Permission)Permissions.READ, (Resource)Resources.TASK, taskId));
        Assert.assertEquals((Object)true, (Object)this.authorizationService.isUserAuthorized(this.userId2, null, (Permission)Permissions.UPDATE, (Resource)Resources.TASK, taskId));
        this.deleteTask(taskId, true);
    }

    @Test
    public void testShouldGrantTaskWorkOnSetCandidateGroup() {
        this.processEngineConfiguration.setDefaultUserPermissionForTask((Permission)Permissions.TASK_WORK);
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.processEngine.getTaskService().addCandidateGroup(taskId, this.groupId);
        Assert.assertEquals((Object)true, (Object)this.authorizationService.isUserAuthorized(this.userId2, Arrays.asList(this.groupId), (Permission)Permissions.READ, (Resource)Resources.TASK, taskId));
        Assert.assertEquals((Object)true, (Object)this.authorizationService.isUserAuthorized(this.userId2, Arrays.asList(this.groupId), (Permission)Permissions.TASK_WORK, (Resource)Resources.TASK, taskId));
        Assert.assertEquals((Object)false, (Object)this.authorizationService.isUserAuthorized(this.userId2, Arrays.asList(this.groupId), (Permission)Permissions.UPDATE, (Resource)Resources.TASK, taskId));
        this.deleteTask(taskId, true);
    }

    @Test
    public void testShouldGrantUpdateOnSetCandidateGroup() {
        this.processEngineConfiguration.setDefaultUserPermissionForTask((Permission)Permissions.UPDATE);
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.processEngine.getTaskService().addCandidateGroup(taskId, this.groupId);
        Assert.assertEquals((Object)true, (Object)this.authorizationService.isUserAuthorized(this.userId2, Arrays.asList(this.groupId), (Permission)Permissions.READ, (Resource)Resources.TASK, taskId));
        Assert.assertEquals((Object)true, (Object)this.authorizationService.isUserAuthorized(this.userId2, Arrays.asList(this.groupId), (Permission)Permissions.UPDATE, (Resource)Resources.TASK, taskId));
        this.deleteTask(taskId, true);
    }
}

