/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.authorization.batch.creation;

import java.util.ArrayList;
import java.util.Collection;
import org.eximeebpms.bpm.engine.authorization.BatchPermissions;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.batch.Batch;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.ModificationBuilder;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.api.authorization.batch.creation.BatchCreationAuthorizationTest;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;

public class ModificationBatchAuthorizationTest
extends BatchCreationAuthorizationTest {
    @Parameterized.Parameters(name="Scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenario.scenario().withoutAuthorizations().failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.BATCH, "batchId", "userId", new Permission[]{Permissions.CREATE}), AuthorizationSpec.grant((Resource)Resources.BATCH, "batchId", "userId", new Permission[]{BatchPermissions.CREATE_BATCH_MODIFY_PROCESS_INSTANCES})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.BATCH, "batchId", "userId", new Permission[]{Permissions.CREATE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.BATCH, "batchId", "userId", new Permission[]{BatchPermissions.CREATE_BATCH_MODIFY_PROCESS_INSTANCES})).succeeds());
    }

    @Test
    public void createBatchModification() {
        BpmnModelInstance instance = Bpmn.createExecutableProcess((String)"process1").startEvent().userTask("user1").userTask("user2").endEvent().done();
        ProcessDefinition processDefinition = this.testHelper.deployAndGetDefinition(instance);
        ArrayList<String> instances = new ArrayList<String>();
        for (int i = 0; i < 2; ++i) {
            ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("process1");
            instances.add(processInstance.getId());
        }
        this.authRule.init(this.scenario).withUser("userId").bindResource("batchId", "*").start();
        ((ModificationBuilder)this.engineRule.getRuntimeService().createModification(processDefinition.getId()).startAfterActivity("user1")).processInstanceIds(instances).executeAsync();
        if (this.authRule.assertScenario(this.scenario)) {
            Batch batch = (Batch)this.engineRule.getManagementService().createBatchQuery().singleResult();
            Assert.assertEquals((Object)"userId", (Object)batch.getCreateUserId());
        }
    }
}

