/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.authorization.externaltask;

import org.eximeebpms.bpm.engine.externaltask.ExternalTask;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.api.authorization.externaltask.HandleExternalTaskAuthorizationTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LockExternalTaskAuthorizationTest
extends HandleExternalTaskAuthorizationTest {
    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void shouldLockExternalTaskWithAuthorizations() {
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("oneExternalTaskProcess");
        ExternalTask externalTask = (ExternalTask)this.engineRule.getExternalTaskService().createExternalTaskQuery().notLocked().singleResult();
        this.authRule.init(this.scenario).withUser("userId").bindResource("processInstanceId", processInstance.getId()).bindResource("processDefinitionKey", "oneExternalTaskProcess").start();
        this.engineRule.getExternalTaskService().lock(externalTask.getId(), "workerId", 2000L);
        if (this.authRule.assertScenario(this.scenario)) {
            ExternalTask lockedTask = (ExternalTask)this.engineRule.getExternalTaskService().createExternalTaskQuery().locked().singleResult();
            Assert.assertNotNull((Object)lockedTask);
        }
    }
}

