/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.authorization.history;

import java.util.Date;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.authorization.HistoricProcessInstancePermissions;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.history.HistoricIncident;
import org.eximeebpms.bpm.engine.history.HistoricIncidentQuery;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.db.DbEntity;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandExecutor;
import org.eximeebpms.bpm.engine.impl.persistence.entity.HistoricIncidentEntity;
import org.eximeebpms.bpm.engine.query.Query;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.api.authorization.AuthorizationTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@RequiredHistoryLevel(value="full")
public class HistoricIncidentAuthorizationTest
extends AuthorizationTest {
    protected static final String TIMER_START_PROCESS_KEY = "timerStartProcess";
    protected static final String ONE_INCIDENT_PROCESS_KEY = "process";
    protected static final String ANOTHER_ONE_INCIDENT_PROCESS_KEY = "anotherOneIncidentProcess";
    protected String deploymentId;

    @Override
    @Before
    public void setUp() throws Exception {
        this.deploymentId = this.testRule.deploy("org/eximeebpms/bpm/engine/test/api/authorization/timerStartEventProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/authorization/oneIncidentProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/authorization/anotherOneIncidentProcess.bpmn20.xml").getId();
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(false);
    }

    @Test
    public void testQueryForStandaloneHistoricIncidents() {
        this.disableAuthorization();
        this.repositoryService.suspendProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY, true, new Date());
        String jobId = null;
        List jobs = this.managementService.createJobQuery().list();
        for (Job job : jobs) {
            if (job.getProcessDefinitionKey() != null) continue;
            jobId = job.getId();
            break;
        }
        this.managementService.setJobRetries(jobId, 0);
        this.enableAuthorization();
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        this.disableAuthorization();
        this.managementService.deleteJob(jobId);
        this.enableAuthorization();
        this.clearDatabase();
    }

    @Test
    public void testStartTimerJobIncidentQueryWithoutAuthorization() {
        this.disableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        this.enableAuthorization();
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testStartTimerJobIncidentQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.disableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    @Test
    public void testStartTimerJobIncidentQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.disableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    @Test
    public void testStartTimerJobIncidentQueryWithReadInstancePermissionOnAnyProcessDefinition() {
        this.disableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    @Test
    public void testSimpleQueryWithoutAuthorization() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testSimpleQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    @Test
    public void testSimpleQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    @Test
    public void testSimpleQueryWithMultiple() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    @Test
    public void testCheckNonePermissionOnHistoricProcessInstance() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getProcessInstanceId();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.NONE});
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        Assertions.assertThat((List)query.list()).isEmpty();
    }

    @Test
    public void testCheckReadPermissionOnHistoricProcessInstance() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getProcessInstanceId();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.READ});
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    @Test
    public void testCheckNoneOnHistoricProcessInstanceAndReadHistoryPermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getProcessInstanceId();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.NONE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_HISTORY});
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    @Test
    public void testCheckReadOnHistoricProcessInstanceAndNonePermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getProcessInstanceId();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.NONE});
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    @Test
    public void testHistoricProcessInstancePermissionsAuthorizationDisabled() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getProcessInstanceId();
        this.disableAuthorization();
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().processInstanceId(processInstanceId);
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    @Test
    public void shouldNotFindIncidentWithRevokedReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", "*", new Permission[]{Permissions.READ_HISTORY});
        this.createRevokeAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testQueryWithoutAuthorization() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        this.verifyQueryResults((Query<?, ?>)query, 2);
    }

    @Test
    public void testQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        this.verifyQueryResults((Query<?, ?>)query, 5);
    }

    @Test
    public void testMixedQueryWithoutAuthorization() {
        this.disableAuthorization();
        this.repositoryService.suspendProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY, true, new Date());
        String firstJobId = null;
        List jobs = this.managementService.createJobQuery().withRetriesLeft().list();
        for (Object job : jobs) {
            if (job.getProcessDefinitionKey() != null) continue;
            firstJobId = job.getId();
            break;
        }
        this.managementService.setJobRetries(firstJobId, 0);
        this.repositoryService.suspendProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY, true, new Date());
        String secondJobId = null;
        jobs = this.managementService.createJobQuery().withRetriesLeft().list();
        for (Job job : jobs) {
            if (job.getProcessDefinitionKey() != null) continue;
            secondJobId = job.getId();
            break;
        }
        this.managementService.setJobRetries(secondJobId, 0);
        this.enableAuthorization();
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        this.verifyQueryResults((Query<?, ?>)query, 2);
        this.disableAuthorization();
        this.managementService.deleteJob(firstJobId);
        this.managementService.deleteJob(secondJobId);
        this.enableAuthorization();
        this.clearDatabase();
    }

    @Test
    public void testMixedQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.disableAuthorization();
        this.repositoryService.suspendProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY, true, new Date());
        String firstJobId = null;
        List jobs = this.managementService.createJobQuery().withRetriesLeft().list();
        for (Object job : jobs) {
            if (job.getProcessDefinitionKey() != null) continue;
            firstJobId = job.getId();
            break;
        }
        this.managementService.setJobRetries(firstJobId, 0);
        this.repositoryService.suspendProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY, true, new Date());
        String secondJobId = null;
        jobs = this.managementService.createJobQuery().withRetriesLeft().list();
        for (Job job : jobs) {
            if (job.getProcessDefinitionKey() != null) continue;
            secondJobId = job.getId();
            break;
        }
        this.managementService.setJobRetries(secondJobId, 0);
        this.enableAuthorization();
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        this.verifyQueryResults((Query<?, ?>)query, 4);
        this.disableAuthorization();
        this.managementService.deleteJob(firstJobId);
        this.managementService.deleteJob(secondJobId);
        this.enableAuthorization();
        this.clearDatabase();
    }

    @Test
    public void testMixedQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.disableAuthorization();
        this.repositoryService.suspendProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY, true, new Date());
        String firstJobId = null;
        List jobs = this.managementService.createJobQuery().withRetriesLeft().list();
        for (Object job : jobs) {
            if (job.getProcessDefinitionKey() != null) continue;
            firstJobId = job.getId();
            break;
        }
        this.managementService.setJobRetries(firstJobId, 0);
        this.repositoryService.suspendProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY, true, new Date());
        String secondJobId = null;
        jobs = this.managementService.createJobQuery().withRetriesLeft().list();
        for (Job job : jobs) {
            if (job.getProcessDefinitionKey() != null) continue;
            secondJobId = job.getId();
            break;
        }
        this.managementService.setJobRetries(secondJobId, 0);
        this.enableAuthorization();
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        this.verifyQueryResults((Query<?, ?>)query, 7);
        this.disableAuthorization();
        this.managementService.deleteJob(firstJobId);
        this.managementService.deleteJob(secondJobId);
        this.enableAuthorization();
        this.clearDatabase();
    }

    protected void clearDatabase() {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("suspend-processdefinition");
                List incidents = Context.getProcessEngineConfiguration().getHistoryService().createHistoricIncidentQuery().list();
                for (HistoricIncident incident : incidents) {
                    commandContext.getHistoricIncidentManager().delete((DbEntity)((HistoricIncidentEntity)incident));
                }
                return null;
            }
        });
    }
}

