/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.authorization.history;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.eximeebpms.bpm.engine.AuthorizationException;
import org.eximeebpms.bpm.engine.authorization.HistoricProcessInstancePermissions;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.history.HistoricJobLog;
import org.eximeebpms.bpm.engine.history.HistoricJobLogQuery;
import org.eximeebpms.bpm.engine.history.HistoricProcessInstance;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandExecutor;
import org.eximeebpms.bpm.engine.query.Query;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.api.authorization.AuthorizationTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@RequiredHistoryLevel(value="full")
public class HistoricJobLogAuthorizationTest
extends AuthorizationTest {
    protected static final String TIMER_START_PROCESS_KEY = "timerStartProcess";
    protected static final String TIMER_BOUNDARY_PROCESS_KEY = "timerBoundaryProcess";
    protected static final String ONE_INCIDENT_PROCESS_KEY = "process";
    protected String batchId;
    protected String deploymentId;

    @Override
    @Before
    public void setUp() throws Exception {
        this.deploymentId = this.testRule.deploy("org/eximeebpms/bpm/engine/test/api/authorization/timerStartEventProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/authorization/timerBoundaryEventProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/authorization/oneIncidentProcess.bpmn20.xml").getId();
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("suspend-processdefinition");
                return null;
            }
        });
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(false);
        if (this.batchId != null) {
            this.managementService.deleteBatch(this.batchId, true);
            this.batchId = null;
        }
    }

    @Test
    public void testStartTimerJobLogQueryWithoutAuthorization() {
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testStartTimerJobLogQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    @Test
    public void testStartTimerJobLogQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    @Test
    public void testSimpleQueryWithoutAuthorization() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testSimpleQueryWithHistoryReadPermissionOnProcessDefinition() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 4);
    }

    @Test
    public void testSimpleQueryWithHistoryReadPermissionOnAnyProcessDefinition() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 5);
    }

    @Test
    public void testSimpleQueryWithMultiple() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 5);
    }

    @Test
    public void shouldNotFindJobLogWithRevokedHistoryReadPermissionOnAnyProcessDefinition() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", "*", new Permission[]{Permissions.READ_HISTORY});
        this.createRevokeAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testQueryWithoutAuthorization() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.disableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().processDefinitionKey(TIMER_START_PROCESS_KEY).singleResult()).getId();
        this.managementService.executeJob(jobId);
        jobId = ((Job)this.managementService.createJobQuery().processDefinitionKey(TIMER_START_PROCESS_KEY).singleResult()).getId();
        this.managementService.executeJob(jobId);
        this.enableAuthorization();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testQueryWithHistoryReadPermissionOnProcessDefinition() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.disableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().processDefinitionKey(TIMER_START_PROCESS_KEY).singleResult()).getId();
        this.managementService.executeJob(jobId);
        jobId = ((Job)this.managementService.createJobQuery().processDefinitionKey(TIMER_START_PROCESS_KEY).singleResult()).getId();
        this.managementService.executeJob(jobId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 12);
    }

    @Test
    public void testQueryWithHistoryReadPermissionOnAnyProcessDefinition() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.disableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().processDefinitionKey(TIMER_START_PROCESS_KEY).singleResult()).getId();
        this.managementService.executeJob(jobId);
        jobId = ((Job)this.managementService.createJobQuery().processDefinitionKey(TIMER_START_PROCESS_KEY).singleResult()).getId();
        this.managementService.executeJob(jobId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 17);
    }

    @Test
    public void testQueryAfterStandaloneJob() {
        this.disableAuthorization();
        this.repositoryService.suspendProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY, true, new Date());
        this.enableAuthorization();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        HistoricJobLog jobLog = (HistoricJobLog)query.singleResult();
        Assert.assertNull((Object)jobLog.getProcessDefinitionKey());
        this.deleteDeployment(this.deploymentId);
        this.disableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.deleteJob(jobId);
        this.enableAuthorization();
    }

    @Test
    public void testQueryAfterDeletingDeployment() {
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.enableAuthorization();
        this.disableAuthorization();
        this.repositoryService.deleteDeployment(this.deploymentId);
        this.enableAuthorization();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 6);
        this.disableAuthorization();
        List instances = this.historyService.createHistoricProcessInstanceQuery().list();
        for (HistoricProcessInstance instance : instances) {
            this.historyService.deleteHistoricProcessInstance(instance.getId());
        }
        this.enableAuthorization();
    }

    @Test
    public void testGetHistoricStandaloneJobLogExceptionStacktrace() {
        this.disableAuthorization();
        this.repositoryService.suspendProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY, true, new Date());
        this.enableAuthorization();
        String jobLogId = ((HistoricJobLog)this.historyService.createHistoricJobLogQuery().singleResult()).getId();
        String stacktrace = this.historyService.getHistoricJobLogExceptionStacktrace(jobLogId);
        Assert.assertNull((Object)stacktrace);
        this.deleteDeployment(this.deploymentId);
        this.disableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.deleteJob(jobId);
        this.enableAuthorization();
    }

    @Test
    public void testGetHistoricJobLogExceptionStacktraceWithoutAuthorization() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.disableAuthorization();
        String jobLogId = ((HistoricJobLog)this.historyService.createHistoricJobLogQuery().failureLog().listPage(0, 1).get(0)).getId();
        this.enableAuthorization();
        try {
            this.historyService.getHistoricJobLogExceptionStacktrace(jobLogId);
            Assert.fail((String)"Exception expected: It should not be possible to get the historic job log exception stacktrace");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ_HISTORY.getName(), message);
            this.testRule.assertTextPresent(ONE_INCIDENT_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testGetHistoricJobLogExceptionStacktraceWithReadHistoryPermissionOnProcessDefinition() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.disableAuthorization();
        String jobLogId = ((HistoricJobLog)this.historyService.createHistoricJobLogQuery().failureLog().listPage(0, 1).get(0)).getId();
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        String stacktrace = this.historyService.getHistoricJobLogExceptionStacktrace(jobLogId);
        Assert.assertNotNull((Object)stacktrace);
    }

    @Test
    public void testGetHistoricJobLogExceptionStacktraceWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.disableAuthorization();
        String jobLogId = ((HistoricJobLog)this.historyService.createHistoricJobLogQuery().failureLog().listPage(0, 1).get(0)).getId();
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        String stacktrace = this.historyService.getHistoricJobLogExceptionStacktrace(jobLogId);
        Assert.assertNotNull((Object)stacktrace);
    }

    @Test
    public void testCheckNonePermissionOnHistoricProcessInstance() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getProcessInstanceId();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.NONE});
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        Assertions.assertThat((List)query.list()).isEmpty();
    }

    @Test
    public void testCheckReadPermissionOnHistoricProcessInstance() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getProcessInstanceId();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.READ});
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId, processInstanceId, processInstanceId, processInstanceId});
    }

    @Test
    public void testCheckNoneOnHistoricProcessInstanceAndReadHistoryPermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getProcessInstanceId();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.NONE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId, processInstanceId, processInstanceId, processInstanceId});
    }

    @Test
    public void testCheckReadOnHistoricProcessInstanceAndNonePermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getProcessInstanceId();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.NONE});
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId, processInstanceId, processInstanceId, processInstanceId});
    }

    @Test
    public void testHistoricProcessInstancePermissionsAuthorizationDisabled() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getProcessInstanceId();
        this.disableAuthorization();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().processInstanceId(processInstanceId);
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId, processInstanceId, processInstanceId, processInstanceId});
    }

    @Test
    public void testSkipAuthOnNonProcessJob() {
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getProcessInstanceId();
        this.disableAuthorization();
        this.batchId = this.runtimeService.deleteProcessInstancesAsync(Arrays.asList(processInstanceId), "bar").getId();
        this.enableAuthorization();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        Assertions.assertThat((List)query.list()).extracting(new String[]{"jobDefinitionType", "processInstanceId"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"batch-seed-job", null})});
    }

    @Test
    public void testSkipAuthOnNonProcessJob_HistoricInstancePermissionsEnabled() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getProcessInstanceId();
        this.disableAuthorization();
        this.batchId = this.runtimeService.deleteProcessInstancesAsync(Arrays.asList(processInstanceId), "bar").getId();
        this.enableAuthorization();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        Assertions.assertThat((List)query.list()).extracting(new String[]{"jobDefinitionType", "processInstanceId"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"batch-seed-job", null})});
    }
}

