/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.authorization.history;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.time.DateUtils;
import org.eximeebpms.bpm.engine.AuthorizationException;
import org.eximeebpms.bpm.engine.history.HistoricCaseInstance;
import org.eximeebpms.bpm.engine.history.HistoricDecisionInstance;
import org.eximeebpms.bpm.engine.history.HistoricIncident;
import org.eximeebpms.bpm.engine.impl.db.DbEntity;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.metrics.Meter;
import org.eximeebpms.bpm.engine.impl.persistence.entity.HistoricIncidentEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.JobEntity;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.repository.CaseDefinition;
import org.eximeebpms.bpm.engine.repository.DecisionDefinition;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.CaseInstance;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.api.authorization.AuthorizationTest;
import org.eximeebpms.bpm.engine.test.dmn.businessruletask.TestPojo;
import org.eximeebpms.bpm.engine.variable.VariableMap;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@RequiredHistoryLevel(value="full")
public class HistoryCleanupAuthorizationTest
extends AuthorizationTest {
    @Override
    @Before
    public void setUp() throws Exception {
        this.processEngineConfiguration.setHistoryCleanupStrategy("endTimeBased");
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        this.processEngineConfiguration.setHistoryCleanupStrategy("removalTimeBased");
        super.tearDown();
        this.clearDatabase();
        this.clearMetrics();
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml", "org/eximeebpms/bpm/engine/test/api/authorization/oneTaskCase.cmmn"})
    public void testHistoryCleanupWithAuthorization() {
        this.prepareInstances(5, 5, 5);
        ClockUtil.setCurrentTime((Date)new Date());
        this.identityService.setAuthentication("user", Collections.singletonList("eximeebpms-admin"), null);
        String jobId = this.historyService.cleanUpHistoryAsync(true).getId();
        this.managementService.executeJob(jobId);
        this.assertResult(0L);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml", "org/eximeebpms/bpm/engine/test/api/authorization/oneTaskCase.cmmn"})
    public void testHistoryCleanupWithoutAuthorization() {
        this.prepareInstances(5, 5, 5);
        ClockUtil.setCurrentTime((Date)new Date());
        try {
            this.historyService.cleanUpHistoryAsync(true).getId();
            Assert.fail((String)"Exception expected: It should not be possible to execute the history cleanup");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent("ENGINE-03029 Required admin authenticated group or user.", message);
        }
    }

    protected void prepareInstances(Integer processInstanceTimeToLive, Integer decisionTimeToLive, Integer caseTimeToLive) {
        int i;
        this.disableAuthorization();
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("testProcess").list();
        Assert.assertEquals((long)1L, (long)processDefinitions.size());
        this.repositoryService.updateProcessDefinitionHistoryTimeToLive(((ProcessDefinition)processDefinitions.get(0)).getId(), processInstanceTimeToLive);
        List decisionDefinitions = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey("testDecision").list();
        Assert.assertEquals((long)1L, (long)decisionDefinitions.size());
        this.repositoryService.updateDecisionDefinitionHistoryTimeToLive(((DecisionDefinition)decisionDefinitions.get(0)).getId(), decisionTimeToLive);
        List caseDefinitions = this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("oneTaskCase").list();
        Assert.assertEquals((long)1L, (long)caseDefinitions.size());
        this.repositoryService.updateCaseDefinitionHistoryTimeToLive(((CaseDefinition)caseDefinitions.get(0)).getId(), caseTimeToLive);
        Date oldCurrentTime = ClockUtil.getCurrentTime();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)oldCurrentTime, (int)-6));
        ArrayList<String> processInstanceIds = new ArrayList<String>();
        VariableMap variables = Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37));
        for (i = 0; i < 3; ++i) {
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables);
            processInstanceIds.add(processInstance.getId());
        }
        this.runtimeService.deleteProcessInstances(processInstanceIds, null, true, true);
        for (i = 0; i < 10; ++i) {
            this.decisionService.evaluateDecisionByKey("testDecision").variables((Map)variables).evaluate();
        }
        for (i = 0; i < 4; ++i) {
            CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("oneTaskCase", (Map)Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37 + (double)i)));
            this.caseService.terminateCaseExecution(caseInstance.getId());
            this.caseService.closeCaseInstance(caseInstance.getId());
        }
        ClockUtil.setCurrentTime((Date)oldCurrentTime);
        this.enableAuthorization();
    }

    protected void assertResult(long expectedInstanceCount) {
        long count = this.historyService.createHistoricProcessInstanceQuery().count() + this.historyService.createHistoricDecisionInstanceQuery().count() + this.historyService.createHistoricCaseInstanceQuery().count();
        Assert.assertEquals((long)expectedInstanceCount, (long)count);
    }

    protected void clearDatabase() {
        String defaultStartTime = this.processEngineConfiguration.getHistoryCleanupBatchWindowStartTime();
        String defaultEndTime = this.processEngineConfiguration.getHistoryCleanupBatchWindowEndTime();
        int defaultBatchSize = this.processEngineConfiguration.getHistoryCleanupBatchSize();
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime(defaultStartTime);
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime(defaultEndTime);
        this.processEngineConfiguration.setHistoryCleanupBatchSize(defaultBatchSize);
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                List jobs = HistoryCleanupAuthorizationTest.this.managementService.createJobQuery().list();
                if (jobs.size() > 0) {
                    Assert.assertEquals((long)1L, (long)jobs.size());
                    String jobId = ((Job)jobs.get(0)).getId();
                    commandContext.getJobManager().deleteJob((JobEntity)jobs.get(0));
                    commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(jobId);
                }
                List historicIncidents = HistoryCleanupAuthorizationTest.this.historyService.createHistoricIncidentQuery().list();
                for (HistoricIncident historicIncident : historicIncidents) {
                    commandContext.getDbEntityManager().delete((DbEntity)((HistoricIncidentEntity)historicIncident));
                }
                commandContext.getMeterLogManager().deleteAll();
                return null;
            }
        });
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        for (Object historicProcessInstance : historicProcessInstances) {
            this.historyService.deleteHistoricProcessInstance(historicProcessInstance.getId());
        }
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        for (HistoricDecisionInstance historicDecisionInstance : historicDecisionInstances) {
            this.historyService.deleteHistoricDecisionInstanceByInstanceId(historicDecisionInstance.getId());
        }
        List historicCaseInstances = this.historyService.createHistoricCaseInstanceQuery().list();
        for (HistoricCaseInstance historicCaseInstance : historicCaseInstances) {
            this.historyService.deleteHistoricCaseInstance(historicCaseInstance.getId());
        }
    }

    protected void clearMetrics() {
        Collection meters = this.processEngineConfiguration.getMetricsRegistry().getDbMeters().values();
        for (Meter meter : meters) {
            meter.getAndClear();
        }
        this.managementService.deleteMetrics(null);
    }
}

