/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.authorization.jobdefinition;

import java.util.Collection;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.management.JobDefinition;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SetJobDefinitionPriorityCascadeAuthorizationTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule);
    @Parameterized.Parameter
    public AuthorizationScenario scenario;

    @Parameterized.Parameters(name="Scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenario.scenario().withoutAuthorizations().failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "processDefinitionKey", "userId", new Permission[]{Permissions.UPDATE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "processDefinitionKey", "userId", new Permission[]{Permissions.UPDATE})).failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "*", "userId", new Permission[]{Permissions.UPDATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "processDefinitionKey", "userId", new Permission[]{Permissions.UPDATE_INSTANCE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "processDefinitionKey", "userId", new Permission[]{Permissions.UPDATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstanceId", "userId", new Permission[]{Permissions.UPDATE})).failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "*", "userId", new Permission[]{Permissions.UPDATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "processDefinitionKey", "userId", new Permission[]{Permissions.UPDATE_INSTANCE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "processDefinitionKey", "userId", new Permission[]{Permissions.UPDATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "*", "userId", new Permission[]{Permissions.UPDATE})).succeeds(), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "processDefinitionKey", "userId", new Permission[]{Permissions.UPDATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "*", "userId", new Permission[]{Permissions.UPDATE_INSTANCE})).succeeds(), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "processDefinitionKey", "userId", new Permission[]{Permissions.UPDATE, Permissions.UPDATE_INSTANCE})).succeeds());
    }

    @Before
    public void setUp() {
        this.authRule.createUserAndGroup("userId", "groupId");
    }

    @After
    public void tearDown() {
        this.authRule.deleteUsersAndGroups();
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/authorization/oneIncidentProcess.bpmn20.xml"})
    public void testSetJobDefinitionPriority() {
        JobDefinition jobDefinition = (JobDefinition)this.engineRule.getManagementService().createJobDefinitionQuery().singleResult();
        ProcessInstance instance = this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        Job job = (Job)this.engineRule.getManagementService().createJobQuery().singleResult();
        this.authRule.init(this.scenario).withUser("userId").bindResource("processDefinitionKey", "process").bindResource("processInstanceId", instance.getId()).start();
        this.engineRule.getManagementService().setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 42L, true);
        if (this.authRule.assertScenario(this.scenario)) {
            jobDefinition = (JobDefinition)this.engineRule.getManagementService().createJobDefinitionQuery().singleResult();
            Assert.assertEquals((long)42L, (long)jobDefinition.getOverridingJobPriority());
            job = (Job)this.engineRule.getManagementService().createJobQuery().singleResult();
            Assert.assertEquals((long)42L, (long)job.getPriority());
        }
    }
}

