/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.externaltask;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.externaltask.LockedExternalTask;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ExternalTaskSupportTest {
    @Rule
    public ProcessEngineRule rule = new ProvidedProcessEngineRule();
    @Parameterized.Parameter
    public String processDefinitionResource;
    protected String deploymentId;

    @Parameterized.Parameters
    public static Collection<Object[]> processResources() {
        return Arrays.asList({"org/eximeebpms/bpm/engine/test/api/externaltask/ExternalTaskSupportTest.businessRuleTask.bpmn20.xml"}, {"org/eximeebpms/bpm/engine/test/api/externaltask/ExternalTaskSupportTest.messageEndEvent.bpmn20.xml"}, {"org/eximeebpms/bpm/engine/test/api/externaltask/ExternalTaskSupportTest.messageIntermediateEvent.bpmn20.xml"}, {"org/eximeebpms/bpm/engine/test/api/externaltask/ExternalTaskSupportTest.sendTask.bpmn20.xml"});
    }

    @Before
    public void setUp() {
        this.deploymentId = this.rule.getRepositoryService().createDeployment().addClasspathResource(this.processDefinitionResource).deploy().getId();
    }

    @After
    public void tearDown() {
        if (this.deploymentId != null) {
            this.rule.getRepositoryService().deleteDeployment(this.deploymentId, true);
        }
    }

    @Test
    public void testExternalTaskSupport() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.rule.getRepositoryService().createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(processDefinition.getId());
        List externalTasks = this.rule.getExternalTaskService().fetchAndLock(1, "aWorker").topic("externalTaskTopic", 5000L).execute();
        Assert.assertEquals((long)1L, (long)externalTasks.size());
        Assert.assertEquals((Object)processInstance.getId(), (Object)((LockedExternalTask)externalTasks.get(0)).getProcessInstanceId());
        this.rule.getExternalTaskService().complete(((LockedExternalTask)externalTasks.get(0)).getId(), "aWorker");
        Assert.assertEquals((long)0L, (long)this.rule.getRuntimeService().createProcessInstanceQuery().count());
    }

    @Test
    public void testExternalTaskProperties() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.rule.getRepositoryService().createProcessDefinitionQuery().singleResult();
        this.rule.getRuntimeService().startProcessInstanceById(processDefinition.getId());
        List externalTasks = this.rule.getExternalTaskService().fetchAndLock(1, "aWorker").topic("externalTaskTopic", 5000L).includeExtensionProperties().execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        Map properties = task.getExtensionProperties();
        Assertions.assertThat((Map)properties).containsOnly(new Map.Entry[]{Assertions.entry((Object)"key1", (Object)"val1"), Assertions.entry((Object)"key2", (Object)"val2")});
    }
}

