/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.history;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.AuthorizationService;
import org.eximeebpms.bpm.engine.BadUserRequestException;
import org.eximeebpms.bpm.engine.authorization.HistoricTaskPermissions;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class EnableHistoricInstancePermissionsTest {
    @Rule
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineConfigurationImpl config;
    protected AuthorizationService authorizationService;

    @Before
    public void assign() {
        this.config = (ProcessEngineConfigurationImpl)this.engineRule.getProcessEngine().getProcessEngineConfiguration();
        this.authorizationService = this.engineRule.getAuthorizationService();
    }

    @After
    public void resetConfig() {
        this.config.setEnableHistoricInstancePermissions(false);
    }

    @Test
    public void shouldBeFalseByDefault() {
        Assertions.assertThat((boolean)this.config.isEnableHistoricInstancePermissions()).isFalse();
    }

    @Test
    public void shouldBeConfiguredToTrue() {
        this.config.setEnableHistoricInstancePermissions(true);
        Assertions.assertThat((boolean)this.config.isEnableHistoricInstancePermissions()).isTrue();
    }

    @Test
    public void shouldBeConfiguredToFalse() {
        this.config.setEnableHistoricInstancePermissions(false);
        Assertions.assertThat((boolean)this.config.isEnableHistoricInstancePermissions()).isFalse();
    }

    @Test
    public void shouldThrowExceptionWhenHistoricInstancePermissionsAreDisabled_Task() {
        this.config.setEnableHistoricInstancePermissions(false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.authorizationService.isUserAuthorized("myUserId", null, (Permission)HistoricTaskPermissions.ALL, (Resource)Resources.HISTORIC_TASK)).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("ENGINE-03090 Historic instance permissions are disabled, please check your process engine configuration.");
    }

    @Test
    public void shouldThrowExceptionWhenHistoricInstancePermissionsAreDisabled_ProcessInstance() {
        this.config.setEnableHistoricInstancePermissions(false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.authorizationService.isUserAuthorized("myUserId", null, (Permission)HistoricTaskPermissions.ALL, (Resource)Resources.HISTORIC_PROCESS_INSTANCE)).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("ENGINE-03090 Historic instance permissions are disabled, please check your process engine configuration.");
    }
}

