/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.history;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.batch.Batch;
import org.eximeebpms.bpm.engine.batch.history.HistoricBatch;
import org.eximeebpms.bpm.engine.batch.history.HistoricBatchQuery;
import org.eximeebpms.bpm.engine.exception.NotValidException;
import org.eximeebpms.bpm.engine.exception.NullValueException;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.api.runtime.TestOrderingUtil;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.batch.BatchMigrationHelper;
import org.eximeebpms.bpm.engine.test.util.ClockTestUtil;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class HistoricBatchQueryTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected MigrationTestRule migrationRule = new MigrationTestRule(this.engineRule);
    protected BatchMigrationHelper helper = new BatchMigrationHelper(this.engineRule, this.migrationRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.migrationRule);
    protected RuntimeService runtimeService;
    protected ManagementService managementService;
    protected HistoryService historyService;

    @Before
    public void initServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
        this.historyService = this.engineRule.getHistoryService();
    }

    @After
    public void removeBatches() {
        this.helper.removeAllRunningAndHistoricBatches();
    }

    @After
    public void resetClock() {
        ClockUtil.reset();
    }

    @Test
    public void testBatchQuery() {
        Batch batch1 = this.helper.migrateProcessInstancesAsync(1);
        Batch batch2 = this.helper.migrateProcessInstancesAsync(1);
        List list = this.historyService.createHistoricBatchQuery().list();
        Assert.assertEquals((long)2L, (long)list.size());
        ArrayList<String> batchIds = new ArrayList<String>();
        for (HistoricBatch resultBatch : list) {
            batchIds.add(resultBatch.getId());
        }
        Assert.assertTrue((boolean)batchIds.contains(batch1.getId()));
        Assert.assertTrue((boolean)batchIds.contains(batch2.getId()));
    }

    @Test
    public void testBatchQueryResult() {
        Date startDate = new Date(10000L);
        Date endDate = new Date(40000L);
        ClockUtil.setCurrentTime((Date)startDate);
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        this.helper.completeSeedJobs(batch);
        this.helper.executeJobs(batch);
        ClockUtil.setCurrentTime((Date)endDate);
        this.helper.executeMonitorJob(batch);
        HistoricBatch resultBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().singleResult();
        Assert.assertNotNull((Object)resultBatch);
        Assert.assertEquals((Object)batch.getId(), (Object)resultBatch.getId());
        Assert.assertEquals((Object)batch.getBatchJobDefinitionId(), (Object)resultBatch.getBatchJobDefinitionId());
        Assert.assertEquals((Object)batch.getMonitorJobDefinitionId(), (Object)resultBatch.getMonitorJobDefinitionId());
        Assert.assertEquals((Object)batch.getSeedJobDefinitionId(), (Object)resultBatch.getSeedJobDefinitionId());
        Assert.assertEquals((Object)batch.getTenantId(), (Object)resultBatch.getTenantId());
        Assert.assertEquals((Object)batch.getType(), (Object)resultBatch.getType());
        Assert.assertEquals((long)batch.getBatchJobsPerSeed(), (long)resultBatch.getBatchJobsPerSeed());
        Assert.assertEquals((long)batch.getInvocationsPerBatchJob(), (long)resultBatch.getInvocationsPerBatchJob());
        Assert.assertEquals((long)batch.getTotalJobs(), (long)resultBatch.getTotalJobs());
        Assert.assertEquals((Object)startDate, (Object)resultBatch.getStartTime());
        Assert.assertEquals((Object)endDate, (Object)resultBatch.getEndTime());
    }

    @Test
    public void testBatchQueryById() {
        Batch batch1 = this.helper.migrateProcessInstancesAsync(1);
        this.helper.migrateProcessInstancesAsync(1);
        HistoricBatch resultBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().batchId(batch1.getId()).singleResult();
        Assert.assertNotNull((Object)resultBatch);
        Assert.assertEquals((Object)batch1.getId(), (Object)resultBatch.getId());
    }

    @Test
    public void testBatchQueryByIdNull() {
        try {
            this.historyService.createHistoricBatchQuery().batchId(null).singleResult();
            Assert.fail((String)"exception expected");
        }
        catch (NullValueException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Batch id is null"});
        }
    }

    @Test
    public void testBatchQueryByType() {
        Batch batch1 = this.helper.migrateProcessInstancesAsync(1);
        this.helper.migrateProcessInstancesAsync(1);
        long count = this.historyService.createHistoricBatchQuery().type(batch1.getType()).count();
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testBatchQueryByNonExistingType() {
        this.helper.migrateProcessInstancesAsync(1);
        long count = this.historyService.createHistoricBatchQuery().type("foo").count();
        Assert.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testBatchByState() {
        Batch batch1 = this.helper.migrateProcessInstancesAsync(1);
        Batch batch2 = this.helper.migrateProcessInstancesAsync(1);
        this.helper.completeBatch(batch1);
        HistoricBatch historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().completed(true).singleResult();
        Assert.assertEquals((Object)batch1.getId(), (Object)historicBatch.getId());
        historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().completed(false).singleResult();
        Assert.assertEquals((Object)batch2.getId(), (Object)historicBatch.getId());
    }

    @Test
    public void testBatchQueryByTypeNull() {
        try {
            this.historyService.createHistoricBatchQuery().type(null).singleResult();
            Assert.fail((String)"exception expected");
        }
        catch (NullValueException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Type is null"});
        }
    }

    @Test
    public void testBatchQueryCount() {
        this.helper.migrateProcessInstancesAsync(1);
        this.helper.migrateProcessInstancesAsync(1);
        long count = this.historyService.createHistoricBatchQuery().count();
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testBatchQueryOrderByIdAsc() {
        this.helper.migrateProcessInstancesAsync(1);
        this.helper.migrateProcessInstancesAsync(1);
        List orderedBatches = ((HistoricBatchQuery)this.historyService.createHistoricBatchQuery().orderById().asc()).list();
        TestOrderingUtil.verifySorting(orderedBatches, TestOrderingUtil.historicBatchById());
    }

    @Test
    public void testBatchQueryOrderByIdDec() {
        this.helper.migrateProcessInstancesAsync(1);
        this.helper.migrateProcessInstancesAsync(1);
        List orderedBatches = ((HistoricBatchQuery)this.historyService.createHistoricBatchQuery().orderById().desc()).list();
        TestOrderingUtil.verifySorting(orderedBatches, TestOrderingUtil.inverted(TestOrderingUtil.historicBatchById()));
    }

    @Test
    public void testBatchQueryOrderByStartTimeAsc() {
        ClockTestUtil.setClockToDateWithoutMilliseconds();
        this.helper.migrateProcessInstancesAsync(1);
        ClockTestUtil.incrementClock(1000L);
        this.helper.migrateProcessInstancesAsync(1);
        List orderedBatches = ((HistoricBatchQuery)this.historyService.createHistoricBatchQuery().orderByStartTime().asc()).list();
        TestOrderingUtil.verifySorting(orderedBatches, TestOrderingUtil.historicBatchByStartTime());
    }

    @Test
    public void testBatchQueryOrderByStartTimeDec() {
        ClockTestUtil.setClockToDateWithoutMilliseconds();
        this.helper.migrateProcessInstancesAsync(1);
        ClockTestUtil.incrementClock(1000L);
        this.helper.migrateProcessInstancesAsync(1);
        List orderedBatches = ((HistoricBatchQuery)this.historyService.createHistoricBatchQuery().orderByStartTime().desc()).list();
        TestOrderingUtil.verifySorting(orderedBatches, TestOrderingUtil.inverted(TestOrderingUtil.historicBatchByStartTime()));
    }

    @Test
    public void testBatchQueryOrderByEndTimeAsc() {
        ClockTestUtil.setClockToDateWithoutMilliseconds();
        Batch batch1 = this.helper.migrateProcessInstancesAsync(1);
        this.helper.completeBatch(batch1);
        ClockTestUtil.incrementClock(1000L);
        Batch batch2 = this.helper.migrateProcessInstancesAsync(1);
        this.helper.completeBatch(batch2);
        List orderedBatches = ((HistoricBatchQuery)this.historyService.createHistoricBatchQuery().orderByEndTime().asc()).list();
        TestOrderingUtil.verifySorting(orderedBatches, TestOrderingUtil.historicBatchByEndTime());
    }

    @Test
    public void testBatchQueryOrderByEndTimeDec() {
        ClockTestUtil.setClockToDateWithoutMilliseconds();
        Batch batch1 = this.helper.migrateProcessInstancesAsync(1);
        this.helper.completeBatch(batch1);
        ClockTestUtil.incrementClock(1000L);
        Batch batch2 = this.helper.migrateProcessInstancesAsync(1);
        this.helper.completeBatch(batch2);
        List orderedBatches = ((HistoricBatchQuery)this.historyService.createHistoricBatchQuery().orderByEndTime().desc()).list();
        TestOrderingUtil.verifySorting(orderedBatches, TestOrderingUtil.inverted(TestOrderingUtil.historicBatchByEndTime()));
    }

    @Test
    public void testBatchQueryOrderingPropertyWithoutOrder() {
        try {
            this.historyService.createHistoricBatchQuery().orderById().singleResult();
            Assert.fail((String)"exception expected");
        }
        catch (NotValidException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Invalid query: call asc() or desc() after using orderByXX()"});
        }
    }

    @Test
    public void testBatchQueryOrderWithoutOrderingProperty() {
        try {
            ((HistoricBatchQuery)this.historyService.createHistoricBatchQuery().asc()).singleResult();
            Assert.fail((String)"exception expected");
        }
        catch (NotValidException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"You should call any of the orderBy methods first before specifying a direction"});
        }
    }
}

