/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.history;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.DecisionService;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.exception.NullValueException;
import org.eximeebpms.bpm.engine.history.HistoricDecisionInstance;
import org.eximeebpms.bpm.engine.history.HistoricDecisionInstanceStatistics;
import org.eximeebpms.bpm.engine.history.HistoricDecisionInstanceStatisticsQuery;
import org.eximeebpms.bpm.engine.repository.DecisionRequirementsDefinition;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class HistoricDecisionInstanceStatisticsQueryTest {
    protected static final String DISH_DRG_DMN = "org/eximeebpms/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml";
    protected static final String SCORE_DRG_DMN = "org/eximeebpms/bpm/engine/test/dmn/deployment/drdScore.dmn11.xml";
    protected static final String NON_EXISTING = "fake";
    protected static final String DISH_DECISION = "dish-decision";
    protected static final String TEMPERATURE = "temperature";
    protected static final String DAY_TYPE = "dayType";
    protected static final String WEEKEND = "Weekend";
    protected DecisionService decisionService;
    protected RepositoryService repositoryService;
    protected HistoryService historyService;
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Before
    public void setUp() {
        this.decisionService = this.engineRule.getDecisionService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.historyService = this.engineRule.getHistoryService();
        this.testRule.deploy(DISH_DRG_DMN);
    }

    @Test
    public void testStatisticForRootDecisionEvaluation() throws Exception {
        this.decisionService.evaluateDecisionTableByKey(DISH_DECISION).variables((Map)Variables.createVariables().putValue(TEMPERATURE, (Object)21).putValue(DAY_TYPE, (Object)WEEKEND)).evaluate();
        this.decisionService.evaluateDecisionTableByKey(DISH_DECISION).variables((Map)Variables.createVariables().putValue(TEMPERATURE, (Object)11).putValue(DAY_TYPE, (Object)WEEKEND)).evaluate();
        DecisionRequirementsDefinition decisionRequirementsDefinition = (DecisionRequirementsDefinition)this.repositoryService.createDecisionRequirementsDefinitionQuery().singleResult();
        HistoricDecisionInstanceStatisticsQuery statisticsQuery = this.historyService.createHistoricDecisionInstanceStatisticsQuery(decisionRequirementsDefinition.getId());
        Assertions.assertThat((long)statisticsQuery.count()).isEqualTo(3L);
        Assertions.assertThat((List)statisticsQuery.list()).hasSize(3);
        Assertions.assertThat((int)((HistoricDecisionInstanceStatistics)statisticsQuery.list().get(0)).getEvaluations()).isEqualTo(2);
        Assertions.assertThat((String)((HistoricDecisionInstanceStatistics)statisticsQuery.list().get(0)).getDecisionDefinitionKey()).isNotNull();
    }

    @Test
    public void testStatisticForRootDecisionWithInstanceConstraintEvaluation() throws Exception {
        this.decisionService.evaluateDecisionTableByKey(DISH_DECISION).variables((Map)Variables.createVariables().putValue(TEMPERATURE, (Object)21).putValue(DAY_TYPE, (Object)WEEKEND)).evaluate();
        this.decisionService.evaluateDecisionTableByKey(DISH_DECISION).variables((Map)Variables.createVariables().putValue(TEMPERATURE, (Object)11).putValue(DAY_TYPE, (Object)WEEKEND)).evaluate();
        DecisionRequirementsDefinition decisionRequirementsDefinition = (DecisionRequirementsDefinition)this.repositoryService.createDecisionRequirementsDefinitionQuery().singleResult();
        String decisionInstanceId = ((HistoricDecisionInstance)this.engineRule.getHistoryService().createHistoricDecisionInstanceQuery().decisionRequirementsDefinitionId(decisionRequirementsDefinition.getId()).rootDecisionInstancesOnly().list().get(0)).getId();
        HistoricDecisionInstanceStatisticsQuery query = this.historyService.createHistoricDecisionInstanceStatisticsQuery(decisionRequirementsDefinition.getId()).decisionInstanceId(decisionInstanceId);
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        Assertions.assertThat((List)query.list()).hasSize(3);
        Assertions.assertThat((int)((HistoricDecisionInstanceStatistics)query.list().get(0)).getEvaluations()).isEqualTo(1);
        Assertions.assertThat((String)((HistoricDecisionInstanceStatistics)query.list().get(0)).getDecisionDefinitionKey()).isNotNull();
    }

    @Test
    public void testStatisticForRootDecisionWithFakeInstanceConstraintEvaluation() throws Exception {
        this.decisionService.evaluateDecisionTableByKey(DISH_DECISION).variables((Map)Variables.createVariables().putValue(TEMPERATURE, (Object)21).putValue(DAY_TYPE, (Object)WEEKEND)).evaluate();
        DecisionRequirementsDefinition decisionRequirementsDefinition = (DecisionRequirementsDefinition)this.repositoryService.createDecisionRequirementsDefinitionQuery().singleResult();
        HistoricDecisionInstanceStatisticsQuery query = this.historyService.createHistoricDecisionInstanceStatisticsQuery(decisionRequirementsDefinition.getId()).decisionInstanceId(NON_EXISTING);
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
        Assertions.assertThat((List)query.list()).hasSize(0);
    }

    @Test
    public void testStatisticForRootDecisionWithNullInstanceConstraintEvaluation() throws Exception {
        this.decisionService.evaluateDecisionTableByKey(DISH_DECISION).variables((Map)Variables.createVariables().putValue(TEMPERATURE, (Object)21).putValue(DAY_TYPE, (Object)WEEKEND)).evaluate();
        DecisionRequirementsDefinition decisionRequirementsDefinition = (DecisionRequirementsDefinition)this.repositoryService.createDecisionRequirementsDefinitionQuery().singleResult();
        HistoricDecisionInstanceStatisticsQuery query = this.historyService.createHistoricDecisionInstanceStatisticsQuery(decisionRequirementsDefinition.getId()).decisionInstanceId(null);
        try {
            query.count();
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
        try {
            query.list();
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    public void testStatisticForChildDecisionEvaluation() throws Exception {
        this.decisionService.evaluateDecisionTableByKey("season").variables((Map)Variables.createVariables().putValue(TEMPERATURE, (Object)21)).evaluate();
        DecisionRequirementsDefinition decisionRequirementsDefinition = (DecisionRequirementsDefinition)this.repositoryService.createDecisionRequirementsDefinitionQuery().singleResult();
        HistoricDecisionInstanceStatisticsQuery statisticsQuery = this.historyService.createHistoricDecisionInstanceStatisticsQuery(decisionRequirementsDefinition.getId());
        Assertions.assertThat((long)statisticsQuery.count()).isEqualTo(1L);
        Assertions.assertThat((List)statisticsQuery.list()).hasSize(1);
        Assertions.assertThat((int)((HistoricDecisionInstanceStatistics)statisticsQuery.list().get(0)).getEvaluations()).isEqualTo(1);
        Assertions.assertThat((String)((HistoricDecisionInstanceStatistics)statisticsQuery.list().get(0)).getDecisionDefinitionKey()).isNotNull();
    }

    @Test
    public void testStatisticConstrainedToOneDRD() throws Exception {
        this.testRule.deploy(SCORE_DRG_DMN);
        this.decisionService.evaluateDecisionTableByKey("score-decision").variables((Map)Variables.createVariables().putValue("input", (Object)"john")).evaluate();
        this.decisionService.evaluateDecisionTableByKey("season").variables((Map)Variables.createVariables().putValue(TEMPERATURE, (Object)21)).evaluate();
        DecisionRequirementsDefinition decisionRequirementsDefinition = (DecisionRequirementsDefinition)this.repositoryService.createDecisionRequirementsDefinitionQuery().decisionRequirementsDefinitionName("Score").singleResult();
        HistoricDecisionInstanceStatisticsQuery statisticsQuery = this.historyService.createHistoricDecisionInstanceStatisticsQuery(decisionRequirementsDefinition.getId());
        Assertions.assertThat((long)statisticsQuery.count()).isEqualTo(1L);
        Assertions.assertThat((List)statisticsQuery.list()).hasSize(1);
        Assertions.assertThat((int)((HistoricDecisionInstanceStatistics)statisticsQuery.list().get(0)).getEvaluations()).isEqualTo(1);
        Assertions.assertThat((String)((HistoricDecisionInstanceStatistics)statisticsQuery.list().get(0)).getDecisionDefinitionKey()).isNotNull();
    }

    @Test
    public void testStatisticDoesNotExistForFakeId() throws Exception {
        Assertions.assertThat((long)this.historyService.createHistoricDecisionInstanceStatisticsQuery(NON_EXISTING).count()).isEqualTo(0L);
        Assertions.assertThat((int)this.historyService.createHistoricDecisionInstanceStatisticsQuery(NON_EXISTING).list().size()).isEqualTo(0);
    }

    @Test
    public void testStatisticThrowsExceptionOnNullConstraintsCount() throws Exception {
        Assertions.assertThatThrownBy(() -> this.historyService.createHistoricDecisionInstanceStatisticsQuery(null).count()).isInstanceOf(NullValueException.class);
    }

    @Test
    public void testStatisticThrowsExceptionOnNullConstraintsList() throws Exception {
        Assertions.assertThatThrownBy(() -> this.historyService.createHistoricDecisionInstanceStatisticsQuery(null).list()).isInstanceOf(NullValueException.class);
    }

    @Test
    public void testStatisticForNotEvaluatedDRD() throws Exception {
        DecisionRequirementsDefinition decisionRequirementsDefinition = (DecisionRequirementsDefinition)this.repositoryService.createDecisionRequirementsDefinitionQuery().singleResult();
        HistoricDecisionInstanceStatisticsQuery statisticsQuery = this.historyService.createHistoricDecisionInstanceStatisticsQuery(decisionRequirementsDefinition.getId());
        Assertions.assertThat((long)statisticsQuery.count()).isEqualTo(0L);
        Assertions.assertThat((List)statisticsQuery.list()).hasSize(0);
    }
}

