/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.identity;

import java.util.List;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.identity.Group;
import org.eximeebpms.bpm.engine.identity.GroupQuery;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GroupQueryTest
extends PluggableProcessEngineTest {
    @Before
    public void setUp() throws Exception {
        this.createGroup("muppets", "Muppet show characters_", "user");
        this.createGroup("frogs", "Famous frogs", "user");
        this.createGroup("mammals", "Famous mammals from eighties", "user");
        this.createGroup("admin", "Administrators", "security");
        this.identityService.saveUser(this.identityService.newUser("kermit"));
        this.identityService.saveUser(this.identityService.newUser("fozzie"));
        this.identityService.saveUser(this.identityService.newUser("mispiggy"));
        this.identityService.saveTenant(this.identityService.newTenant("tenant"));
        this.identityService.createMembership("kermit", "muppets");
        this.identityService.createMembership("fozzie", "muppets");
        this.identityService.createMembership("mispiggy", "muppets");
        this.identityService.createMembership("kermit", "frogs");
        this.identityService.createMembership("fozzie", "mammals");
        this.identityService.createMembership("mispiggy", "mammals");
        this.identityService.createMembership("kermit", "admin");
        this.identityService.createTenantGroupMembership("tenant", "frogs");
    }

    private Group createGroup(String id, String name, String type) {
        Group group = this.identityService.newGroup(id);
        group.setName(name);
        group.setType(type);
        this.identityService.saveGroup(group);
        return group;
    }

    @After
    public void tearDown() throws Exception {
        this.identityService.deleteUser("kermit");
        this.identityService.deleteUser("fozzie");
        this.identityService.deleteUser("mispiggy");
        this.identityService.deleteGroup("muppets");
        this.identityService.deleteGroup("mammals");
        this.identityService.deleteGroup("frogs");
        this.identityService.deleteGroup("admin");
        this.identityService.deleteTenant("tenant");
    }

    @Test
    public void testQueryById() {
        GroupQuery query = this.identityService.createGroupQuery().groupId("muppets");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByInvalidId() {
        GroupQuery query = this.identityService.createGroupQuery().groupId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.identityService.createGroupQuery().groupId(null).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByIdIn() {
        Assert.assertTrue((boolean)this.identityService.createGroupQuery().groupIdIn(new String[]{"a", "b"}).list().isEmpty());
        List list = this.identityService.createGroupQuery().list();
        String[] ids = new String[list.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = ((Group)list.get(i)).getId();
        }
        List idInList = this.identityService.createGroupQuery().groupIdIn(ids).list();
        Assert.assertEquals((long)list.size(), (long)idInList.size());
        for (Group group : idInList) {
            boolean found = false;
            for (Group otherGroup : list) {
                if (!otherGroup.getId().equals(group.getId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            Assert.fail((String)("Expected to find group " + String.valueOf(group)));
        }
    }

    @Test
    public void testQueryByName() {
        GroupQuery query = this.identityService.createGroupQuery().groupName("Muppet show characters_");
        this.verifyQueryResults(query, 1);
        query = this.identityService.createGroupQuery().groupName("Famous frogs");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByInvalidName() {
        GroupQuery query = this.identityService.createGroupQuery().groupName("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.identityService.createGroupQuery().groupName(null).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByNameLike() {
        GroupQuery query = this.identityService.createGroupQuery().groupNameLike("%Famous%");
        this.verifyQueryResults(query, 2);
        query = this.identityService.createGroupQuery().groupNameLike("Famous%");
        this.verifyQueryResults(query, 2);
        query = this.identityService.createGroupQuery().groupNameLike("%show%");
        this.verifyQueryResults(query, 1);
        query = this.identityService.createGroupQuery().groupNameLike("%ters\\_");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByInvalidNameLike() {
        GroupQuery query = this.identityService.createGroupQuery().groupNameLike("%invalid%");
        this.verifyQueryResults(query, 0);
        try {
            this.identityService.createGroupQuery().groupNameLike(null).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByType() {
        GroupQuery query = this.identityService.createGroupQuery().groupType("user");
        this.verifyQueryResults(query, 3);
        query = this.identityService.createGroupQuery().groupType("admin");
        this.verifyQueryResults(query, 0);
    }

    @Test
    public void testQueryByInvalidType() {
        GroupQuery query = this.identityService.createGroupQuery().groupType("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.identityService.createGroupQuery().groupType(null).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByMember() {
        GroupQuery query = this.identityService.createGroupQuery().groupMember("fozzie");
        this.verifyQueryResults(query, 2);
        query = this.identityService.createGroupQuery().groupMember("kermit");
        this.verifyQueryResults(query, 3);
        query = (GroupQuery)query.orderByGroupId().asc();
        List groups = query.list();
        Assert.assertEquals((long)3L, (long)groups.size());
        Assert.assertEquals((Object)"admin", (Object)((Group)groups.get(0)).getId());
        Assert.assertEquals((Object)"frogs", (Object)((Group)groups.get(1)).getId());
        Assert.assertEquals((Object)"muppets", (Object)((Group)groups.get(2)).getId());
        query = query.groupType("user");
        groups = query.list();
        Assert.assertEquals((long)2L, (long)groups.size());
        Assert.assertEquals((Object)"frogs", (Object)((Group)groups.get(0)).getId());
        Assert.assertEquals((Object)"muppets", (Object)((Group)groups.get(1)).getId());
    }

    @Test
    public void testQueryByInvalidMember() {
        GroupQuery query = this.identityService.createGroupQuery().groupMember("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.identityService.createGroupQuery().groupMember(null).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByMemberOfTenant() {
        GroupQuery query = this.identityService.createGroupQuery().memberOfTenant("nonExisting");
        this.verifyQueryResults(query, 0);
        query = this.identityService.createGroupQuery().memberOfTenant("tenant");
        this.verifyQueryResults(query, 1);
        Group group = (Group)query.singleResult();
        Assert.assertEquals((Object)"frogs", (Object)group.getId());
    }

    @Test
    public void testQuerySorting() {
        Assert.assertEquals((long)4L, (long)((GroupQuery)this.identityService.createGroupQuery().orderByGroupId().asc()).count());
        Assert.assertEquals((long)4L, (long)((GroupQuery)this.identityService.createGroupQuery().orderByGroupName().asc()).count());
        Assert.assertEquals((long)4L, (long)((GroupQuery)this.identityService.createGroupQuery().orderByGroupType().asc()).count());
        Assert.assertEquals((long)4L, (long)((GroupQuery)this.identityService.createGroupQuery().orderByGroupId().desc()).count());
        Assert.assertEquals((long)4L, (long)((GroupQuery)this.identityService.createGroupQuery().orderByGroupName().desc()).count());
        Assert.assertEquals((long)4L, (long)((GroupQuery)this.identityService.createGroupQuery().orderByGroupType().desc()).count());
        GroupQuery query = (GroupQuery)((GroupQuery)this.identityService.createGroupQuery().orderByGroupType().asc()).orderByGroupName().desc();
        List groups = query.list();
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertEquals((Object)"security", (Object)((Group)groups.get(0)).getType());
        Assert.assertEquals((Object)"user", (Object)((Group)groups.get(1)).getType());
        Assert.assertEquals((Object)"user", (Object)((Group)groups.get(2)).getType());
        Assert.assertEquals((Object)"user", (Object)((Group)groups.get(3)).getType());
        Assert.assertEquals((Object)"admin", (Object)((Group)groups.get(0)).getId());
        Assert.assertEquals((Object)"muppets", (Object)((Group)groups.get(1)).getId());
        Assert.assertEquals((Object)"mammals", (Object)((Group)groups.get(2)).getId());
        Assert.assertEquals((Object)"frogs", (Object)((Group)groups.get(3)).getId());
    }

    @Test
    public void testQueryInvalidSortingUsage() {
        try {
            this.identityService.createGroupQuery().orderByGroupId().list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.identityService.createGroupQuery().orderByGroupId().orderByGroupName().list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    private void verifyQueryResults(GroupQuery query, int countExpected) {
        Assert.assertEquals((long)countExpected, (long)query.list().size());
        Assert.assertEquals((long)countExpected, (long)query.count());
        if (countExpected == 1) {
            Assert.assertNotNull((Object)query.singleResult());
        } else if (countExpected > 1) {
            this.verifySingleResultFails(query);
        } else if (countExpected == 0) {
            Assert.assertNull((Object)query.singleResult());
        }
    }

    private void verifySingleResultFails(GroupQuery query) {
        try {
            query.singleResult();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }
}

