/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.mgmt;

import java.util.HashMap;
import java.util.Map;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.management.JobDefinition;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.JobQuery;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.junit.Assert;
import org.junit.Test;

public class ActivateJobTest
extends PluggableProcessEngineTest {
    @Test
    public void testActivationById_shouldThrowProcessEngineException() {
        try {
            this.managementService.activateJobById(null);
            Assert.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testActivationById_shouldActivateJob() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job job = (Job)jobQuery.singleResult();
        Assert.assertTrue((boolean)job.isSuspended());
        this.managementService.activateJobById(job.getId());
        Assert.assertEquals((long)1L, (long)jobQuery.active().count());
        Assert.assertEquals((long)0L, (long)jobQuery.suspended().count());
        Job activeJob = (Job)jobQuery.active().singleResult();
        Assert.assertEquals((Object)job.getId(), (Object)activeJob.getId());
        Assert.assertFalse((boolean)activeJob.isSuspended());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testActivationByJobDefinitionId_shouldActivateJob() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job job = (Job)jobQuery.singleResult();
        Assert.assertTrue((boolean)job.isSuspended());
        this.managementService.activateJobByJobDefinitionId(jobDefinition.getId());
        Assert.assertEquals((long)0L, (long)jobQuery.suspended().count());
        Assert.assertEquals((long)1L, (long)jobQuery.active().count());
        Job activeJob = (Job)jobQuery.active().singleResult();
        Assert.assertEquals((Object)job.getId(), (Object)activeJob.getId());
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJob.getJobDefinitionId());
        Assert.assertFalse((boolean)activeJob.isSuspended());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testActivateByProcessInstanceId_shouldActivateJob() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job job = (Job)jobQuery.singleResult();
        Assert.assertTrue((boolean)job.isSuspended());
        this.managementService.activateJobByProcessInstanceId(processInstance.getId());
        Assert.assertEquals((long)1L, (long)jobQuery.active().count());
        Assert.assertEquals((long)0L, (long)jobQuery.suspended().count());
        Job suspendedJob = (Job)jobQuery.active().singleResult();
        Assert.assertEquals((Object)job.getId(), (Object)suspendedJob.getId());
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJob.getJobDefinitionId());
        Assert.assertFalse((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testActivationByProcessDefinitionId_shouldActivateJob() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job job = (Job)jobQuery.singleResult();
        Assert.assertTrue((boolean)job.isSuspended());
        this.managementService.activateJobByProcessDefinitionId(processDefinition.getId());
        Assert.assertEquals((long)1L, (long)jobQuery.active().count());
        Assert.assertEquals((long)0L, (long)jobQuery.suspended().count());
        Job activeJob = (Job)jobQuery.active().singleResult();
        Assert.assertEquals((Object)job.getId(), (Object)activeJob.getId());
        Assert.assertFalse((boolean)activeJob.isSuspended());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testActivationByProcessDefinitionKey_shouldActivateJob() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job job = (Job)jobQuery.singleResult();
        Assert.assertTrue((boolean)job.isSuspended());
        this.managementService.activateJobByProcessDefinitionKey(processDefinition.getKey());
        Assert.assertEquals((long)0L, (long)jobQuery.suspended().count());
        Assert.assertEquals((long)1L, (long)jobQuery.active().count());
        Job activeJob = (Job)jobQuery.active().singleResult();
        Assert.assertEquals((Object)job.getId(), (Object)activeJob.getId());
        Assert.assertFalse((boolean)activeJob.isSuspended());
    }

    @Test
    public void testMultipleActivationByProcessDefinitionKey_shouldActivateJob() {
        String key = "suspensionProcess";
        int nrOfProcessDefinitions = 3;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(key, true);
        this.managementService.activateJobByProcessDefinitionKey(key);
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)0L, (long)jobQuery.suspended().count());
        Assert.assertEquals((long)3L, (long)jobQuery.active().count());
        for (org.eximeebpms.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testActivationByIdUsingBuilder() {
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", (Map)Variables.createVariables().putValue("fail", (Object)true));
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job job = (Job)jobQuery.singleResult();
        Assert.assertTrue((boolean)job.isSuspended());
        this.managementService.updateJobSuspensionState().byJobId(job.getId()).activate();
        Assert.assertEquals((long)1L, (long)jobQuery.active().count());
        Assert.assertEquals((long)0L, (long)jobQuery.suspended().count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testActivationByJobDefinitionIdUsingBuilder() {
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", (Map)Variables.createVariables().putValue("fail", (Object)true));
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.suspended().count());
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.updateJobSuspensionState().byJobDefinitionId(jobDefinition.getId()).activate();
        Assert.assertEquals((long)1L, (long)jobQuery.active().count());
        Assert.assertEquals((long)0L, (long)jobQuery.suspended().count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testActivationByProcessInstanceIdUsingBuilder() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("suspensionProcess", (Map)Variables.createVariables().putValue("fail", (Object)true));
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.suspended().count());
        this.managementService.updateJobSuspensionState().byProcessInstanceId(processInstance.getId()).activate();
        Assert.assertEquals((long)1L, (long)jobQuery.active().count());
        Assert.assertEquals((long)0L, (long)jobQuery.suspended().count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testActivationByProcessDefinitionIdUsingBuilder() {
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", (Map)Variables.createVariables().putValue("fail", (Object)true));
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.suspended().count());
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.managementService.updateJobSuspensionState().byProcessDefinitionId(processDefinition.getId()).activate();
        Assert.assertEquals((long)1L, (long)jobQuery.active().count());
        Assert.assertEquals((long)0L, (long)jobQuery.suspended().count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testActivationByProcessDefinitionKeyUsingBuilder() {
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", (Map)Variables.createVariables().putValue("fail", (Object)true));
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.suspended().count());
        this.managementService.updateJobSuspensionState().byProcessDefinitionKey("suspensionProcess").activate();
        Assert.assertEquals((long)1L, (long)jobQuery.active().count());
        Assert.assertEquals((long)0L, (long)jobQuery.suspended().count());
    }
}

