/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.mgmt;

import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.batch.Batch;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.jobexecutor.DefaultJobPriorityProvider;
import org.eximeebpms.bpm.engine.management.JobDefinition;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.batch.BatchMigrationHelper;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class BatchPriorityTest {
    public static final long CUSTOM_PRIORITY = DefaultJobPriorityProvider.DEFAULT_PRIORITY + 10L;
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected MigrationTestRule migrationRule = new MigrationTestRule(this.engineRule);
    protected BatchMigrationHelper helper = new BatchMigrationHelper(this.engineRule, this.migrationRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.migrationRule);
    protected RuntimeService runtimeService;
    protected ManagementService managementService;
    protected HistoryService historyService;
    protected IdentityService identityService;
    protected int defaultBatchJobsPerSeed;
    protected long defaultBatchJobPriority;

    @Before
    public void initServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
        this.historyService = this.engineRule.getHistoryService();
        this.identityService = this.engineRule.getIdentityService();
    }

    @Before
    public void saveAndReduceBatchConfiguration() {
        ProcessEngineConfigurationImpl configuration = this.engineRule.getProcessEngineConfiguration();
        this.defaultBatchJobsPerSeed = configuration.getBatchJobsPerSeed();
        this.defaultBatchJobPriority = configuration.getBatchJobPriority();
        configuration.setBatchJobsPerSeed(1);
    }

    @After
    public void removeBatches() {
        this.helper.removeAllRunningAndHistoricBatches();
    }

    @After
    public void resetBatchJobsPerSeed() {
        ProcessEngineConfigurationImpl processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        processEngineConfiguration.setBatchJobsPerSeed(this.defaultBatchJobsPerSeed);
        processEngineConfiguration.setBatchJobPriority(this.defaultBatchJobPriority);
    }

    @Test
    public void seedJobShouldHaveDefaultPriority() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        Job seedJob = this.helper.getSeedJob(batch);
        Assert.assertEquals((long)DefaultJobPriorityProvider.DEFAULT_PRIORITY, (long)seedJob.getPriority());
    }

    @Test
    public void monitorJobShouldHaveDefaultPriority() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        this.helper.completeSeedJobs(batch);
        Job monitorJob = this.helper.getMonitorJob(batch);
        Assert.assertEquals((long)DefaultJobPriorityProvider.DEFAULT_PRIORITY, (long)monitorJob.getPriority());
    }

    @Test
    public void batchExecutionJobShouldHaveDefaultPriority() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        this.helper.completeSeedJobs(batch);
        Job executionJob = this.helper.getExecutionJobs(batch).get(0);
        Assert.assertEquals((long)DefaultJobPriorityProvider.DEFAULT_PRIORITY, (long)executionJob.getPriority());
    }

    @Test
    public void seedJobShouldGetPriorityFromProcessEngineConfiguration() {
        this.setBatchJobPriority(CUSTOM_PRIORITY);
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        Job seedJob = this.helper.getSeedJob(batch);
        Assert.assertEquals((long)CUSTOM_PRIORITY, (long)seedJob.getPriority());
    }

    @Test
    public void monitorJobShouldGetPriorityFromProcessEngineConfiguration() {
        this.setBatchJobPriority(CUSTOM_PRIORITY);
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        this.helper.completeSeedJobs(batch);
        Job monitorJob = this.helper.getMonitorJob(batch);
        Assert.assertEquals((long)CUSTOM_PRIORITY, (long)monitorJob.getPriority());
    }

    @Test
    public void executionJobShouldGetPriorityFromProcessEngineConfiguration() {
        this.setBatchJobPriority(CUSTOM_PRIORITY);
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        this.helper.completeSeedJobs(batch);
        Job executionJob = this.helper.getExecutionJobs(batch).get(0);
        Assert.assertEquals((long)CUSTOM_PRIORITY, (long)executionJob.getPriority());
    }

    @Test
    public void seedJobShouldGetPriorityFromOverridingJobDefinitionPriority() {
        Batch batch = this.helper.migrateProcessInstancesAsync(2);
        JobDefinition seedJobDefinition = this.helper.getSeedJobDefinition(batch);
        this.managementService.setOverridingJobPriorityForJobDefinition(seedJobDefinition.getId(), CUSTOM_PRIORITY);
        this.helper.executeSeedJob(batch);
        Job seedJob = this.helper.getSeedJob(batch);
        Assert.assertEquals((long)CUSTOM_PRIORITY, (long)seedJob.getPriority());
    }

    @Test
    public void seedJobShouldGetPriorityFromOverridingJobDefinitionPriorityWithCascade() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        JobDefinition seedJobDefinition = this.helper.getSeedJobDefinition(batch);
        this.managementService.setOverridingJobPriorityForJobDefinition(seedJobDefinition.getId(), CUSTOM_PRIORITY, true);
        Job seedJob = this.helper.getSeedJob(batch);
        Assert.assertEquals((long)CUSTOM_PRIORITY, (long)seedJob.getPriority());
    }

    @Test
    public void monitorJobShouldGetPriorityOverridingJobDefinitionPriority() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        JobDefinition monitorJobDefinition = this.helper.getMonitorJobDefinition(batch);
        this.managementService.setOverridingJobPriorityForJobDefinition(monitorJobDefinition.getId(), CUSTOM_PRIORITY);
        this.helper.completeSeedJobs(batch);
        Job monitorJob = this.helper.getMonitorJob(batch);
        Assert.assertEquals((long)CUSTOM_PRIORITY, (long)monitorJob.getPriority());
    }

    @Test
    public void monitorJobShouldGetPriorityOverridingJobDefinitionPriorityWithCascade() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        JobDefinition monitorJobDefinition = this.helper.getMonitorJobDefinition(batch);
        this.helper.completeSeedJobs(batch);
        this.managementService.setOverridingJobPriorityForJobDefinition(monitorJobDefinition.getId(), CUSTOM_PRIORITY, true);
        Job monitorJob = this.helper.getMonitorJob(batch);
        Assert.assertEquals((long)CUSTOM_PRIORITY, (long)monitorJob.getPriority());
    }

    @Test
    public void executionJobShouldGetPriorityFromOverridingJobDefinitionPriority() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        JobDefinition executionJobDefinition = this.helper.getExecutionJobDefinition(batch);
        this.managementService.setOverridingJobPriorityForJobDefinition(executionJobDefinition.getId(), CUSTOM_PRIORITY, true);
        this.helper.completeSeedJobs(batch);
        Job executionJob = this.helper.getExecutionJobs(batch).get(0);
        Assert.assertEquals((long)CUSTOM_PRIORITY, (long)executionJob.getPriority());
    }

    @Test
    public void executionJobShouldGetPriorityFromOverridingJobDefinitionPriorityWithCascade() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        JobDefinition executionJobDefinition = this.helper.getExecutionJobDefinition(batch);
        this.helper.completeSeedJobs(batch);
        this.managementService.setOverridingJobPriorityForJobDefinition(executionJobDefinition.getId(), CUSTOM_PRIORITY, true);
        Job executionJob = this.helper.getExecutionJobs(batch).get(0);
        Assert.assertEquals((long)CUSTOM_PRIORITY, (long)executionJob.getPriority());
    }

    protected void setBatchJobPriority(long priority) {
        this.engineRule.getProcessEngineConfiguration().setBatchJobPriority(priority);
    }
}

