/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.mgmt;

import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.management.JobDefinition;
import org.eximeebpms.bpm.engine.management.JobDefinitionQuery;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class JobDefinitionQueryTest
extends PluggableProcessEngineTest {
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/JobDefinitionQueryTest.testBase.bpmn"})
    @Test
    public void testQueryByNoCriteria() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        this.verifyQueryResults(query, 4);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/JobDefinitionQueryTest.testBase.bpmn"})
    @Test
    public void testQueryByJobDefinitionId() {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobType("timer-start-event").singleResult();
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery().jobDefinitionId(jobDefinition.getId());
        this.verifyQueryResults(query, 1);
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)((JobDefinition)query.singleResult()).getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/JobDefinitionQueryTest.testBase.bpmn"})
    @Test
    public void testQueryByInvalidJobDefinitionId() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery().jobDefinitionId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.managementService.createJobDefinitionQuery().jobDefinitionId(null);
            Assert.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/JobDefinitionQueryTest.testBase.bpmn"})
    @Test
    public void testQueryByActivityId() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery().activityIdIn(new String[]{"ServiceTask_1"});
        this.verifyQueryResults(query, 1);
        query = this.managementService.createJobDefinitionQuery().activityIdIn(new String[]{"ServiceTask_1", "BoundaryEvent_1"});
        this.verifyQueryResults(query, 2);
        query = this.managementService.createJobDefinitionQuery().activityIdIn(new String[]{"ServiceTask_1", "BoundaryEvent_1", "StartEvent_1"});
        this.verifyQueryResults(query, 3);
        query = this.managementService.createJobDefinitionQuery().activityIdIn(new String[]{"ServiceTask_1", "BoundaryEvent_1", "StartEvent_1", "IntermediateCatchEvent_1"});
        this.verifyQueryResults(query, 4);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/JobDefinitionQueryTest.testBase.bpmn"})
    @Test
    public void testQueryByInvalidActivityId() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery().activityIdIn(new String[]{"invalid"});
        this.verifyQueryResults(query, 0);
        try {
            this.managementService.createJobDefinitionQuery().activityIdIn(null);
            Assert.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.createJobDefinitionQuery().activityIdIn(new String[]{null});
            Assert.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/JobDefinitionQueryTest.testBase.bpmn"})
    @Test
    public void testQueryByProcessDefinitionId() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery().processDefinitionId(processDefinition.getId());
        this.verifyQueryResults(query, 4);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/JobDefinitionQueryTest.testBase.bpmn"})
    @Test
    public void testQueryByInvalidDefinitionId() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery().processDefinitionId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.managementService.createJobDefinitionQuery().processDefinitionId(null);
            Assert.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/JobDefinitionQueryTest.testBase.bpmn"})
    @Test
    public void testQueryByProcessDefinitionKey() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery().processDefinitionKey(processDefinition.getKey());
        this.verifyQueryResults(query, 4);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/JobDefinitionQueryTest.testBase.bpmn"})
    @Test
    public void testQueryByInvalidDefinitionKey() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery().processDefinitionKey("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.managementService.createJobDefinitionQuery().processDefinitionKey(null);
            Assert.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/JobDefinitionQueryTest.testBase.bpmn"})
    @Test
    public void testQueryByJobType() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery().jobType("async-continuation");
        this.verifyQueryResults(query, 1);
        query = this.managementService.createJobDefinitionQuery().jobType("timer-start-event");
        this.verifyQueryResults(query, 1);
        query = this.managementService.createJobDefinitionQuery().jobType("timer-intermediate-transition");
        this.verifyQueryResults(query, 1);
        query = this.managementService.createJobDefinitionQuery().jobType("timer-transition");
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/JobDefinitionQueryTest.testBase.bpmn"})
    @Test
    public void testQueryByInvalidJobType() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery().jobType("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.managementService.createJobDefinitionQuery().jobType(null);
            Assert.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/JobDefinitionQueryTest.testBase.bpmn"})
    @Test
    public void testQueryByInvalidJobConfiguration() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery().jobConfiguration("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.managementService.createJobDefinitionQuery().jobConfiguration(null);
            Assert.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/JobDefinitionQueryTest.testBase.bpmn"})
    @Test
    public void testQueryByActive() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery().active();
        this.verifyQueryResults(query, 4);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobType("async-continuation").singleResult();
        this.managementService.suspendJobDefinitionById(jobDefinition.getId());
        this.verifyQueryResults(query, 3);
        jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobType("timer-start-event").singleResult();
        this.managementService.suspendJobDefinitionById(jobDefinition.getId());
        this.verifyQueryResults(query, 2);
        jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobType("timer-intermediate-transition").singleResult();
        this.managementService.suspendJobDefinitionById(jobDefinition.getId());
        this.verifyQueryResults(query, 1);
        jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobType("timer-transition").singleResult();
        this.managementService.suspendJobDefinitionById(jobDefinition.getId());
        this.verifyQueryResults(query, 0);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/JobDefinitionQueryTest.testBase.bpmn"})
    @Test
    public void testQueryBySuspended() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery().suspended();
        this.verifyQueryResults(query, 0);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobType("async-continuation").singleResult();
        this.managementService.suspendJobDefinitionById(jobDefinition.getId());
        this.verifyQueryResults(query, 1);
        jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobType("timer-start-event").singleResult();
        this.managementService.suspendJobDefinitionById(jobDefinition.getId());
        this.verifyQueryResults(query, 2);
        jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobType("timer-intermediate-transition").singleResult();
        this.managementService.suspendJobDefinitionById(jobDefinition.getId());
        this.verifyQueryResults(query, 3);
        jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobType("timer-transition").singleResult();
        this.managementService.suspendJobDefinitionById(jobDefinition.getId());
        this.verifyQueryResults(query, 4);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/JobDefinitionQueryTest.testBase.bpmn"})
    @Test
    public void testQueryPaging() {
        Assert.assertEquals((long)4L, (long)this.managementService.createJobDefinitionQuery().listPage(0, 4).size());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobDefinitionQuery().listPage(2, 1).size());
        Assert.assertEquals((long)2L, (long)this.managementService.createJobDefinitionQuery().listPage(1, 2).size());
        Assert.assertEquals((long)3L, (long)this.managementService.createJobDefinitionQuery().listPage(1, 4).size());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/JobDefinitionQueryTest.testBase.bpmn"})
    @Test
    public void testQuerySorting() {
        Assert.assertEquals((long)4L, (long)((JobDefinitionQuery)this.managementService.createJobDefinitionQuery().orderByActivityId().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((JobDefinitionQuery)this.managementService.createJobDefinitionQuery().orderByJobConfiguration().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((JobDefinitionQuery)this.managementService.createJobDefinitionQuery().orderByJobDefinitionId().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((JobDefinitionQuery)this.managementService.createJobDefinitionQuery().orderByJobType().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((JobDefinitionQuery)this.managementService.createJobDefinitionQuery().orderByProcessDefinitionId().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((JobDefinitionQuery)this.managementService.createJobDefinitionQuery().orderByProcessDefinitionKey().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((JobDefinitionQuery)this.managementService.createJobDefinitionQuery().orderByActivityId().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((JobDefinitionQuery)this.managementService.createJobDefinitionQuery().orderByJobConfiguration().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((JobDefinitionQuery)this.managementService.createJobDefinitionQuery().orderByJobDefinitionId().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((JobDefinitionQuery)this.managementService.createJobDefinitionQuery().orderByJobType().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((JobDefinitionQuery)this.managementService.createJobDefinitionQuery().orderByProcessDefinitionId().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((JobDefinitionQuery)this.managementService.createJobDefinitionQuery().orderByProcessDefinitionKey().desc()).list().size());
    }

    @Test
    public void testQueryInvalidSortingUsage() {
        try {
            this.managementService.createJobDefinitionQuery().orderByJobDefinitionId().list();
            Assert.fail();
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("call asc() or desc() after using orderByXX()", e.getMessage());
        }
        try {
            this.managementService.createJobQuery().asc();
            Assert.fail();
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("You should call any of the orderBy methods first before specifying a direction", e.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/JobDefinitionQueryTest.testBase.bpmn"})
    @Test
    public void testQueryWithOverridingJobPriority() {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().listPage(0, 1).get(0);
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 42L);
        JobDefinition queriedDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().withOverridingJobPriority().singleResult();
        Assert.assertNotNull((Object)queriedDefinition);
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)queriedDefinition.getId());
        Assert.assertEquals((long)42L, (long)queriedDefinition.getOverridingJobPriority());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobDefinitionQuery().withOverridingJobPriority().count());
    }

    private void verifyQueryResults(JobDefinitionQuery query, int countExpected) {
        Assert.assertEquals((long)countExpected, (long)query.list().size());
        Assert.assertEquals((long)countExpected, (long)query.count());
        if (countExpected == 1) {
            Assert.assertNotNull((Object)query.singleResult());
        } else if (countExpected > 1) {
            this.verifySingleResultFails(query);
        } else if (countExpected == 0) {
            Assert.assertNull((Object)query.singleResult());
        }
    }

    private void verifySingleResultFails(JobDefinitionQuery query) {
        try {
            query.singleResult();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }
}

