/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.mgmt.metrics;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.impl.ProcessEngineImpl;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.jobexecutor.CallerRunsRejectedJobsHandler;
import org.eximeebpms.bpm.engine.impl.jobexecutor.DefaultJobExecutor;
import org.eximeebpms.bpm.engine.impl.jobexecutor.JobExecutor;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.api.mgmt.metrics.AbstractMetricsTest;
import org.eximeebpms.bpm.engine.test.concurrency.ConcurrencyTestHelper;
import org.eximeebpms.bpm.engine.test.jobexecutor.ControllableJobExecutor;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JobExecutorMetricsTest
extends AbstractMetricsTest {
    protected JobExecutor defaultJobExecutor;
    protected ProcessEngine processEngine;

    @Before
    public void saveJobExecutor() {
        this.processEngine = this.engineRule.getProcessEngine();
        this.defaultJobExecutor = this.processEngineConfiguration.getJobExecutor();
    }

    @After
    public void restoreJobExecutor() {
        this.processEngineConfiguration.setJobExecutor(this.defaultJobExecutor);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/metrics/asyncServiceTaskProcess.bpmn20.xml"})
    @Test
    public void testJobAcquisitionMetricReporting() {
        for (int i = 0; i < 3; ++i) {
            this.runtimeService.startProcessInstanceByKey("asyncServiceTaskProcess");
        }
        this.testRule.waitForJobExecutorToProcessAllJobs(5000L);
        this.processEngineConfiguration.getDbMetricsReporter().reportNow();
        long acquisitionAttempts = this.managementService.createMetricsQuery().name("job-acquisition-attempt").sum();
        Assert.assertTrue((acquisitionAttempts >= 1L ? 1 : 0) != 0);
        long acquiredJobs = this.managementService.createMetricsQuery().name("job-acquired-success").sum();
        Assert.assertEquals((long)3L, (long)acquiredJobs);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/metrics/asyncServiceTaskProcess.bpmn20.xml"})
    @Test
    public void testCompetingJobAcquisitionMetricReporting() {
        for (int i = 0; i < 3; ++i) {
            this.runtimeService.startProcessInstanceByKey("asyncServiceTaskProcess");
        }
        ControllableJobExecutor jobExecutor1 = new ControllableJobExecutor((ProcessEngineImpl)this.processEngine);
        this.processEngineConfiguration.setJobExecutor((JobExecutor)jobExecutor1);
        ControllableJobExecutor jobExecutor2 = new ControllableJobExecutor((ProcessEngineImpl)this.processEngine);
        ConcurrencyTestHelper.ThreadControl jobAcquisitionThread1 = jobExecutor1.getAcquisitionThreadControl();
        ConcurrencyTestHelper.ThreadControl jobAcquisitionThread2 = jobExecutor2.getAcquisitionThreadControl();
        jobExecutor1.start();
        jobAcquisitionThread1.waitForSync();
        jobAcquisitionThread1.makeContinueAndWaitForSync();
        jobExecutor2.start();
        jobAcquisitionThread2.waitForSync();
        jobAcquisitionThread2.makeContinueAndWaitForSync();
        jobAcquisitionThread1.makeContinueAndWaitForSync();
        jobAcquisitionThread2.makeContinueAndWaitForSync();
        this.processEngineConfiguration.getDbMetricsReporter().reportNow();
        long acquisitionAttempts = this.managementService.createMetricsQuery().name("job-acquisition-attempt").sum();
        Assert.assertEquals((long)4L, (long)acquisitionAttempts);
        long acquiredJobs = this.managementService.createMetricsQuery().name("job-acquired-success").sum();
        Assert.assertEquals((long)3L, (long)acquiredJobs);
        long acquiredJobsFailure = this.managementService.createMetricsQuery().name("job-acquired-failure").sum();
        Assert.assertEquals((long)3L, (long)acquiredJobsFailure);
        jobExecutor1.shutdown();
        jobExecutor2.shutdown();
        this.processEngineConfiguration.getDbMetricsReporter().reportNow();
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/metrics/asyncServiceTaskProcess.bpmn20.xml"})
    @Test
    public void testJobExecutionMetricReporting() {
        int i;
        for (i = 0; i < 3; ++i) {
            this.runtimeService.startProcessInstanceByKey("asyncServiceTaskProcess");
        }
        for (i = 0; i < 2; ++i) {
            this.runtimeService.startProcessInstanceByKey("asyncServiceTaskProcess", (Map)Variables.createVariables().putValue("fail", (Object)true));
        }
        this.testRule.waitForJobExecutorToProcessAllJobs(5000L);
        long jobsSuccessful = this.managementService.createMetricsQuery().name("job-successful").sum();
        Assert.assertEquals((long)3L, (long)jobsSuccessful);
        long jobsFailed = this.managementService.createMetricsQuery().name("job-failed").sum();
        Assert.assertEquals((long)6L, (long)jobsFailed);
        long jobCandidatesForAcquisition = this.managementService.createMetricsQuery().name("job-acquired-success").sum();
        Assert.assertEquals((long)9L, (long)jobCandidatesForAcquisition);
    }

    @Deployment
    @Test
    public void testJobExecutionMetricExclusiveFollowUp() {
        for (int i = 0; i < 3; ++i) {
            this.runtimeService.startProcessInstanceByKey("exclusiveServiceTasksProcess");
        }
        this.testRule.waitForJobExecutorToProcessAllJobs(5000L);
        long jobsSuccessful = this.managementService.createMetricsQuery().name("job-successful").sum();
        long jobsFailed = this.managementService.createMetricsQuery().name("job-failed").sum();
        long jobCandidatesForAcquisition = this.managementService.createMetricsQuery().name("job-acquired-success").sum();
        long exclusiveFollowupJobs = this.managementService.createMetricsQuery().name("job-locked-exclusive").sum();
        Assert.assertEquals((long)6L, (long)jobsSuccessful);
        Assert.assertEquals((long)0L, (long)jobsFailed);
        Assert.assertEquals((long)3L, (long)jobCandidatesForAcquisition);
        Assert.assertEquals((long)3L, (long)exclusiveFollowupJobs);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/metrics/asyncServiceTaskProcess.bpmn20.xml"})
    @Test
    public void testJobRejectedExecutionMetricReporting() {
        RejectingJobExecutor rejectingExecutor = new RejectingJobExecutor();
        this.processEngineConfiguration.setJobExecutor((JobExecutor)rejectingExecutor);
        rejectingExecutor.registerProcessEngine((ProcessEngineImpl)this.processEngine);
        for (int i = 0; i < 3; ++i) {
            this.runtimeService.startProcessInstanceByKey("asyncServiceTaskProcess");
        }
        List jobIds = this.managementService.createJobQuery().processDefinitionKey("asyncServiceTaskProcess").list().stream().map(Job::getId).collect(Collectors.toList());
        JobExecutor jobExecutor = ((ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration()).getJobExecutor();
        jobExecutor.executeJobs(jobIds, (ProcessEngineImpl)this.processEngine);
        long numRejectedJobs = this.managementService.createMetricsQuery().name("job-execution-rejected").sum();
        Assertions.assertThat((long)numRejectedJobs).isEqualTo(3L);
    }

    public static class RejectingJobExecutor
    extends DefaultJobExecutor {
        public RejectingJobExecutor() {
            ArrayBlockingQueue threadPoolQueue = new ArrayBlockingQueue(this.queueSize);
            this.threadPoolExecutor = new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, 0L, TimeUnit.MILLISECONDS, threadPoolQueue){

                @Override
                public void execute(Runnable command) {
                    throw new RejectedExecutionException();
                }
            };
            this.threadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
            this.rejectedJobsHandler = new CallerRunsRejectedJobsHandler();
        }
    }
}

