/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.multitenancy.cmmn.query;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.exception.NullValueException;
import org.eximeebpms.bpm.engine.repository.CaseDefinition;
import org.eximeebpms.bpm.engine.repository.CaseDefinitionQuery;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiTenancyCaseDefinitionQueryTest
extends PluggableProcessEngineTest {
    protected static final String CASE_DEFINITION_KEY = "Case_1";
    protected static final String CMMN = "org/eximeebpms/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testSimpleDeployment.cmmn";
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    @Before
    public void setUp() {
        this.testRule.deploy(CMMN);
        this.testRule.deployForTenant(TENANT_ONE, CMMN);
        this.testRule.deployForTenant(TENANT_TWO, CMMN);
    }

    @Test
    public void testQueryNoTenantIdSet() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }

    @Test
    public void testQueryByTenantId() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        query = this.repositoryService.createCaseDefinitionQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void testQueryByTenantIds() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
    }

    @Test
    public void testQueryByDefinitionsWithoutTenantId() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery().withoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void testQueryByTenantIdsIncludeDefinitionsWithoutTenantId() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).includeCaseDefinitionsWithoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        query = this.repositoryService.createCaseDefinitionQuery().tenantIdIn(new String[]{TENANT_TWO}).includeCaseDefinitionsWithoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        query = this.repositoryService.createCaseDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).includeCaseDefinitionsWithoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }

    @Test
    public void testQueryByKey() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(CASE_DEFINITION_KEY);
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        query = this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(CASE_DEFINITION_KEY).withoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        query = this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(CASE_DEFINITION_KEY).tenantIdIn(new String[]{TENANT_ONE});
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void testQueryByLatestNoTenantIdSet() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN);
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(CASE_DEFINITION_KEY).latestVersion();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        Map<String, CaseDefinition> caseDefinitionsForTenant = this.getCaseDefinitionsForTenant(query.list());
        Assertions.assertThat((int)caseDefinitionsForTenant.get(TENANT_ONE).getVersion()).isEqualTo(2);
        Assertions.assertThat((int)caseDefinitionsForTenant.get(TENANT_TWO).getVersion()).isEqualTo(1);
        Assertions.assertThat((int)caseDefinitionsForTenant.get(null).getVersion()).isEqualTo(1);
    }

    @Test
    public void testQueryByLatestWithTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN);
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(CASE_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_ONE});
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        CaseDefinition caseDefinition = (CaseDefinition)query.singleResult();
        Assertions.assertThat((String)caseDefinition.getTenantId()).isEqualTo((Object)TENANT_ONE);
        Assertions.assertThat((int)caseDefinition.getVersion()).isEqualTo(2);
        query = this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(CASE_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        caseDefinition = (CaseDefinition)query.singleResult();
        Assertions.assertThat((String)caseDefinition.getTenantId()).isEqualTo((Object)TENANT_TWO);
        Assertions.assertThat((int)caseDefinition.getVersion()).isEqualTo(1);
    }

    @Test
    public void testQueryByLatestWithTenantIds() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN);
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(CASE_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        Map<String, CaseDefinition> caseDefinitionsForTenant = this.getCaseDefinitionsForTenant(query.list());
        Assertions.assertThat((int)caseDefinitionsForTenant.get(TENANT_ONE).getVersion()).isEqualTo(2);
        Assertions.assertThat((int)caseDefinitionsForTenant.get(TENANT_TWO).getVersion()).isEqualTo(1);
    }

    @Test
    public void testQueryByLatestWithoutTenantId() {
        this.testRule.deploy(CMMN);
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(CASE_DEFINITION_KEY).latestVersion().withoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        CaseDefinition cDefinition = (CaseDefinition)query.singleResult();
        Assertions.assertThat((String)cDefinition.getTenantId()).isNull();
        Assertions.assertThat((int)cDefinition.getVersion()).isEqualTo(2);
    }

    @Test
    public void testQueryByLatestWithTenantIdsIncludeDefinitionsWithoutTenantId() {
        this.testRule.deploy(CMMN);
        this.testRule.deployForTenant(TENANT_ONE, CMMN);
        this.testRule.deployForTenant(TENANT_ONE, CMMN);
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(CASE_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).includeCaseDefinitionsWithoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        Map<String, CaseDefinition> caseDefinitionsForTenant = this.getCaseDefinitionsForTenant(query.list());
        Assertions.assertThat((int)caseDefinitionsForTenant.get(TENANT_ONE).getVersion()).isEqualTo(3);
        Assertions.assertThat((int)caseDefinitionsForTenant.get(TENANT_TWO).getVersion()).isEqualTo(1);
        Assertions.assertThat((int)caseDefinitionsForTenant.get(null).getVersion()).isEqualTo(2);
    }

    @Test
    public void testQueryByNonExistingTenantId() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery().tenantIdIn(new String[]{"nonExisting"});
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void testFailQueryByTenantIdNull() {
        try {
            this.repositoryService.createCaseDefinitionQuery().tenantIdIn(new String[]{null});
            Assert.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    public void testQuerySortingAsc() {
        List caseDefinitions = ((CaseDefinitionQuery)this.repositoryService.createCaseDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().asc()).list();
        Assertions.assertThat((List)caseDefinitions).hasSize(2);
        Assertions.assertThat((String)((CaseDefinition)caseDefinitions.get(0)).getTenantId()).isEqualTo((Object)TENANT_ONE);
        Assertions.assertThat((String)((CaseDefinition)caseDefinitions.get(1)).getTenantId()).isEqualTo((Object)TENANT_TWO);
    }

    @Test
    public void testQuerySortingDesc() {
        List caseDefinitions = ((CaseDefinitionQuery)this.repositoryService.createCaseDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().desc()).list();
        Assertions.assertThat((List)caseDefinitions).hasSize(2);
        Assertions.assertThat((String)((CaseDefinition)caseDefinitions.get(0)).getTenantId()).isEqualTo((Object)TENANT_TWO);
        Assertions.assertThat((String)((CaseDefinition)caseDefinitions.get(1)).getTenantId()).isEqualTo((Object)TENANT_ONE);
    }

    @Test
    public void testQueryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void testQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(0L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).includeCaseDefinitionsWithoutTenantId().count()).isEqualTo(2L);
    }

    @Test
    public void testQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void testQueryDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }

    protected Map<String, CaseDefinition> getCaseDefinitionsForTenant(List<CaseDefinition> definitions) {
        HashMap<String, CaseDefinition> definitionsForTenant = new HashMap<String, CaseDefinition>();
        for (CaseDefinition definition : definitions) {
            definitionsForTenant.put(definition.getTenantId(), definition);
        }
        return definitionsForTenant;
    }
}

