/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.multitenancy.query;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.history.UserOperationLogEntry;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class MultiTenancyUserOperationLogQueryTest {
    protected static final String USER_ONE = "aUserId";
    protected static final String USER_TWO = "aUserId1";
    protected static final String USER_WITHOUT_TENANT = "aUserId1";
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String PROCESS_NAME = "process";
    protected static final BpmnModelInstance MODEL = Bpmn.createExecutableProcess((String)"process").startEvent().userTask("aTaskId").done();
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected TaskService taskService;
    protected HistoryService historyService;
    protected RuntimeService runtimeService;
    protected IdentityService identityService;

    @Before
    public void init() {
        this.taskService = this.engineRule.getTaskService();
        this.historyService = this.engineRule.getHistoryService();
        this.identityService = this.engineRule.getIdentityService();
        this.runtimeService = this.engineRule.getRuntimeService();
    }

    @Test
    public void shouldReturnNoResultsWithoutTenant() {
        this.testRule.deployForTenant(TENANT_ONE, MODEL);
        this.identityService.setAuthentication(USER_ONE, null, Arrays.asList(TENANT_ONE));
        this.runtimeService.startProcessInstanceByKey(PROCESS_NAME);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        this.identityService.setAuthentication("aUserId1", null);
        UserOperationLogEntry singleResult = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult();
        Assertions.assertThat((long)this.historyService.createUserOperationLogQuery().entityType("Task").count()).isZero();
        Assertions.assertThat((Object)singleResult).isEqualTo(null);
    }

    @Test
    public void shouldReturnResultsWhenMultipleTenants() {
        this.testRule.deploy(MODEL);
        this.runtimeService.startProcessInstanceByKey(PROCESS_NAME);
        this.identityService.setAuthenticatedUserId("aUserId1");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        this.testRule.deployForTenant(TENANT_ONE, MODEL);
        this.identityService.setAuthentication(USER_ONE, null, Arrays.asList(TENANT_ONE));
        this.runtimeService.createProcessInstanceByKey(PROCESS_NAME).processDefinitionTenantId(TENANT_ONE).execute();
        taskId = ((Task)this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT_ONE}).singleResult()).getId();
        this.taskService.complete(taskId);
        this.testRule.deployForTenant(TENANT_TWO, MODEL);
        this.identityService.setAuthentication("aUserId1", null, Arrays.asList(TENANT_TWO));
        this.runtimeService.createProcessInstanceByKey(PROCESS_NAME).processDefinitionTenantId(TENANT_TWO).execute();
        taskId = ((Task)this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT_TWO}).singleResult()).getId();
        this.taskService.complete(taskId);
        List list = this.historyService.createUserOperationLogQuery().entityType("Task").list();
        Assertions.assertThat((long)this.historyService.createUserOperationLogQuery().entityType("Task").count()).isEqualTo(2L);
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((String)((UserOperationLogEntry)list.get(0)).getTenantId()).isIn(new Object[]{null, TENANT_TWO});
        Assertions.assertThat((String)((UserOperationLogEntry)list.get(1)).getTenantId()).isIn(new Object[]{null, TENANT_TWO});
    }

    @Test
    public void shouldReturnResultsWhenTwoTenant() {
        this.testRule.deployForTenant(TENANT_ONE, MODEL);
        this.identityService.setAuthentication(USER_ONE, null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        this.runtimeService.startProcessInstanceByKey(PROCESS_NAME);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        UserOperationLogEntry singleResult = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult();
        Assertions.assertThat((long)this.historyService.createUserOperationLogQuery().entityType("Task").count()).isOne();
        Assertions.assertThat((String)singleResult.getTenantId()).isEqualTo((Object)TENANT_ONE);
    }

    @Test
    public void shouldReturnResultsWithoutTenantId() {
        this.testRule.deploy(MODEL);
        this.runtimeService.startProcessInstanceByKey(PROCESS_NAME);
        this.identityService.setAuthenticatedUserId("aUserId1");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        this.testRule.deployForTenant(TENANT_ONE, MODEL);
        this.identityService.setAuthentication(USER_ONE, null, Arrays.asList(TENANT_ONE));
        this.runtimeService.createProcessInstanceByKey(PROCESS_NAME).processDefinitionTenantId(TENANT_ONE).execute();
        taskId = ((Task)this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT_ONE}).singleResult()).getId();
        this.taskService.complete(taskId);
        this.testRule.deployForTenant(TENANT_TWO, MODEL);
        this.identityService.setAuthentication("aUserId1", null, Arrays.asList(TENANT_TWO));
        this.runtimeService.createProcessInstanceByKey(PROCESS_NAME).processDefinitionTenantId(TENANT_TWO).execute();
        taskId = ((Task)this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT_TWO}).singleResult()).getId();
        this.taskService.complete(taskId);
        List list = this.historyService.createUserOperationLogQuery().entityType("Task").withoutTenantId().list();
        Assertions.assertThat((long)this.historyService.createUserOperationLogQuery().entityType("Task").withoutTenantId().count()).isOne();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((String)((UserOperationLogEntry)list.get(0)).getTenantId()).isEqualTo(null);
    }

    @Test
    public void shouldReturnResultsTenantIdIn() {
        this.testRule.deploy(MODEL);
        this.runtimeService.startProcessInstanceByKey(PROCESS_NAME);
        this.identityService.setAuthenticatedUserId("aUserId1");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        this.testRule.deployForTenant(TENANT_ONE, MODEL);
        this.identityService.setAuthentication(USER_ONE, null, Arrays.asList(TENANT_ONE));
        this.runtimeService.createProcessInstanceByKey(PROCESS_NAME).processDefinitionTenantId(TENANT_ONE).execute();
        taskId = ((Task)this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT_ONE}).singleResult()).getId();
        this.taskService.complete(taskId);
        this.testRule.deployForTenant(TENANT_TWO, MODEL);
        this.identityService.setAuthentication("aUserId1", null, Arrays.asList(TENANT_TWO));
        this.runtimeService.createProcessInstanceByKey(PROCESS_NAME).processDefinitionTenantId(TENANT_TWO).execute();
        taskId = ((Task)this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT_TWO}).singleResult()).getId();
        this.taskService.complete(taskId);
        List list = this.historyService.createUserOperationLogQuery().entityType("Task").tenantIdIn(new String[]{TENANT_TWO}).list();
        Assertions.assertThat((long)this.historyService.createUserOperationLogQuery().entityType("Task").tenantIdIn(new String[]{TENANT_TWO}).count()).isOne();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((String)((UserOperationLogEntry)list.get(0)).getTenantId()).isEqualTo((Object)TENANT_TWO);
    }
}

