/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.multitenancy.suspensionstate;

import java.util.Arrays;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.externaltask.ExternalTask;
import org.eximeebpms.bpm.engine.externaltask.ExternalTaskQuery;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.JobQuery;
import org.eximeebpms.bpm.engine.runtime.ProcessInstanceQuery;
import org.eximeebpms.bpm.engine.task.TaskQuery;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.SendTaskBuilder;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyProcessInstanceSuspensionStateTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String PROCESS_DEFINITION_KEY = "testProcess";
    protected static final BpmnModelInstance PROCESS = ((BoundaryEventBuilder)((SendTaskBuilder)((SendTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().parallelGateway("fork").userTask().moveToLastGateway().sendTask().camundaType("external")).camundaTopic("test")).boundaryEvent().timerWithDuration("PT1M")).done();
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Before
    public void setUp() throws Exception {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, PROCESS);
        this.testRule.deploy(PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_TWO).execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().execute();
    }

    @Test
    public void suspendAndActivateProcessInstancesForAllTenants() {
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).activate();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
    }

    @Test
    public void suspendProcessInstanceForTenant() {
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).suspend();
        Assertions.assertThat((long)query.active().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void suspendProcessInstanceForNonTenant() {
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().suspend();
        Assertions.assertThat((long)query.active().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void activateProcessInstanceForTenant() {
        this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).activate();
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.active().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void activateProcessInstanceForNonTenant() {
        this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().activate();
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.active().withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void suspendAndActivateProcessInstancesIncludingUserTasksForAllTenants() {
        TaskQuery query = this.engineRule.getTaskService().createTaskQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).activate();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
    }

    @Test
    public void suspendProcessInstanceIncludingUserTaskForTenant() {
        TaskQuery query = this.engineRule.getTaskService().createTaskQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).suspend();
        Assertions.assertThat((long)query.active().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void suspendProcessInstanceIncludingUserTaskForNonTenant() {
        TaskQuery query = this.engineRule.getTaskService().createTaskQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().suspend();
        Assertions.assertThat((long)query.active().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void activateProcessInstanceIncludingUserTaskForTenant() {
        this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        TaskQuery query = this.engineRule.getTaskService().createTaskQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).activate();
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.active().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void activateProcessInstanceIncludingUserTaskForNonTenant() {
        this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        TaskQuery query = this.engineRule.getTaskService().createTaskQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().activate();
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.active().withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void suspendAndActivateProcessInstancesIncludingExternalTasksForAllTenants() {
        ExternalTaskQuery query = this.engineRule.getExternalTaskService().createExternalTaskQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).activate();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
    }

    @Test
    public void suspendProcessInstanceIncludingExternalTaskForTenant() {
        ExternalTaskQuery query = this.engineRule.getExternalTaskService().createExternalTaskQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).suspend();
        Assertions.assertThat((long)query.active().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void suspendProcessInstanceIncludingExternalTaskForNonTenant() {
        ExternalTaskQuery query = this.engineRule.getExternalTaskService().createExternalTaskQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().suspend();
        Assertions.assertThat((long)query.active().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(1L);
        Assertions.assertThat((String)((ExternalTask)query.suspended().singleResult()).getTenantId()).isNull();
    }

    @Test
    public void activateProcessInstanceIncludingExternalTaskForTenant() {
        this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        ExternalTaskQuery query = this.engineRule.getExternalTaskService().createExternalTaskQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).activate();
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.active().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void activateProcessInstanceIncludingExternalTaskForNonTenant() {
        this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        ExternalTaskQuery query = this.engineRule.getExternalTaskService().createExternalTaskQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().activate();
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(1L);
        Assertions.assertThat((String)((ExternalTask)query.active().singleResult()).getTenantId()).isNull();
    }

    @Test
    public void suspendAndActivateProcessInstancesIncludingJobsForAllTenants() {
        JobQuery query = this.engineRule.getManagementService().createJobQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).activate();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
    }

    @Test
    public void suspendProcessInstanceIncludingJobForTenant() {
        JobQuery query = this.engineRule.getManagementService().createJobQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).suspend();
        Assertions.assertThat((long)query.active().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void suspendProcessInstanceIncludingJobForNonTenant() {
        JobQuery query = this.engineRule.getManagementService().createJobQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().suspend();
        Assertions.assertThat((long)query.active().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(1L);
        Assertions.assertThat((String)((Job)query.suspended().singleResult()).getTenantId()).isNull();
    }

    @Test
    public void activateProcessInstanceIncludingJobForTenant() {
        this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        JobQuery query = this.engineRule.getManagementService().createJobQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).activate();
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.active().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void activateProcessInstanceIncludingJobForNonTenant() {
        this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        JobQuery query = this.engineRule.getManagementService().createJobQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().activate();
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(1L);
        Assertions.assertThat((String)((Job)query.active().singleResult()).getTenantId()).isNull();
    }

    @Test
    public void suspendProcessInstanceNoAuthenticatedTenants() {
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getIdentityService().setAuthentication("user", null, null);
        this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        this.engineRule.getIdentityService().clearAuthentication();
        Assertions.assertThat((long)query.active().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void failToSuspendProcessInstanceByProcessDefinitionIdNoAuthenticatedTenants() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).tenantIdIn(new String[]{TENANT_ONE}).singleResult();
        this.engineRule.getIdentityService().setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionId(processDefinition.getId()).suspend()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot update the process definition '" + processDefinition.getId() + "' because it belongs to no authenticated tenant");
    }

    @Test
    public void suspendProcessInstanceWithAuthenticatedTenant() {
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getIdentityService().setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        this.engineRule.getIdentityService().clearAuthentication();
        Assertions.assertThat((long)query.active().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.active().tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().withoutTenantId().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void suspendProcessInstanceDisabledTenantCheck() {
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.engineRule.getIdentityService().setAuthentication("user", null, null);
        this.engineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).count()).isEqualTo(2L);
        Assertions.assertThat((long)query.suspended().withoutTenantId().count()).isEqualTo(1L);
    }
}

