/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.multitenancy.tenantcheck;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.ProcessEngineConfiguration;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.query.PeriodUnit;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class MultiTenancyHistoricProcessInstanceReportCmdTenantCheckTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String PROCESS_DEFINITION_KEY = "testProcess";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected RepositoryService repositoryService;
    protected IdentityService identityService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected HistoryService historyService;
    protected ProcessEngineConfiguration processEngineConfiguration;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected static final BpmnModelInstance BPMN_PROCESS = Bpmn.createExecutableProcess((String)"testProcess").startEvent().userTask().endEvent().done();

    @Before
    public void init() {
        this.repositoryService = this.engineRule.getRepositoryService();
        this.identityService = this.engineRule.getIdentityService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
        this.historyService = this.engineRule.getHistoryService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
    }

    @Test
    public void getDurationReportByMonthNoAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, BPMN_PROCESS);
        this.startAndCompleteProcessInstance(null);
        this.identityService.setAuthentication("user", null, null);
        List result = this.historyService.createHistoricProcessInstanceReport().duration(PeriodUnit.MONTH);
        Assertions.assertThat((List)result).hasSize(0);
    }

    @Test
    public void getDurationReportByMonthWithAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, BPMN_PROCESS);
        this.startAndCompleteProcessInstance(null);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        List result = this.historyService.createHistoricProcessInstanceReport().duration(PeriodUnit.MONTH);
        Assertions.assertThat((List)result).hasSize(1);
    }

    @Test
    public void getDurationReportByMonthDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, BPMN_PROCESS);
        this.startAndCompleteProcessInstance(null);
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        List result = this.historyService.createHistoricProcessInstanceReport().duration(PeriodUnit.MONTH);
        Assertions.assertThat((List)result).hasSize(1);
    }

    @Test
    public void getReportByMultipleProcessDefinitionIdByMonthNoAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, BPMN_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, BPMN_PROCESS);
        this.startAndCompleteProcessInstance(TENANT_ONE);
        this.startAndCompleteProcessInstance(TENANT_TWO);
        String processDefinitionIdOne = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).singleResult()).getId();
        String processDefinitionIdTwo = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_TWO}).singleResult()).getId();
        this.identityService.setAuthentication("user", null, null);
        List result = this.historyService.createHistoricProcessInstanceReport().processDefinitionIdIn(new String[]{processDefinitionIdOne, processDefinitionIdTwo}).duration(PeriodUnit.MONTH);
        Assertions.assertThat((List)result).hasSize(0);
    }

    @Test
    public void getReportByMultipleProcessDefinitionIdByMonthWithAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, BPMN_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, BPMN_PROCESS);
        this.startAndCompleteProcessInstance(TENANT_ONE);
        this.startAndCompleteProcessInstance(TENANT_TWO);
        String processDefinitionIdOne = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).singleResult()).getId();
        String processDefinitionIdTwo = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_TWO}).singleResult()).getId();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        List result = this.historyService.createHistoricProcessInstanceReport().processDefinitionIdIn(new String[]{processDefinitionIdOne, processDefinitionIdTwo}).duration(PeriodUnit.MONTH);
        Assertions.assertThat((List)result).hasSize(1);
    }

    @Test
    public void getReportByMultipleProcessDefinitionIdByMonthDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, BPMN_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, BPMN_PROCESS);
        this.startAndCompleteProcessInstance(TENANT_ONE);
        this.startAndCompleteProcessInstance(TENANT_TWO);
        String processDefinitionIdOne = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).singleResult()).getId();
        String processDefinitionIdTwo = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_TWO}).singleResult()).getId();
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        List result = this.historyService.createHistoricProcessInstanceReport().processDefinitionIdIn(new String[]{processDefinitionIdOne, processDefinitionIdTwo}).duration(PeriodUnit.MONTH);
        Assertions.assertThat((List)result).hasSize(2);
    }

    @Test
    public void getReportByProcessDefinitionKeyByMonthNoAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, BPMN_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, BPMN_PROCESS);
        this.startAndCompleteProcessInstance(TENANT_ONE);
        this.startAndCompleteProcessInstance(TENANT_TWO);
        this.identityService.setAuthentication("user", null, null);
        List result = this.historyService.createHistoricProcessInstanceReport().processDefinitionKeyIn(new String[]{PROCESS_DEFINITION_KEY}).duration(PeriodUnit.MONTH);
        Assertions.assertThat((List)result).hasSize(0);
    }

    @Test
    public void getReportByProcessDefinitionKeyByMonthWithAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, BPMN_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, BPMN_PROCESS);
        this.startAndCompleteProcessInstance(TENANT_ONE);
        this.startAndCompleteProcessInstance(TENANT_TWO);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        List result = this.historyService.createHistoricProcessInstanceReport().processDefinitionKeyIn(new String[]{PROCESS_DEFINITION_KEY}).duration(PeriodUnit.MONTH);
        Assertions.assertThat((List)result).hasSize(1);
    }

    @Test
    public void getReportByProcessDefinitionKeyByMonthDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, BPMN_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, BPMN_PROCESS);
        this.startAndCompleteProcessInstance(TENANT_ONE);
        this.startAndCompleteProcessInstance(TENANT_TWO);
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        List result = this.historyService.createHistoricProcessInstanceReport().processDefinitionKeyIn(new String[]{PROCESS_DEFINITION_KEY}).duration(PeriodUnit.MONTH);
        Assertions.assertThat((List)result).hasSize(2);
    }

    protected String startAndCompleteProcessInstance(String tenantId) {
        String processInstanceId = null;
        processInstanceId = tenantId == null ? this.runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY).getId() : this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(tenantId).execute().getId();
        this.addToCalendar(2, 5);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstanceId).singleResult();
        this.taskService.complete(task.getId());
        return processInstanceId;
    }

    protected void addToCalendar(int field, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(ClockUtil.getCurrentTime());
        calendar.add(field, month);
        ClockUtil.setCurrentTime((Date)calendar.getTime());
    }
}

