/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.multitenancy.tenantcheck;

import java.util.Arrays;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.runtime.Execution;
import org.eximeebpms.bpm.engine.task.TaskQuery;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyMessageEventReceivedCmdTenantCheckTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final BpmnModelInstance MESSAGE_CATCH_PROCESS = ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"messageCatch").startEvent().intermediateCatchEvent().message("message")).userTask().endEvent().done();
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected IdentityService identityService;

    @Before
    public void setUp() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
        this.identityService = this.engineRule.getIdentityService();
    }

    @Test
    public void correlateReceivedMessageToIntermediateCatchEventNoAuthenticatedTenants() {
        this.testRule.deploy(MESSAGE_CATCH_PROCESS);
        this.runtimeService.createProcessInstanceByKey("messageCatch").execute();
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processDefinitionKey("messageCatch").messageEventSubscriptionName("message").singleResult();
        this.identityService.setAuthentication("user", null, null);
        this.runtimeService.messageEventReceived("message", execution.getId());
        this.identityService.clearAuthentication();
        TaskQuery query = this.taskService.createTaskQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(0L);
        Assertions.assertThat((long)this.taskService.createTaskQuery().withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void correlateReceivedMessageToIntermediateCatchEventWithAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_CATCH_PROCESS);
        this.runtimeService.createProcessInstanceByKey("messageCatch").execute();
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processDefinitionKey("messageCatch").messageEventSubscriptionName("message").singleResult();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.runtimeService.messageEventReceived("message", execution.getId());
        this.identityService.clearAuthentication();
        TaskQuery query = this.taskService.createTaskQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void correlateReceivedMessageToIntermediateCatchEventDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, MESSAGE_CATCH_PROCESS);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_TWO).execute();
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processDefinitionKey("messageCatch").messageEventSubscriptionName("message").tenantIdIn(new String[]{TENANT_ONE}).singleResult();
        this.runtimeService.messageEventReceived("message", execution.getId());
        TaskQuery query = this.taskService.createTaskQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(0L);
    }

    @Test
    public void failToCorrelateReceivedMessageToIntermediateCatchEventNoAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_CATCH_PROCESS);
        this.runtimeService.createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processDefinitionKey("messageCatch").messageEventSubscriptionName("message").tenantIdIn(new String[]{TENANT_ONE}).singleResult();
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.messageEventReceived("message", execution.getId())).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot update the process instance");
    }
}

