/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eximeebpms.bpm.application.ProcessApplicationRegistration;
import org.eximeebpms.bpm.application.impl.EmbeddedProcessApplication;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.exception.NotFoundException;
import org.eximeebpms.bpm.engine.exception.NotValidException;
import org.eximeebpms.bpm.engine.query.Query;
import org.eximeebpms.bpm.engine.repository.DeploymentBuilder;
import org.eximeebpms.bpm.engine.repository.DeploymentQuery;
import org.eximeebpms.bpm.engine.repository.ProcessApplicationDeployment;
import org.eximeebpms.bpm.engine.repository.ProcessDefinitionQuery;
import org.eximeebpms.bpm.engine.repository.Resource;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.ScriptTaskBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class RedeploymentTest {
    public static final String DEPLOYMENT_NAME = "my-deployment";
    public static final String PROCESS_KEY = "process";
    public static final String PROCESS_1_KEY = "process-1";
    public static final String PROCESS_2_KEY = "process-2";
    public static final String PROCESS_3_KEY = "process-3";
    public static final String RESOURCE_NAME = "path/to/my/process.bpmn";
    public static final String RESOURCE_1_NAME = "path/to/my/process1.bpmn";
    public static final String RESOURCE_2_NAME = "path/to/my/process2.bpmn";
    public static final String RESOURCE_3_NAME = "path/to/my/process3.bpmn";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RepositoryService repositoryService;
    protected boolean enforceHistoryTimeToLive;

    @Before
    public void setUp() {
        this.repositoryService = this.engineRule.getRepositoryService();
        this.enforceHistoryTimeToLive = this.engineRule.getProcessEngineConfiguration().isEnforceHistoryTimeToLive();
    }

    @After
    public void tearDown() {
        this.engineRule.getProcessEngineConfiguration().setEnforceHistoryTimeToLive(this.enforceHistoryTimeToLive);
    }

    @Test
    public void testRedeployInvalidDeployment() {
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources("not-existing").deploy();
            Assert.fail((String)"It should not be able to re-deploy an unexisting deployment");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourceById("not-existing", "an-id").deploy();
            Assert.fail((String)"It should not be able to re-deploy an unexisting deployment");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourcesById("not-existing", Collections.singletonList("an-id")).deploy();
            Assert.fail((String)"It should not be able to re-deploy an unexisting deployment");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourceByName("not-existing", "a-name").deploy();
            Assert.fail((String)"It should not be able to re-deploy an unexisting deployment");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourcesByName("not-existing", Collections.singletonList("a-name")).deploy();
            Assert.fail((String)"It should not be able to re-deploy an unexisting deployment");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testNotValidDeploymentId() {
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(null);
            Assert.fail((String)"It should not be possible to pass a null deployment id");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourceById(null, "an-id");
            Assert.fail((String)"It should not be possible to pass a null deployment id");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourcesById(null, Collections.singletonList("an-id"));
            Assert.fail((String)"It should not be possible to pass a null deployment id");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourceByName(null, "a-name");
            Assert.fail((String)"It should not be possible to pass a null deployment id");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourcesByName(null, Collections.singletonList("a-name"));
            Assert.fail((String)"It should not be possible to pass a null deployment id");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testRedeployUnexistingDeploymentResource() {
        BpmnModelInstance model = this.createProcessWithServiceTask(PROCESS_KEY);
        Object deployment = this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, model));
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourceByName(deployment.getId(), "not-existing-resource.bpmn").deploy();
            Assert.fail((String)"It should not be possible to re-deploy a not existing deployment resource");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourcesByName(deployment.getId(), Collections.singletonList("not-existing-resource.bpmn")).deploy();
            Assert.fail((String)"It should not be possible to re-deploy a not existing deployment resource");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourceById(deployment.getId(), "not-existing-resource-id").deploy();
            Assert.fail((String)"It should not be possible to re-deploy a not existing deployment resource");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourcesById(deployment.getId(), Collections.singletonList("not-existing-resource-id")).deploy();
            Assert.fail((String)"It should not be possible to re-deploy a not existing deployment resource");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testNotValidResource() {
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourceById("an-id", null);
            Assert.fail((String)"It should not be possible to pass a null resource id");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourcesById("an-id", null);
            Assert.fail((String)"It should not be possible to pass a null resource id");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourcesById("an-id", Collections.singletonList(null));
            Assert.fail((String)"It should not be possible to pass a null resource id");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourcesById("an-id", new ArrayList());
            Assert.fail((String)"It should not be possible to pass a null resource id");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourceByName("an-id", null);
            Assert.fail((String)"It should not be possible to pass a null resource name");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourcesByName("an-id", null);
            Assert.fail((String)"It should not be possible to pass a null resource name");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourcesByName("an-id", Collections.singletonList(null));
            Assert.fail((String)"It should not be possible to pass a null resource name");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourcesByName("an-id", new ArrayList());
            Assert.fail((String)"It should not be possible to pass a null resource name");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testRedeployNewDeployment() {
        BpmnModelInstance model = this.createProcessWithServiceTask(PROCESS_KEY);
        Object deployment1 = this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, model));
        DeploymentQuery query = this.repositoryService.createDeploymentQuery().deploymentName(DEPLOYMENT_NAME);
        Assert.assertNotNull((Object)deployment1.getId());
        this.verifyQueryResults((Query<?, ?>)query, 1);
        Object deployment2 = this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()));
        Assert.assertNotNull(deployment2);
        Assert.assertNotNull((Object)deployment2.getId());
        Assert.assertFalse((boolean)deployment1.getId().equals(deployment2.getId()));
        this.verifyQueryResults((Query<?, ?>)query, 2);
    }

    @Test
    public void testFailingDeploymentName() {
        try {
            this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).nameFromDeployment("a-deployment-id");
            Assert.fail((String)"Cannot set name() and nameFromDeployment().");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().nameFromDeployment("a-deployment-id").name(DEPLOYMENT_NAME);
            Assert.fail((String)"Cannot set name() and nameFromDeployment().");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testRedeployDeploymentName() {
        BpmnModelInstance model = this.createProcessWithServiceTask(PROCESS_KEY);
        Object deployment1 = this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, model));
        Assert.assertEquals((Object)DEPLOYMENT_NAME, (Object)deployment1.getName());
        Object deployment2 = this.testRule.deploy(this.repositoryService.createDeployment().nameFromDeployment(deployment1.getId()).addDeploymentResources(deployment1.getId()));
        Assert.assertNotNull(deployment2);
        Assert.assertEquals((Object)deployment1.getName(), (Object)deployment2.getName());
    }

    @Test
    public void testRedeployDeploymentDifferentName() {
        BpmnModelInstance model = this.createProcessWithServiceTask(PROCESS_KEY);
        Object deployment1 = this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, model));
        Assert.assertEquals((Object)DEPLOYMENT_NAME, (Object)deployment1.getName());
        Object deployment2 = this.testRule.deploy(this.repositoryService.createDeployment().name("my-another-deployment").addDeploymentResources(deployment1.getId()));
        Assert.assertNotNull(deployment2);
        Assert.assertFalse((boolean)deployment1.getName().equals(deployment2.getName()));
    }

    @Test
    public void testRedeployDeploymentSourcePropertyNotSet() {
        BpmnModelInstance model = this.createProcessWithServiceTask(PROCESS_KEY);
        Object deployment1 = this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).source("my-deployment-source").addModelInstance(RESOURCE_NAME, model));
        Assert.assertEquals((Object)"my-deployment-source", (Object)deployment1.getSource());
        Object deployment2 = this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()));
        Assert.assertNotNull(deployment2);
        Assert.assertNull((Object)deployment2.getSource());
    }

    @Test
    public void testRedeploySetDeploymentSourceProperty() {
        BpmnModelInstance model = this.createProcessWithServiceTask(PROCESS_KEY);
        Object deployment1 = this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).source("my-deployment-source").addModelInstance(RESOURCE_NAME, model));
        Assert.assertEquals((Object)"my-deployment-source", (Object)deployment1.getSource());
        Object deployment2 = this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).source("my-another-deployment-source"));
        Assert.assertNotNull(deployment2);
        Assert.assertEquals((Object)"my-another-deployment-source", (Object)deployment2.getSource());
    }

    @Test
    public void testRedeployDeploymentResource() {
        BpmnModelInstance model = this.createProcessWithServiceTask(PROCESS_KEY);
        Object deployment1 = this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, model));
        Resource resource1 = this.getResourceByName(deployment1.getId(), RESOURCE_NAME);
        model = this.createProcessWithUserTask(PROCESS_KEY);
        Object deployment2 = this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, model));
        Resource resource2 = this.getResourceByName(deployment2.getId(), RESOURCE_NAME);
        Object deployment3 = this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()));
        Resource resource3 = this.getResourceByName(deployment3.getId(), RESOURCE_NAME);
        Assert.assertNotNull((Object)resource3);
        Assert.assertNotNull((Object)resource3.getId());
        Assert.assertFalse((boolean)resource1.getId().equals(resource3.getId()));
        Assert.assertEquals((Object)deployment3.getId(), (Object)resource3.getDeploymentId());
        Assert.assertEquals((Object)resource1.getName(), (Object)resource3.getName());
        byte[] bytes1 = resource1.getBytes();
        byte[] bytes2 = resource2.getBytes();
        byte[] bytes3 = resource3.getBytes();
        Assert.assertTrue((boolean)Arrays.equals(bytes1, bytes3));
        Assert.assertFalse((boolean)Arrays.equals(bytes2, bytes3));
    }

    @Test
    public void testRedeployAllDeploymentResources() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        BpmnModelInstance model2 = this.createProcessWithUserTask(PROCESS_2_KEY);
        Object deployment1 = this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 1);
        this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model2).addModelInstance(RESOURCE_2_NAME, model1));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 3);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 3);
    }

    @Test
    public void testRedeployOneDeploymentResourcesByName() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        BpmnModelInstance model2 = this.createProcessWithUserTask(PROCESS_2_KEY);
        Object deployment1 = this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 1);
        model1 = this.createProcessWithScriptTask(PROCESS_1_KEY);
        model2 = this.createProcessWithReceiveTask(PROCESS_2_KEY);
        this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourceByName(deployment1.getId(), RESOURCE_1_NAME));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 3);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
    }

    @Test
    public void testRedeployMultipleDeploymentResourcesByName() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        BpmnModelInstance model2 = this.createProcessWithUserTask(PROCESS_2_KEY);
        BpmnModelInstance model3 = this.createProcessWithScriptTask(PROCESS_3_KEY);
        Object deployment1 = this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2).addModelInstance(RESOURCE_3_NAME, model3));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_3_KEY), 1);
        model1 = this.createProcessWithScriptTask(PROCESS_1_KEY);
        model2 = this.createProcessWithReceiveTask(PROCESS_2_KEY);
        model3 = this.createProcessWithUserTask(PROCESS_3_KEY);
        Object deployment2 = this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2).addModelInstance(RESOURCE_3_NAME, model3));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_3_KEY), 2);
        this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourceByName(deployment1.getId(), RESOURCE_1_NAME).addDeploymentResourceByName(deployment1.getId(), RESOURCE_3_NAME));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 3);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_3_KEY), 3);
        this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourcesByName(deployment2.getId(), Arrays.asList(RESOURCE_1_NAME, RESOURCE_3_NAME)));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 4);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_3_KEY), 4);
    }

    @Test
    public void testRedeployOneAndMultipleDeploymentResourcesByName() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        BpmnModelInstance model2 = this.createProcessWithUserTask(PROCESS_2_KEY);
        BpmnModelInstance model3 = this.createProcessWithScriptTask(PROCESS_3_KEY);
        Object deployment1 = this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2).addModelInstance(RESOURCE_3_NAME, model3));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_3_KEY), 1);
        model1 = this.createProcessWithScriptTask(PROCESS_1_KEY);
        model2 = this.createProcessWithReceiveTask(PROCESS_2_KEY);
        model3 = this.createProcessWithUserTask(PROCESS_3_KEY);
        this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2).addModelInstance(RESOURCE_3_NAME, model3));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_3_KEY), 2);
        this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourceByName(deployment1.getId(), RESOURCE_1_NAME).addDeploymentResourcesByName(deployment1.getId(), Arrays.asList(RESOURCE_2_NAME, RESOURCE_3_NAME)));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 3);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 3);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_3_KEY), 3);
    }

    @Test
    public void testSameDeploymentResourceByName() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        BpmnModelInstance model2 = this.createProcessWithUserTask(PROCESS_2_KEY);
        Object deployment1 = this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 1);
        model1 = this.createProcessWithScriptTask(PROCESS_1_KEY);
        model2 = this.createProcessWithReceiveTask(PROCESS_2_KEY);
        this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourceByName(deployment1.getId(), RESOURCE_1_NAME).addDeploymentResourcesByName(deployment1.getId(), Collections.singletonList(RESOURCE_1_NAME)));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 3);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
    }

    @Test
    public void testRedeployOneDeploymentResourcesById() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        BpmnModelInstance model2 = this.createProcessWithUserTask(PROCESS_2_KEY);
        Object deployment1 = this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 1);
        Resource resource = this.getResourceByName(deployment1.getId(), RESOURCE_1_NAME);
        model1 = this.createProcessWithScriptTask(PROCESS_1_KEY);
        model2 = this.createProcessWithReceiveTask(PROCESS_2_KEY);
        this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourceById(deployment1.getId(), resource.getId()));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 3);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
    }

    @Test
    public void testRedeployMultipleDeploymentResourcesById() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        BpmnModelInstance model2 = this.createProcessWithUserTask(PROCESS_2_KEY);
        BpmnModelInstance model3 = this.createProcessWithScriptTask(PROCESS_3_KEY);
        Object deployment1 = this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2).addModelInstance(RESOURCE_3_NAME, model3));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_3_KEY), 1);
        Resource resource11 = this.getResourceByName(deployment1.getId(), RESOURCE_1_NAME);
        Resource resource13 = this.getResourceByName(deployment1.getId(), RESOURCE_3_NAME);
        model1 = this.createProcessWithScriptTask(PROCESS_1_KEY);
        model2 = this.createProcessWithReceiveTask(PROCESS_2_KEY);
        model3 = this.createProcessWithUserTask(PROCESS_3_KEY);
        Object deployment2 = this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2).addModelInstance(RESOURCE_3_NAME, model3));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_3_KEY), 2);
        Resource resource21 = this.getResourceByName(deployment2.getId(), RESOURCE_1_NAME);
        Resource resource23 = this.getResourceByName(deployment2.getId(), RESOURCE_3_NAME);
        this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourceById(deployment1.getId(), resource11.getId()).addDeploymentResourceById(deployment1.getId(), resource13.getId()));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 3);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_3_KEY), 3);
        this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourcesById(deployment2.getId(), Arrays.asList(resource21.getId(), resource23.getId())));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 4);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_3_KEY), 4);
    }

    @Test
    public void testRedeployOneAndMultipleDeploymentResourcesById() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        BpmnModelInstance model2 = this.createProcessWithUserTask(PROCESS_2_KEY);
        BpmnModelInstance model3 = this.createProcessWithScriptTask(PROCESS_3_KEY);
        Object deployment1 = this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2).addModelInstance(RESOURCE_3_NAME, model3));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_3_KEY), 1);
        Resource resource1 = this.getResourceByName(deployment1.getId(), RESOURCE_1_NAME);
        Resource resource2 = this.getResourceByName(deployment1.getId(), RESOURCE_2_NAME);
        Resource resource3 = this.getResourceByName(deployment1.getId(), RESOURCE_3_NAME);
        model1 = this.createProcessWithScriptTask(PROCESS_1_KEY);
        model2 = this.createProcessWithReceiveTask(PROCESS_2_KEY);
        model3 = this.createProcessWithUserTask(PROCESS_3_KEY);
        this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2).addModelInstance(RESOURCE_3_NAME, model3));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_3_KEY), 2);
        this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourceById(deployment1.getId(), resource1.getId()).addDeploymentResourcesById(deployment1.getId(), Arrays.asList(resource2.getId(), resource3.getId())));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 3);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 3);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_3_KEY), 3);
    }

    @Test
    public void testRedeploySameDeploymentResourceById() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        BpmnModelInstance model2 = this.createProcessWithUserTask(PROCESS_2_KEY);
        Object deployment1 = this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 1);
        Resource resource1 = this.getResourceByName(deployment1.getId(), RESOURCE_1_NAME);
        model1 = this.createProcessWithScriptTask(PROCESS_1_KEY);
        model2 = this.createProcessWithReceiveTask(PROCESS_2_KEY);
        this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourceById(deployment1.getId(), resource1.getId()).addDeploymentResourcesById(deployment1.getId(), Collections.singletonList(resource1.getId())));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 3);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
    }

    @Test
    public void testRedeployDeploymentResourceByIdAndName() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        BpmnModelInstance model2 = this.createProcessWithUserTask(PROCESS_2_KEY);
        Object deployment1 = this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 1);
        Resource resource1 = this.getResourceByName(deployment1.getId(), RESOURCE_1_NAME);
        Resource resource2 = this.getResourceByName(deployment1.getId(), RESOURCE_2_NAME);
        model1 = this.createProcessWithScriptTask(PROCESS_1_KEY);
        model2 = this.createProcessWithReceiveTask(PROCESS_2_KEY);
        this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResourceById(deployment1.getId(), resource1.getId()).addDeploymentResourceByName(deployment1.getId(), resource2.getName()));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 3);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 3);
    }

    @Test
    public void testRedeployDeploymentResourceByIdAndNameMultiple() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        BpmnModelInstance model2 = this.createProcessWithUserTask(PROCESS_2_KEY);
        Object deployment1 = this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 1);
        Resource resource1 = this.getResourceByName(deployment1.getId(), RESOURCE_1_NAME);
        Resource resource2 = this.getResourceByName(deployment1.getId(), RESOURCE_2_NAME);
        model1 = this.createProcessWithScriptTask(PROCESS_1_KEY);
        model2 = this.createProcessWithReceiveTask(PROCESS_2_KEY);
        this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1).addModelInstance(RESOURCE_2_NAME, model2));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        this.testRule.deploy(this.repositoryService.createDeployment().addDeploymentResourcesById(deployment1.getId(), Collections.singletonList(resource1.getId())).addDeploymentResourcesByName(deployment1.getId(), Collections.singletonList(resource2.getName())));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 3);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 3);
    }

    @Test
    public void testRedeployFormDifferentDeployments() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        Object deployment1 = this.testRule.deploy(this.repositoryService.createDeployment().name("my-deployment-1").addModelInstance(RESOURCE_1_NAME, model1));
        Assert.assertEquals((long)1L, (long)this.repositoryService.getDeploymentResources(deployment1.getId()).size());
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        BpmnModelInstance model2 = this.createProcessWithReceiveTask(PROCESS_2_KEY);
        Object deployment2 = this.testRule.deploy(this.repositoryService.createDeployment().name("my-deployment-2").addModelInstance(RESOURCE_2_NAME, model2));
        Assert.assertEquals((long)1L, (long)this.repositoryService.getDeploymentResources(deployment2.getId()).size());
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 1);
        Object deployment3 = this.testRule.deploy(this.repositoryService.createDeployment().name("my-deployment-3").addDeploymentResources(deployment1.getId()).addDeploymentResources(deployment2.getId()));
        Assert.assertEquals((long)2L, (long)this.repositoryService.getDeploymentResources(deployment3.getId()).size());
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
    }

    @Test
    public void testRedeployFormDifferentDeploymentsById() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        Object deployment1 = this.testRule.deploy(this.repositoryService.createDeployment().name("my-deployment-1").addModelInstance(RESOURCE_1_NAME, model1));
        Assert.assertEquals((long)1L, (long)this.repositoryService.getDeploymentResources(deployment1.getId()).size());
        Resource resource1 = this.getResourceByName(deployment1.getId(), RESOURCE_1_NAME);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        BpmnModelInstance model2 = this.createProcessWithReceiveTask(PROCESS_2_KEY);
        Object deployment2 = this.testRule.deploy(this.repositoryService.createDeployment().name("my-deployment-2").addModelInstance(RESOURCE_2_NAME, model2));
        Assert.assertEquals((long)1L, (long)this.repositoryService.getDeploymentResources(deployment2.getId()).size());
        Resource resource2 = this.getResourceByName(deployment2.getId(), RESOURCE_2_NAME);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 1);
        Object deployment3 = this.testRule.deploy(this.repositoryService.createDeployment().name("my-deployment-3").addDeploymentResourceById(deployment1.getId(), resource1.getId()).addDeploymentResourceById(deployment2.getId(), resource2.getId()));
        Assert.assertEquals((long)2L, (long)this.repositoryService.getDeploymentResources(deployment3.getId()).size());
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
    }

    @Test
    public void testRedeployFormDifferentDeploymentsByName() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        Object deployment1 = this.testRule.deploy(this.repositoryService.createDeployment().name("my-deployment-1").addModelInstance(RESOURCE_1_NAME, model1));
        Assert.assertEquals((long)1L, (long)this.repositoryService.getDeploymentResources(deployment1.getId()).size());
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        BpmnModelInstance model2 = this.createProcessWithReceiveTask(PROCESS_2_KEY);
        Object deployment2 = this.testRule.deploy(this.repositoryService.createDeployment().name("my-deployment-2").addModelInstance(RESOURCE_2_NAME, model2));
        Assert.assertEquals((long)1L, (long)this.repositoryService.getDeploymentResources(deployment2.getId()).size());
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 1);
        Object deployment3 = this.testRule.deploy(this.repositoryService.createDeployment().name("my-deployment-3").addDeploymentResourceByName(deployment1.getId(), RESOURCE_1_NAME).addDeploymentResourceByName(deployment2.getId(), RESOURCE_2_NAME));
        Assert.assertEquals((long)2L, (long)this.repositoryService.getDeploymentResources(deployment3.getId()).size());
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
    }

    @Test
    public void testRedeployFormDifferentDeploymentsByNameAndId() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        Object deployment1 = this.testRule.deploy(this.repositoryService.createDeployment().name("my-deployment-1").addModelInstance(RESOURCE_1_NAME, model1));
        Assert.assertEquals((long)1L, (long)this.repositoryService.getDeploymentResources(deployment1.getId()).size());
        Resource resource1 = this.getResourceByName(deployment1.getId(), RESOURCE_1_NAME);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        BpmnModelInstance model2 = this.createProcessWithReceiveTask(PROCESS_2_KEY);
        Object deployment2 = this.testRule.deploy(this.repositoryService.createDeployment().name("my-deployment-2").addModelInstance(RESOURCE_2_NAME, model2));
        Assert.assertEquals((long)1L, (long)this.repositoryService.getDeploymentResources(deployment2.getId()).size());
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 1);
        Object deployment3 = this.testRule.deploy(this.repositoryService.createDeployment().name("my-deployment-3").addDeploymentResourceById(deployment1.getId(), resource1.getId()).addDeploymentResourceByName(deployment2.getId(), RESOURCE_2_NAME));
        Assert.assertEquals((long)2L, (long)this.repositoryService.getDeploymentResources(deployment3.getId()).size());
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
    }

    @Test
    public void testRedeployFormDifferentDeploymentsAddsNewSource() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        Object deployment1 = this.testRule.deploy(this.repositoryService.createDeployment().name("my-deployment-1").addModelInstance(RESOURCE_1_NAME, model1));
        Assert.assertEquals((long)1L, (long)this.repositoryService.getDeploymentResources(deployment1.getId()).size());
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        BpmnModelInstance model2 = this.createProcessWithReceiveTask(PROCESS_2_KEY);
        Object deployment2 = this.testRule.deploy(this.repositoryService.createDeployment().name("my-deployment-2").addModelInstance(RESOURCE_2_NAME, model2));
        Assert.assertEquals((long)1L, (long)this.repositoryService.getDeploymentResources(deployment2.getId()).size());
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 1);
        BpmnModelInstance model3 = this.createProcessWithUserTask(PROCESS_3_KEY);
        Object deployment3 = this.testRule.deploy(this.repositoryService.createDeployment().name("my-deployment-3").addDeploymentResources(deployment1.getId()).addDeploymentResources(deployment2.getId()).addModelInstance(RESOURCE_3_NAME, model3));
        Assert.assertEquals((long)3L, (long)this.repositoryService.getDeploymentResources(deployment3.getId()).size());
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_2_KEY), 2);
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_3_KEY), 1);
    }

    @Test
    public void testRedeployFormDifferentDeploymentsSameResourceName() {
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        Object deployment1 = this.testRule.deploy(this.repositoryService.createDeployment().name("my-deployment-1").addModelInstance(RESOURCE_1_NAME, model1));
        BpmnModelInstance model2 = this.createProcessWithReceiveTask(PROCESS_2_KEY);
        Object deployment2 = this.testRule.deploy(this.repositoryService.createDeployment().name("my-deployment-2").addModelInstance(RESOURCE_1_NAME, model2));
        try {
            this.repositoryService.createDeployment().name("my-deployment-3").addDeploymentResources(deployment1.getId()).addDeploymentResources(deployment2.getId()).deploy();
            Assert.fail((String)"It should not be possible to deploy different resources with same name.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testRedeployAndAddNewResourceWithSameName() {
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        Object deployment1 = this.testRule.deploy(this.repositoryService.createDeployment().name("my-deployment-1").addModelInstance(RESOURCE_1_NAME, model1));
        BpmnModelInstance model2 = this.createProcessWithReceiveTask(PROCESS_2_KEY);
        try {
            this.repositoryService.createDeployment().name("my-deployment-2").addModelInstance(RESOURCE_1_NAME, model2).addDeploymentResourceByName(deployment1.getId(), RESOURCE_1_NAME).deploy();
            Assert.fail((String)"It should not be possible to deploy different resources with same name.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testRedeployEnableDuplcateChecking() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        BpmnModelInstance model1 = this.createProcessWithServiceTask(PROCESS_1_KEY);
        Object deployment1 = this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_1_NAME, model1));
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
        Object deployment2 = this.testRule.deploy(this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).enableDuplicateFiltering(true));
        Assert.assertEquals((Object)deployment1.getId(), (Object)deployment2.getId());
        this.verifyQueryResults((Query<?, ?>)query.processDefinitionKey(PROCESS_1_KEY), 1);
    }

    @Test
    public void testSimpleProcessApplicationDeployment() {
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        BpmnModelInstance model = this.createProcessWithServiceTask(PROCESS_KEY);
        ProcessApplicationDeployment deployment1 = (ProcessApplicationDeployment)this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(processApplication.getReference()).name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, model).enableDuplicateFiltering(true));
        Resource resource1 = this.getResourceByName(deployment1.getId(), RESOURCE_NAME);
        ProcessApplicationDeployment deployment2 = (ProcessApplicationDeployment)this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(processApplication.getReference()).name(DEPLOYMENT_NAME).addDeploymentResourceById(deployment1.getId(), resource1.getId()));
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        Assert.assertEquals((long)1L, (long)deploymentIds.size());
        Assert.assertTrue((boolean)deploymentIds.contains(deployment2.getId()));
    }

    @Test
    public void testRedeployProcessApplicationDeploymentResumePreviousVersions() {
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        BpmnModelInstance model = this.createProcessWithServiceTask(PROCESS_KEY);
        ProcessApplicationDeployment deployment1 = (ProcessApplicationDeployment)this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(processApplication.getReference()).name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, model).enableDuplicateFiltering(true));
        Resource resource1 = this.getResourceByName(deployment1.getId(), RESOURCE_NAME);
        model = this.createProcessWithUserTask(PROCESS_KEY);
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(processApplication.getReference()).name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, model).enableDuplicateFiltering(true));
        ProcessApplicationDeployment deployment3 = (ProcessApplicationDeployment)this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(processApplication.getReference()).name(DEPLOYMENT_NAME).resumePreviousVersions().addDeploymentResourceById(deployment1.getId(), resource1.getId()));
        ProcessApplicationRegistration registration = deployment3.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        Assert.assertEquals((long)3L, (long)deploymentIds.size());
    }

    @Test
    public void testProcessApplicationDeploymentResumePreviousVersionsByDeploymentName() {
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        BpmnModelInstance model = this.createProcessWithServiceTask(PROCESS_KEY);
        ProcessApplicationDeployment deployment1 = (ProcessApplicationDeployment)this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(processApplication.getReference()).name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, model).enableDuplicateFiltering(true));
        Resource resource1 = this.getResourceByName(deployment1.getId(), RESOURCE_NAME);
        model = this.createProcessWithUserTask(PROCESS_KEY);
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(processApplication.getReference()).name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, model).enableDuplicateFiltering(true));
        ProcessApplicationDeployment deployment3 = (ProcessApplicationDeployment)this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(processApplication.getReference()).name(DEPLOYMENT_NAME).resumePreviousVersions().resumePreviousVersionsBy("deployment-name").addDeploymentResourceById(deployment1.getId(), resource1.getId()));
        ProcessApplicationRegistration registration = deployment3.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        Assert.assertEquals((long)3L, (long)deploymentIds.size());
    }

    protected void verifyQueryResults(Query<?, ?> query, int countExpected) {
        Assert.assertEquals((long)countExpected, (long)query.count());
    }

    protected Resource getResourceByName(String deploymentId, String resourceName) {
        List resources = this.repositoryService.getDeploymentResources(deploymentId);
        for (Resource resource : resources) {
            if (!resource.getName().equals(resourceName)) continue;
            return resource;
        }
        return null;
    }

    protected BpmnModelInstance createProcessWithServiceTask(String key) {
        return ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)key).startEvent().serviceTask().camundaExpression("${true}")).endEvent().done();
    }

    protected BpmnModelInstance createProcessWithUserTask(String key) {
        return Bpmn.createExecutableProcess((String)key).startEvent().userTask().endEvent().done();
    }

    protected BpmnModelInstance createProcessWithReceiveTask(String key) {
        return Bpmn.createExecutableProcess((String)key).startEvent().receiveTask().endEvent().done();
    }

    protected BpmnModelInstance createProcessWithScriptTask(String key) {
        return ((ScriptTaskBuilder)((ScriptTaskBuilder)Bpmn.createExecutableProcess((String)key).startEvent().scriptTask().scriptFormat("javascript")).scriptText("return true")).userTask().endEvent().done();
    }
}

