/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime;

import java.util.ArrayList;
import java.util.List;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.batch.Batch;
import org.eximeebpms.bpm.engine.management.JobDefinition;
import org.eximeebpms.bpm.engine.runtime.ModificationBuilder;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.api.runtime.BatchHelper;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;

public class BatchModificationHelper
extends BatchHelper {
    protected ProcessEngineTestRule testRule;
    protected List<String> currentProcessInstances;

    public BatchModificationHelper(ProcessEngineRule engineRule) {
        super(engineRule);
        this.testRule = new ProcessEngineTestRule(engineRule);
        this.currentProcessInstances = new ArrayList<String>();
    }

    public Batch startAfterAsync(String key, int numberOfProcessInstances, String activityId, String processDefinitionId) {
        RuntimeService runtimeService = this.engineRule.getRuntimeService();
        List<String> processInstanceIds = this.startInstances(key, numberOfProcessInstances);
        return ((ModificationBuilder)runtimeService.createModification(processDefinitionId).startAfterActivity(activityId)).processInstanceIds(processInstanceIds).executeAsync();
    }

    public Batch startBeforeAsync(String key, int numberOfProcessInstances, String activityId, String processDefinitionId) {
        RuntimeService runtimeService = this.engineRule.getRuntimeService();
        List<String> processInstanceIds = this.startInstances(key, numberOfProcessInstances);
        return ((ModificationBuilder)runtimeService.createModification(processDefinitionId).startBeforeActivity(activityId)).processInstanceIds(processInstanceIds).executeAsync();
    }

    public Batch startTransitionAsync(String key, int numberOfProcessInstances, String transitionId, String processDefinitionId) {
        RuntimeService runtimeService = this.engineRule.getRuntimeService();
        List<String> processInstanceIds = this.startInstances(key, numberOfProcessInstances);
        return ((ModificationBuilder)runtimeService.createModification(processDefinitionId).startTransition(transitionId)).processInstanceIds(processInstanceIds).executeAsync();
    }

    public Batch cancelAllAsync(String key, int numberOfProcessInstances, String activityId, String processDefinitionId) {
        RuntimeService runtimeService = this.engineRule.getRuntimeService();
        List<String> processInstanceIds = this.startInstances(key, numberOfProcessInstances);
        return runtimeService.createModification(processDefinitionId).cancelAllForActivity(activityId).processInstanceIds(processInstanceIds).executeAsync();
    }

    public List<String> startInstances(String key, int numOfInstances) {
        ArrayList<String> instances = new ArrayList<String>();
        for (int i = 0; i < numOfInstances; ++i) {
            ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey(key);
            instances.add(processInstance.getId());
        }
        this.currentProcessInstances = instances;
        return instances;
    }

    @Override
    public JobDefinition getExecutionJobDefinition(Batch batch) {
        return (JobDefinition)this.engineRule.getManagementService().createJobDefinitionQuery().jobDefinitionId(batch.getBatchJobDefinitionId()).jobType("instance-modification").singleResult();
    }
}

