/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime;

import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.delegate.DelegateExecution;
import org.eximeebpms.bpm.engine.delegate.JavaDelegate;
import org.eximeebpms.bpm.engine.repository.Deployment;
import org.eximeebpms.bpm.engine.runtime.ActivityInstance;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class NestedExecutionAPIInvocationTest {
    @Rule
    public ProcessEngineRule engineRule1 = new ProvidedProcessEngineRule();
    @ClassRule
    public static ProcessEngineBootstrapRule engine2BootstrapRule = new ProcessEngineBootstrapRule("eximeebpms.cfg.prefix_extended.xml");
    @Rule
    public ProcessEngineRule engineRule2 = new ProvidedProcessEngineRule(engine2BootstrapRule);
    public static final String PROCESS_KEY_1 = "process";
    public static final String PROCESS_KEY_2 = "multiEngineProcess";
    public static final String ONE_TASK_PROCESS_KEY = "oneTaskProcess";
    public static final BpmnModelInstance PROCESS_MODEL = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().userTask("waitState").serviceTask("startProcess").camundaClass(NestedProcessStartDelegate.class.getName())).endEvent().done();
    public static final BpmnModelInstance PROCESS_MODEL_2 = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"multiEngineProcess").startEvent().userTask("waitState").serviceTask("startProcess").camundaClass(StartProcessOnAnotherEngineDelegate.class.getName())).endEvent().done();
    public static final BpmnModelInstance ONE_TASK_PROCESS_MODEL = Bpmn.createExecutableProcess((String)"oneTaskProcess").startEvent().userTask("waitState").endEvent().done();

    @Before
    public void init() {
        StartProcessOnAnotherEngineDelegate.engine = engine2BootstrapRule.getProcessEngine();
        NestedProcessStartDelegate.engine = this.engineRule1.getProcessEngine();
        Deployment deployment1 = this.engineRule1.getRepositoryService().createDeployment().addModelInstance("foo.bpmn", PROCESS_MODEL).deploy();
        Deployment deployment2 = this.engineRule1.getRepositoryService().createDeployment().addModelInstance("boo.bpmn", PROCESS_MODEL_2).deploy();
        this.engineRule1.manageDeployment(deployment1);
        this.engineRule1.manageDeployment(deployment2);
        Deployment deployment3 = this.engineRule2.getProcessEngine().getRepositoryService().createDeployment().addModelInstance("joo.bpmn", ONE_TASK_PROCESS_MODEL).deploy();
        this.engineRule2.manageDeployment(deployment3);
    }

    @After
    public void clearEngineReference() {
        StartProcessOnAnotherEngineDelegate.engine = null;
        NestedProcessStartDelegate.engine = null;
    }

    @Test
    public void testWaitStateIsReachedOnNestedInstantiation() {
        this.engineRule1.getRuntimeService().startProcessInstanceByKey(PROCESS_KEY_1);
        String taskId = ((Task)this.engineRule1.getTaskService().createTaskQuery().singleResult()).getId();
        this.engineRule1.getTaskService().complete(taskId);
    }

    @Test
    public void testWaitStateIsReachedOnMultiEngine() {
        this.engineRule1.getRuntimeService().startProcessInstanceByKey(PROCESS_KEY_2);
        String taskId = ((Task)this.engineRule1.getTaskService().createTaskQuery().singleResult()).getId();
        this.engineRule1.getTaskService().complete(taskId);
    }

    public static class StartProcessOnAnotherEngineDelegate
    implements JavaDelegate {
        public static ProcessEngine engine;

        public void execute(DelegateExecution execution) throws Exception {
            RuntimeService runtimeService = engine.getRuntimeService();
            ProcessInstance processInstance = runtimeService.startProcessInstanceByKey(NestedExecutionAPIInvocationTest.ONE_TASK_PROCESS_KEY);
            ActivityInstance activityInstance = runtimeService.getActivityInstance(processInstance.getId());
            ActivityInstance[] activityInstances = activityInstance.getActivityInstances("waitState");
            Assert.assertEquals((long)1L, (long)activityInstances.length);
        }
    }

    public static class NestedProcessStartDelegate
    implements JavaDelegate {
        public static ProcessEngine engine;

        public void execute(DelegateExecution execution) throws Exception {
            RuntimeService runtimeService = engine.getRuntimeService();
            ProcessInstance processInstance = runtimeService.startProcessInstanceByKey(NestedExecutionAPIInvocationTest.PROCESS_KEY_1);
            ActivityInstance activityInstance = runtimeService.getActivityInstance(processInstance.getId());
            ActivityInstance[] activityInstances = activityInstance.getActivityInstances("waitState");
            Assert.assertEquals((long)1L, (long)activityInstances.length);
        }
    }
}

