/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime;

import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.runtime.ActivityInstance;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class ProcessInstanceModificationVariableTest {
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);
    RuntimeService runtimeService;
    TaskService taskService;

    @Before
    public void initialize() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
    }

    @Test
    public void modifyAProcessInstanceWithLocalVariableCreation() {
        BpmnModelInstance instance = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"Process").startEvent().userTask("userTask").camundaTaskListenerClass("create", "org.eximeebpms.bpm.engine.test.api.runtime.util.CreateLocalVariableEventListener")).endEvent().done();
        this.testHelper.deployAndGetDefinition(instance);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstance.getId());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("userTask")).cancelActivityInstance(updatedTree.getActivityInstances("userTask")[0].getId()).execute(false, false);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.testHelper.assertProcessEnded(processInstance.getId());
    }
}

