/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.BadUserRequestException;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.ProcessEngines;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.delegate.DelegateExecution;
import org.eximeebpms.bpm.engine.delegate.JavaDelegate;
import org.eximeebpms.bpm.engine.exception.NotFoundException;
import org.eximeebpms.bpm.engine.exception.NullValueException;
import org.eximeebpms.bpm.engine.history.HistoricActivityInstance;
import org.eximeebpms.bpm.engine.history.HistoricDetail;
import org.eximeebpms.bpm.engine.history.HistoricProcessInstance;
import org.eximeebpms.bpm.engine.history.HistoricTaskInstance;
import org.eximeebpms.bpm.engine.impl.RuntimeServiceImpl;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.eximeebpms.bpm.engine.impl.cfg.StandaloneProcessEngineConfiguration;
import org.eximeebpms.bpm.engine.impl.history.HistoryLevel;
import org.eximeebpms.bpm.engine.impl.persistence.entity.HistoricDetailVariableInstanceUpdateEntity;
import org.eximeebpms.bpm.engine.impl.util.CollectionUtil;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.ActivityInstance;
import org.eximeebpms.bpm.engine.runtime.Execution;
import org.eximeebpms.bpm.engine.runtime.Incident;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.eximeebpms.bpm.engine.runtime.TransitionInstance;
import org.eximeebpms.bpm.engine.runtime.VariableInstance;
import org.eximeebpms.bpm.engine.runtime.VariableInstanceQuery;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.api.runtime.DummySerializable;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.eximeebpms.bpm.engine.test.api.runtime.util.SimpleSerializableBean;
import org.eximeebpms.bpm.engine.test.bpmn.executionlistener.RecorderExecutionListener;
import org.eximeebpms.bpm.engine.test.bpmn.tasklistener.util.RecorderTaskListener;
import org.eximeebpms.bpm.engine.test.history.SerializableVariable;
import org.eximeebpms.bpm.engine.test.util.ActivityInstanceAssert;
import org.eximeebpms.bpm.engine.test.util.ExecutableProcessUtil;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.TestExecutionListener;
import org.eximeebpms.bpm.engine.variable.VariableMap;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.eximeebpms.bpm.engine.variable.type.ValueType;
import org.eximeebpms.bpm.engine.variable.value.SerializationDataFormat;
import org.eximeebpms.bpm.engine.variable.value.TypedValue;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.CallActivityBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.ManualTaskBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.SubProcessBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class RuntimeServiceTest {
    public static final String TESTING_INSTANCE_DELETION = "testing instance deletion";
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> configuration.setJavaSerializationFormatEnabled(true));
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    private RuntimeService runtimeService;
    private TaskService taskService;
    private ManagementService managementService;
    private RepositoryService repositoryService;
    private HistoryService historyService;
    private ProcessEngineConfigurationImpl processEngineConfiguration;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
        this.managementService = this.engineRule.getManagementService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.historyService = this.engineRule.getHistoryService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
    }

    @Test
    public void testStartProcessInstanceByKeyNullKey() {
        try {
            this.runtimeService.startProcessInstanceByKey(null);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testStartProcessInstanceByKeyUnexistingKey() {
        try {
            this.runtimeService.startProcessInstanceByKey("unexistingkey");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("no processes deployed with key", ae.getMessage());
        }
    }

    @Test
    public void testStartProcessInstanceByIdNullId() {
        try {
            this.runtimeService.startProcessInstanceById(null);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testStartProcessInstanceByIdUnexistingId() {
        try {
            this.runtimeService.startProcessInstanceById("unexistingId");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("no deployed process definition found with id", ae.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testStartProcessInstanceByIdNullVariables() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)null);
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").count());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void startProcessInstanceWithBusinessKey() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "123");
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((Object)"123", (Object)processInstance.getBusinessKey());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").count());
        processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "456", CollectionUtil.singletonMap((String)"var", (Object)"value"));
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").count());
        Assert.assertEquals((Object)"value", (Object)this.runtimeService.getVariable(processInstance.getId(), "var"));
        processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId(), "789");
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").count());
        processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId(), "101123", CollectionUtil.singletonMap((String)"var", (Object)"value2"));
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((long)4L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").count());
        Assert.assertEquals((Object)"value2", (Object)this.runtimeService.getVariable(processInstance.getId(), "var"));
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").count());
        this.runtimeService.deleteProcessInstance(processInstance.getId(), TESTING_INSTANCE_DELETION);
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").count());
        if (!"none".equals(this.processEngineConfiguration.getHistory())) {
            HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
            Assert.assertEquals((Object)TESTING_INSTANCE_DELETION, (Object)historicTaskInstance.getDeleteReason());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstances() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.deleteProcessInstances(Arrays.asList(processInstance.getId(), processInstance2.getId()), null, false, false);
        Assertions.assertThat((long)this.runtimeService.createProcessInstanceQuery().count()).isEqualTo(0L);
    }

    @Deployment
    @Test
    public void testDeleteProcessInstanceWithListeners() {
        RecorderExecutionListener.clear();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedParallelGatewayScopeTasks");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "");
        List<RecorderExecutionListener.RecordedEvent> recordedEvents = RecorderExecutionListener.getRecordedEvents();
        Assert.assertEquals((long)10L, (long)recordedEvents.size());
        HashSet<RecorderExecutionListener.RecordedEvent> startEvents = new HashSet<RecorderExecutionListener.RecordedEvent>();
        HashSet<RecorderExecutionListener.RecordedEvent> endEvents = new HashSet<RecorderExecutionListener.RecordedEvent>();
        for (RecorderExecutionListener.RecordedEvent event : recordedEvents) {
            if (event.getEventName().equals("start")) {
                startEvents.add(event);
                continue;
            }
            if (!event.getEventName().equals("end")) continue;
            endEvents.add(event);
        }
        Assertions.assertThat(startEvents).hasSize(5);
        Assertions.assertThat(endEvents).hasSize(5);
        for (RecorderExecutionListener.RecordedEvent startEvent : startEvents) {
            Assertions.assertThat((String)startEvent.getActivityId()).isIn(new Object[]{"innerTask1", "innerTask2", "outerTask", "subProcess", "theStart"});
            for (RecorderExecutionListener.RecordedEvent endEvent : endEvents) {
                if (!startEvent.getActivityId().equals(endEvent.getActivityId())) continue;
                Assertions.assertThat((String)startEvent.getActivityInstanceId()).isEqualTo((Object)endEvent.getActivityInstanceId());
                Assertions.assertThat((String)startEvent.getExecutionId()).isEqualTo((Object)endEvent.getExecutionId());
            }
        }
        for (RecorderExecutionListener.RecordedEvent recordedEvent : endEvents) {
            Assertions.assertThat((String)recordedEvent.getActivityId()).isIn(new Object[]{"innerTask1", "innerTask2", "outerTask", "subProcess", null});
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstanceSkipCustomListenersEnsureHistoryWritten() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null, true);
        if (!"none".equals(this.processEngineConfiguration.getHistory())) {
            List hais = this.historyService.createHistoricActivityInstanceQuery().list();
            for (HistoricActivityInstance hai : hais) {
                Assert.assertNotNull((Object)hai.getEndTime());
            }
        }
    }

    @Deployment
    @Test
    public void testDeleteProcessInstanceSkipCustomListeners() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null, false);
        Assert.assertTrue((TestExecutionListener.collectedEvents.size() == 1 ? 1 : 0) != 0);
        TestExecutionListener.reset();
        processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null, true);
        Assert.assertTrue((TestExecutionListener.collectedEvents.size() == 0 ? 1 : 0) != 0);
        TestExecutionListener.reset();
    }

    @Deployment
    @Test
    public void testDeleteProcessInstanceSkipCustomListenersScope() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null, false);
        Assert.assertTrue((TestExecutionListener.collectedEvents.size() == 1 ? 1 : 0) != 0);
        TestExecutionListener.reset();
        processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null, true);
        Assert.assertTrue((TestExecutionListener.collectedEvents.size() == 0 ? 1 : 0) != 0);
        TestExecutionListener.reset();
    }

    @Deployment
    @Test
    public void testDeleteProcessInstanceSkipCustomTaskListeners() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        RecorderTaskListener.clear();
        this.runtimeService.deleteProcessInstance(instance.getId(), null, false);
        Assert.assertEquals((long)1L, (long)RecorderTaskListener.getRecordedEvents().size());
        Assert.assertEquals((Object)"delete", (Object)RecorderTaskListener.getRecordedEvents().get(0).getEvent());
        instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        RecorderTaskListener.clear();
        this.runtimeService.deleteProcessInstance(instance.getId(), null, true);
        Assert.assertTrue((boolean)RecorderTaskListener.getRecordedEvents().isEmpty());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcessWithIoMappings.bpmn20.xml"})
    @RequiredHistoryLevel(value="full")
    @Test
    public void testDeleteProcessInstanceSkipIoMappings() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("ioMappingProcess");
        this.runtimeService.deleteProcessInstance(instance.getId(), null, false, true, true);
        this.testRule.assertProcessEnded(instance.getId());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(instance.getId()).list().size());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableName("inputMappingExecuted").count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcessWithIoMappings.bpmn20.xml"})
    @RequiredHistoryLevel(value="full")
    @Test
    public void testDeleteProcessInstanceWithoutSkipIoMappings() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("ioMappingProcess");
        this.runtimeService.deleteProcessInstance(instance.getId(), null, false, true, false);
        this.testRule.assertProcessEnded(instance.getId());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(instance.getId()).list().size());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableName("inputMappingExecuted").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableName("outputMappingExecuted").count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/RuntimeServiceTest.testCascadingDeleteSubprocessInstanceSkipIoMappings.Calling.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/runtime/RuntimeServiceTest.testCascadingDeleteSubprocessInstanceSkipIoMappings.Called.bpmn20.xml"})
    @RequiredHistoryLevel(value="full")
    @Test
    public void testCascadingDeleteSubprocessInstanceSkipIoMappings() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        ProcessInstance instance2 = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(instance.getId()).singleResult();
        this.runtimeService.deleteProcessInstance(instance.getId(), "test_purposes", false, true, true);
        this.testRule.assertProcessEnded(instance.getId());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(instance2.getId()).list().size());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableName("inputMappingExecuted").count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/RuntimeServiceTest.testCascadingDeleteSubprocessInstanceSkipIoMappings.Calling.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/runtime/RuntimeServiceTest.testCascadingDeleteSubprocessInstanceSkipIoMappings.Called.bpmn20.xml"})
    @RequiredHistoryLevel(value="full")
    @Test
    public void testCascadingDeleteSubprocessInstanceWithoutSkipIoMappings() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        ProcessInstance instance2 = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(instance.getId()).singleResult();
        this.runtimeService.deleteProcessInstance(instance.getId(), "test_purposes", false, true, false);
        this.testRule.assertProcessEnded(instance.getId());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(instance2.getId()).list().size());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableName("inputMappingExecuted").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableName("outputMappingExecuted").count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstanceNullReason() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").count());
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").count());
    }

    @Test
    public void testDeleteProcessInstancesManyParallelSubprocesses() {
        BpmnModelInstance multiInstanceWithSubprocess = ((MultiInstanceLoopCharacteristicsBuilder)Bpmn.createExecutableProcess((String)"multiInstanceWithSubprocess").startEvent().subProcess().embeddedSubProcess().startEvent().userTask("userTask").endEvent().subProcessDone().multiInstance().cardinality("300")).multiInstanceDone().endEvent().done();
        this.testRule.deploy(multiInstanceWithSubprocess);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("multiInstanceWithSubprocess");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "some reason");
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId()).count());
    }

    @Test
    public void testDeleteProcessInstanceWithFake() {
        try {
            this.runtimeService.deleteProcessInstance("aFake", null);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("No process instance found for id", e.getMessage());
            Assert.assertTrue((boolean)(e instanceof NotFoundException));
        }
    }

    @Test
    public void testDeleteProcessInstanceIfExistsWithFake() {
        this.runtimeService.deleteProcessInstanceIfExists("aFake", null, false, false, false, false);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstancesWithFake() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        try {
            this.runtimeService.deleteProcessInstances(Arrays.asList(instance.getId(), "aFake"), "test", false, false, false, false);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException e) {
            Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").count());
            Assert.assertTrue((boolean)(e instanceof NotFoundException));
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstancesIfExistsWithFake() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.deleteProcessInstancesIfExists(Arrays.asList(instance.getId(), "aFake"), "test", false, false, false);
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").count());
    }

    @Test
    public void testDeleteProcessInstanceNullId() {
        try {
            this.runtimeService.deleteProcessInstance(null, "test null id delete");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("processInstanceId is null", ae.getMessage());
            Assert.assertTrue((boolean)(ae instanceof BadUserRequestException));
        }
    }

    @Deployment
    @Test
    public void testDeleteProcessInstanceWithActiveCompensation() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("compensationProcess");
        Task innerTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(innerTask.getId());
        Task afterSubProcessTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"taskAfterSubprocess", (Object)afterSubProcessTask.getTaskDefinitionKey());
        this.taskService.complete(afterSubProcessTask.getId());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("outerAfterBoundaryTask").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("innerAfterBoundaryTask").count());
        this.runtimeService.deleteProcessInstance(instance.getId(), "");
        this.testRule.assertProcessEnded(instance.getId());
    }

    @Deployment
    @Test
    public void testDeleteProcessInstanceWithVariableOnScopeAndConcurrentExecution() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("task")).execute();
        List executions = this.runtimeService.createExecutionQuery().list();
        for (Execution execution : executions) {
            this.runtimeService.setVariableLocal(execution.getId(), "foo", (Object)"bar");
        }
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Test
    @RequiredHistoryLevel(value="audit")
    public void testDeleteCalledSubprocess() {
        BpmnModelInstance callingInstance = ((CallActivityBuilder)ProcessModels.newModel("oneTaskProcess").startEvent().callActivity().calledElement("called")).endEvent().done();
        BpmnModelInstance calledInstance = ProcessModels.newModel("called").startEvent().userTask().endEvent().done();
        this.testRule.deploy(callingInstance, calledInstance);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getProcessInstanceId();
        String subprocessId = ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("called").singleResult()).getId();
        this.runtimeService.deleteProcessInstance(subprocessId, TESTING_INSTANCE_DELETION);
        Assert.assertEquals((Object)TESTING_INSTANCE_DELETION, (Object)((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(subprocessId).singleResult()).getDeleteReason());
        Assert.assertEquals((Object)TESTING_INSTANCE_DELETION, (Object)((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult()).getDeleteReason());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testFindActiveActivityIds() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List activities = this.runtimeService.getActiveActivityIds(processInstance.getId());
        Assert.assertNotNull((Object)activities);
        Assert.assertEquals((long)1L, (long)activities.size());
    }

    @Test
    public void testFindActiveActivityIdsUnexistingExecututionId() {
        try {
            this.runtimeService.getActiveActivityIds("unexistingExecutionId");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("execution unexistingExecutionId doesn't exist", ae.getMessage());
        }
    }

    @Test
    public void testFindActiveActivityIdsNullExecututionId() {
        try {
            this.runtimeService.getActiveActivityIds(null);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("executionId is null", ae.getMessage());
        }
    }

    @Deployment
    @Test
    public void testFindActiveActivityIdProcessWithErrorEventAndSubProcess() {
        ProcessInstance processInstance = this.engineRule.getProcessEngine().getRuntimeService().startProcessInstanceByKey("errorEventSubprocess");
        List activeActivities = this.runtimeService.getActiveActivityIds(processInstance.getId());
        Assert.assertEquals((long)3L, (long)activeActivities.size());
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        Task parallelUserTask = null;
        for (Task task : tasks) {
            if (!task.getName().equals("ParallelUserTask") && !task.getName().equals("MainUserTask")) {
                Assert.fail((String)("Expected: <ParallelUserTask> or <MainUserTask> but was <" + task.getName() + ">."));
            }
            if (!task.getName().equals("ParallelUserTask")) continue;
            parallelUserTask = task;
        }
        Assert.assertNotNull(parallelUserTask);
        this.taskService.complete(parallelUserTask.getId());
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId()).activityId("subprocess1WaitBeforeError").singleResult();
        this.runtimeService.signal(execution.getId());
        activeActivities = this.runtimeService.getActiveActivityIds(processInstance.getId());
        Assert.assertEquals((long)2L, (long)activeActivities.size());
        tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        Task beforeErrorUserTask = null;
        for (Task task : tasks) {
            if (!task.getName().equals("BeforeError") && !task.getName().equals("MainUserTask")) {
                Assert.fail((String)("Expected: <BeforeError> or <MainUserTask> but was <" + task.getName() + ">."));
            }
            if (!task.getName().equals("BeforeError")) continue;
            beforeErrorUserTask = task;
        }
        Assert.assertNotNull(beforeErrorUserTask);
        this.taskService.complete(beforeErrorUserTask.getId());
        activeActivities = this.runtimeService.getActiveActivityIds(processInstance.getId());
        Assert.assertEquals((long)2L, (long)activeActivities.size());
        tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        Task afterErrorUserTask = null;
        for (Task task : tasks) {
            if (!task.getName().equals("AfterError") && !task.getName().equals("MainUserTask")) {
                Assert.fail((String)("Expected: <AfterError> or <MainUserTask> but was <" + task.getName() + ">."));
            }
            if (!task.getName().equals("AfterError")) continue;
            afterErrorUserTask = task;
        }
        Assert.assertNotNull(afterErrorUserTask);
        this.taskService.complete(afterErrorUserTask.getId());
        tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)"MainUserTask", (Object)((Task)tasks.get(0)).getName());
        activeActivities = this.runtimeService.getActiveActivityIds(processInstance.getId());
        Assert.assertEquals((long)1L, (long)activeActivities.size());
        Assert.assertEquals((Object)"MainUserTask", activeActivities.get(0));
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testSignalUnexistingExecututionId() {
        try {
            this.runtimeService.signal("unexistingExecutionId");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("execution unexistingExecutionId doesn't exist", ae.getMessage());
            Assert.assertTrue((boolean)(ae instanceof BadUserRequestException));
        }
    }

    @Test
    public void testSignalNullExecutionId() {
        try {
            this.runtimeService.signal(null);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("executionId is null", ae.getMessage());
            Assert.assertTrue((boolean)(ae instanceof BadUserRequestException));
        }
    }

    @Deployment
    @Test
    public void testSignalWithProcessVariables() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testSignalWithProcessVariables");
        HashMap<String, String> processVariables = new HashMap<String, String>();
        processVariables.put("variable", "value");
        this.runtimeService.signal(processInstance.getId(), processVariables);
        Map variables = this.runtimeService.getVariables(processInstance.getId());
        Assert.assertEquals((Object)variables, processVariables);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/RuntimeServiceTest.testSignalWithProcessVariables.bpmn20.xml"})
    @Test
    public void testSignalWithSignalNameAndData() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testSignalWithProcessVariables");
        HashMap<String, String> processVariables = new HashMap<String, String>();
        processVariables.put("variable", "value");
        this.runtimeService.signal(processInstance.getId(), "dummySignalName", (Object)new String("SignalData"), processVariables);
        Map variables = this.runtimeService.getVariables(processInstance.getId());
        Assert.assertEquals((Object)variables, processVariables);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/RuntimeServiceTest.testSignalWithProcessVariables.bpmn20.xml"})
    @Test
    public void testSignalWithoutSignalNameAndData() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testSignalWithProcessVariables");
        HashMap<String, String> processVariables = new HashMap<String, String>();
        processVariables.put("variable", "value");
        this.runtimeService.signal(processInstance.getId(), null, null, processVariables);
        Map variables = this.runtimeService.getVariables(processInstance.getId());
        Assert.assertEquals(processVariables, (Object)variables);
    }

    @Deployment
    @Test
    public void testSignalInactiveExecution() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("testSignalInactiveExecution");
        try {
            this.runtimeService.signal(instance.getId());
            Assert.fail();
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("cannot signal execution " + instance.getId() + ": it has no current activity", e.getMessage());
        }
        catch (Exception e) {
            Assert.fail((String)"Signalling an inactive execution that has no activity should result in a ProcessEngineException");
        }
    }

    @Test
    public void testGetVariablesUnexistingExecutionId() {
        try {
            this.runtimeService.getVariables("unexistingExecutionId");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("execution unexistingExecutionId doesn't exist", ae.getMessage());
        }
    }

    @Test
    public void testGetVariablesNullExecutionId() {
        try {
            this.runtimeService.getVariables(null);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("executionId is null", ae.getMessage());
        }
    }

    @Test
    public void testGetVariableUnexistingExecutionId() {
        try {
            this.runtimeService.getVariables("unexistingExecutionId");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("execution unexistingExecutionId doesn't exist", ae.getMessage());
        }
    }

    @Test
    public void testGetVariableNullExecutionId() {
        try {
            this.runtimeService.getVariables(null);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("executionId is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testGetVariableUnexistingVariableName() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Object variableValue = this.runtimeService.getVariable(processInstance.getId(), "unexistingVariable");
        Assert.assertNull((Object)variableValue);
    }

    @Test
    public void testSetVariableUnexistingExecutionId() {
        try {
            this.runtimeService.setVariable("unexistingExecutionId", "variableName", (Object)"value");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("execution unexistingExecutionId doesn't exist", ae.getMessage());
        }
    }

    @Test
    public void testSetVariableNullExecutionId() {
        try {
            this.runtimeService.setVariable(null, "variableName", (Object)"variableValue");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("executionId is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testSetVariableNullVariableName() {
        try {
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
            this.runtimeService.setVariable(processInstance.getId(), null, (Object)"variableValue");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("variableName is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testSetVariables() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("variable1", "value1");
        vars.put("variable2", "value2");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariables(processInstance.getId(), vars);
        Assert.assertEquals((Object)"value1", (Object)this.runtimeService.getVariable(processInstance.getId(), "variable1"));
        Assert.assertEquals((Object)"value2", (Object)this.runtimeService.getVariable(processInstance.getId(), "variable2"));
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testGetVariablesTyped() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("variable1", "value1");
        vars.put("variable2", "value2");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        VariableMap variablesTyped = this.runtimeService.getVariablesTyped(processInstance.getId());
        Assert.assertEquals(vars, (Object)variablesTyped);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testGetVariablesTypedDeserialize() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("broken", (Object)Variables.serializedObjectValue((String)"broken").serializationDataFormat((SerializationDataFormat)Variables.SerializationDataFormats.JAVA).objectTypeName("unexisting").create()));
        VariableMap variablesTyped = this.runtimeService.getVariablesTyped(processInstance.getId(), false);
        Assert.assertNotNull((Object)variablesTyped.getValueTyped("broken"));
        variablesTyped = this.runtimeService.getVariablesTyped(processInstance.getId(), Arrays.asList("broken"), false);
        Assert.assertNotNull((Object)variablesTyped.getValueTyped("broken"));
        try {
            this.runtimeService.getVariablesTyped(processInstance.getId());
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Cannot deserialize object", e.getMessage());
        }
        try {
            this.runtimeService.getVariablesTyped(processInstance.getId(), Arrays.asList("broken"), true);
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Cannot deserialize object", e.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testGetVariablesLocalTyped() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("variable1", "value1");
        vars.put("variable2", "value2");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        VariableMap variablesTyped = this.runtimeService.getVariablesLocalTyped(processInstance.getId());
        Assert.assertEquals(vars, (Object)variablesTyped);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testGetVariablesLocalTypedDeserialize() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("broken", (Object)Variables.serializedObjectValue((String)"broken").serializationDataFormat((SerializationDataFormat)Variables.SerializationDataFormats.JAVA).objectTypeName("unexisting").create()));
        VariableMap variablesTyped = this.runtimeService.getVariablesLocalTyped(processInstance.getId(), false);
        Assert.assertNotNull((Object)variablesTyped.getValueTyped("broken"));
        variablesTyped = this.runtimeService.getVariablesLocalTyped(processInstance.getId(), Arrays.asList("broken"), false);
        Assert.assertNotNull((Object)variablesTyped.getValueTyped("broken"));
        try {
            this.runtimeService.getVariablesLocalTyped(processInstance.getId());
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Cannot deserialize object", e.getMessage());
        }
        try {
            this.runtimeService.getVariablesLocalTyped(processInstance.getId(), Arrays.asList("broken"), true);
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Cannot deserialize object", e.getMessage());
        }
    }

    @Test
    public void testSetVariablesUnexistingExecutionId() {
        try {
            this.runtimeService.setVariables("unexistingexecution", Collections.EMPTY_MAP);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("execution unexistingexecution doesn't exist", ae.getMessage());
        }
    }

    @Test
    public void testSetVariablesNullExecutionId() {
        try {
            this.runtimeService.setVariables(null, Collections.EMPTY_MAP);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("executionId is null", ae.getMessage());
        }
    }

    @Test
    public void setVariablesSyncOnCompletedProcessInstance() {
        this.testRule.deploy(ExecutableProcessUtil.USER_TASK_PROCESS);
        String id = this.runtimeService.startProcessInstanceByKey("process").getId();
        Task task = (Task)this.engineRule.getTaskService().createTaskQuery().processInstanceId(id).singleResult();
        this.engineRule.getTaskService().complete(task.getId());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.setVariables(id, (Map)Variables.createVariables().putValue("foo", (Object)"bar"))).isInstanceOf(NullValueException.class)).hasMessage("execution " + id + " doesn't exist: execution is null");
    }

    private void checkHistoricVariableUpdateEntity(String variableName, String processInstanceId) {
        if (this.processEngineConfiguration.getHistoryLevel().equals(HistoryLevel.HISTORY_LEVEL_FULL)) {
            boolean deletedVariableUpdateFound = false;
            List resultSet = this.historyService.createHistoricDetailQuery().processInstanceId(processInstanceId).list();
            for (HistoricDetail currentHistoricDetail : resultSet) {
                Assert.assertTrue((boolean)(currentHistoricDetail instanceof HistoricDetailVariableInstanceUpdateEntity));
                HistoricDetailVariableInstanceUpdateEntity historicVariableUpdate = (HistoricDetailVariableInstanceUpdateEntity)currentHistoricDetail;
                if (!historicVariableUpdate.getName().equals(variableName) || historicVariableUpdate.getValue() != null) continue;
                if (deletedVariableUpdateFound) {
                    Assert.fail((String)"Mismatch: A HistoricVariableUpdateEntity with a null value already found");
                    continue;
                }
                deletedVariableUpdateFound = true;
            }
            Assert.assertTrue((boolean)deletedVariableUpdateFound);
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testRemoveVariable() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("variable1", "value1");
        vars.put("variable2", "value2");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariables(processInstance.getId(), vars);
        this.runtimeService.removeVariable(processInstance.getId(), "variable1");
        Assert.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "variable1"));
        Assert.assertNull((Object)this.runtimeService.getVariableLocal(processInstance.getId(), "variable1"));
        Assert.assertEquals((Object)"value2", (Object)this.runtimeService.getVariable(processInstance.getId(), "variable2"));
        this.checkHistoricVariableUpdateEntity("variable1", processInstance.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneSubProcess.bpmn20.xml"})
    @Test
    public void testRemoveVariableInParentScope() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("variable1", "value1");
        vars.put("variable2", "value2");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("startSimpleSubProcess", vars);
        Task currentTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.runtimeService.removeVariable(currentTask.getExecutionId(), "variable1");
        Assert.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "variable1"));
        Assert.assertEquals((Object)"value2", (Object)this.runtimeService.getVariable(processInstance.getId(), "variable2"));
        this.checkHistoricVariableUpdateEntity("variable1", processInstance.getId());
    }

    @Test
    public void testRemoveVariableNullExecutionId() {
        try {
            this.runtimeService.removeVariable(null, "variable");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("executionId is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testRemoveVariableLocal() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("variable1", "value1");
        vars.put("variable2", "value2");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        this.runtimeService.removeVariableLocal(processInstance.getId(), "variable1");
        Assert.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "variable1"));
        Assert.assertNull((Object)this.runtimeService.getVariableLocal(processInstance.getId(), "variable1"));
        Assert.assertEquals((Object)"value2", (Object)this.runtimeService.getVariable(processInstance.getId(), "variable2"));
        this.checkHistoricVariableUpdateEntity("variable1", processInstance.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneSubProcess.bpmn20.xml"})
    @Test
    public void testRemoveVariableLocalWithParentScope() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("variable1", "value1");
        vars.put("variable2", "value2");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("startSimpleSubProcess", vars);
        Task currentTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.runtimeService.setVariableLocal(currentTask.getExecutionId(), "localVariable", (Object)"local value");
        Assert.assertEquals((Object)"local value", (Object)this.runtimeService.getVariableLocal(currentTask.getExecutionId(), "localVariable"));
        this.runtimeService.removeVariableLocal(currentTask.getExecutionId(), "localVariable");
        Assert.assertNull((Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "localVariable"));
        Assert.assertNull((Object)this.runtimeService.getVariableLocal(currentTask.getExecutionId(), "localVariable"));
        Assert.assertEquals((Object)"value1", (Object)this.runtimeService.getVariable(processInstance.getId(), "variable1"));
        Assert.assertEquals((Object)"value2", (Object)this.runtimeService.getVariable(processInstance.getId(), "variable2"));
        Assert.assertEquals((Object)"value1", (Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable1"));
        Assert.assertEquals((Object)"value2", (Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable2"));
        this.checkHistoricVariableUpdateEntity("localVariable", processInstance.getId());
    }

    @Test
    public void testRemoveLocalVariableNullExecutionId() {
        try {
            this.runtimeService.removeVariableLocal(null, "variable");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("executionId is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testRemoveVariables() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("variable1", "value1");
        vars.put("variable2", "value2");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        this.runtimeService.setVariable(processInstance.getId(), "variable3", (Object)"value3");
        this.runtimeService.removeVariables(processInstance.getId(), vars.keySet());
        Assert.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "variable1"));
        Assert.assertNull((Object)this.runtimeService.getVariableLocal(processInstance.getId(), "variable1"));
        Assert.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "variable2"));
        Assert.assertNull((Object)this.runtimeService.getVariableLocal(processInstance.getId(), "variable2"));
        Assert.assertEquals((Object)"value3", (Object)this.runtimeService.getVariable(processInstance.getId(), "variable3"));
        Assert.assertEquals((Object)"value3", (Object)this.runtimeService.getVariableLocal(processInstance.getId(), "variable3"));
        this.checkHistoricVariableUpdateEntity("variable1", processInstance.getId());
        this.checkHistoricVariableUpdateEntity("variable2", processInstance.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneSubProcess.bpmn20.xml"})
    @Test
    public void testRemoveVariablesWithParentScope() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("variable1", "value1");
        vars.put("variable2", "value2");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("startSimpleSubProcess", vars);
        this.runtimeService.setVariable(processInstance.getId(), "variable3", (Object)"value3");
        Task currentTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.runtimeService.removeVariables(currentTask.getExecutionId(), vars.keySet());
        Assert.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "variable1"));
        Assert.assertNull((Object)this.runtimeService.getVariableLocal(processInstance.getId(), "variable1"));
        Assert.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "variable2"));
        Assert.assertNull((Object)this.runtimeService.getVariableLocal(processInstance.getId(), "variable2"));
        Assert.assertEquals((Object)"value3", (Object)this.runtimeService.getVariable(processInstance.getId(), "variable3"));
        Assert.assertEquals((Object)"value3", (Object)this.runtimeService.getVariableLocal(processInstance.getId(), "variable3"));
        Assert.assertNull((Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable1"));
        Assert.assertNull((Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable2"));
        Assert.assertEquals((Object)"value3", (Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable3"));
        this.checkHistoricVariableUpdateEntity("variable1", processInstance.getId());
        this.checkHistoricVariableUpdateEntity("variable2", processInstance.getId());
    }

    @Test
    public void testRemoveVariablesNullExecutionId() {
        try {
            this.runtimeService.removeVariables(null, (Collection)Collections.EMPTY_LIST);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("executionId is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneSubProcess.bpmn20.xml"})
    @Test
    public void testRemoveVariablesLocalWithParentScope() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("variable1", "value1");
        vars.put("variable2", "value2");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("startSimpleSubProcess", vars);
        Task currentTask = (Task)this.taskService.createTaskQuery().singleResult();
        HashMap<String, String> varsToDelete = new HashMap<String, String>();
        varsToDelete.put("variable3", "value3");
        varsToDelete.put("variable4", "value4");
        varsToDelete.put("variable5", "value5");
        this.runtimeService.setVariablesLocal(currentTask.getExecutionId(), varsToDelete);
        this.runtimeService.setVariableLocal(currentTask.getExecutionId(), "variable6", (Object)"value6");
        Assert.assertEquals((Object)"value3", (Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable3"));
        Assert.assertEquals((Object)"value3", (Object)this.runtimeService.getVariableLocal(currentTask.getExecutionId(), "variable3"));
        Assert.assertEquals((Object)"value4", (Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable4"));
        Assert.assertEquals((Object)"value4", (Object)this.runtimeService.getVariableLocal(currentTask.getExecutionId(), "variable4"));
        Assert.assertEquals((Object)"value5", (Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable5"));
        Assert.assertEquals((Object)"value5", (Object)this.runtimeService.getVariableLocal(currentTask.getExecutionId(), "variable5"));
        Assert.assertEquals((Object)"value6", (Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable6"));
        Assert.assertEquals((Object)"value6", (Object)this.runtimeService.getVariableLocal(currentTask.getExecutionId(), "variable6"));
        this.runtimeService.removeVariablesLocal(currentTask.getExecutionId(), varsToDelete.keySet());
        Assert.assertEquals((Object)"value1", (Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable1"));
        Assert.assertEquals((Object)"value2", (Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable2"));
        Assert.assertNull((Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable3"));
        Assert.assertNull((Object)this.runtimeService.getVariableLocal(currentTask.getExecutionId(), "variable3"));
        Assert.assertNull((Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable4"));
        Assert.assertNull((Object)this.runtimeService.getVariableLocal(currentTask.getExecutionId(), "variable4"));
        Assert.assertNull((Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable5"));
        Assert.assertNull((Object)this.runtimeService.getVariableLocal(currentTask.getExecutionId(), "variable5"));
        Assert.assertEquals((Object)"value6", (Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable6"));
        Assert.assertEquals((Object)"value6", (Object)this.runtimeService.getVariableLocal(currentTask.getExecutionId(), "variable6"));
        this.checkHistoricVariableUpdateEntity("variable3", processInstance.getId());
        this.checkHistoricVariableUpdateEntity("variable4", processInstance.getId());
        this.checkHistoricVariableUpdateEntity("variable5", processInstance.getId());
    }

    @Test
    public void testRemoveVariablesLocalNullExecutionId() {
        try {
            this.runtimeService.removeVariablesLocal(null, (Collection)Collections.EMPTY_LIST);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("executionId is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testUpdateVariables() {
        HashMap<String, String> modifications = new HashMap<String, String>();
        modifications.put("variable1", "value1");
        modifications.put("variable2", "value2");
        ArrayList<String> deletions = new ArrayList<String>();
        deletions.add("variable1");
        HashMap<String, String> initialVariables = new HashMap<String, String>();
        initialVariables.put("variable1", "initialValue");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", initialVariables);
        ((RuntimeServiceImpl)this.runtimeService).updateVariables(processInstance.getId(), modifications, deletions);
        Assert.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "variable1"));
        Assert.assertEquals((Object)"value2", (Object)this.runtimeService.getVariable(processInstance.getId(), "variable2"));
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneSubProcess.bpmn20.xml"})
    @Test
    public void testUpdateVariablesLocal() {
        HashMap<String, String> globalVars = new HashMap<String, String>();
        globalVars.put("variable4", "value4");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("startSimpleSubProcess", globalVars);
        Task currentTask = (Task)this.taskService.createTaskQuery().singleResult();
        HashMap<String, String> localVars = new HashMap<String, String>();
        localVars.put("variable1", "value1");
        localVars.put("variable2", "value2");
        localVars.put("variable3", "value3");
        this.runtimeService.setVariablesLocal(currentTask.getExecutionId(), localVars);
        HashMap<String, String> modifications = new HashMap<String, String>();
        modifications.put("variable1", "anotherValue1");
        modifications.put("variable2", "anotherValue2");
        ArrayList<String> deletions = new ArrayList<String>();
        deletions.add("variable2");
        deletions.add("variable3");
        deletions.add("variable4");
        ((RuntimeServiceImpl)this.runtimeService).updateVariablesLocal(currentTask.getExecutionId(), modifications, deletions);
        Assert.assertEquals((Object)"anotherValue1", (Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable1"));
        Assert.assertNull((Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable2"));
        Assert.assertNull((Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable3"));
        Assert.assertEquals((Object)"value4", (Object)this.runtimeService.getVariable(processInstance.getId(), "variable4"));
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/RuntimeServiceTest.catchAlertSignal.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/runtime/RuntimeServiceTest.catchPanicSignal.bpmn20.xml"})
    @Test
    public void testSignalEventReceived() {
        List page;
        int executions;
        this.startSignalCatchProcesses();
        Assert.assertEquals((long)12L, (long)this.runtimeService.createExecutionQuery().count());
        this.runtimeService.signalEventReceived("alert");
        Assert.assertEquals((long)6L, (long)this.runtimeService.createExecutionQuery().count());
        this.runtimeService.signalEventReceived("panic");
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
        this.startSignalCatchProcesses();
        for (executions = 3; executions > 0; --executions) {
            page = this.runtimeService.createExecutionQuery().signalEventSubscriptionName("alert").listPage(0, 1);
            this.runtimeService.signalEventReceived("alert", ((Execution)page.get(0)).getId());
            Assert.assertEquals((long)(executions - 1), (long)this.runtimeService.createExecutionQuery().signalEventSubscriptionName("alert").count());
        }
        for (executions = 3; executions > 0; --executions) {
            page = this.runtimeService.createExecutionQuery().signalEventSubscriptionName("panic").listPage(0, 1);
            this.runtimeService.signalEventReceived("panic", ((Execution)page.get(0)).getId());
            Assert.assertEquals((long)(executions - 1), (long)this.runtimeService.createExecutionQuery().signalEventSubscriptionName("panic").count());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/RuntimeServiceTest.catchAlertMessage.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/runtime/RuntimeServiceTest.catchPanicMessage.bpmn20.xml"})
    @Test
    public void testMessageEventReceived() {
        List page;
        int executions;
        this.startMessageCatchProcesses();
        Assert.assertEquals((long)12L, (long)this.runtimeService.createExecutionQuery().count());
        for (executions = 3; executions > 0; --executions) {
            page = this.runtimeService.createExecutionQuery().messageEventSubscriptionName("alert").listPage(0, 1);
            this.runtimeService.messageEventReceived("alert", ((Execution)page.get(0)).getId());
            Assert.assertEquals((long)(executions - 1), (long)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("alert").count());
        }
        for (executions = 3; executions > 0; --executions) {
            page = this.runtimeService.createExecutionQuery().messageEventSubscriptionName("panic").listPage(0, 1);
            this.runtimeService.messageEventReceived("panic", ((Execution)page.get(0)).getId());
            Assert.assertEquals((long)(executions - 1), (long)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("panic").count());
        }
    }

    @Test
    public void testSignalEventReceivedNonExistingExecution() {
        try {
            this.runtimeService.signalEventReceived("alert", "nonexistingExecution");
            Assert.fail((String)"exeception expected");
        }
        catch (ProcessEngineException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Cannot find execution with id 'nonexistingExecution'"));
        }
    }

    @Test
    public void testMessageEventReceivedNonExistingExecution() {
        try {
            this.runtimeService.messageEventReceived("alert", "nonexistingExecution");
            Assert.fail((String)"exeception expected");
        }
        catch (ProcessEngineException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Execution with id 'nonexistingExecution' does not have a subscription to a message event with name 'alert'"));
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/RuntimeServiceTest.catchAlertSignal.bpmn20.xml"})
    @Test
    public void testExecutionWaitingForDifferentSignal() {
        this.runtimeService.startProcessInstanceByKey("catchAlertSignal");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().signalEventSubscriptionName("alert").singleResult();
        try {
            this.runtimeService.signalEventReceived("bogusSignal", execution.getId());
            Assert.fail((String)"exeception expected");
        }
        catch (ProcessEngineException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("has not subscribed to a signal event with name 'bogusSignal'"));
        }
    }

    private void startSignalCatchProcesses() {
        for (int i = 0; i < 3; ++i) {
            this.runtimeService.startProcessInstanceByKey("catchAlertSignal");
            this.runtimeService.startProcessInstanceByKey("catchPanicSignal");
        }
    }

    private void startMessageCatchProcesses() {
        for (int i = 0; i < 3; ++i) {
            this.runtimeService.startProcessInstanceByKey("catchAlertMessage");
            this.runtimeService.startProcessInstanceByKey("catchPanicMessage");
        }
    }

    @Test
    public void testActivityInstanceForNonExistingProcessInstanceId() {
        Assert.assertNull((Object)this.runtimeService.getActivityInstance("some-nonexisting-id"));
    }

    @Test
    public void testActivityInstanceForNullProcessInstanceId() {
        try {
            this.runtimeService.getActivityInstance(null);
            Assert.fail((String)"PEE expected!");
        }
        catch (ProcessEngineException engineException) {
            Assert.assertTrue((boolean)engineException.getMessage().contains("processInstanceId is null"));
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testActivityInstancePopulated() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "business-key");
        ActivityInstance rootActInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        Assert.assertEquals((Object)processInstance.getId(), (Object)rootActInstance.getProcessInstanceId());
        Assert.assertEquals((Object)processInstance.getProcessDefinitionId(), (Object)rootActInstance.getProcessDefinitionId());
        Assert.assertEquals((Object)processInstance.getId(), (Object)rootActInstance.getProcessInstanceId());
        Assert.assertTrue((boolean)rootActInstance.getExecutionIds()[0].equals(processInstance.getId()));
        Assert.assertEquals((Object)rootActInstance.getProcessDefinitionId(), (Object)rootActInstance.getActivityId());
        Assert.assertNull((Object)rootActInstance.getParentActivityInstanceId());
        Assert.assertEquals((Object)"processDefinition", (Object)rootActInstance.getActivityType());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        ActivityInstance childActivityInstance = rootActInstance.getChildActivityInstances()[0];
        Assert.assertEquals((Object)processInstance.getId(), (Object)childActivityInstance.getProcessInstanceId());
        Assert.assertEquals((Object)processInstance.getProcessDefinitionId(), (Object)childActivityInstance.getProcessDefinitionId());
        Assert.assertEquals((Object)processInstance.getId(), (Object)childActivityInstance.getProcessInstanceId());
        Assert.assertTrue((boolean)childActivityInstance.getExecutionIds()[0].equals(task.getExecutionId()));
        Assert.assertEquals((Object)"theTask", (Object)childActivityInstance.getActivityId());
        Assert.assertEquals((Object)rootActInstance.getId(), (Object)childActivityInstance.getParentActivityInstanceId());
        Assert.assertEquals((Object)"userTask", (Object)childActivityInstance.getActivityType());
        Assert.assertNotNull((Object)childActivityInstance.getChildActivityInstances());
        Assert.assertNotNull((Object)childActivityInstance.getChildTransitionInstances());
        Assert.assertEquals((long)0L, (long)childActivityInstance.getChildActivityInstances().length);
        Assert.assertEquals((long)0L, (long)childActivityInstance.getChildTransitionInstances().length);
    }

    @Deployment
    @Test
    public void testActivityInstanceTreeForAsyncBeforeTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).transition("theTask").done());
        TransitionInstance asyncBeforeTransitionInstance = tree.getChildTransitionInstances()[0];
        Assert.assertEquals((Object)processInstance.getId(), (Object)asyncBeforeTransitionInstance.getExecutionId());
    }

    @Deployment
    @Test
    public void testActivityInstanceTreeForConcurrentAsyncBeforeTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("concurrentTasksProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("theTask").transition("asyncTask").done());
        TransitionInstance asyncBeforeTransitionInstance = tree.getChildTransitionInstances()[0];
        String asyncExecutionId = ((Job)this.managementService.createJobQuery().singleResult()).getExecutionId();
        Assert.assertEquals((Object)asyncExecutionId, (Object)asyncBeforeTransitionInstance.getExecutionId());
    }

    @Deployment
    @Test
    public void testActivityInstanceTreeForAsyncBeforeStartEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).transition("theStart").done());
        TransitionInstance asyncBeforeTransitionInstance = tree.getChildTransitionInstances()[0];
        Assert.assertEquals((Object)processInstance.getId(), (Object)asyncBeforeTransitionInstance.getExecutionId());
    }

    @Deployment
    @Test
    public void testActivityInstanceTreeForAsyncAfterTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).transition("theTask").done());
        TransitionInstance asyncAfterTransitionInstance = tree.getChildTransitionInstances()[0];
        Assert.assertEquals((Object)processInstance.getId(), (Object)asyncAfterTransitionInstance.getExecutionId());
    }

    @Deployment
    @Test
    public void testActivityInstanceTreeForConcurrentAsyncAfterTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("concurrentTasksProcess");
        Task asyncTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("asyncTask").singleResult();
        Assert.assertNotNull((Object)asyncTask);
        this.taskService.complete(asyncTask.getId());
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("theTask").transition("asyncTask").done());
        TransitionInstance asyncBeforeTransitionInstance = tree.getChildTransitionInstances()[0];
        String asyncExecutionId = ((Job)this.managementService.createJobQuery().singleResult()).getExecutionId();
        Assert.assertEquals((Object)asyncExecutionId, (Object)asyncBeforeTransitionInstance.getExecutionId());
    }

    @Deployment
    @Test
    public void testActivityInstanceTreeForAsyncAfterEndEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("asyncEndEventProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).transition("theEnd").done());
        TransitionInstance asyncAfterTransitionInstance = tree.getChildTransitionInstances()[0];
        Assert.assertEquals((Object)processInstance.getId(), (Object)asyncAfterTransitionInstance.getExecutionId());
    }

    @Deployment
    @Test
    public void testActivityInstanceTreeForNestedAsyncBeforeTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subProcess").transition("theTask").done());
        TransitionInstance asyncBeforeTransitionInstance = tree.getChildActivityInstances()[0].getChildTransitionInstances()[0];
        String asyncExecutionId = ((Job)this.managementService.createJobQuery().singleResult()).getExecutionId();
        Assert.assertEquals((Object)asyncExecutionId, (Object)asyncBeforeTransitionInstance.getExecutionId());
    }

    @Deployment
    @Test
    public void testActivityInstanceTreeForNestedAsyncBeforeStartEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subProcess").transition("theSubProcessStart").done());
    }

    @Deployment
    @Test
    public void testActivityInstanceTreeForNestedAsyncAfterTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subProcess").transition("theTask").done());
        TransitionInstance asyncAfterTransitionInstance = tree.getChildActivityInstances()[0].getChildTransitionInstances()[0];
        String asyncExecutionId = ((Job)this.managementService.createJobQuery().singleResult()).getExecutionId();
        Assert.assertEquals((Object)asyncExecutionId, (Object)asyncAfterTransitionInstance.getExecutionId());
    }

    @Deployment
    @Test
    public void testActivityInstanceTreeForNestedAsyncAfterEndEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("asyncEndEventProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subProcess").transition("theSubProcessEnd").done());
        TransitionInstance asyncAfterTransitionInstance = tree.getChildActivityInstances()[0].getChildTransitionInstances()[0];
        String asyncExecutionId = ((Job)this.managementService.createJobQuery().singleResult()).getExecutionId();
        Assert.assertEquals((Object)asyncExecutionId, (Object)asyncAfterTransitionInstance.getExecutionId());
    }

    @Deployment
    @Test
    public void testActivityInstanceForConcurrentSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("concurrentSubProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        Assert.assertNotNull((Object)tree);
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").beginScope("subProcess").activity("innerTask").done());
    }

    @Deployment
    @Test
    public void testGetActivityInstancesForActivity() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("miSubprocess");
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ActivityInstance tree = this.runtimeService.getActivityInstance(instance.getId());
        ActivityInstance[] processActivityInstances = tree.getActivityInstances(definition.getId());
        Assert.assertEquals((long)1L, (long)processActivityInstances.length);
        Assert.assertEquals((Object)tree.getId(), (Object)processActivityInstances[0].getId());
        Assert.assertEquals((Object)definition.getId(), (Object)processActivityInstances[0].getActivityId());
        this.assertActivityInstances(tree.getActivityInstances("subProcess#multiInstanceBody"), 1, "subProcess#multiInstanceBody");
        this.assertActivityInstances(tree.getActivityInstances("subProcess"), 3, "subProcess");
        this.assertActivityInstances(tree.getActivityInstances("innerTask"), 3, "innerTask");
        ActivityInstance subProcessInstance = tree.getChildActivityInstances()[0].getChildActivityInstances()[0];
        this.assertActivityInstances(subProcessInstance.getActivityInstances("subProcess"), 1, "subProcess");
        ActivityInstance[] childInstances = subProcessInstance.getActivityInstances("innerTask");
        Assert.assertEquals((long)1L, (long)childInstances.length);
        Assert.assertEquals((Object)subProcessInstance.getChildActivityInstances()[0].getId(), (Object)childInstances[0].getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/RuntimeServiceTest.testGetActivityInstancesForActivity.bpmn20.xml"})
    @Test
    public void testGetInvalidActivityInstancesForActivity() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("miSubprocess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(instance.getId());
        try {
            tree.getActivityInstances(null);
            Assert.fail((String)"exception expected");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/RuntimeServiceTest.testGetActivityInstancesForActivity.bpmn20.xml"})
    @Test
    public void testGetActivityInstancesForNonExistingActivity() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("miSubprocess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(instance.getId());
        ActivityInstance[] instances = tree.getActivityInstances("aNonExistingActivityId");
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.length);
    }

    @Deployment
    @Test
    public void testGetTransitionInstancesForActivity() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("miSubprocess");
        Job job = (Job)this.managementService.createJobQuery().listPage(0, 1).get(0);
        this.managementService.executeJob(job.getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        ActivityInstance tree = this.runtimeService.getActivityInstance(instance.getId());
        Assert.assertEquals((long)0L, (long)tree.getTransitionInstances("subProcess").length);
        TransitionInstance[] asyncBeforeInstances = tree.getTransitionInstances("innerTask");
        Assert.assertEquals((long)2L, (long)asyncBeforeInstances.length);
        Assert.assertEquals((Object)"innerTask", (Object)asyncBeforeInstances[0].getActivityId());
        Assert.assertEquals((Object)"innerTask", (Object)asyncBeforeInstances[1].getActivityId());
        Assert.assertFalse((boolean)asyncBeforeInstances[0].getId().equals(asyncBeforeInstances[1].getId()));
        TransitionInstance[] asyncEndEventInstances = tree.getTransitionInstances("theSubProcessEnd");
        Assert.assertEquals((long)1L, (long)asyncEndEventInstances.length);
        Assert.assertEquals((Object)"theSubProcessEnd", (Object)asyncEndEventInstances[0].getActivityId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/RuntimeServiceTest.testGetTransitionInstancesForActivity.bpmn20.xml"})
    @Test
    public void testGetInvalidTransitionInstancesForActivity() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("miSubprocess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(instance.getId());
        try {
            tree.getTransitionInstances(null);
            Assert.fail((String)"exception expected");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/RuntimeServiceTest.testGetTransitionInstancesForActivity.bpmn20.xml"})
    @Test
    public void testGetTransitionInstancesForNonExistingActivity() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("miSubprocess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(instance.getId());
        TransitionInstance[] instances = tree.getTransitionInstances("aNonExistingActivityId");
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.length);
    }

    protected void assertActivityInstances(ActivityInstance[] instances, int expectedAmount, String expectedActivityId) {
        Assert.assertEquals((long)expectedAmount, (long)instances.length);
        HashSet<String> instanceIds = new HashSet<String>();
        for (ActivityInstance instance : instances) {
            Assert.assertEquals((Object)expectedActivityId, (Object)instance.getActivityId());
            instanceIds.add(instance.getId());
        }
        Assert.assertEquals((long)expectedAmount, (long)instanceIds.size());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testActivityInstanceNoIncidents() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        Assert.assertNotNull((Object)tree);
        Incident[] incidents = tree.getActivityInstances("theTask")[0].getIncidents();
        Assert.assertEquals((long)0L, (long)incidents.length);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testActivityInstanceIncidents() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String executionId = ((Execution)this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId()).active().singleResult()).getId();
        Incident incident = this.runtimeService.createIncident("foo", executionId, "bar");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        Assert.assertNotNull((Object)tree);
        ActivityInstanceAssert.assertThat(tree).hasTotalIncidents(1);
        Incident[] incidents = tree.getActivityInstances("theTask")[0].getIncidents();
        Assert.assertEquals((long)1L, (long)incidents.length);
        Assert.assertEquals((Object)incident, (Object)incidents[0]);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testActivityInstanceNoIncidentIds() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        Assert.assertNotNull((Object)tree);
        String[] incidentIds = tree.getActivityInstances("theTask")[0].getIncidentIds();
        Assert.assertEquals((long)0L, (long)incidentIds.length);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testActivityInstanceIncidentIds() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String executionId = ((Execution)this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId()).active().singleResult()).getId();
        Incident incident = this.runtimeService.createIncident("foo", executionId, "bar");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        Assert.assertNotNull((Object)tree);
        ActivityInstanceAssert.assertThat(tree).hasTotalIncidents(1);
        Assert.assertEquals((long)1L, (long)tree.getActivityInstances("theTask").length);
        String[] incidentIds = tree.getActivityInstances("theTask")[0].getIncidentIds();
        Assert.assertEquals((long)1L, (long)incidentIds.length);
        Assert.assertEquals((Object)incident.getId(), (Object)incidentIds[0]);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/RuntimeServiceTest.testActivityInstanceTreeForConcurrentAsyncAfterTask.bpmn20.xml"})
    public void testActivityInstanceIncidentConcurrentTasksProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("concurrentTasksProcess");
        String executionId = ((Execution)this.runtimeService.createExecutionQuery().activityId("theTask").active().singleResult()).getId();
        Incident theTaskIncident = this.runtimeService.createIncident("foo", executionId, "bar");
        executionId = ((Execution)this.runtimeService.createExecutionQuery().activityId("asyncTask").active().singleResult()).getId();
        Incident asyncTaskIncident = this.runtimeService.createIncident("foo", executionId, "bar");
        Incident anotherIncident = this.runtimeService.createIncident("foo", executionId, "bar");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        Assert.assertNotNull((Object)tree);
        ActivityInstanceAssert.assertThat(tree).hasTotalIncidents(3);
        Assert.assertEquals((long)1L, (long)tree.getActivityInstances("theTask").length);
        String[] incidentIds = tree.getActivityInstances("theTask")[0].getIncidentIds();
        Assert.assertEquals((long)1L, (long)incidentIds.length);
        Assert.assertEquals((Object)theTaskIncident.getId(), (Object)incidentIds[0]);
        Assert.assertEquals((long)1L, (long)tree.getActivityInstances("asyncTask").length);
        incidentIds = tree.getActivityInstances("asyncTask")[0].getIncidentIds();
        Assert.assertEquals((long)2L, (long)incidentIds.length);
        for (String incidentId : incidentIds) {
            if (incidentId.equals(asyncTaskIncident.getId()) || incidentId.equals(anotherIncident.getId())) continue;
            Assert.fail((String)("Expected: " + asyncTaskIncident.getId() + " or " + anotherIncident.getId() + " but it was " + incidentId));
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/RuntimeServiceTest.testActivityInstanceForConcurrentSubprocess.bpmn20.xml"})
    public void testActivityInstanceIncidentConcurrentSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("concurrentSubProcess");
        String executionId = ((Execution)this.runtimeService.createExecutionQuery().activityId("outerTask").active().singleResult()).getId();
        Incident outerTaskIncident = this.runtimeService.createIncident("foo", executionId, "bar");
        executionId = ((Execution)this.runtimeService.createExecutionQuery().activityId("innerTask").active().singleResult()).getId();
        Incident innerTaskIncident = this.runtimeService.createIncident("foo", executionId, "bar");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        Assert.assertNotNull((Object)tree);
        ActivityInstanceAssert.assertThat(tree).hasTotalIncidents(2);
        Assert.assertEquals((long)1L, (long)tree.getActivityInstances("outerTask").length);
        String[] incidentIds = tree.getActivityInstances("outerTask")[0].getIncidentIds();
        Assert.assertEquals((long)1L, (long)incidentIds.length);
        Assert.assertEquals((Object)outerTaskIncident.getId(), (Object)incidentIds[0]);
        Assert.assertEquals((long)1L, (long)tree.getActivityInstances("innerTask").length);
        incidentIds = tree.getActivityInstances("innerTask")[0].getIncidentIds();
        Assert.assertEquals((long)1L, (long)incidentIds.length);
        Assert.assertEquals((Object)innerTaskIncident.getId(), (Object)incidentIds[0]);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/RuntimeServiceTest.testGetActivityInstancesForActivity.bpmn20.xml"})
    public void testActivityInstanceIncidentMultiInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miSubprocess");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("innerTask").active().list().get(0);
        String executionId = execution.getId();
        Incident incident = this.runtimeService.createIncident("foo", executionId, "bar");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        Assert.assertNotNull((Object)tree);
        ActivityInstanceAssert.assertThat(tree).hasTotalIncidents(1);
        boolean innerTaskMatched = false;
        for (ActivityInstance activityInstance : tree.getActivityInstances("innerTask")) {
            if (activityInstance.getExecutionIds()[0].equals(executionId)) {
                String[] incidentIds = activityInstance.getIncidentIds();
                Assert.assertEquals((long)1L, (long)incidentIds.length);
                Assert.assertEquals((Object)incident.getId(), (Object)incidentIds[0]);
                innerTaskMatched = true;
                continue;
            }
            Assert.assertEquals((long)0L, (long)activityInstance.getIncidentIds().length);
        }
        Assert.assertTrue((boolean)innerTaskMatched);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneAsyncTask.bpmn"})
    public void testActivityInstanceIncidentFailedJob() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.setJobRetries(job.getId(), 0);
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasTotalIncidents(1);
        TransitionInstance transitionInstance = activityInstance.getTransitionInstances("theTask")[0];
        Object[] incidents = transitionInstance.getIncidentIds();
        Assertions.assertThat((Object[])incidents).containsExactly((Object[])new String[]{incident.getId()});
    }

    @Test
    public void testActivityInstanceIncidentFailedJobInSubProcess() {
        BpmnModelInstance process = ((UserTaskBuilder)ProcessModels.newModel("process").startEvent().subProcess("subProcess").embeddedSubProcess().startEvent().userTask("task").camundaAsyncBefore()).endEvent().subProcessDone().endEvent().done();
        this.testRule.deploy(process);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.setJobRetries(job.getId(), 0);
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasTotalIncidents(1);
        TransitionInstance transitionInstance = activityInstance.getTransitionInstances("task")[0];
        Object[] incidents = transitionInstance.getIncidentIds();
        Assertions.assertThat((Object[])incidents).containsExactly((Object[])new String[]{incident.getId()});
    }

    @Test
    public void testActivityInstanceIncidentOnNonLeafWithScopeActivity() {
        BpmnModelInstance process = ((UserTaskBuilder)((SubProcessBuilder)ProcessModels.newModel("process").startEvent().subProcess("subProcess").camundaExecutionListenerClass("start", CreateIncidentDelegate.class)).embeddedSubProcess().startEvent().userTask("task").camundaInputParameter("foo", "bar")).endEvent().subProcessDone().endEvent().done();
        this.testRule.deploy(process);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasTotalIncidents(1);
        ActivityInstance subProcessInstance = activityInstance.getActivityInstances("subProcess")[0];
        Object[] incidents = subProcessInstance.getIncidentIds();
        Assertions.assertThat((Object[])incidents).containsExactly((Object[])new String[]{incident.getId()});
    }

    @Test
    public void testActivityInstanceIncidentOnNonLeafWithNonScopeActivity() {
        BpmnModelInstance process = ((SubProcessBuilder)ProcessModels.newModel("process").startEvent().subProcess("subProcess").camundaExecutionListenerClass("start", CreateIncidentDelegate.class)).embeddedSubProcess().startEvent().userTask("task").endEvent().subProcessDone().endEvent().done();
        this.testRule.deploy(process);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasTotalIncidents(1);
        ActivityInstance subProcessInstance = activityInstance.getActivityInstances("task")[0];
        Object[] incidents = subProcessInstance.getIncidentIds();
        Assertions.assertThat((Object[])incidents).containsExactly((Object[])new String[]{incident.getId()});
    }

    @Test
    public void testActivityInstanceOnAsyncAfterSequentialMultiInstance() {
        String processDefinitionKey = "process";
        SubProcessBuilder subprocessBuilder = (SubProcessBuilder)((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)Bpmn.createExecutableProcess((String)processDefinitionKey).startEvent().subProcess("subprocess").multiInstance().sequential()).camundaAsyncAfter()).cardinality("3")).multiInstanceDone();
        BpmnModelInstance process = subprocessBuilder.embeddedSubProcess().startEvent().endEvent().subProcessDone().endEvent().done();
        this.testRule.deploy(process);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(processDefinitionKey);
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginMiBody("subprocess").transition("subprocess").done());
    }

    @Test
    public void testActivityInstanceOnAsyncAfterSequentialMultiInstance_NonScopeActivity() {
        String processDefinitionKey = "process";
        BpmnModelInstance process = ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)Bpmn.createExecutableProcess((String)processDefinitionKey).startEvent().manualTask("task").multiInstance().sequential()).camundaAsyncAfter()).cardinality("3")).multiInstanceDone().endEvent().done();
        this.testRule.deploy(process);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(processDefinitionKey);
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginMiBody("task").transition("task").done());
    }

    @Test
    public void testActivityInstanceOnAsyncAfterParallelMultiInstance() {
        String processDefinitionKey = "process";
        SubProcessBuilder subprocessBuilder = (SubProcessBuilder)((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)Bpmn.createExecutableProcess((String)processDefinitionKey).startEvent().subProcess("subprocess").multiInstance().camundaAsyncAfter()).cardinality("3")).multiInstanceDone();
        BpmnModelInstance process = subprocessBuilder.embeddedSubProcess().startEvent().endEvent().subProcessDone().endEvent().done();
        this.testRule.deploy(process);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(processDefinitionKey);
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginMiBody("subprocess").transition("subprocess").transition("subprocess").transition("subprocess").done());
    }

    @Test
    public void testActivityInstanceOnAsyncAfterScopeActivityWithOutgoingTransition() {
        String processDefinitionKey = "process";
        BpmnModelInstance process = ((ManualTaskBuilder)((ManualTaskBuilder)Bpmn.createExecutableProcess((String)processDefinitionKey).startEvent().subProcess("subprocess").embeddedSubProcess().startEvent().manualTask("task").camundaAsyncAfter()).camundaInputParameter("foo", "bar")).endEvent().subProcessDone().endEvent().done();
        this.testRule.deploy(process);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(processDefinitionKey);
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subprocess").transition("task").done());
    }

    @Test
    public void testActivityInstanceOnAsyncAfterScopeActivityWithoutOutgoingTransition() {
        String processDefinitionKey = "process";
        BpmnModelInstance process = ((ManualTaskBuilder)((ManualTaskBuilder)Bpmn.createExecutableProcess((String)processDefinitionKey).startEvent().subProcess("subprocess").embeddedSubProcess().startEvent().manualTask("task").camundaAsyncAfter()).camundaInputParameter("foo", "bar")).subProcessDone().endEvent().done();
        this.testRule.deploy(process);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(processDefinitionKey);
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subprocess").transition("task").done());
    }

    @Test
    public void testActivityInstanceOnAsyncBeforeScopeActivity() {
        String processDefinitionKey = "process";
        BpmnModelInstance process = ((ManualTaskBuilder)((ManualTaskBuilder)Bpmn.createExecutableProcess((String)processDefinitionKey).startEvent().subProcess("subprocess").embeddedSubProcess().startEvent().manualTask("task").camundaAsyncBefore()).camundaInputParameter("foo", "bar")).endEvent().subProcessDone().endEvent().done();
        this.testRule.deploy(process);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(processDefinitionKey);
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subprocess").transition("task").done());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testChangeVariableType() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        DummySerializable dummy = new DummySerializable();
        this.runtimeService.setVariable(instance.getId(), "dummy", (Object)dummy);
        this.runtimeService.setVariable(instance.getId(), "dummy", (Object)47);
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertEquals((Object)47, (Object)variableInstance.getValue());
        Assert.assertEquals((Object)ValueType.INTEGER.getName(), (Object)variableInstance.getTypeName());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testStartByKeyWithCaseInstanceId() {
        String caseInstanceId = "aCaseInstanceId";
        ProcessInstance firstInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", null, caseInstanceId);
        Assert.assertEquals((Object)caseInstanceId, (Object)firstInstance.getCaseInstanceId());
        firstInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(firstInstance.getId()).singleResult();
        Assert.assertNotNull((Object)firstInstance);
        Assert.assertEquals((Object)caseInstanceId, (Object)firstInstance.getCaseInstanceId());
        ProcessInstance secondInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", null, caseInstanceId, null);
        Assert.assertEquals((Object)caseInstanceId, (Object)secondInstance.getCaseInstanceId());
        secondInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(secondInstance.getId()).singleResult();
        Assert.assertNotNull((Object)secondInstance);
        Assert.assertEquals((Object)caseInstanceId, (Object)secondInstance.getCaseInstanceId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testStartByIdWithCaseInstanceId() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("oneTaskProcess").singleResult()).getId();
        String caseInstanceId = "aCaseInstanceId";
        ProcessInstance firstInstance = this.runtimeService.startProcessInstanceById(processDefinitionId, null, caseInstanceId);
        Assert.assertEquals((Object)caseInstanceId, (Object)firstInstance.getCaseInstanceId());
        firstInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(firstInstance.getId()).singleResult();
        Assert.assertNotNull((Object)firstInstance);
        Assert.assertEquals((Object)caseInstanceId, (Object)firstInstance.getCaseInstanceId());
        ProcessInstance secondInstance = this.runtimeService.startProcessInstanceById(processDefinitionId, null, caseInstanceId, null);
        Assert.assertEquals((Object)caseInstanceId, (Object)secondInstance.getCaseInstanceId());
        secondInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(secondInstance.getId()).singleResult();
        Assert.assertNotNull((Object)secondInstance);
        Assert.assertEquals((Object)caseInstanceId, (Object)secondInstance.getCaseInstanceId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testSetAbstractNumberValueFails() {
        try {
            this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValueTyped("var", (TypedValue)Variables.numberValue((Number)42)));
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresentIgnoreCase("cannot serialize value of abstract type number", e.getMessage());
        }
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        try {
            this.runtimeService.setVariable(processInstance.getId(), "var", (Object)Variables.numberValue((Number)42));
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresentIgnoreCase("cannot serialize value of abstract type number", e.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/messageStartEvent.bpmn20.xml"})
    @Test
    public void testStartProcessInstanceByMessageWithEarlierVersionOfProcessDefinition() {
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/runtime/messageStartEvent_version2.bpmn20.xml").deploy().getId();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(Integer.valueOf(1)).singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByMessageAndProcessDefinitionId("startMessage", processDefinition.getId());
        Assertions.assertThat((Object)processInstance).isNotNull();
        Assertions.assertThat((String)processInstance.getProcessDefinitionId()).isEqualTo((Object)processDefinition.getId());
        this.repositoryService.deleteDeployment(deploymentId, true);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/messageStartEvent.bpmn20.xml"})
    @Test
    public void testStartProcessInstanceByMessageWithLastVersionOfProcessDefinition() {
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/runtime/messageStartEvent_version2.bpmn20.xml").deploy().getId();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().latestVersion().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByMessageAndProcessDefinitionId("newStartMessage", processDefinition.getId());
        Assertions.assertThat((Object)processInstance).isNotNull();
        Assertions.assertThat((String)processInstance.getProcessDefinitionId()).isEqualTo((Object)processDefinition.getId());
        this.repositoryService.deleteDeployment(deploymentId, true);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/messageStartEvent.bpmn20.xml"})
    @Test
    public void testStartProcessInstanceByMessageWithNonExistingMessageStartEvent() {
        String deploymentId = null;
        try {
            deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/runtime/messageStartEvent_version2.bpmn20.xml").deploy().getId();
            ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(Integer.valueOf(1)).singleResult();
            this.runtimeService.startProcessInstanceByMessageAndProcessDefinitionId("newStartMessage", processDefinition.getId());
            Assert.fail((String)"exeception expected");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Cannot correlate message 'newStartMessage'"});
        }
        finally {
            if (deploymentId != null) {
                this.repositoryService.deleteDeployment(deploymentId, true);
            }
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testActivityInstanceActivityNameProperty() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        ActivityInstance[] activityInstances = tree.getActivityInstances("theTask");
        Assert.assertEquals((long)1L, (long)activityInstances.length);
        ActivityInstance task = activityInstances[0];
        Assert.assertNotNull((Object)task);
        Assert.assertNotNull((Object)task.getActivityName());
        Assert.assertEquals((Object)"my task", (Object)task.getActivityName());
    }

    @Deployment
    @Test
    public void testTransitionInstanceActivityNamePropertyBeforeTask() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        TransitionInstance[] instances = tree.getTransitionInstances("firstServiceTask");
        TransitionInstance task = instances[0];
        Assert.assertNotNull((Object)task);
        Assert.assertNotNull((Object)task.getActivityName());
        Assert.assertEquals((Object)"First Service Task", (Object)task.getActivityName());
        instances = tree.getTransitionInstances("secondServiceTask");
        task = instances[0];
        Assert.assertNotNull((Object)task);
        Assert.assertNotNull((Object)task.getActivityName());
        Assert.assertEquals((Object)"Second Service Task", (Object)task.getActivityName());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/RuntimeServiceTest.testTransitionInstanceActivityNamePropertyBeforeTask.bpmn20.xml"})
    @Test
    public void testTransitionInstanceActivityTypePropertyBeforeTask() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        TransitionInstance[] instances = tree.getTransitionInstances("firstServiceTask");
        TransitionInstance task = instances[0];
        Assert.assertNotNull((Object)task);
        Assert.assertNotNull((Object)task.getActivityType());
        Assert.assertEquals((Object)"serviceTask", (Object)task.getActivityType());
        instances = tree.getTransitionInstances("secondServiceTask");
        task = instances[0];
        Assert.assertNotNull((Object)task);
        Assert.assertNotNull((Object)task.getActivityType());
        Assert.assertEquals((Object)"serviceTask", (Object)task.getActivityType());
    }

    @Deployment
    @Test
    public void testTransitionInstanceActivityNamePropertyAfterTask() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        TransitionInstance[] instances = tree.getTransitionInstances("firstServiceTask");
        TransitionInstance task = instances[0];
        Assert.assertNotNull((Object)task);
        Assert.assertNotNull((Object)task.getActivityName());
        Assert.assertEquals((Object)"First Service Task", (Object)task.getActivityName());
        instances = tree.getTransitionInstances("secondServiceTask");
        task = instances[0];
        Assert.assertNotNull((Object)task);
        Assert.assertNotNull((Object)task.getActivityName());
        Assert.assertEquals((Object)"Second Service Task", (Object)task.getActivityName());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/RuntimeServiceTest.testTransitionInstanceActivityNamePropertyAfterTask.bpmn20.xml"})
    @Test
    public void testTransitionInstanceActivityTypePropertyAfterTask() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        TransitionInstance[] instances = tree.getTransitionInstances("firstServiceTask");
        TransitionInstance task = instances[0];
        Assert.assertNotNull((Object)task);
        Assert.assertNotNull((Object)task.getActivityType());
        Assert.assertEquals((Object)"serviceTask", (Object)task.getActivityType());
        instances = tree.getTransitionInstances("secondServiceTask");
        task = instances[0];
        Assert.assertNotNull((Object)task);
        Assert.assertNotNull((Object)task.getActivityType());
        Assert.assertEquals((Object)"serviceTask", (Object)task.getActivityType());
    }

    @Deployment
    @Test
    public void testTransitionInstanceActivityNamePropertyBeforeStartEvent() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        TransitionInstance[] instances = tree.getTransitionInstances("start");
        TransitionInstance task = instances[0];
        Assert.assertNotNull((Object)task);
        Assert.assertNotNull((Object)task.getActivityName());
        Assert.assertEquals((Object)"The Start Event", (Object)task.getActivityName());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/RuntimeServiceTest.testTransitionInstanceActivityNamePropertyBeforeStartEvent.bpmn20.xml"})
    @Test
    public void testTransitionInstanceActivityTypePropertyBeforeStartEvent() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        TransitionInstance[] instances = tree.getTransitionInstances("start");
        TransitionInstance task = instances[0];
        Assert.assertNotNull((Object)task);
        Assert.assertNotNull((Object)task.getActivityType());
        Assert.assertEquals((Object)"startEvent", (Object)task.getActivityType());
    }

    @Deployment
    @Test
    public void testTransitionInstanceActivityNamePropertyAfterStartEvent() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        TransitionInstance[] instances = tree.getTransitionInstances("start");
        TransitionInstance task = instances[0];
        Assert.assertNotNull((Object)task);
        Assert.assertNotNull((Object)task.getActivityName());
        Assert.assertEquals((Object)"The Start Event", (Object)task.getActivityName());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/RuntimeServiceTest.testTransitionInstanceActivityNamePropertyAfterStartEvent.bpmn20.xml"})
    @Test
    public void testTransitionInstanceActivityTypePropertyAfterStartEvent() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        TransitionInstance[] instances = tree.getTransitionInstances("start");
        TransitionInstance task = instances[0];
        Assert.assertNotNull((Object)task);
        Assert.assertNotNull((Object)task.getActivityType());
        Assert.assertEquals((Object)"startEvent", (Object)task.getActivityType());
    }

    @Test
    public void testStartProcessInstanceByIdAfterReboot() {
        ProcessEngines.destroy();
        StandaloneInMemProcessEngineConfiguration processEngineConfiguration = new StandaloneInMemProcessEngineConfiguration();
        processEngineConfiguration.setProcessEngineName("reboot-test-schema");
        processEngineConfiguration.setJdbcUrl("jdbc:h2:mem:activiti-reboot-test;DB_CLOSE_DELAY=1000");
        ProcessEngine schemaProcessEngine = processEngineConfiguration.buildProcessEngine();
        ProcessEngine processEngine = new StandaloneProcessEngineConfiguration().setProcessEngineName("reboot-test").setDatabaseSchemaUpdate("false").setJdbcUrl("jdbc:h2:mem:activiti-reboot-test;DB_CLOSE_DELAY=1000").setJobExecutorActivate(false).buildProcessEngine();
        processEngine.getRepositoryService().createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml").deploy();
        List processDefinitions = processEngine.getRepositoryService().createProcessDefinitionQuery().list();
        Assert.assertEquals((long)1L, (long)processDefinitions.size());
        ProcessInstance processInstance = processEngine.getRuntimeService().startProcessInstanceById(((ProcessDefinition)processDefinitions.get(0)).getId());
        String processInstanceId = processInstance.getId();
        Assert.assertNotNull((Object)processInstance);
        processEngine.close();
        Assert.assertNotNull((Object)processEngine.getRuntimeService());
        processEngine = new StandaloneProcessEngineConfiguration().setProcessEngineName("reboot-test").setDatabaseSchemaUpdate("false").setJdbcUrl("jdbc:h2:mem:activiti-reboot-test;DB_CLOSE_DELAY=1000").setJobExecutorActivate(false).buildProcessEngine();
        processInstance = (ProcessInstance)processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        Assert.assertNotNull((Object)processInstance);
        TaskService taskService = processEngine.getTaskService();
        Task task = (Task)taskService.createTaskQuery().list().get(0);
        taskService.complete(task.getId());
        processInstance = (ProcessInstance)processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        Assert.assertNull((Object)processInstance);
        processInstance = processEngine.getRuntimeService().startProcessInstanceById(((ProcessDefinition)processDefinitions.get(0)).getId());
        Assert.assertNotNull((Object)processInstance);
        processEngine.close();
        schemaProcessEngine.close();
    }

    @Deployment
    @Test
    public void testVariableScope() {
        HashMap<String, String> varMap = new HashMap<String, String>();
        varMap.put("test", "test");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("simpleSubProcess", varMap);
        Task subProcessTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        Assert.assertEquals((Object)"Task in subprocess", (Object)subProcessTask.getName());
        Assert.assertEquals((Object)"test2", (Object)this.runtimeService.getVariable(subProcessTask.getExecutionId(), "test"));
        Assert.assertEquals((Object)"test2", this.runtimeService.getVariables(subProcessTask.getExecutionId()).get("test"));
        Assert.assertEquals((Object)"test", (Object)this.runtimeService.getVariable(pi.getId(), "test"));
        Assert.assertEquals((Object)"test", this.runtimeService.getVariables(pi.getId()).get("test"));
        this.runtimeService.setVariableLocal(subProcessTask.getExecutionId(), "test", (Object)"test3");
        Assert.assertEquals((Object)"test3", (Object)this.runtimeService.getVariable(subProcessTask.getExecutionId(), "test"));
        Assert.assertEquals((Object)"test3", this.runtimeService.getVariables(subProcessTask.getExecutionId()).get("test"));
        Assert.assertEquals((Object)"test", (Object)this.runtimeService.getVariable(pi.getId(), "test"));
        Assert.assertEquals((Object)"test", this.runtimeService.getVariables(pi.getId()).get("test"));
        this.runtimeService.setVariable(pi.getId(), "test", (Object)"test4");
        Assert.assertEquals((Object)"test3", (Object)this.runtimeService.getVariable(subProcessTask.getExecutionId(), "test"));
        Assert.assertEquals((Object)"test3", this.runtimeService.getVariables(subProcessTask.getExecutionId()).get("test"));
        Assert.assertEquals((Object)"test4", (Object)this.runtimeService.getVariable(pi.getId(), "test"));
        Assert.assertEquals((Object)"test4", this.runtimeService.getVariables(pi.getId()).get("test"));
        this.taskService.complete(subProcessTask.getId());
    }

    @Deployment
    @Test
    public void testBasicVariableOperations() {
        Date now = new Date();
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        byte[] bytes = "somebytes".getBytes();
        byte[] streamBytes = "morebytes".getBytes();
        Map variables = new HashMap<String, Object>();
        variables.put("longVar", 928374L);
        variables.put("shortVar", (short)123);
        variables.put("integerVar", 1234);
        variables.put("stringVar", "coca-cola");
        variables.put("dateVar", now);
        variables.put("nullVar", null);
        variables.put("serializableVar", serializable);
        variables.put("bytesVar", bytes);
        variables.put("byteStreamVar", new ByteArrayInputStream(streamBytes));
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("taskAssigneeProcess", variables);
        variables = this.runtimeService.getVariables(processInstance.getId());
        Assert.assertEquals((Object)"coca-cola", variables.get("stringVar"));
        Assert.assertEquals((Object)928374L, variables.get("longVar"));
        Assert.assertEquals((Object)123, variables.get("shortVar"));
        Assert.assertEquals((Object)1234, variables.get("integerVar"));
        Assert.assertEquals((Object)now, variables.get("dateVar"));
        Assert.assertEquals(null, variables.get("nullVar"));
        Assert.assertEquals(serializable, variables.get("serializableVar"));
        Assert.assertTrue((boolean)Arrays.equals(bytes, (byte[])variables.get("bytesVar")));
        Assert.assertTrue((boolean)Arrays.equals(streamBytes, (byte[])variables.get("byteStreamVar")));
        Assert.assertEquals((long)9L, (long)variables.size());
        this.runtimeService.setVariable(processInstance.getId(), "longVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "shortVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "integerVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "stringVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "dateVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "nullVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "serializableVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "bytesVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "byteStreamVar", null);
        variables = this.runtimeService.getVariables(processInstance.getId());
        Assert.assertEquals(null, variables.get("longVar"));
        Assert.assertEquals(null, variables.get("shortVar"));
        Assert.assertEquals(null, variables.get("integerVar"));
        Assert.assertEquals(null, variables.get("stringVar"));
        Assert.assertEquals(null, variables.get("dateVar"));
        Assert.assertEquals(null, variables.get("nullVar"));
        Assert.assertEquals(null, variables.get("serializableVar"));
        Assert.assertEquals(null, variables.get("bytesVar"));
        Assert.assertEquals(null, variables.get("byteStreamVar"));
        Assert.assertEquals((long)9L, (long)variables.size());
        this.runtimeService.setVariable(processInstance.getId(), "new var", (Object)"hi");
        this.runtimeService.setVariable(processInstance.getId(), "longVar", (Object)9987L);
        this.runtimeService.setVariable(processInstance.getId(), "shortVar", (Object)456);
        this.runtimeService.setVariable(processInstance.getId(), "integerVar", (Object)4567);
        this.runtimeService.setVariable(processInstance.getId(), "stringVar", (Object)"colgate");
        this.runtimeService.setVariable(processInstance.getId(), "dateVar", (Object)now);
        this.runtimeService.setVariable(processInstance.getId(), "serializableVar", serializable);
        this.runtimeService.setVariable(processInstance.getId(), "bytesVar", (Object)bytes);
        this.runtimeService.setVariable(processInstance.getId(), "byteStreamVar", (Object)new ByteArrayInputStream(streamBytes));
        variables = this.runtimeService.getVariables(processInstance.getId());
        Assert.assertEquals((Object)"hi", variables.get("new var"));
        Assert.assertEquals((Object)9987L, variables.get("longVar"));
        Assert.assertEquals((Object)456, variables.get("shortVar"));
        Assert.assertEquals((Object)4567, variables.get("integerVar"));
        Assert.assertEquals((Object)"colgate", variables.get("stringVar"));
        Assert.assertEquals((Object)now, variables.get("dateVar"));
        Assert.assertEquals(null, variables.get("nullVar"));
        Assert.assertEquals(serializable, variables.get("serializableVar"));
        Assert.assertTrue((boolean)Arrays.equals(bytes, (byte[])variables.get("bytesVar")));
        Assert.assertTrue((boolean)Arrays.equals(streamBytes, (byte[])variables.get("byteStreamVar")));
        Assert.assertEquals((long)10L, (long)variables.size());
        ArrayList<String> varFilter = new ArrayList<String>(2);
        varFilter.add("stringVar");
        varFilter.add("integerVar");
        Map filteredVariables = this.runtimeService.getVariables(processInstance.getId(), varFilter);
        Assert.assertEquals((long)2L, (long)filteredVariables.size());
        Assert.assertTrue((boolean)filteredVariables.containsKey("stringVar"));
        Assert.assertTrue((boolean)filteredVariables.containsKey("integerVar"));
        this.runtimeService.setVariable(processInstance.getId(), "nullVar", (Object)"a value");
        Object newValue = this.runtimeService.getVariable(processInstance.getId(), "nullVar");
        Assert.assertNotNull((Object)newValue);
        Assert.assertEquals((Object)"a value", (Object)newValue);
        this.runtimeService.setVariable(processInstance.getId(), "serializableVar", (Object)100);
        variables = this.runtimeService.getVariables(processInstance.getId());
        Assert.assertEquals((Object)100, variables.get("serializableVar"));
        this.runtimeService.setVariable(processInstance.getId(), "serializableVar", serializable);
        variables = this.runtimeService.getVariables(processInstance.getId());
        Assert.assertEquals(serializable, variables.get("serializableVar"));
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/RuntimeServiceTest.testBasicVariableOperations.bpmn20.xml"})
    @Test
    public void testOnlyChangeType() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("aVariable", 1234);
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("taskAssigneeProcess", variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableName("aVariable");
        VariableInstance variable = (VariableInstance)query.singleResult();
        Assert.assertEquals((Object)ValueType.INTEGER.getName(), (Object)variable.getTypeName());
        this.runtimeService.setVariable(pi.getId(), "aVariable", (Object)1234L);
        variable = (VariableInstance)query.singleResult();
        Assert.assertEquals((Object)ValueType.LONG.getName(), (Object)variable.getTypeName());
        this.runtimeService.setVariable(pi.getId(), "aVariable", (Object)1234);
        variable = (VariableInstance)query.singleResult();
        Assert.assertEquals((Object)ValueType.SHORT.getName(), (Object)variable.getTypeName());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/RuntimeServiceTest.testBasicVariableOperations.bpmn20.xml"})
    @Test
    public void testChangeTypeFromSerializableUsingApi() {
        HashMap<String, SerializableVariable> variables = new HashMap<String, SerializableVariable>();
        variables.put("aVariable", new SerializableVariable("foo"));
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("taskAssigneeProcess", variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableName("aVariable");
        VariableInstance variable = (VariableInstance)query.singleResult();
        Assert.assertEquals((Object)ValueType.OBJECT.getName(), (Object)variable.getTypeName());
        this.runtimeService.setVariable(pi.getId(), "aVariable", null);
        variable = (VariableInstance)query.singleResult();
        Assert.assertEquals((Object)ValueType.NULL.getName(), (Object)variable.getTypeName());
    }

    @Deployment
    @Test
    public void testChangeSerializableInsideEngine() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        SerializableVariable var = (SerializableVariable)this.taskService.getVariable(task.getId(), "variableName");
        Assert.assertNotNull((Object)var);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/RuntimeServiceTest.testBasicVariableOperations.bpmn20.xml"})
    @Test
    public void testChangeToSerializableUsingApi() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aVariable", "test");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("taskAssigneeProcess", variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableName("aVariable");
        VariableInstance variable = (VariableInstance)query.singleResult();
        Assert.assertEquals((Object)ValueType.STRING.getName(), (Object)variable.getTypeName());
        this.runtimeService.setVariable(processInstance.getId(), "aVariable", (Object)new SerializableVariable("foo"));
        variable = (VariableInstance)query.singleResult();
        Assert.assertEquals((Object)ValueType.OBJECT.getName(), (Object)variable.getTypeName());
    }

    @Deployment
    @Test
    public void testGetVariableInstancesFromVariableScope() {
        VariableMap variables = Variables.createVariables().putValue("anIntegerVariable", (Object)1234).putValue("anObjectValue", (Object)Variables.objectValue((Object)new SimpleSerializableBean(10)).serializationDataFormat((SerializationDataFormat)Variables.SerializationDataFormats.JAVA)).putValue("anUntypedObjectValue", (Object)new SimpleSerializableBean(30));
        this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/RuntimeServiceTest.testSetVariableInScope.bpmn20.xml"})
    @Test
    public void testSetVariableInScopeExplicitUpdate() {
        this.runtimeService.startProcessInstanceByKey("testProcess", Collections.singletonMap("shouldExplicitlyUpdateVariable", true));
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)variableInstance);
        Assert.assertEquals((Object)"shouldExplicitlyUpdateVariable", (Object)variableInstance.getName());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/RuntimeServiceTest.testSetVariableInScope.bpmn20.xml"})
    @Test
    public void testSetVariableInScopeImplicitUpdate() {
        this.runtimeService.startProcessInstanceByKey("testProcess", Collections.singletonMap("shouldExplicitlyUpdateVariable", true));
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)variableInstance);
        Assert.assertEquals((Object)"shouldExplicitlyUpdateVariable", (Object)variableInstance.getName());
    }

    @Deployment
    @Test
    public void testUpdateVariableInProcessWithoutWaitstate() {
        this.runtimeService.startProcessInstanceByKey("oneScriptTaskProcess", Collections.singletonMap("var", new SimpleSerializableBean(10)));
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertNull((Object)processInstance);
    }

    @Deployment
    @Test
    public void testSetUpdateAndDeleteComplexVariable() {
        this.runtimeService.startProcessInstanceByKey("oneUserTaskProcess", Collections.singletonMap("var", new SimpleSerializableBean(10)));
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertNotNull((Object)processInstance);
    }

    @Deployment
    @Test
    public void testRollback() {
        try {
            this.runtimeService.startProcessInstanceByKey("RollbackProcess");
            Assert.fail((String)"Starting the process instance should throw an exception");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Buzzz", (Object)e.getMessage());
        }
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/trivial.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/runtime/rollbackAfterSubProcess.bpmn20.xml"})
    @Test
    public void testRollbackAfterSubProcess() {
        try {
            this.runtimeService.startProcessInstanceByKey("RollbackAfterSubProcess");
            Assert.fail((String)"Starting the process instance should throw an exception");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Buzzz", (Object)e.getMessage());
        }
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    @Test
    public void testGetActivityInstanceForCompletedInstanceInDelegate() {
        BpmnModelInstance deletingProcess = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process1").startEvent().userTask().serviceTask().camundaClass(DeleteInstanceDelegate.class.getName())).userTask().endEvent().done();
        BpmnModelInstance processToDelete = Bpmn.createExecutableProcess((String)"process2").startEvent().userTask().endEvent().done();
        this.testRule.deploy(deletingProcess, processToDelete);
        ProcessInstance instanceToDelete = this.runtimeService.startProcessInstanceByKey("process2");
        ProcessInstance deletingInstance = this.runtimeService.startProcessInstanceByKey("process1", (Map)Variables.createVariables().putValue("instanceToComplete", (Object)instanceToDelete.getId()));
        Task deleteTrigger = (Task)this.taskService.createTaskQuery().processInstanceId(deletingInstance.getId()).singleResult();
        this.taskService.complete(deleteTrigger.getId());
        boolean activityInstanceNull = (Boolean)this.runtimeService.getVariable(deletingInstance.getId(), "activityInstanceNull");
        Assert.assertTrue((boolean)activityInstanceNull);
    }

    @RequiredHistoryLevel(value="full")
    @Test
    public void testDeleteProcessInstanceWithSubprocessInstances() {
        BpmnModelInstance calling = this.prepareComplexProcess("A", "B", "A");
        BpmnModelInstance calledA = this.prepareSimpleProcess("A");
        BpmnModelInstance calledB = this.prepareSimpleProcess("B");
        this.testRule.deploy(calling, calledA, calledB);
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("calling");
        List subInstances = this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(instance.getId()).list();
        String id = instance.getId();
        this.runtimeService.deleteProcessInstance(id, "test_purposes", false, true, false, false);
        this.testRule.assertProcessEnded(id);
        for (ProcessInstance subInstance : subInstances) {
            this.testRule.assertProcessEnded(subInstance.getId());
        }
    }

    @RequiredHistoryLevel(value="full")
    @Test
    public void testDeleteProcessInstanceWithoutSubprocessInstances() {
        BpmnModelInstance calling = this.prepareComplexProcess("A", "B", "C");
        BpmnModelInstance calledA = this.prepareSimpleProcess("A");
        BpmnModelInstance calledB = this.prepareSimpleProcess("B");
        BpmnModelInstance calledC = this.prepareSimpleProcess("C");
        this.testRule.deploy(calling, calledA, calledB, calledC);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("calling");
        List subInstances = this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(processInstance.getId()).list();
        String id = processInstance.getId();
        this.runtimeService.deleteProcessInstance(id, "test_purposes", false, true, false, true);
        this.testRule.assertProcessEnded(id);
        for (ProcessInstance subInstance : subInstances) {
            this.testRule.assertProcessNotEnded(subInstance.getId());
        }
    }

    @Test
    public void testDeleteProcessInstancesWithoutSubprocessInstances() {
        String callingProcessKey = "calling";
        String calledProcessKey = "called";
        BpmnModelInstance calling = this.prepareCallingProcess(callingProcessKey, calledProcessKey);
        BpmnModelInstance called = this.prepareSimpleProcess(calledProcessKey);
        this.testRule.deploy(calling, called);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(callingProcessKey);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey(callingProcessKey);
        List subprocessList = this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(processInstance.getId()).list();
        subprocessList.addAll(this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(processInstance2.getId()).list());
        this.runtimeService.deleteProcessInstances(Arrays.asList(processInstance.getId(), processInstance2.getId()), null, false, false, true, false);
        this.testRule.assertProcessEnded(processInstance.getId());
        this.testRule.assertProcessEnded(processInstance2.getId());
        for (ProcessInstance instance : subprocessList) {
            this.testRule.assertProcessNotEnded(instance.getId());
        }
    }

    @Test
    public void testDeleteProcessInstancesWithSubprocessInstances() {
        String callingProcessKey = "calling";
        String calledProcessKey = "called";
        BpmnModelInstance calling = this.prepareCallingProcess(callingProcessKey, calledProcessKey);
        BpmnModelInstance called = this.prepareSimpleProcess(calledProcessKey);
        this.testRule.deploy(calling, called);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(callingProcessKey);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey(callingProcessKey);
        List subprocessList = this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(processInstance.getId()).list();
        subprocessList.addAll(this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(processInstance2.getId()).list());
        this.runtimeService.deleteProcessInstances(Arrays.asList(processInstance.getId(), processInstance2.getId()), null, false, false, false, false);
        this.testRule.assertProcessEnded(processInstance.getId());
        this.testRule.assertProcessEnded(processInstance2.getId());
        for (ProcessInstance subprocess : subprocessList) {
            this.testRule.assertProcessEnded(subprocess.getId());
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetVariablesByEmptyList() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getId();
        Map variables = this.runtimeService.getVariables(processInstanceId, new ArrayList());
        Assert.assertNotNull((Object)variables);
        Assert.assertTrue((boolean)variables.isEmpty());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetVariablesTypedByEmptyList() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getId();
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstanceId, new ArrayList(), false);
        Assert.assertNotNull((Object)variables);
        Assert.assertTrue((boolean)variables.isEmpty());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetVariablesLocalByEmptyList() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getId();
        Map variables = this.runtimeService.getVariablesLocal(processInstanceId, new ArrayList());
        Assert.assertNotNull((Object)variables);
        Assert.assertTrue((boolean)variables.isEmpty());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetVariablesLocalTypedByEmptyList() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getId();
        VariableMap variables = this.runtimeService.getVariablesLocalTyped(processInstanceId, new ArrayList(), false);
        Assert.assertNotNull((Object)variables);
        Assert.assertTrue((boolean)variables.isEmpty());
    }

    private BpmnModelInstance prepareComplexProcess(String calledProcessA, String calledProcessB, String calledProcessC) {
        BpmnModelInstance calling = ((CallActivityBuilder)((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"calling").startEvent().parallelGateway("fork1").subProcess().embeddedSubProcess().startEvent().parallelGateway("fork2").callActivity("callingA").calledElement(calledProcessA)).endEvent("endA").moveToNode("fork2").callActivity("callingB").calledElement(calledProcessB)).endEvent().subProcessDone().moveToNode("fork1").callActivity("callingC").calledElement(calledProcessC)).endEvent().done();
        return calling;
    }

    private BpmnModelInstance prepareSimpleProcess(String name) {
        BpmnModelInstance calledA = Bpmn.createExecutableProcess((String)name).startEvent().userTask("Task" + name).endEvent().done();
        return calledA;
    }

    private BpmnModelInstance prepareCallingProcess(String callingProcess, String calledProcess) {
        BpmnModelInstance calling = ((CallActivityBuilder)Bpmn.createExecutableProcess((String)callingProcess).startEvent().callActivity().calledElement(calledProcess)).endEvent().done();
        return calling;
    }

    public static class CreateIncidentDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            RuntimeService runtimeService = execution.getProcessEngineServices().getRuntimeService();
            runtimeService.createIncident("foo", execution.getId(), null);
        }
    }

    public static class DeleteInstanceDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            RuntimeService runtimeService = execution.getProcessEngineServices().getRuntimeService();
            TaskService taskService = execution.getProcessEngineServices().getTaskService();
            String instanceToDelete = (String)execution.getVariable("instanceToComplete");
            Task taskToTrigger = (Task)taskService.createTaskQuery().processInstanceId(instanceToDelete).singleResult();
            taskService.complete(taskToTrigger.getId());
            ActivityInstance activityInstance = runtimeService.getActivityInstance(instanceToDelete);
            execution.setVariable("activityInstanceNull", (Object)(activityInstance == null ? 1 : 0));
        }
    }
}

