/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime.migration;

import java.util.List;
import org.eximeebpms.bpm.engine.externaltask.ExternalTask;
import org.eximeebpms.bpm.engine.externaltask.LockedExternalTask;
import org.eximeebpms.bpm.engine.migration.MigratingProcessInstanceValidationException;
import org.eximeebpms.bpm.engine.migration.MigrationPlan;
import org.eximeebpms.bpm.engine.migration.MigrationPlanValidationException;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.Incident;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.models.ExternalTaskModels;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.models.ServiceTaskModels;
import org.eximeebpms.bpm.engine.test.util.ActivityInstanceAssert;
import org.eximeebpms.bpm.engine.test.util.ExecutionAssert;
import org.eximeebpms.bpm.engine.test.util.MigrationPlanValidationReportAssert;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.builder.BusinessRuleTaskBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationExternalTaskTest {
    public static final String WORKER_ID = "foo";
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @Test
    public void testTrees() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ExternalTaskModels.ONE_EXTERNAL_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ExternalTaskModels.ONE_EXTERNAL_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("externalTask", "externalTask").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("externalTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("externalTask")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("externalTask", this.testHelper.getSingleActivityInstanceBeforeMigration("externalTask").getId()).done());
    }

    @Test
    public void testProperties() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ExternalTaskModels.ONE_EXTERNAL_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ExternalTaskModels.ONE_EXTERNAL_TASK_PROCESS).changeElementId("Process", "newProcess").changeElementId("externalTask", "newExternalTask"));
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("externalTask", "newExternalTask").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        ExternalTask externalTaskBeforeMigration = (ExternalTask)this.rule.getExternalTaskService().createExternalTaskQuery().singleResult();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        ExternalTask externalTaskAfterMigration = (ExternalTask)this.rule.getExternalTaskService().createExternalTaskQuery().singleResult();
        Assert.assertEquals((Object)"newExternalTask", (Object)externalTaskAfterMigration.getActivityId());
        Assert.assertEquals((Object)targetProcessDefinition.getId(), (Object)externalTaskAfterMigration.getProcessDefinitionId());
        Assert.assertEquals((Object)"newProcess", (Object)externalTaskAfterMigration.getProcessDefinitionKey());
        Assert.assertEquals((long)externalTaskBeforeMigration.getPriority(), (long)externalTaskAfterMigration.getPriority());
        Assert.assertEquals((Object)externalTaskBeforeMigration.getActivityInstanceId(), (Object)externalTaskAfterMigration.getActivityInstanceId());
        Assert.assertEquals((Object)externalTaskBeforeMigration.getErrorMessage(), (Object)externalTaskAfterMigration.getErrorMessage());
        Assert.assertEquals((Object)externalTaskBeforeMigration.getExecutionId(), (Object)externalTaskAfterMigration.getExecutionId());
        Assert.assertEquals((Object)externalTaskBeforeMigration.getId(), (Object)externalTaskAfterMigration.getId());
        Assert.assertEquals((Object)externalTaskBeforeMigration.getLockExpirationTime(), (Object)externalTaskAfterMigration.getLockExpirationTime());
        Assert.assertEquals((Object)processInstance.getId(), (Object)externalTaskAfterMigration.getProcessInstanceId());
        Assert.assertEquals((Object)externalTaskBeforeMigration.getRetries(), (Object)externalTaskAfterMigration.getRetries());
        Assert.assertEquals((Object)externalTaskBeforeMigration.getTenantId(), (Object)externalTaskAfterMigration.getTenantId());
        Assert.assertEquals((Object)externalTaskBeforeMigration.getTopicName(), (Object)externalTaskAfterMigration.getTopicName());
        Assert.assertEquals((Object)externalTaskBeforeMigration.getWorkerId(), (Object)externalTaskAfterMigration.getWorkerId());
    }

    @Test
    public void testContinueProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ExternalTaskModels.ONE_EXTERNAL_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ExternalTaskModels.ONE_EXTERNAL_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("externalTask", "externalTask").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        LockedExternalTask task = this.fetchAndLockSingleTask(WORKER_ID);
        this.rule.getExternalTaskService().complete(task.getId(), WORKER_ID);
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testChangeTaskConfiguration() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ExternalTaskModels.ONE_EXTERNAL_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((ServiceTaskBuilder)((ServiceTaskBuilder)ModifiableBpmnModelInstance.modify(ExternalTaskModels.ONE_EXTERNAL_TASK_PROCESS).serviceTaskBuilder("externalTask").camundaTopic("newfoo")).camundaTaskPriority(Integer.toString(ExternalTaskModels.PRIORITY * 2))).done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("externalTask", "externalTask").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        ExternalTask externalTaskAfterMigration = (ExternalTask)this.rule.getExternalTaskService().createExternalTaskQuery().singleResult();
        Assert.assertEquals((long)ExternalTaskModels.PRIORITY.longValue(), (long)externalTaskAfterMigration.getPriority());
        Assert.assertEquals((Object)WORKER_ID, (Object)externalTaskAfterMigration.getTopicName());
    }

    @Test
    public void testChangeTaskType() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ExternalTaskModels.ONE_EXTERNAL_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)ProcessModels.newModel().startEvent().businessRuleTask("externalBusinessRuleTask").camundaType("external")).camundaTopic(WORKER_ID)).camundaTaskPriority(ExternalTaskModels.PRIORITY.toString())).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("externalTask", "externalBusinessRuleTask").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        LockedExternalTask task = this.fetchAndLockSingleTask(WORKER_ID);
        this.rule.getExternalTaskService().complete(task.getId(), WORKER_ID);
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testLockedTaskProperties() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ExternalTaskModels.ONE_EXTERNAL_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ExternalTaskModels.ONE_EXTERNAL_TASK_PROCESS).changeElementId("Process", "newProcess").changeElementId("externalTask", "newExternalTask"));
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("externalTask", "newExternalTask").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.fetchAndLockSingleTask(WORKER_ID);
        ExternalTask externalTaskBeforeMigration = (ExternalTask)this.rule.getExternalTaskService().createExternalTaskQuery().singleResult();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        ExternalTask externalTaskAfterMigration = (ExternalTask)this.rule.getExternalTaskService().createExternalTaskQuery().singleResult();
        Assert.assertEquals((Object)externalTaskBeforeMigration.getLockExpirationTime(), (Object)externalTaskAfterMigration.getLockExpirationTime());
        Assert.assertEquals((Object)externalTaskBeforeMigration.getWorkerId(), (Object)externalTaskAfterMigration.getWorkerId());
    }

    @Test
    public void testLockedTaskContinueProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ExternalTaskModels.ONE_EXTERNAL_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ExternalTaskModels.ONE_EXTERNAL_TASK_PROCESS).changeElementId("Process", "newProcess").changeElementId("externalTask", "newExternalTask"));
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("externalTask", "newExternalTask").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        LockedExternalTask externalTask = this.fetchAndLockSingleTask(WORKER_ID);
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.rule.getExternalTaskService().complete(externalTask.getId(), WORKER_ID);
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void cannotMigrateFromExternalToClassDelegateServiceTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ExternalTaskModels.ONE_EXTERNAL_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ServiceTaskModels.oneClassDelegateServiceTask("foo.Bar"));
        try {
            this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("externalTask", "serviceTask").build();
            Assert.fail((String)"exception expected");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("externalTask", "Activities have incompatible types (ExternalTaskActivityBehavior is not compatible with ClassDelegateActivityBehavior)");
        }
    }

    @Test
    public void testAddParentScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ExternalTaskModels.ONE_EXTERNAL_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ExternalTaskModels.SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("externalTask", "externalTask").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        LockedExternalTask task = this.fetchAndLockSingleTask(WORKER_ID);
        this.rule.getExternalTaskService().complete(task.getId(), WORKER_ID);
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testRemoveParentScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ExternalTaskModels.SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ExternalTaskModels.ONE_EXTERNAL_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("externalTask", "externalTask").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        LockedExternalTask task = this.fetchAndLockSingleTask(WORKER_ID);
        this.rule.getExternalTaskService().complete(task.getId(), WORKER_ID);
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testIncident() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ExternalTaskModels.ONE_EXTERNAL_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ExternalTaskModels.ONE_EXTERNAL_TASK_PROCESS).changeElementId("externalTask", "newExternalTask"));
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("externalTask", "newExternalTask").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        ExternalTask externalTask = (ExternalTask)this.rule.getExternalTaskService().createExternalTaskQuery().singleResult();
        this.rule.getExternalTaskService().setRetries(externalTask.getId(), 0);
        Incident incidentBeforeMigration = (Incident)this.rule.getRuntimeService().createIncidentQuery().singleResult();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Incident incidentAfterMigration = (Incident)this.rule.getRuntimeService().createIncidentQuery().singleResult();
        Assert.assertNotNull((Object)incidentAfterMigration);
        Assert.assertEquals((Object)incidentBeforeMigration.getId(), (Object)incidentAfterMigration.getId());
        Assert.assertEquals((Object)"failedExternalTask", (Object)incidentAfterMigration.getIncidentType());
        Assert.assertEquals((Object)externalTask.getId(), (Object)incidentAfterMigration.getConfiguration());
        Assert.assertEquals((Object)"newExternalTask", (Object)incidentAfterMigration.getActivityId());
        Assert.assertEquals((Object)targetProcessDefinition.getId(), (Object)incidentAfterMigration.getProcessDefinitionId());
        Assert.assertEquals((Object)externalTask.getExecutionId(), (Object)incidentAfterMigration.getExecutionId());
        this.rule.getExternalTaskService().setRetries(externalTask.getId(), 1);
        LockedExternalTask task = this.fetchAndLockSingleTask(WORKER_ID);
        this.rule.getExternalTaskService().complete(task.getId(), WORKER_ID);
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testIncidentWithoutMapExternalTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ExternalTaskModels.ONE_EXTERNAL_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ExternalTaskModels.ONE_EXTERNAL_TASK_PROCESS).changeElementId("externalTask", "newExternalTask"));
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        ExternalTask externalTask = (ExternalTask)this.rule.getExternalTaskService().createExternalTaskQuery().singleResult();
        this.rule.getExternalTaskService().setRetries(externalTask.getId(), 0);
        Incident incidentBeforeMigration = (Incident)this.rule.getRuntimeService().createIncidentQuery().singleResult();
        Assert.assertNotNull((Object)incidentBeforeMigration);
        try {
            this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
            Assert.fail((String)"Exception expected!");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof MigratingProcessInstanceValidationException));
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/externaltask/ExternalTaskWithoutIdTest.bpmn"})
    public void testProcessDefinitionWithoutIdField() {
        ProcessDefinition sourceProcessDefinition = (ProcessDefinition)this.testHelper.deploy("org/eximeebpms/bpm/engine/test/api/externaltask/ExternalTaskWithoutIdTest.bpmn").getDeployedProcessDefinitions().get(0);
        ProcessDefinition targetProcessDefinition = (ProcessDefinition)this.testHelper.deploy("org/eximeebpms/bpm/engine/test/api/externaltask/ExternalTaskWithoutIdTest.bpmn").getDeployedProcessDefinitions().get(0);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        List instructions = migrationPlan.getInstructions();
        Assert.assertEquals((long)2L, (long)instructions.size());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/externaltask/ExternalTaskWithoutIdTest.bpmn"})
    public void testProcessDefinitionWithIdField() {
        ProcessDefinition sourceProcessDefinition = (ProcessDefinition)this.testHelper.deploy("org/eximeebpms/bpm/engine/test/api/externaltask/ExternalTaskWithIdTest.bpmn").getDeployedProcessDefinitions().get(0);
        ProcessDefinition targetProcessDefinition = (ProcessDefinition)this.testHelper.deploy("org/eximeebpms/bpm/engine/test/api/externaltask/ExternalTaskWithIdTest.bpmn").getDeployedProcessDefinitions().get(0);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        List instructions = migrationPlan.getInstructions();
        Assert.assertEquals((long)2L, (long)instructions.size());
    }

    protected LockedExternalTask fetchAndLockSingleTask(String topic) {
        List tasks = this.rule.getExternalTaskService().fetchAndLock(1, WORKER_ID).topic(topic, 1000L).execute();
        Assert.assertEquals((long)1L, (long)tasks.size());
        return (LockedExternalTask)tasks.get(0);
    }
}

