/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.task;

import java.util.ArrayList;
import java.util.HashMap;
import org.eximeebpms.bpm.engine.BadUserRequestException;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.eximeebpms.bpm.engine.variable.value.ObjectValue;
import org.eximeebpms.bpm.engine.variable.value.StringValue;
import org.junit.Assert;
import org.junit.Test;

public class TaskVariablesTest
extends PluggableProcessEngineTest {
    @Test
    public void testStandaloneTaskVariables() {
        Task task = this.taskService.newTask();
        task.setName("gonzoTask");
        this.taskService.saveTask(task);
        String taskId = task.getId();
        this.taskService.setVariable(taskId, "instrument", (Object)"trumpet");
        Assert.assertEquals((Object)"trumpet", (Object)this.taskService.getVariable(taskId, "instrument"));
        this.taskService.deleteTask(taskId, true);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/task/TaskVariablesTest.testTaskExecutionVariables.bpmn20.xml"})
    @Test
    public void testTaskExecutionVariableLongValue() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getId();
        StringBuffer longString = new StringBuffer();
        for (int i = 0; i < 500; ++i) {
            longString.append("tensymbols");
        }
        try {
            this.runtimeService.setVariable(processInstanceId, "var", (Object)longString.toString());
        }
        catch (Exception ex) {
            if (!(ex instanceof BadUserRequestException)) {
                Assert.fail((String)("BadUserRequestException is expected, but another exception was received:  " + String.valueOf(ex)));
            }
            Assert.assertEquals((Object)"Variable value is too long", (Object)ex.getMessage());
        }
    }

    @Deployment
    @Test
    public void testTaskExecutionVariables() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        HashMap<String, String> expectedVariables = new HashMap<String, String>();
        Assert.assertEquals(expectedVariables, (Object)this.runtimeService.getVariables(processInstanceId));
        Assert.assertEquals(expectedVariables, (Object)this.taskService.getVariables(taskId));
        Assert.assertEquals(expectedVariables, (Object)this.runtimeService.getVariablesLocal(processInstanceId));
        Assert.assertEquals(expectedVariables, (Object)this.taskService.getVariablesLocal(taskId));
        this.runtimeService.setVariable(processInstanceId, "instrument", (Object)"trumpet");
        expectedVariables = new HashMap();
        Assert.assertEquals(expectedVariables, (Object)this.taskService.getVariablesLocal(taskId));
        expectedVariables.put("instrument", "trumpet");
        Assert.assertEquals(expectedVariables, (Object)this.runtimeService.getVariables(processInstanceId));
        Assert.assertEquals(expectedVariables, (Object)this.taskService.getVariables(taskId));
        Assert.assertEquals(expectedVariables, (Object)this.runtimeService.getVariablesLocal(processInstanceId));
        this.taskService.setVariable(taskId, "player", (Object)"gonzo");
        expectedVariables = new HashMap();
        Assert.assertEquals(expectedVariables, (Object)this.taskService.getVariablesLocal(taskId));
        expectedVariables.put("player", "gonzo");
        expectedVariables.put("instrument", "trumpet");
        Assert.assertEquals(expectedVariables, (Object)this.runtimeService.getVariables(processInstanceId));
        Assert.assertEquals(expectedVariables, (Object)this.taskService.getVariables(taskId));
        Assert.assertEquals(expectedVariables, (Object)this.runtimeService.getVariablesLocal(processInstanceId));
        Assert.assertEquals(expectedVariables, (Object)this.runtimeService.getVariablesLocal(processInstanceId, null));
        Assert.assertEquals(expectedVariables, (Object)this.runtimeService.getVariablesLocalTyped(processInstanceId, null, true));
        this.taskService.setVariableLocal(taskId, "budget", (Object)"unlimited");
        expectedVariables = new HashMap();
        expectedVariables.put("budget", "unlimited");
        Assert.assertEquals(expectedVariables, (Object)this.taskService.getVariablesLocal(taskId));
        Assert.assertEquals(expectedVariables, (Object)this.taskService.getVariablesLocalTyped(taskId, true));
        expectedVariables.put("player", "gonzo");
        expectedVariables.put("instrument", "trumpet");
        Assert.assertEquals(expectedVariables, (Object)this.taskService.getVariables(taskId));
        Assert.assertEquals(expectedVariables, (Object)this.taskService.getVariablesTyped(taskId, true));
        Assert.assertEquals(expectedVariables, (Object)this.taskService.getVariables(taskId, null));
        Assert.assertEquals(expectedVariables, (Object)this.taskService.getVariablesTyped(taskId, null, true));
        expectedVariables = new HashMap();
        expectedVariables.put("player", "gonzo");
        expectedVariables.put("instrument", "trumpet");
        Assert.assertEquals(expectedVariables, (Object)this.runtimeService.getVariables(processInstanceId));
        Assert.assertEquals(expectedVariables, (Object)this.runtimeService.getVariablesLocal(processInstanceId));
        ArrayList<String> serializableValue = new ArrayList<String>();
        serializableValue.add("1");
        serializableValue.add("2");
        this.taskService.setVariable(taskId, "objectVariable", (Object)Variables.objectValue(serializableValue).create());
        ArrayList<String> serializableValueLocal = new ArrayList<String>();
        serializableValueLocal.add("3");
        serializableValueLocal.add("4");
        this.taskService.setVariableLocal(taskId, "objectVariableLocal", (Object)Variables.objectValue(serializableValueLocal).create());
        Object value = this.taskService.getVariable(taskId, "objectVariable");
        Assert.assertEquals(serializableValue, (Object)value);
        Object valueLocal = this.taskService.getVariableLocal(taskId, "objectVariableLocal");
        Assert.assertEquals(serializableValueLocal, (Object)valueLocal);
        ObjectValue typedValue = (ObjectValue)this.taskService.getVariableTyped(taskId, "objectVariable");
        Assert.assertEquals(serializableValue, (Object)typedValue.getValue());
        ObjectValue serializedValue = (ObjectValue)this.taskService.getVariableTyped(taskId, "objectVariable", false);
        Assert.assertFalse((boolean)serializedValue.isDeserialized());
        ObjectValue typedValueLocal = (ObjectValue)this.taskService.getVariableLocalTyped(taskId, "objectVariableLocal");
        Assert.assertEquals(serializableValueLocal, (Object)typedValueLocal.getValue());
        ObjectValue serializedValueLocal = (ObjectValue)this.taskService.getVariableLocalTyped(taskId, "objectVariableLocal", false);
        Assert.assertFalse((boolean)serializedValueLocal.isDeserialized());
        try {
            StringValue val = (StringValue)this.taskService.getVariableTyped(taskId, "objectVariable");
            Assert.fail((String)"expected exception");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }
}

