/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.variables;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.api.variables.NoopDelegate;
import org.eximeebpms.bpm.engine.test.api.variables.Pojo;
import org.eximeebpms.bpm.engine.test.history.UpdateValueDelegate;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class ImplicitVariableUpdateDisabledTest {
    @ClassRule
    public static final ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(c -> c.setImplicitVariableUpdateDetectionEnabled(false));
    private final ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    private final ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    private RuntimeService runtimeService;

    @Before
    public void createProcessEngine() {
        this.runtimeService = this.engineRule.getRuntimeService();
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/variables/ImplicitVariableUpdateTest.sequence.bpmn20.xml"})
    @Test
    public void testUpdate() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("serviceTaskProcess", (Map)Variables.createVariables().putValue("listVar", new ArrayList()).putValue("delegate", (Object)new UpdateValueDelegate()));
        List list = (List)this.runtimeService.getVariable(instance.getId(), "listVar");
        Assert.assertNotNull((Object)list);
        Assertions.assertThat((List)list).isEmpty();
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/variables/ImplicitVariableUpdateTest.sequence.bpmn20.xml"})
    @Test
    public void testSerialization() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("serviceTaskProcess", (Map)Variables.createVariables().putValue("pojo", (Object)new Pojo(1)).putValue("delegate", (Object)new NoopDelegate()));
        Pojo.shouldUpdateFoo = true;
        Pojo pojo1 = (Pojo)this.runtimeService.getVariable(instance.getId(), "pojo");
        Assertions.assertThat((int)pojo1.getFoo()).isEqualTo(2);
        Pojo.shouldUpdateFoo = false;
        Pojo pojo2 = (Pojo)this.runtimeService.getVariable(instance.getId(), "pojo");
        Assertions.assertThat((int)pojo2.getFoo()).isEqualTo(1);
    }
}

