/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.async;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.impl.Page;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.AcquirableJobEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.JobEntity;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.JobQuery;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.bpmn.async.FailingDelegate;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.EndEventBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.EventBasedGatewayBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.ExclusiveGatewayBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.InclusiveGatewayBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.IntermediateThrowEventBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.MessageEventDefinitionBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.ParallelGatewayBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.StartEventBuilder;
import org.eximeebpms.bpm.model.bpmn.instance.MessageEventDefinition;
import org.junit.Assert;
import org.junit.Test;

public class FoxJobRetryCmdTest
extends PluggableProcessEngineTest {
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedServiceTask.bpmn20.xml"})
    @Test
    public void testFailedServiceTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedServiceTask");
        this.assertJobRetriesForActivity(pi, "failingServiceTask");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedUserTask.bpmn20.xml"})
    @Test
    public void testFailedUserTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedUserTask");
        this.assertJobRetriesForActivity(pi, "failingUserTask");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedBusinessRuleTask.bpmn20.xml"})
    @Test
    public void testFailedBusinessRuleTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedBusinessRuleTask");
        this.assertJobRetriesForActivity(pi, "failingBusinessRuleTask");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedCallActivity.bpmn20.xml"})
    @Test
    public void testFailedCallActivity() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedCallActivity");
        this.assertJobRetriesForActivity(pi, "failingCallActivity");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedScriptTask.bpmn20.xml"})
    @Test
    public void testFailedScriptTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedScriptTask");
        this.assertJobRetriesForActivity(pi, "failingScriptTask");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedSendTask.bpmn20.xml"})
    @Test
    public void testFailedSendTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedSendTask");
        this.assertJobRetriesForActivity(pi, "failingSendTask");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedSubProcess.bpmn20.xml"})
    @Test
    public void testFailedSubProcess() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedSubProcess");
        this.assertJobRetriesForActivity(pi, "failingSubProcess");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedTask.bpmn20.xml"})
    @Test
    public void testFailedTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedTask");
        this.assertJobRetriesForActivity(pi, "failingTask");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedTransaction.bpmn20.xml"})
    @Test
    public void testFailedTransaction() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedTask");
        this.assertJobRetriesForActivity(pi, "failingTransaction");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedReceiveTask.bpmn20.xml"})
    @Test
    public void testFailedReceiveTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedReceiveTask");
        this.assertJobRetriesForActivity(pi, "failingReceiveTask");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedBoundaryTimerEvent.bpmn20.xml"})
    @Test
    public void testFailedBoundaryTimerEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedBoundaryTimerEvent");
        this.assertJobRetriesForActivity(pi, "userTask");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedIntermediateCatchingTimerEvent.bpmn20.xml"})
    @Test
    public void testFailedIntermediateCatchingTimerEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedIntermediateCatchingTimerEvent");
        this.assertJobRetriesForActivity(pi, "failingTimerEvent");
    }

    @Deployment
    @Test
    public void testFailingMultiInstanceBody() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failingMultiInstance");
        this.assertJobRetriesForActivity(pi, "task#multiInstanceBody");
    }

    @Deployment
    @Test
    public void testFailingMultiInstanceInnerActivity() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failingMultiInstance");
        this.assertJobRetriesForActivity(pi, "task");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testBrokenFoxJobRetryValue.bpmn20.xml"})
    @Test
    public void testBrokenFoxJobRetryValue() {
        Job job = (Job)this.managementService.createJobQuery().list().get(0);
        Assert.assertNotNull((Object)job);
        Assert.assertEquals((long)3L, (long)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(0, job.getId());
        job = this.refreshJob(job.getId());
        Assert.assertEquals((long)0L, (long)job.getRetries());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedStartTimerEvent.bpmn20.xml"})
    @Test
    public void testFailedTimerStartEvent() {
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        Job job = (Job)this.managementService.createJobQuery().list().get(0);
        Assert.assertNotNull((Object)job);
        String jobId = job.getId();
        Assertions.assertThat((int)job.getRetries()).isEqualTo(5);
        this.waitForExecutedJobWithRetriesLeft(4, jobId);
        this.stillOneJobWithExceptionAndRetriesLeft(jobId);
        job = this.refreshJob(jobId);
        Assert.assertNotNull((Object)job);
        Assert.assertEquals((long)4L, (long)job.getRetries());
        this.waitForExecutedJobWithRetriesLeft(3, jobId);
        job = this.refreshJob(jobId);
        Assert.assertEquals((long)3L, (long)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft(jobId);
        this.waitForExecutedJobWithRetriesLeft(2, jobId);
        job = this.refreshJob(jobId);
        Assert.assertEquals((long)2L, (long)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft(jobId);
        this.waitForExecutedJobWithRetriesLeft(1, jobId);
        job = this.refreshJob(jobId);
        Assert.assertEquals((long)1L, (long)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft(jobId);
        this.waitForExecutedJobWithRetriesLeft(0, jobId);
        job = this.refreshJob(jobId);
        Assert.assertEquals((long)0L, (long)job.getRetries());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().jobId(jobId).withRetriesLeft().count());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedIntermediateThrowingSignalEvent.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.failingSignalStart.bpmn20.xml"})
    public void FAILING_testFailedIntermediateThrowingSignalEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedIntermediateThrowingSignalEvent");
        this.assertJobRetriesForActivity(pi, "failingSignalEvent");
    }

    @Deployment
    @Test
    public void testRetryOnTimerStartEventInEventSubProcess() {
        this.runtimeService.startProcessInstanceByKey("process").getId();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)5L, (long)job.getRetries());
        try {
            this.managementService.executeJob(job.getId());
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)4L, (long)job.getRetries());
    }

    @Test
    public void testRetryOnServiceTaskLikeMessageThrowEvent() {
        BpmnModelInstance bpmnModelInstance = ((MessageEventDefinitionBuilder)((IntermediateThrowEventBuilder)((IntermediateThrowEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().intermediateThrowEvent().camundaAsyncBefore()).camundaFailedJobRetryTimeCycle("R10/PT5S")).messageEventDefinition("messageDefinition").message("message")).messageEventDefinitionDone().endEvent().done();
        MessageEventDefinition messageDefinition = (MessageEventDefinition)bpmnModelInstance.getModelElementById("messageDefinition");
        messageDefinition.setCamundaClass(FailingDelegate.class.getName());
        this.testRule.deploy(bpmnModelInstance);
        this.runtimeService.startProcessInstanceByKey("process");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        try {
            this.managementService.executeJob(job.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)9L, (long)job.getRetries());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedServiceTask.bpmn20.xml"})
    public void FAILING_testFailedRetryWithTimeShift() throws ParseException {
        Date tenMinutesBeforeTimeShift = this.createDateFromLocalString("2015-10-25T02:50:00 CEST");
        Date fiveMinutesBeforeTimeShift = this.createDateFromLocalString("2015-10-25T02:55:00 CEST");
        Date twoMinutesBeforeTimeShift = this.createDateFromLocalString("2015-10-25T02:58:00 CEST");
        ClockUtil.setCurrentTime((Date)tenMinutesBeforeTimeShift);
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedServiceTask");
        Assert.assertNotNull((Object)pi);
        List<AcquirableJobEntity> acquirableJobs = this.findAndLockAcquirableJobs();
        Assert.assertEquals((long)1L, (long)acquirableJobs.size());
        this.waitForExecutedJobWithRetriesLeft(4);
        JobEntity job = (JobEntity)this.fetchJob(pi.getProcessInstanceId());
        Assert.assertTrue((boolean)tenMinutesBeforeTimeShift.before(job.getLockExpirationTime()));
        Assert.assertEquals((Object)fiveMinutesBeforeTimeShift, (Object)job.getLockExpirationTime());
        Assert.assertTrue((boolean)twoMinutesBeforeTimeShift.after(job.getLockExpirationTime()));
        acquirableJobs = this.findAndLockAcquirableJobs();
        Assert.assertEquals((long)0L, (long)acquirableJobs.size());
        ClockUtil.setCurrentTime((Date)twoMinutesBeforeTimeShift);
        acquirableJobs = this.findAndLockAcquirableJobs();
        Assert.assertEquals((long)1L, (long)acquirableJobs.size());
        this.waitForExecutedJobWithRetriesLeft(3);
        job = (JobEntity)this.refreshJob(job.getId());
        Assert.assertTrue((boolean)twoMinutesBeforeTimeShift.before(job.getLockExpirationTime()));
        acquirableJobs = this.findAndLockAcquirableJobs();
        Assert.assertEquals((String)"Job shouldn't be acquirable", (long)0L, (long)acquirableJobs.size());
        ClockUtil.reset();
    }

    @Test
    public void testFailedJobRetryTimeCycleWithExpression() {
        BpmnModelInstance bpmnModelInstance = ((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask().camundaClass("foo")).camundaAsyncBefore()).camundaFailedJobRetryTimeCycle("${var}")).endEvent().done();
        this.testRule.deploy(bpmnModelInstance);
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("var", (Object)"R10/PT5M"));
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        try {
            this.managementService.executeJob(job.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)9L, (long)job.getRetries());
    }

    @Test
    public void testFailedJobRetryTimeCycleWithUndefinedVar() {
        BpmnModelInstance bpmnModelInstance = ((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask().camundaClass("foo")).camundaAsyncBefore()).camundaFailedJobRetryTimeCycle("${var}")).endEvent().done();
        this.testRule.deploy(bpmnModelInstance);
        this.runtimeService.startProcessInstanceByKey("process");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        try {
            this.managementService.executeJob(job.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)2L, (long)job.getRetries());
    }

    @Test
    public void testFailedJobRetryTimeCycleWithChangingExpression() throws ParseException {
        BpmnModelInstance bpmnModelInstance = ((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask().camundaClass("foo")).camundaAsyncBefore()).camundaFailedJobRetryTimeCycle("${var}")).endEvent().done();
        Date startDate = this.simpleDateFormat.parse("2017-01-01T09:55:00");
        ClockUtil.setCurrentTime((Date)startDate);
        this.testRule.deploy(bpmnModelInstance);
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("var", (Object)"R10/PT5M"));
        startDate = this.simpleDateFormat.parse("2017-01-01T10:00:00");
        ClockUtil.setCurrentTime((Date)startDate);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        try {
            this.managementService.executeJob(job.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)9L, (long)job.getRetries());
        startDate = this.simpleDateFormat.parse("2017-01-01T10:05:00");
        ClockUtil.setCurrentTime((Date)startDate);
        this.runtimeService.setVariable(pi.getProcessInstanceId(), "var", (Object)"R10/PT10M");
        try {
            this.managementService.executeJob(job.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Date expectedDate = this.simpleDateFormat.parse("2017-01-01T10:15:00");
        Date duedateTime = ((Job)this.managementService.createJobQuery().singleResult()).getDuedate();
        Assert.assertEquals((Object)expectedDate, (Object)duedateTime);
    }

    @Test
    public void testRetryOnTimerStartEventWithExpression() {
        BpmnModelInstance bpmnModelInstance = ((ServiceTaskBuilder)((StartEventBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().camundaFailedJobRetryTimeCycle("${var}")).timerWithDuration("PT5M")).serviceTask().camundaClass("bar")).endEvent().done();
        this.testRule.deploy(bpmnModelInstance);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        try {
            this.managementService.executeJob(job.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)2L, (long)job.getRetries());
    }

    @Test
    public void testRetryOnAsyncStartEvent() throws Exception {
        BpmnModelInstance bpmnModelInstance = ((ServiceTaskBuilder)((StartEventBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().camundaAsyncBefore()).camundaFailedJobRetryTimeCycle("R5/PT5M")).serviceTask().camundaClass("bar")).endEvent().done();
        this.testRule.deploy(bpmnModelInstance);
        Date startDate = this.simpleDateFormat.parse("2018-01-01T10:00:00");
        ClockUtil.setCurrentTime((Date)startDate);
        this.runtimeService.startProcessInstanceByKey("process");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)5L, (long)job.getRetries());
        try {
            this.managementService.executeJob(job.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)4L, (long)job.getRetries());
        Date expectedDate = this.simpleDateFormat.parse("2018-01-01T10:05:00");
        Assert.assertEquals((Object)expectedDate, (Object)job.getDuedate());
    }

    @Test
    public void testIntermediateCatchEvent() throws Exception {
        BpmnModelInstance bpmnModelInstance = ((IntermediateCatchEventBuilder)((IntermediateCatchEventBuilder)((IntermediateCatchEventBuilder)((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().intermediateCatchEvent().message("foo")).camundaAsyncBefore()).camundaFailedJobRetryTimeCycle("R5/PT5M")).camundaExecutionListenerClass("start", "foo")).endEvent().done();
        this.testRule.deploy(bpmnModelInstance);
        Date startDate = this.simpleDateFormat.parse("2018-01-01T10:00:00");
        ClockUtil.setCurrentTime((Date)startDate);
        this.runtimeService.startProcessInstanceByKey("process");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)5L, (long)job.getRetries());
        try {
            this.managementService.executeJob(job.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)4L, (long)job.getRetries());
        Date expectedDate = this.simpleDateFormat.parse("2018-01-01T10:05:00");
        Assert.assertEquals((Object)expectedDate, (Object)job.getDuedate());
    }

    @Test
    public void testEndEvent() throws Exception {
        BpmnModelInstance bpmnModelInstance = ((EndEventBuilder)((EndEventBuilder)((EndEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().camundaAsyncBefore()).camundaFailedJobRetryTimeCycle("R5/PT5M")).camundaExecutionListenerClass("start", "foo")).done();
        this.testRule.deploy(bpmnModelInstance);
        Date startDate = this.simpleDateFormat.parse("2018-01-01T10:00:00");
        ClockUtil.setCurrentTime((Date)startDate);
        this.runtimeService.startProcessInstanceByKey("process");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)5L, (long)job.getRetries());
        try {
            this.managementService.executeJob(job.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)4L, (long)job.getRetries());
        Date expectedDate = this.simpleDateFormat.parse("2018-01-01T10:05:00");
        Assert.assertEquals((Object)expectedDate, (Object)job.getDuedate());
    }

    @Test
    public void testExclusiveGateway() throws Exception {
        BpmnModelInstance bpmnModelInstance = ((ExclusiveGatewayBuilder)((ExclusiveGatewayBuilder)((ExclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().exclusiveGateway().camundaAsyncBefore()).camundaFailedJobRetryTimeCycle("R5/PT5M")).camundaExecutionListenerClass("start", "foo")).endEvent().done();
        this.testRule.deploy(bpmnModelInstance);
        Date startDate = this.simpleDateFormat.parse("2018-01-01T10:00:00");
        ClockUtil.setCurrentTime((Date)startDate);
        this.runtimeService.startProcessInstanceByKey("process");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)5L, (long)job.getRetries());
        try {
            this.managementService.executeJob(job.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)4L, (long)job.getRetries());
        Date expectedDate = this.simpleDateFormat.parse("2018-01-01T10:05:00");
        Assert.assertEquals((Object)expectedDate, (Object)job.getDuedate());
    }

    @Test
    public void testInclusiveGateway() throws Exception {
        BpmnModelInstance bpmnModelInstance = ((InclusiveGatewayBuilder)((InclusiveGatewayBuilder)((InclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().inclusiveGateway().camundaAsyncBefore()).camundaFailedJobRetryTimeCycle("R5/PT5M")).camundaExecutionListenerClass("start", "foo")).endEvent().done();
        this.testRule.deploy(bpmnModelInstance);
        Date startDate = this.simpleDateFormat.parse("2018-01-01T10:00:00");
        ClockUtil.setCurrentTime((Date)startDate);
        this.runtimeService.startProcessInstanceByKey("process");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)5L, (long)job.getRetries());
        try {
            this.managementService.executeJob(job.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)4L, (long)job.getRetries());
        Date expectedDate = this.simpleDateFormat.parse("2018-01-01T10:05:00");
        Assert.assertEquals((Object)expectedDate, (Object)job.getDuedate());
    }

    @Test
    public void testEventBasedGateway() throws Exception {
        BpmnModelInstance bpmnModelInstance = ((IntermediateCatchEventBuilder)((EventBasedGatewayBuilder)((EventBasedGatewayBuilder)((EventBasedGatewayBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().eventBasedGateway().camundaAsyncBefore()).camundaFailedJobRetryTimeCycle("R5/PT5M")).camundaExecutionListenerClass("start", "foo")).intermediateCatchEvent().condition("${true}")).endEvent().done();
        this.testRule.deploy(bpmnModelInstance);
        Date startDate = this.simpleDateFormat.parse("2018-01-01T10:00:00");
        ClockUtil.setCurrentTime((Date)startDate);
        this.runtimeService.startProcessInstanceByKey("process");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)5L, (long)job.getRetries());
        try {
            this.managementService.executeJob(job.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)4L, (long)job.getRetries());
        Date expectedDate = this.simpleDateFormat.parse("2018-01-01T10:05:00");
        Assert.assertEquals((Object)expectedDate, (Object)job.getDuedate());
    }

    @Test
    public void testParallelGateway() throws Exception {
        BpmnModelInstance bpmnModelInstance = ((ParallelGatewayBuilder)((ParallelGatewayBuilder)((ParallelGatewayBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().parallelGateway().camundaAsyncBefore()).camundaFailedJobRetryTimeCycle("R5/PT5M")).camundaExecutionListenerClass("start", "foo")).endEvent().done();
        this.testRule.deploy(bpmnModelInstance);
        Date startDate = this.simpleDateFormat.parse("2018-01-01T10:00:00");
        ClockUtil.setCurrentTime((Date)startDate);
        this.runtimeService.startProcessInstanceByKey("process");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)5L, (long)job.getRetries());
        try {
            this.managementService.executeJob(job.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)4L, (long)job.getRetries());
        Date expectedDate = this.simpleDateFormat.parse("2018-01-01T10:05:00");
        Assert.assertEquals((Object)expectedDate, (Object)job.getDuedate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailingIntermidiateBoundaryTimerJobWithCustomRetries() throws ParseException {
        try {
            BpmnModelInstance bpmnModelInstance = ((ServiceTaskBuilder)((BoundaryEventBuilder)((BoundaryEventBuilder)((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().userTask("wait").boundaryEvent("timer").cancelActivity(Boolean.valueOf(false))).timerWithCycle("R4/PT1M")).camundaFailedJobRetryTimeCycle("R2/PT10M")).serviceTask("failing").camundaClass("foo")).endEvent().done();
            this.testRule.deploy(bpmnModelInstance);
            Date startDate = this.simpleDateFormat.parse("2019-01-01T10:00:00");
            ClockUtil.setCurrentTime((Date)startDate);
            this.runtimeService.startProcessInstanceByKey("process");
            ClockUtil.setCurrentTime((Date)this.simpleDateFormat.parse("2019-01-01T10:01:01"));
            Job firstJob = (Job)this.managementService.createJobQuery().singleResult();
            try {
                this.managementService.executeJob(firstJob.getId());
            }
            catch (Exception exception) {
                // empty catch block
            }
            List jobs = this.managementService.createJobQuery().list();
            Assert.assertEquals((long)2L, (long)jobs.size());
            for (Job job : jobs) {
                Date expectedDate;
                if (job.getRetries() == 1) {
                    expectedDate = this.simpleDateFormat.parse("2019-01-01T10:11:01");
                    Assert.assertEquals((Object)expectedDate, (Object)job.getDuedate());
                    Assert.assertNull((Object)((JobEntity)job).getLockExpirationTime());
                    continue;
                }
                if (job.getRetries() == 2) {
                    expectedDate = this.simpleDateFormat.parse("2019-01-01T10:02:00");
                    Assert.assertEquals((Object)expectedDate, (Object)job.getDuedate());
                    Assert.assertNull((Object)((JobEntity)job).getLockExpirationTime());
                    continue;
                }
                Assert.fail((String)"Unexpected job");
            }
        }
        finally {
            ClockUtil.reset();
        }
    }

    @Test
    public void testExecuteSecondJobWhenJobFailedWithCustomJobRetriesInSameProcess() {
        BpmnModelInstance bpmnModelInstance = ((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().parallelGateway("gwt").serviceTask("failing").camundaClass("foo")).camundaAsyncBefore()).camundaFailedJobRetryTimeCycle("R2/PT5M")).moveToNode("gwt").userTask("beforePassing").serviceTask("passing").camundaExpression("${true}")).camundaAsyncBefore()).userTask("afterPassing").done();
        this.testRule.deploy(bpmnModelInstance);
        this.runtimeService.startProcessInstanceByKey("process");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        try {
            this.managementService.executeJob(job.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("beforePassing").singleResult();
        this.taskService.complete(task.getId());
        this.testRule.waitForJobExecutorToProcessAllJobs(5000L);
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("afterPassing").singleResult();
        Assert.assertNotNull((Object)task);
        Job failedJob = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)1L, (long)failedJob.getRetries());
        Assert.assertNull((Object)((JobEntity)failedJob).getLockExpirationTime());
    }

    protected void assertJobRetriesForActivity(ProcessInstance pi, String activityId) {
        Assert.assertNotNull((Object)pi);
        this.waitForExecutedJobWithRetriesLeft(4);
        this.stillOneJobWithExceptionAndRetriesLeft();
        Job job = this.fetchJob(pi.getProcessInstanceId());
        Assert.assertNotNull((Object)job);
        Assert.assertEquals((Object)pi.getProcessInstanceId(), (Object)job.getProcessInstanceId());
        Assert.assertEquals((long)4L, (long)job.getRetries());
        ExecutionEntity execution = this.fetchExecutionEntity(pi.getProcessInstanceId(), activityId);
        Assert.assertNotNull((Object)execution);
        this.waitForExecutedJobWithRetriesLeft(3);
        job = this.refreshJob(job.getId());
        Assert.assertEquals((long)3L, (long)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        Assert.assertEquals((Object)activityId, (Object)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(2);
        job = this.refreshJob(job.getId());
        Assert.assertEquals((long)2L, (long)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        Assert.assertEquals((Object)activityId, (Object)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(1);
        job = this.refreshJob(job.getId());
        Assert.assertEquals((long)1L, (long)job.getRetries());
        this.stillOneJobWithExceptionAndRetriesLeft();
        execution = this.refreshExecutionEntity(execution.getId());
        Assert.assertEquals((Object)activityId, (Object)execution.getActivityId());
        this.waitForExecutedJobWithRetriesLeft(0);
        job = this.refreshJob(job.getId());
        Assert.assertEquals((long)0L, (long)job.getRetries());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
        execution = this.refreshExecutionEntity(execution.getId());
        Assert.assertEquals((Object)activityId, (Object)execution.getActivityId());
    }

    protected void waitForExecutedJobWithRetriesLeft(int retriesLeft, String jobId) {
        JobQuery jobQuery = this.managementService.createJobQuery();
        if (jobId != null) {
            jobQuery.jobId(jobId);
        }
        Job job = (Job)jobQuery.singleResult();
        try {
            this.managementService.executeJob(job.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        job = (Job)jobQuery.singleResult();
        if (job.getRetries() != retriesLeft) {
            this.waitForExecutedJobWithRetriesLeft(retriesLeft, jobId);
        }
    }

    protected void waitForExecutedJobWithRetriesLeft(int retriesLeft) {
        this.waitForExecutedJobWithRetriesLeft(retriesLeft, null);
    }

    protected ExecutionEntity refreshExecutionEntity(String executionId) {
        return (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(executionId).singleResult();
    }

    protected ExecutionEntity fetchExecutionEntity(String processInstanceId, String activityId) {
        return (ExecutionEntity)this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).activityId(activityId).singleResult();
    }

    protected Job refreshJob(String jobId) {
        return (Job)this.managementService.createJobQuery().jobId(jobId).singleResult();
    }

    protected Job fetchJob(String processInstanceId) {
        return (Job)this.managementService.createJobQuery().processInstanceId(processInstanceId).singleResult();
    }

    protected void stillOneJobWithExceptionAndRetriesLeft(String jobId) {
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().jobId(jobId).withException().count());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().jobId(jobId).withRetriesLeft().count());
    }

    protected void stillOneJobWithExceptionAndRetriesLeft() {
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
    }

    protected Date createDateFromLocalString(String dateString) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss z", Locale.US);
        return dateFormat.parse(dateString);
    }

    protected List<AcquirableJobEntity> findAndLockAcquirableJobs() {
        return (List)this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<List<AcquirableJobEntity>>(){

            public List<AcquirableJobEntity> execute(CommandContext commandContext) {
                List jobs = commandContext.getJobManager().findNextJobsToExecute(new Page(0, 100));
                for (AcquirableJobEntity job : jobs) {
                    job.setLockOwner("test");
                }
                return jobs;
            }
        });
    }
}

