/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.async;

import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class JobRetryCmdWithDefaultPropertyTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule("org/eximeebpms/bpm/engine/test/bpmn/async/default.job.retry.property.eximeebpms.cfg.xml");
    @Rule
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected RuntimeService runtimeService;
    protected ManagementService managementService;

    @Before
    public void setUp() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedTask.bpmn20.xml"})
    @Test
    public void testDefaultNumberOfRetryProperty() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedTask");
        Assert.assertNotNull((Object)pi);
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(pi.getProcessInstanceId()).singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertEquals((Object)pi.getProcessInstanceId(), (Object)job.getProcessInstanceId());
        Assert.assertEquals((long)5L, (long)job.getRetries());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedServiceTask.bpmn20.xml"})
    @Test
    public void testOverwritingPropertyWithBpmnExtension() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("failedServiceTask");
        Assert.assertNotNull((Object)pi);
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(pi.getProcessInstanceId()).singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertEquals((Object)pi.getProcessInstanceId(), (Object)job.getProcessInstanceId());
        try {
            this.managementService.executeJob(job.getId());
            Assert.fail((String)"Exception expected!");
        }
        catch (Exception exception) {
            // empty catch block
        }
        job = (Job)this.managementService.createJobQuery().jobId(job.getId()).singleResult();
        Assert.assertEquals((long)4L, (long)job.getRetries());
    }
}

