/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.sequenceflow;

import java.util.HashMap;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class ConditionalScriptSequenceFlowTest
extends PluggableProcessEngineTest {
    @Deployment
    @Test
    public void testScriptExpression() {
        String[] directions = new String[]{"left", "right"};
        HashMap<String, String> variables = new HashMap<String, String>();
        for (String direction : directions) {
            variables.put("foo", direction);
            this.runtimeService.startProcessInstanceByKey("process", variables);
            Task task = (Task)this.taskService.createTaskQuery().singleResult();
            Assert.assertEquals((Object)direction, (Object)task.getTaskDefinitionKey());
            this.taskService.complete(task.getId());
        }
    }

    @Deployment
    @Test
    public void testScriptExpressionWithNonBooleanResult() {
        try {
            this.runtimeService.startProcessInstanceByKey("process");
            Assert.fail((String)"expected exception: invalid return value in script");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("condition script returns non-Boolean", e.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/sequenceflow/ConditionalScriptSequenceFlowTest.testScriptResourceExpression.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/sequenceflow/condition-left.groovy"})
    @Test
    public void testScriptResourceExpression() {
        String[] directions = new String[]{"left", "right"};
        HashMap<String, String> variables = new HashMap<String, String>();
        for (String direction : directions) {
            variables.put("foo", direction);
            this.runtimeService.startProcessInstanceByKey("process", variables);
            Task task = (Task)this.taskService.createTaskQuery().singleResult();
            Assert.assertEquals((Object)direction, (Object)task.getTaskDefinitionKey());
            this.taskService.complete(task.getId());
        }
    }
}

