/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.subprocess.transaction;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ParseException;
import org.eximeebpms.bpm.engine.Problem;
import org.eximeebpms.bpm.engine.ResourceReport;
import org.eximeebpms.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.eximeebpms.bpm.engine.runtime.ActivityInstance;
import org.eximeebpms.bpm.engine.runtime.Execution;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.ActivityInstanceAssert;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.junit.Assert;
import org.junit.Test;

public class TransactionSubProcessTest
extends PluggableProcessEngineTest {
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/subprocess/transaction/TransactionSubProcessTest.testSimpleCase.bpmn20.xml"})
    @Test
    public void testSimpleCaseTxSuccessful() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("transactionProcess");
        Assert.assertEquals((long)5L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("undoBookHotel").count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("undoBookFlight").count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.setVariable(task.getId(), "confirmed", (Object)true);
        this.taskService.complete(task.getId());
        List activeActivityIds = this.runtimeService.getActiveActivityIds(processInstance.getId());
        Assert.assertTrue((boolean)activeActivityIds.contains("afterSuccess"));
        EventSubscriptionEntity eventSubscriptionEntity = (EventSubscriptionEntity)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("tx").executionId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)eventSubscriptionEntity.getConfiguration());
        Execution eventScopeExecution = (Execution)this.runtimeService.createExecutionQuery().executionId(eventSubscriptionEntity.getConfiguration()).singleResult();
        Assert.assertNotNull((Object)eventScopeExecution);
        EventSubscriptionEntity miBodyEventSubscriptionEntity = (EventSubscriptionEntity)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("bookHotel#multiInstanceBody").executionId(eventScopeExecution.getId()).singleResult();
        Assert.assertNotNull((Object)miBodyEventSubscriptionEntity);
        String miBodyEventScopeExecutionId = miBodyEventSubscriptionEntity.getConfiguration();
        Assert.assertEquals((long)5L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("undoBookHotel").executionId(miBodyEventScopeExecutionId).count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("undoBookFlight").executionId(eventScopeExecution.getId()).count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("undoChargeCard").executionId(eventScopeExecution.getId()).count());
        Assert.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookHotel"));
        Assert.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookFlight"));
        Assert.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "undoChargeCard"));
        this.runtimeService.signal(processInstance.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/subprocess/transaction/TransactionSubProcessTest.testSimpleCase.bpmn20.xml"})
    @Test
    public void testActivityInstanceTreeAfterSuccessfulCompletion() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("transactionProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.setVariable(task.getId(), "confirmed", (Object)true);
        this.taskService.complete(task.getId());
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("afterSuccess").done());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/subprocess/transaction/TransactionSubProcessTest.testWaitstateCompensationHandler.bpmn20.xml"})
    @Test
    public void testWaitstateCompensationHandler() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("transactionProcess");
        Assert.assertEquals((long)5L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("undoBookHotel").count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("undoBookFlight").count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.setVariable(task.getId(), "confirmed", (Object)false);
        this.taskService.complete(task.getId());
        List undoBookHotel = this.taskService.createTaskQuery().taskDefinitionKey("undoBookHotel").list();
        List undoBookFlight = this.taskService.createTaskQuery().taskDefinitionKey("undoBookFlight").list();
        Assert.assertEquals((long)5L, (long)undoBookHotel.size());
        Assert.assertEquals((long)1L, (long)undoBookFlight.size());
        ActivityInstance rootActivityInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        List<ActivityInstance> undoBookHotelInstances = this.getInstancesForActivityId(rootActivityInstance, "undoBookHotel");
        List<ActivityInstance> undoBookFlightInstances = this.getInstancesForActivityId(rootActivityInstance, "undoBookFlight");
        Assert.assertEquals((long)5L, (long)undoBookHotelInstances.size());
        Assert.assertEquals((long)1L, (long)undoBookFlightInstances.size());
        ActivityInstanceAssert.assertThat(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getId()).beginScope("tx").activity("failure").activity("undoBookHotel").activity("undoBookHotel").activity("undoBookHotel").activity("undoBookHotel").activity("undoBookHotel").activity("undoBookFlight").done());
        for (Task t : undoBookHotel) {
            this.taskService.complete(t.getId());
        }
        this.taskService.complete(((Task)undoBookFlight.get(0)).getId());
        List activeActivityIds = this.runtimeService.getActiveActivityIds(processInstance.getId());
        Assert.assertTrue((boolean)activeActivityIds.contains("afterCancellation"));
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").count());
        this.runtimeService.signal(processInstance.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/subprocess/transaction/TransactionSubProcessTest.testSimpleCase.bpmn20.xml"})
    @Test
    public void testSimpleCaseTxCancelled() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("transactionProcess");
        Assert.assertEquals((long)5L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("undoBookHotel").count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("undoBookFlight").count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.setVariable(task.getId(), "confirmed", (Object)false);
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").count());
        Assert.assertEquals((Object)5, (Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookHotel"));
        Assert.assertEquals((Object)1, (Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookFlight"));
        Assert.assertEquals((Object)1, (Object)this.runtimeService.getVariable(processInstance.getId(), "undoChargeCard"));
        List<Execution> compensationHandlerExecutions = this.collectExecutionsFor("undoBookHotel", "undoBookFlight", "undoChargeCard");
        for (Execution execution : compensationHandlerExecutions) {
            this.runtimeService.signal(execution.getId());
        }
        List activeActivityIds = this.runtimeService.getActiveActivityIds(processInstance.getId());
        Assert.assertTrue((boolean)activeActivityIds.contains("afterCancellation"));
        if (!this.processEngineConfiguration.getHistory().equals("none")) {
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("undoBookFlight").count());
            Assert.assertEquals((long)5L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("undoBookHotel").count());
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("undoChargeCard").count());
        }
        this.runtimeService.signal(processInstance.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    @Deployment
    @Test
    public void testCancelEndConcurrent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("transactionProcess");
        Assert.assertEquals((long)5L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("undoBookHotel").count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("undoBookFlight").count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.setVariable(task.getId(), "confirmed", (Object)false);
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").count());
        Assert.assertEquals((Object)5, (Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookHotel"));
        Assert.assertEquals((Object)1, (Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookFlight"));
        List<Execution> compensationHandlerExecutions = this.collectExecutionsFor("undoBookHotel", "undoBookFlight");
        for (Execution execution : compensationHandlerExecutions) {
            this.runtimeService.signal(execution.getId());
        }
        List activeActivityIds = this.runtimeService.getActiveActivityIds(processInstance.getId());
        Assert.assertTrue((boolean)activeActivityIds.contains("afterCancellation"));
        if (!this.processEngineConfiguration.getHistory().equals("none")) {
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("undoBookFlight").count());
            Assert.assertEquals((long)5L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("undoBookHotel").count());
        }
        this.runtimeService.signal(processInstance.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    @Deployment
    @Test
    public void testNestedCancelInner() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("transactionProcess");
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("undoBookFlight").count());
        Assert.assertEquals((long)5L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("innerTxundoBookHotel").count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("innerTxundoBookFlight").count());
        Task taskInner = (Task)this.taskService.createTaskQuery().taskDefinitionKey("innerTxaskCustomer").singleResult();
        Task taskOuter = (Task)this.taskService.createTaskQuery().taskDefinitionKey("bookFlight").singleResult();
        Assert.assertNotNull((Object)taskInner);
        Assert.assertNotNull((Object)taskOuter);
        this.taskService.setVariable(taskInner.getId(), "confirmed", (Object)false);
        this.taskService.complete(taskInner.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("innerTxundoBookHotel").count());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("innerTxundoBookFlight").count());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("undoBookFlight").count());
        Assert.assertEquals((Object)5, (Object)this.runtimeService.getVariable(processInstance.getId(), "innerTxundoBookHotel"));
        Assert.assertEquals((Object)1, (Object)this.runtimeService.getVariable(processInstance.getId(), "innerTxundoBookFlight"));
        List<Execution> compensationHandlerExecutions = this.collectExecutionsFor("innerTxundoBookFlight", "innerTxundoBookHotel");
        for (Execution execution : compensationHandlerExecutions) {
            this.runtimeService.signal(execution.getId());
        }
        List activeActivityIds = this.runtimeService.getActiveActivityIds(processInstance.getId());
        Assert.assertTrue((boolean)activeActivityIds.contains("afterInnerCancellation"));
        if (!this.processEngineConfiguration.getHistory().equals("none")) {
            Assert.assertEquals((long)5L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("innerTxundoBookHotel").count());
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("innerTxundoBookFlight").count());
        }
        this.taskService.complete(taskOuter.getId());
        this.runtimeService.signal(((Execution)this.runtimeService.createExecutionQuery().activityId("afterInnerCancellation").singleResult()).getId());
        this.testRule.assertProcessEnded(processInstance.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    @Deployment
    @Test
    public void testNestedCancelOuter() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("transactionProcess");
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("undoBookFlight").count());
        Assert.assertEquals((long)5L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("innerTxundoBookHotel").count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("innerTxundoBookFlight").count());
        Task taskInner = (Task)this.taskService.createTaskQuery().taskDefinitionKey("innerTxaskCustomer").singleResult();
        Task taskOuter = (Task)this.taskService.createTaskQuery().taskDefinitionKey("bookFlight").singleResult();
        Assert.assertNotNull((Object)taskInner);
        Assert.assertNotNull((Object)taskOuter);
        this.taskService.complete(taskOuter.getId());
        List activeActivityIds = this.runtimeService.getActiveActivityIds(processInstance.getId());
        Assert.assertTrue((boolean)activeActivityIds.contains("afterOuterCancellation"));
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("innerTxundoBookHotel").count());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("innerTxundoBookFlight").count());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").activityId("undoBookFlight").count());
        Assert.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "innerTxundoBookHotel"));
        Assert.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "innerTxundoBookFlight"));
        Assert.assertEquals((Object)1, (Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookFlight"));
        this.runtimeService.signal(((Execution)this.runtimeService.createExecutionQuery().activityId("afterOuterCancellation").singleResult()).getId());
        this.testRule.assertProcessEnded(processInstance.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    @Deployment
    @Test
    public void testMultiInstanceTx() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("transactionProcess");
        List eventSubscriptions = this.runtimeService.createEventSubscriptionQuery().eventType("compensate").list();
        Assert.assertEquals((long)10L, (long)eventSubscriptions.size());
        Task task = (Task)this.taskService.createTaskQuery().listPage(0, 1).get(0);
        this.taskService.setVariable(task.getId(), "confirmed", (Object)false);
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        Assert.assertEquals((Object)1, (Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookHotel"));
        Assert.assertEquals((Object)1, (Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookFlight"));
        this.runtimeService.signal(((Execution)this.runtimeService.createExecutionQuery().activityId("afterCancellation").singleResult()).getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/subprocess/transaction/TransactionSubProcessTest.testMultiInstanceTx.bpmn20.xml"})
    @Test
    public void testMultiInstanceTxSuccessful() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("transactionProcess");
        List eventSubscriptions = this.runtimeService.createEventSubscriptionQuery().eventType("compensate").list();
        Assert.assertEquals((long)10L, (long)eventSubscriptions.size());
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.setVariable(task.getId(), "confirmed", (Object)true);
            this.taskService.complete(task.getId());
        }
        List executions = this.runtimeService.createExecutionQuery().activityId("receive").list();
        for (Execution execution : executions) {
            this.runtimeService.signal(execution.getId());
        }
        this.runtimeService.signal(((Execution)this.runtimeService.createExecutionQuery().activityId("afterSuccess").singleResult()).getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    @Test
    public void testCompensateSubprocess() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("txProcess");
        Task innerTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(innerTask.getId());
        this.runtimeService.setVariable(instance.getId(), "cancelTx", (Object)true);
        this.runtimeService.setVariable(instance.getId(), "compensate", (Object)false);
        Task beforeCancelTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(beforeCancelTask.getId());
        Task compensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)compensationTask);
        Assert.assertEquals((Object)"undoInnerTask", (Object)compensationTask.getTaskDefinitionKey());
        this.taskService.complete(compensationTask.getId());
        Task afterBoundaryTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"afterCancel", (Object)afterBoundaryTask.getTaskDefinitionKey());
        this.taskService.complete(afterBoundaryTask.getId());
        this.testRule.assertProcessEnded(instance.getId());
    }

    @Deployment
    @Test
    public void testCompensateTransactionWithEventSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("txProcess");
        Task beforeCancelTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(beforeCancelTask.getId());
        Task compensationHandler = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)compensationHandler);
        Assert.assertEquals((Object)"blackBoxCompensationHandler", (Object)compensationHandler.getTaskDefinitionKey());
        this.taskService.complete(compensationHandler.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/subprocess/transaction/TransactionSubProcessTest.testCompensateTransactionWithEventSubprocess.bpmn20.xml"})
    @Test
    public void testCompensateTransactionWithEventSubprocessActivityInstanceTree() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("txProcess");
        Task beforeCancelTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(beforeCancelTask.getId());
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("tx").activity("cancelEnd").beginScope("innerSubProcess").activity("blackBoxCompensationHandler").beginScope("eventSubProcess").activity("eventSubProcessThrowCompensation").done());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/subprocess/transaction/TransactionSubProcessTest.testCompensateSubprocess.bpmn20.xml"})
    @Test
    public void testCompensateSubprocessNotTriggered() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("txProcess");
        Task innerTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(innerTask.getId());
        this.runtimeService.setVariable(instance.getId(), "cancelTx", (Object)false);
        this.runtimeService.setVariable(instance.getId(), "compensate", (Object)false);
        Task beforeEndTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(beforeEndTask.getId());
        Task afterTxTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"afterTx", (Object)afterTxTask.getTaskDefinitionKey());
        this.taskService.complete(afterTxTask.getId());
        this.testRule.assertProcessEnded(instance.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/subprocess/transaction/TransactionSubProcessTest.testCompensateSubprocess.bpmn20.xml"})
    @Test
    public void testCompensateSubprocessAfterTxCompletion() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("txProcess");
        Task innerTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(innerTask.getId());
        this.runtimeService.setVariable(instance.getId(), "cancelTx", (Object)false);
        this.runtimeService.setVariable(instance.getId(), "compensate", (Object)true);
        Task beforeTxEndTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(beforeTxEndTask.getId());
        Task afterTxTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(afterTxTask.getId());
        Task compensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)compensationTask);
        Assert.assertEquals((Object)"undoInnerTask", (Object)compensationTask.getTaskDefinitionKey());
        this.taskService.complete(compensationTask.getId());
        this.testRule.assertProcessEnded(instance.getId());
    }

    @Deployment
    public void FAILURE_testMultipleCompensationOfCancellationOfMultipleTx() {
        ArrayList<String> devices = new ArrayList<String>();
        devices.add("device1");
        devices.add("device2");
        devices.add("fail");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("order", (Map)Variables.putValue((String)"devices", devices));
        int expected = 3;
        int actual = this.historyService.createHistoricActivityInstanceQuery().activityId("ServiceTask_CompensateConfiguration").list().size();
        Assert.assertEquals((long)expected, (long)actual);
    }

    @Test
    public void testMultipleCancelBoundaryFails() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/bpmn/subprocess/transaction/TransactionSubProcessTest.testMultipleCancelBoundaryFails.bpmn20.xml").deploy();
            Assert.fail((String)"exception expected");
        }
        catch (ParseException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"multiple boundary events with cancelEventDefinition not supported on same transaction"});
            Assertions.assertThat((String)((Problem)((ResourceReport)e.getResorceReports().get(0)).getErrors().get(0)).getMainElementId()).isEqualTo((Object)"catchCancelTx2");
        }
    }

    @Test
    public void testCancelBoundaryNoTransactionFails() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/bpmn/subprocess/transaction/TransactionSubProcessTest.testCancelBoundaryNoTransactionFails.bpmn20.xml").deploy();
            Assert.fail((String)"exception expected");
        }
        catch (ParseException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"boundary event with cancelEventDefinition only supported on transaction subprocesses"});
            Assertions.assertThat((String)((Problem)((ResourceReport)e.getResorceReports().get(0)).getErrors().get(0)).getMainElementId()).isEqualTo((Object)"catchCancelTx");
        }
    }

    @Test
    public void testCancelEndNoTransactionFails() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/bpmn/subprocess/transaction/TransactionSubProcessTest.testCancelEndNoTransactionFails.bpmn20.xml").deploy();
            Assert.fail((String)"exception expected");
        }
        catch (ParseException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"end event with cancelEventDefinition only supported inside transaction subprocess"});
            Assertions.assertThat((String)((Problem)((ResourceReport)e.getResorceReports().get(0)).getErrors().get(0)).getMainElementId()).isEqualTo((Object)"failure");
        }
    }

    @Deployment
    @Test
    public void testParseWithDI() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("TransactionSubProcessTest");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setVariable(task.getId(), "confirmed", (Object)false);
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
        processInstance = this.runtimeService.startProcessInstanceByKey("TransactionSubProcessTest");
        task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setVariable(task.getId(), "confirmed", (Object)true);
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    protected List<Execution> collectExecutionsFor(String ... activityIds) {
        ArrayList<Execution> executions = new ArrayList<Execution>();
        for (String activityId : activityIds) {
            executions.addAll(this.runtimeService.createExecutionQuery().activityId(activityId).list());
        }
        return executions;
    }
}

