/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.cmmn.listener;

import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.delegate.DelegateCaseVariableInstance;
import org.eximeebpms.bpm.engine.delegate.VariableListener;
import org.eximeebpms.bpm.engine.history.HistoricDetail;
import org.eximeebpms.bpm.engine.history.HistoricVariableUpdate;
import org.eximeebpms.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.eximeebpms.bpm.engine.impl.context.CaseExecutionContext;
import org.eximeebpms.bpm.engine.impl.history.HistoryLevel;
import org.eximeebpms.bpm.engine.repository.CaseDefinition;
import org.eximeebpms.bpm.engine.runtime.CaseExecution;
import org.eximeebpms.bpm.engine.runtime.CaseInstance;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.cmmn.listener.DelegateVariableInstanceSpec;
import org.eximeebpms.bpm.engine.test.cmmn.listener.LogAndUpdateVariableListener;
import org.eximeebpms.bpm.engine.test.cmmn.listener.LogExecutionContextListener;
import org.eximeebpms.bpm.engine.test.cmmn.listener.LogInjectedValuesListener;
import org.eximeebpms.bpm.engine.test.cmmn.listener.LogVariableListener;
import org.eximeebpms.bpm.engine.test.cmmn.listener.ProcessEngineAwareListener;
import org.eximeebpms.bpm.engine.test.cmmn.listener.SimpleBean;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class VariableListenerTest
extends PluggableProcessEngineTest {
    protected Map<Object, Object> beans = null;

    @Before
    public void setUp() throws Exception {
        LogVariableListener.reset();
        this.beans = this.processEngineConfiguration.getBeans();
    }

    @Deployment
    @Test
    public void testAnyEventListenerByClass() {
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assert.assertNotNull((Object)taskExecution);
        this.caseService.withCaseExecution(caseInstance.getId()).setVariable("anInstanceVariable", (Object)"anInstanceValue").execute();
        Assert.assertTrue((boolean)LogVariableListener.getInvocations().isEmpty());
        this.caseService.withCaseExecution(taskExecution.getId()).setVariableLocal("aTaskVariable", (Object)"aTaskValue").execute();
        Assert.assertEquals((long)1L, (long)LogVariableListener.getInvocations().size());
        DelegateVariableInstanceSpec.fromCaseExecution(taskExecution).event("create").name("aTaskVariable").value("aTaskValue").matches(LogVariableListener.getInvocations().get(0));
        LogVariableListener.reset();
        this.caseService.withCaseExecution(taskExecution.getId()).setVariable("aTaskVariable", (Object)"aNewTaskValue").execute();
        Assert.assertEquals((long)1L, (long)LogVariableListener.getInvocations().size());
        DelegateVariableInstanceSpec.fromCaseExecution(taskExecution).event("update").name("aTaskVariable").value("aNewTaskValue").activityInstanceId(taskExecution.getId()).matches(LogVariableListener.getInvocations().get(0));
        LogVariableListener.reset();
        this.caseService.withCaseExecution(taskExecution.getId()).removeVariable("aTaskVariable").execute();
        Assert.assertEquals((long)1L, (long)LogVariableListener.getInvocations().size());
        DelegateVariableInstanceSpec.fromCaseExecution(taskExecution).event("delete").name("aTaskVariable").value(null).activityInstanceId(taskExecution.getId()).matches(LogVariableListener.getInvocations().get(0));
        LogVariableListener.reset();
    }

    @Deployment
    @Test
    public void testCreateEventListenerByClass() {
        this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assert.assertNotNull((Object)taskExecution);
        this.caseService.withCaseExecution(taskExecution.getId()).setVariableLocal("aTaskVariable", (Object)"aTaskValue").execute();
        Assert.assertEquals((long)1L, (long)LogVariableListener.getInvocations().size());
        DelegateVariableInstanceSpec.fromCaseExecution(taskExecution).event("create").name("aTaskVariable").value("aTaskValue").matches(LogVariableListener.getInvocations().get(0));
        LogVariableListener.reset();
        this.caseService.withCaseExecution(taskExecution.getId()).setVariable("aTaskVariable", (Object)"aNewTaskValue").execute();
        Assert.assertTrue((boolean)LogVariableListener.getInvocations().isEmpty());
        this.caseService.withCaseExecution(taskExecution.getId()).removeVariable("aTaskVariable").execute();
        Assert.assertTrue((boolean)LogVariableListener.getInvocations().isEmpty());
    }

    @Deployment
    @Test
    public void testUpdateEventListenerByClass() {
        this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assert.assertNotNull((Object)taskExecution);
        this.caseService.withCaseExecution(taskExecution.getId()).setVariableLocal("aTaskVariable", (Object)"aTaskValue").execute();
        Assert.assertTrue((boolean)LogVariableListener.getInvocations().isEmpty());
        this.caseService.withCaseExecution(taskExecution.getId()).setVariable("aTaskVariable", (Object)"aNewTaskValue").execute();
        Assert.assertEquals((long)1L, (long)LogVariableListener.getInvocations().size());
        DelegateVariableInstanceSpec.fromCaseExecution(taskExecution).event("update").name("aTaskVariable").value("aNewTaskValue").activityInstanceId(taskExecution.getId()).matches(LogVariableListener.getInvocations().get(0));
        LogVariableListener.reset();
        this.caseService.withCaseExecution(taskExecution.getId()).removeVariable("aTaskVariable").execute();
        Assert.assertTrue((boolean)LogVariableListener.getInvocations().isEmpty());
    }

    @Deployment
    @Test
    public void testVariableListenerInvokedFromSourceScope() {
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assert.assertNotNull((Object)taskExecution);
        this.caseService.withCaseExecution(caseInstance.getId()).setVariable("aTaskVariable", (Object)"aTaskValue").execute();
        Assert.assertEquals((long)0L, (long)LogVariableListener.getInvocations().size());
        this.caseService.withCaseExecution(taskExecution.getId()).setVariable("aTaskVariable", (Object)"aTaskValue").execute();
        Assert.assertEquals((long)1L, (long)LogVariableListener.getInvocations().size());
        DelegateVariableInstanceSpec.fromCaseExecution((CaseExecution)caseInstance).sourceExecution(taskExecution).event("update").name("aTaskVariable").value("aTaskValue").activityInstanceId(caseInstance.getId()).matches(LogVariableListener.getInvocations().get(0));
        LogVariableListener.reset();
    }

    @Deployment
    @Test
    public void testDeleteEventListenerByClass() {
        this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assert.assertNotNull((Object)taskExecution);
        this.caseService.withCaseExecution(taskExecution.getId()).setVariableLocal("aTaskVariable", (Object)"aTaskValue").execute();
        Assert.assertTrue((boolean)LogVariableListener.getInvocations().isEmpty());
        this.caseService.withCaseExecution(taskExecution.getId()).setVariable("aTaskVariable", (Object)"aNewTaskValue").execute();
        Assert.assertTrue((boolean)LogVariableListener.getInvocations().isEmpty());
        this.caseService.withCaseExecution(taskExecution.getId()).removeVariable("aTaskVariable").execute();
        Assert.assertEquals((long)1L, (long)LogVariableListener.getInvocations().size());
        DelegateVariableInstanceSpec.fromCaseExecution(taskExecution).event("delete").name("aTaskVariable").value(null).activityInstanceId(taskExecution.getId()).matches(LogVariableListener.getInvocations().get(0));
        LogVariableListener.reset();
    }

    @Deployment
    @Test
    public void testVariableListenerByDelegateExpression() {
        this.beans.put("listener", new LogVariableListener());
        this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assert.assertNotNull((Object)taskExecution);
        this.caseService.withCaseExecution(taskExecution.getId()).setVariableLocal("aTaskVariable", (Object)"aTaskValue").execute();
        Assert.assertEquals((long)1L, (long)LogVariableListener.getInvocations().size());
        DelegateVariableInstanceSpec.fromCaseExecution(taskExecution).event("create").name("aTaskVariable").value("aTaskValue").matches(LogVariableListener.getInvocations().get(0));
        LogVariableListener.reset();
    }

    @Deployment
    @Test
    public void testVariableListenerByExpression() {
        SimpleBean simpleBean = new SimpleBean();
        this.beans.put("bean", simpleBean);
        this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assert.assertNotNull((Object)taskExecution);
        this.caseService.withCaseExecution(taskExecution.getId()).setVariableLocal("aTaskVariable", (Object)"aTaskValue").execute();
        Assert.assertTrue((boolean)simpleBean.wasInvoked());
    }

    @Deployment
    @Test
    public void testVariableListenerByScript() {
        this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assert.assertNotNull((Object)taskExecution);
        this.caseService.withCaseExecution(taskExecution.getId()).setVariableLocal("aTaskVariable", (Object)"aTaskValue").execute();
        Assert.assertTrue((boolean)SimpleBean.wasStaticallyInvoked());
        SimpleBean.reset();
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/listener/VariableListenerTest.testListenerOnParentScope.cmmn"})
    @Test
    public void testListenerSourceExecution() {
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assert.assertNotNull((Object)taskExecution);
        this.caseService.withCaseExecution(taskExecution.getId()).setVariable("aTaskVariable", (Object)"aTaskValue").execute();
        Assert.assertEquals((long)1L, (long)LogVariableListener.getInvocations().size());
        DelegateVariableInstanceSpec.fromCaseExecution((CaseExecution)caseInstance).sourceExecution(taskExecution).event("create").name("aTaskVariable").value("aTaskValue").matches(LogVariableListener.getInvocations().get(0));
        LogVariableListener.reset();
    }

    @Deployment
    @Test
    public void testListenerOnParentScope() {
        this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assert.assertNotNull((Object)taskExecution);
        this.caseService.withCaseExecution(taskExecution.getId()).setVariableLocal("aTaskVariable", (Object)"aTaskValue").execute();
        Assert.assertEquals((long)1L, (long)LogVariableListener.getInvocations().size());
        DelegateVariableInstanceSpec.fromCaseExecution(taskExecution).event("create").name("aTaskVariable").value("aTaskValue").matches(LogVariableListener.getInvocations().get(0));
        LogVariableListener.reset();
    }

    @Deployment
    @Test
    public void testChildListenersNotInvoked() {
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey("case").create();
        this.caseService.withCaseExecution(caseInstance.getId()).setVariableLocal("aTaskVariable", (Object)"aTaskValue").execute();
        Assert.assertEquals((long)0L, (long)LogVariableListener.getInvocations().size());
        LogVariableListener.reset();
    }

    @Deployment
    @Test
    public void testListenerOnAncestorScope() {
        this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution stageExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult();
        Assert.assertNotNull((Object)stageExecution);
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assert.assertNotNull((Object)taskExecution);
        this.caseService.withCaseExecution(taskExecution.getId()).setVariableLocal("aTaskVariable", (Object)"aTaskValue").execute();
        Assert.assertEquals((long)1L, (long)LogVariableListener.getInvocations().size());
        DelegateVariableInstanceSpec.fromCaseExecution(taskExecution).event("create").name("aTaskVariable").value("aTaskValue").matches(LogVariableListener.getInvocations().get(0));
        LogVariableListener.reset();
    }

    @Deployment
    @Test
    public void testInvalidListenerClassName() {
        this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assert.assertNotNull((Object)taskExecution);
        try {
            this.caseService.withCaseExecution(taskExecution.getId()).setVariableLocal("aTaskVariable", (Object)"aTaskValue").execute();
            Assert.fail((String)"expected exception during variable listener invocation");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment
    @Test
    public void testListenerDoesNotImplementInterface() {
        this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assert.assertNotNull((Object)taskExecution);
        try {
            this.caseService.withCaseExecution(taskExecution.getId()).setVariableLocal("aTaskVariable", (Object)"aTaskValue").execute();
            Assert.fail((String)"expected exception during variable listener invocation");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment
    @Test
    public void testDelegateInstanceIsProcessEngineAware() {
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey("case").create();
        Assert.assertFalse((boolean)ProcessEngineAwareListener.hasFoundValidRuntimeService());
        this.caseService.withCaseExecution(caseInstance.getId()).setVariableLocal("aTaskVariable", (Object)"aTaskValue").execute();
        Assert.assertTrue((boolean)ProcessEngineAwareListener.hasFoundValidRuntimeService());
        ProcessEngineAwareListener.reset();
    }

    @Deployment
    @Ignore
    @Test
    public void testListenerDoesNotInterfereWithHistory() {
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey("case").create();
        this.caseService.withCaseExecution(caseInstance.getId()).setVariableLocal("variable", (Object)"value1").execute();
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= HistoryLevel.HISTORY_LEVEL_FULL.getId()) {
            List variableUpdates = this.historyService.createHistoricDetailQuery().variableUpdates().list();
            Assert.assertEquals((long)2L, (long)variableUpdates.size());
            for (HistoricDetail detail : variableUpdates) {
                HistoricVariableUpdate update = (HistoricVariableUpdate)detail;
                boolean update1Processed = false;
                boolean update2Processed = false;
                if (!update1Processed && update.getValue().equals("value1")) {
                    update1Processed = true;
                    continue;
                }
                if (!update2Processed && update.getValue().equals("value2")) {
                    update2Processed = true;
                    continue;
                }
                Assert.fail((String)"unexpected variable update");
            }
        }
    }

    @Deployment
    @Test
    public void testListenerInvocationFinishesBeforeSubsequentInvocations() {
        this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assert.assertNotNull((Object)taskExecution);
        this.caseService.withCaseExecution(taskExecution.getId()).setVariableLocal("variable", (Object)"value1").execute();
        List<DelegateCaseVariableInstance> invocations = LogAndUpdateVariableListener.getInvocations();
        Assert.assertEquals((long)6L, (long)invocations.size());
        DelegateVariableInstanceSpec.fromCaseExecution(taskExecution).event("create").name("variable").value("value1").matches(LogAndUpdateVariableListener.getInvocations().get(0));
        DelegateVariableInstanceSpec.fromCaseExecution(taskExecution).event("create").name("variable").value("value1").matches(LogAndUpdateVariableListener.getInvocations().get(1));
        for (int i = 2; i < 6; ++i) {
            DelegateVariableInstanceSpec.fromCaseExecution(taskExecution).event("update").name("variable").value("value2").matches(LogAndUpdateVariableListener.getInvocations().get(i));
        }
        LogAndUpdateVariableListener.reset();
    }

    @Deployment
    @Test
    public void testTwoListenersOnSameScope() {
        this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assert.assertNotNull((Object)taskExecution);
        this.caseService.withCaseExecution(taskExecution.getId()).setVariableLocal("testVariable", (Object)"value1").execute();
        Assert.assertEquals((long)1L, (long)LogVariableListener.getInvocations().size());
        DelegateVariableInstanceSpec.fromCaseExecution(taskExecution).event("create").name("testVariable").value("value1").matches(LogVariableListener.getInvocations().get(0));
        Assert.assertEquals((long)1L, (long)LogAndUpdateVariableListener.getInvocations().size());
        DelegateVariableInstanceSpec.fromCaseExecution(taskExecution).event("create").name("testVariable").value("value1").matches(LogAndUpdateVariableListener.getInvocations().get(0));
        LogVariableListener.reset();
        LogAndUpdateVariableListener.reset();
    }

    @Deployment
    @Test
    public void testVariableListenerByClassWithFieldExpressions() {
        this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assert.assertNotNull((Object)taskExecution);
        this.caseService.withCaseExecution(taskExecution.getId()).setVariableLocal("testVariable", (Object)"value1").execute();
        Assert.assertEquals((long)1L, (long)LogInjectedValuesListener.getResolvedStringValueExpressions().size());
        Assert.assertEquals((Object)"injectedValue", (Object)LogInjectedValuesListener.getResolvedStringValueExpressions().get(0));
        Assert.assertEquals((long)1L, (long)LogInjectedValuesListener.getResolvedJuelExpressions().size());
        Assert.assertEquals((Object)"cam", (Object)LogInjectedValuesListener.getResolvedJuelExpressions().get(0));
        LogInjectedValuesListener.reset();
    }

    @Deployment
    @Test
    public void testVariableListenerByDelegateExpressionWithFieldExpressions() {
        this.beans.put("listener", new LogInjectedValuesListener());
        this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assert.assertNotNull((Object)taskExecution);
        this.caseService.withCaseExecution(taskExecution.getId()).setVariableLocal("testVariable", (Object)"value1").execute();
        Assert.assertEquals((long)1L, (long)LogInjectedValuesListener.getResolvedStringValueExpressions().size());
        Assert.assertEquals((Object)"injectedValue", (Object)LogInjectedValuesListener.getResolvedStringValueExpressions().get(0));
        Assert.assertEquals((long)1L, (long)LogInjectedValuesListener.getResolvedJuelExpressions().size());
        Assert.assertEquals((Object)"cam", (Object)LogInjectedValuesListener.getResolvedJuelExpressions().get(0));
        LogInjectedValuesListener.reset();
    }

    @Deployment
    @Test
    public void testVariableListenerExecutionContext() {
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assert.assertNotNull((Object)taskExecution);
        this.caseService.withCaseExecution(taskExecution.getId()).setVariableLocal("testVariable", (Object)"value1").execute();
        Assert.assertEquals((long)1L, (long)LogExecutionContextListener.getCaseExecutionContexts().size());
        CaseExecutionContext executionContext = LogExecutionContextListener.getCaseExecutionContexts().get(0);
        Assert.assertNotNull((Object)executionContext);
        Assert.assertEquals((Object)caseInstance.getId(), (Object)executionContext.getCaseInstance().getId());
        Assert.assertEquals((Object)taskExecution.getId(), (Object)((CaseExecutionEntity)executionContext.getExecution()).getId());
        LogExecutionContextListener.reset();
    }

    @Deployment
    @Test
    public void testInvokeBuiltinListenersOnly() {
        this.processEngineConfiguration.setInvokeCustomVariableListeners(false);
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
        this.processEngineConfiguration.getDeploymentCache().getCaseDefinitionById(caseDefinition.getId()).findActivity("PI_HumanTask_1").addBuiltInVariableListener("create", (VariableListener)new LogVariableListener());
        this.caseService.withCaseDefinitionByKey("case").create();
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assert.assertNotNull((Object)taskExecution);
        this.caseService.withCaseExecution(taskExecution.getId()).setVariableLocal("testVariable", (Object)"value1").execute();
        Assert.assertEquals((long)1L, (long)LogVariableListener.getInvocations().size());
        Assert.assertEquals((long)0L, (long)LogExecutionContextListener.getCaseExecutionContexts().size());
        LogVariableListener.reset();
        LogExecutionContextListener.reset();
        this.processEngineConfiguration.setInvokeCustomVariableListeners(true);
    }

    @Test
    public void testDefaultCustomListenerInvocationSetting() {
        Assert.assertTrue((boolean)this.processEngineConfiguration.isInvokeCustomVariableListeners());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/listener/VariableListenerTest.testVariableListenerWithProcessTask.cmmn", "org/eximeebpms/bpm/engine/test/cmmn/listener/VariableListenerTest.testVariableListenerWithProcessTask.bpmn20.xml"})
    @Test
    public void testVariableListenerWithProcessTask() {
        CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("case");
        CaseExecution processTask = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_ProcessTask_1").singleResult();
        String processTaskId = processTask.getId();
        this.caseService.withCaseExecution(processTaskId).manualStart();
        Assert.assertEquals((long)1L, (long)LogVariableListener.getInvocations().size());
        DelegateVariableInstanceSpec.fromCaseExecution((CaseExecution)caseInstance).sourceExecution(processTask).event("create").name("aVariable").value("aValue").matches(LogVariableListener.getInvocations().get(0));
        LogVariableListener.reset();
    }

    @After
    public void tearDown() throws Exception {
        this.beans.clear();
    }
}

