/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.cmmn.sentry;

import org.eximeebpms.bpm.engine.runtime.CaseExecution;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.cmmn.CmmnTest;
import org.junit.Assert;
import org.junit.Test;

public class SentryVariableOnPartExitCriteriaTest
extends CmmnTest {
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/sentry/SentryVariableOnPartExitCriteriaTest.testExitTaskWithVariableOnPart.cmmn"})
    @Test
    public void testExitTaskWithVariableOnPartSatisfied() {
        this.createCaseInstance();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        Assert.assertTrue((boolean)firstHumanTask.isActive());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        Assert.assertTrue((boolean)secondHumanTask.isActive());
        this.caseService.withCaseExecution(firstHumanTaskId).setVariable("variable_1", (Object)100).complete();
        firstHumanTask = this.queryCaseExecutionById(firstHumanTaskId);
        Assert.assertNull((Object)firstHumanTask);
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        Assert.assertNull((Object)secondHumanTask);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/sentry/SentryVariableOnPartExitCriteriaTest.testExitTaskWithVariableOnPart.cmmn"})
    @Test
    public void testExitTaskWithVariableOnPartNotSatisfied() {
        this.createCaseInstance();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        Assert.assertTrue((boolean)firstHumanTask.isActive());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        Assert.assertTrue((boolean)secondHumanTask.isActive());
        this.caseService.withCaseExecution(firstHumanTaskId).setVariable("variable", (Object)100).complete();
        firstHumanTask = this.queryCaseExecutionById(firstHumanTaskId);
        Assert.assertNull((Object)firstHumanTask);
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        Assert.assertTrue((boolean)secondHumanTask.isActive());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/sentry/SentryVariableOnPartExitCriteriaTest.testExitTaskWithMultipleOnPart.cmmn"})
    @Test
    public void testExitTaskWithMultipleOnPartSatisfied() {
        this.createCaseInstance();
        CaseExecution humanTask1 = this.queryCaseExecutionByActivityId("HumanTask_1");
        Assert.assertTrue((boolean)humanTask1.isActive());
        CaseExecution humanTask2 = this.queryCaseExecutionByActivityId("HumanTask_2");
        Assert.assertTrue((boolean)humanTask2.isActive());
        this.complete(humanTask1.getId());
        CaseExecution stageExecution = this.queryCaseExecutionByActivityId("Stage_1");
        Assert.assertNotNull((Object)stageExecution);
        this.caseService.setVariable(stageExecution.getId(), "value", (Object)99);
        stageExecution = this.queryCaseExecutionByActivityId("Stage_1");
        Assert.assertNotNull((Object)stageExecution);
        this.caseService.setVariable(stageExecution.getId(), "value", (Object)101);
        stageExecution = this.queryCaseExecutionByActivityId("Stage_1");
        Assert.assertNull((Object)stageExecution);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/cmmn/sentry/SentryVariableOnPartExitCriteriaTest.testExitTasksOfDifferentScopes.cmmn"})
    @Test
    public void testExitMultipleTasksOfDifferentScopes() {
        this.createCaseInstance();
        CaseExecution stageExecution1 = this.queryCaseExecutionByActivityId("Stage_1");
        this.caseService.setVariable(stageExecution1.getId(), "value", (Object)101);
        stageExecution1 = this.queryCaseExecutionByActivityId("Stage_1");
        Assert.assertNull((Object)stageExecution1);
        CaseExecution stageExecution2 = this.queryCaseExecutionByActivityId("Stage_2");
        Assert.assertNull((Object)stageExecution2);
    }
}

