/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.concurrency;

import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.OptimisticLockingException;
import org.eximeebpms.bpm.engine.externaltask.ExternalTask;
import org.eximeebpms.bpm.engine.impl.cmd.LockExternalTaskCmd;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExternalTaskEntity;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.eximeebpms.bpm.engine.test.concurrency.ConcurrencyTestHelper;
import org.junit.Test;

public class CompetingExternalTaskLockingTest
extends ConcurrencyTestCase {
    protected static final String WORKER_ID_1 = "WORKER_1";
    protected static final String WORKER_ID_2 = "WORKER_2";
    protected static final long LOCK_DURATION = 10000L;

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void shouldThrowOleOnConcurrentLockingAttempt() throws InterruptedException {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        String externalTaskId = ((ExternalTask)this.externalTaskService.createExternalTaskQuery().notLocked().singleResult()).getId();
        ConcurrencyTestHelper.ThreadControl lockThread1 = this.executeControllableCommand(new ControllableExternalTaskLockCmd(externalTaskId, WORKER_ID_1, 10000L));
        lockThread1.reportInterrupts();
        lockThread1.waitForSync();
        ConcurrencyTestHelper.ThreadControl lockThread2 = this.executeControllableCommand(new ControllableExternalTaskLockCmd(externalTaskId, WORKER_ID_2, 10000L));
        lockThread2.reportInterrupts();
        lockThread2.waitForSync();
        lockThread1.makeContinue();
        lockThread1.waitForSync();
        lockThread2.makeContinue();
        Thread.sleep(2000L);
        lockThread1.waitUntilDone();
        lockThread2.waitForSync();
        lockThread2.waitUntilDone();
        ExternalTask lockedExternalTask = (ExternalTask)this.externalTaskService.createExternalTaskQuery().locked().singleResult();
        Assertions.assertThat((Throwable)lockThread1.getException()).isNull();
        Assertions.assertThat((Throwable)lockThread2.getException()).isNotNull();
        Assertions.assertThat((Throwable)lockThread2.getException()).isInstanceOf(OptimisticLockingException.class);
        Assertions.assertThat((String)lockedExternalTask.getWorkerId()).isEqualToIgnoringCase((CharSequence)WORKER_ID_1);
    }

    private static class ControllableExternalTaskLockCmd
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        protected LockExternalTaskCmd lockExternalTaskCmd;

        public ControllableExternalTaskLockCmd(String externalTaskId, String workerId, long lockDuration) {
            this.lockExternalTaskCmd = new ControllableLockExternalTaskCmd(externalTaskId, workerId, lockDuration, this.monitor);
        }

        public Void execute(CommandContext commandContext) {
            this.lockExternalTaskCmd.execute(commandContext);
            this.monitor.sync();
            return null;
        }
    }

    private static class ControllableLockExternalTaskCmd
    extends LockExternalTaskCmd {
        protected final ConcurrencyTestHelper.ThreadControl monitor;

        public ControllableLockExternalTaskCmd(String externalTaskId, String workerId, long lockDuration, ConcurrencyTestHelper.ThreadControl threadControl) {
            super(externalTaskId, workerId, lockDuration);
            this.monitor = threadControl;
        }

        protected boolean validateWorkerViolation(ExternalTaskEntity externalTask) {
            boolean result = super.validateWorkerViolation(externalTask);
            this.monitor.sync();
            return result;
        }
    }
}

