/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.concurrency;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.OptimisticLockingException;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.delegate.DelegateExecution;
import org.eximeebpms.bpm.engine.delegate.ExecutionListener;
import org.eximeebpms.bpm.engine.delegate.JavaDelegate;
import org.eximeebpms.bpm.engine.history.HistoricJobLog;
import org.eximeebpms.bpm.engine.impl.MessageCorrelationBuilderImpl;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.cmd.CompleteTaskCmd;
import org.eximeebpms.bpm.engine.impl.cmd.MessageEventReceivedCmd;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.test.RequiredDatabase;
import org.eximeebpms.bpm.engine.runtime.Execution;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.eximeebpms.bpm.engine.test.concurrency.ConcurrencyTestHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class CompetingMessageCorrelationTest
extends ConcurrencyTestCase {
    @After
    public void tearDown() throws Exception {
        ((ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration()).getCommandExecutorTxRequiresNew().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                List jobLogs = CompetingMessageCorrelationTest.this.processEngine.getHistoryService().createHistoricJobLogQuery().list();
                for (HistoricJobLog jobLog : jobLogs) {
                    commandContext.getHistoricJobLogManager().deleteHistoricJobLogById(jobLog.getId());
                }
                return null;
            }
        });
        Assert.assertEquals((long)0L, (long)this.processEngine.getHistoryService().createHistoricJobLogQuery().list().size());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/concurrency/CompetingMessageCorrelationTest.catchMessageProcess.bpmn20.xml"})
    @Test
    @RequiredDatabase(excludes={"h2"})
    public void testConcurrentExclusiveCorrelation() throws InterruptedException {
        InvocationLogListener.reset();
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ConcurrencyTestHelper.ThreadControl thread1 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", true));
        thread1.reportInterrupts();
        ConcurrencyTestHelper.ThreadControl thread2 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", true));
        thread2.reportInterrupts();
        thread1.waitForSync();
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitForSync();
        Assert.assertEquals((long)1L, (long)InvocationLogListener.getInvocations());
        thread2.makeContinue();
        Thread.sleep(2000L);
        thread1.makeContinue();
        Assert.assertNull((Object)thread1.getException());
        thread2.waitForSync();
        Assert.assertTrue((thread2.getException() != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(thread2.getException() instanceof ProcessEngineException));
        Assertions.assertThat((String)thread2.getException().getMessage()).contains(new CharSequence[]{"does not have a subscription to a message event with name 'Message'"});
        thread1.join();
        Assert.assertNull((Object)thread1.getException());
        Task afterMessageTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)afterMessageTask.getTaskDefinitionKey(), (Object)"afterMessageUserTask");
        Assert.assertEquals((long)1L, (long)InvocationLogListener.getInvocations());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/concurrency/CompetingMessageCorrelationTest.catchMessageProcess.bpmn20.xml"})
    @Test
    public void testConcurrentCorrelationFailsWithOptimisticLockingException() {
        InvocationLogListener.reset();
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ConcurrencyTestHelper.ThreadControl thread1 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", false));
        thread1.reportInterrupts();
        ConcurrencyTestHelper.ThreadControl thread2 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", false));
        thread2.reportInterrupts();
        thread1.waitForSync();
        thread2.waitForSync();
        thread1.makeContinue();
        thread2.makeContinue();
        thread1.waitForSync();
        thread2.waitForSync();
        Assert.assertEquals((long)2L, (long)InvocationLogListener.getInvocations());
        thread1.waitUntilDone();
        Assert.assertNull((Object)thread1.getException());
        Task afterMessageTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)afterMessageTask.getTaskDefinitionKey(), (Object)"afterMessageUserTask");
        thread2.waitUntilDone();
        Assert.assertTrue((thread2.getException() != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(thread2.getException() instanceof OptimisticLockingException));
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/concurrency/CompetingMessageCorrelationTest.catchMessageProcess.bpmn20.xml"})
    @Test
    public void testConcurrentExclusiveCorrelationToDifferentExecutions() throws InterruptedException {
        InvocationLogListener.reset();
        ProcessInstance instance1 = this.runtimeService.startProcessInstanceByKey("testProcess");
        ProcessInstance instance2 = this.runtimeService.startProcessInstanceByKey("testProcess");
        ConcurrencyTestHelper.ThreadControl thread1 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", instance1.getId(), true));
        thread1.reportInterrupts();
        ConcurrencyTestHelper.ThreadControl thread2 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", instance2.getId(), true));
        thread2.reportInterrupts();
        thread1.waitForSync();
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitForSync();
        Assert.assertEquals((long)1L, (long)InvocationLogListener.getInvocations());
        thread2.makeContinue();
        thread1.waitUntilDone();
        Assert.assertNull((Object)thread1.getException());
        thread2.waitForSync();
        Assert.assertEquals((long)2L, (long)InvocationLogListener.getInvocations());
        thread2.waitUntilDone();
        Assert.assertNull((Object)thread2.getException());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().taskDefinitionKey("afterMessageUserTask").count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/concurrency/CompetingMessageCorrelationTest.catchMessageProcess.bpmn20.xml"})
    @Ignore
    @Test
    public void testConcurrentExclusiveCorrelationToDifferentExecutionsCase2() throws InterruptedException {
        InvocationLogListener.reset();
        ProcessInstance instance1 = this.runtimeService.startProcessInstanceByKey("testProcess");
        ProcessInstance instance2 = this.runtimeService.startProcessInstanceByKey("testProcess");
        ConcurrencyTestHelper.ThreadControl thread1 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", instance1.getId(), true));
        thread1.reportInterrupts();
        ConcurrencyTestHelper.ThreadControl thread2 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", instance2.getId(), true));
        thread2.reportInterrupts();
        thread1.waitForSync();
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitForSync();
        Assert.assertEquals((long)1L, (long)InvocationLogListener.getInvocations());
        thread2.makeContinue();
        thread2.waitForSync();
        Assert.assertEquals((long)2L, (long)InvocationLogListener.getInvocations());
        thread2.waitUntilDone();
        Assert.assertNull((Object)thread2.getException());
        thread1.waitUntilDone();
        Assert.assertNull((Object)thread1.getException());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().taskDefinitionKey("afterMessageUserTask").count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/concurrency/CompetingMessageCorrelationTest.catchMessageProcess.bpmn20.xml"})
    @Test
    public void testConcurrentMixedCorrelation() {
        InvocationLogListener.reset();
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ConcurrencyTestHelper.ThreadControl thread1 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", true));
        thread1.reportInterrupts();
        ConcurrencyTestHelper.ThreadControl thread2 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", false));
        thread2.reportInterrupts();
        thread1.waitForSync();
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitForSync();
        thread2.makeContinue();
        thread2.waitForSync();
        Assert.assertEquals((long)2L, (long)InvocationLogListener.getInvocations());
        thread1.waitUntilDone();
        Assert.assertNull((Object)thread1.getException());
        Task afterMessageTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)afterMessageTask.getTaskDefinitionKey(), (Object)"afterMessageUserTask");
        thread2.makeContinue();
        thread2.waitForSync();
        Assert.assertTrue((thread2.getException() != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(thread2.getException() instanceof OptimisticLockingException));
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/concurrency/CompetingMessageCorrelationTest.catchMessageProcess.bpmn20.xml"})
    @Ignore(value="CAM-3636")
    @Test
    public void testConcurrentMixedCorrelationCase2() throws InterruptedException {
        InvocationLogListener.reset();
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ConcurrencyTestHelper.ThreadControl thread1 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", false));
        thread1.reportInterrupts();
        ConcurrencyTestHelper.ThreadControl thread2 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", true));
        thread2.reportInterrupts();
        thread1.waitForSync();
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitForSync();
        thread2.makeContinue();
        thread2.waitForSync();
        Assert.assertEquals((long)2L, (long)InvocationLogListener.getInvocations());
        thread1.makeContinue();
        Thread.sleep(5000L);
        Assert.assertNull((Object)thread1.getException());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().count());
        thread2.waitUntilDone();
        Assert.assertNull((Object)thread2.getException());
        Task afterMessageTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)afterMessageTask);
        Assert.assertEquals((Object)afterMessageTask.getTaskDefinitionKey(), (Object)"afterMessageUserTask");
        thread1.join();
        Assert.assertTrue((thread1.getException() != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(thread1.getException() instanceof OptimisticLockingException));
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/concurrency/CompetingMessageCorrelationTest.eventSubprocess.bpmn"})
    @Test
    public void testEventSubprocess() {
        InvocationLogListener.reset();
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ConcurrencyTestHelper.ThreadControl thread1 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("incoming", false));
        thread1.reportInterrupts();
        ConcurrencyTestHelper.ThreadControl thread2 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("incoming", false));
        thread2.reportInterrupts();
        thread1.waitForSync();
        thread2.waitForSync();
        thread1.makeContinue();
        thread2.makeContinue();
        thread1.waitForSync();
        thread2.waitForSync();
        thread1.waitUntilDone();
        Assert.assertNull((Object)thread1.getException());
        thread2.waitUntilDone();
        Assert.assertTrue((thread2.getException() != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(thread2.getException() instanceof OptimisticLockingException));
    }

    @Deployment
    @Test
    public void testConcurrentMessageCorrelationAndTreeCompaction() {
        this.runtimeService.startProcessInstanceByKey("process");
        ConcurrencyTestHelper.ThreadControl correlateThread = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", false));
        correlateThread.reportInterrupts();
        correlateThread.waitForSync();
        correlateThread.makeContinueAndWaitForSync();
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        correlateThread.waitUntilDone();
        Throwable exception = correlateThread.getException();
        Assert.assertNotNull((Object)exception);
        Assert.assertTrue((boolean)(exception instanceof OptimisticLockingException));
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/concurrency/CompetingMessageCorrelationTest.testConcurrentMessageCorrelationAndTreeCompaction.bpmn20.xml"})
    @Test
    public void testConcurrentTreeCompactionAndMessageCorrelation() {
        this.runtimeService.startProcessInstanceByKey("process");
        List tasks = this.taskService.createTaskQuery().list();
        ConcurrencyTestHelper.ThreadControl taskCompletionThread = this.executeControllableCommand(new ControllableCompleteTaskCommand(tasks));
        taskCompletionThread.reportInterrupts();
        taskCompletionThread.waitForSync();
        this.runtimeService.correlateMessage("Message");
        taskCompletionThread.waitUntilDone();
        Throwable exception = taskCompletionThread.getException();
        Assert.assertNotNull((Object)exception);
        Assert.assertTrue((boolean)(exception instanceof OptimisticLockingException));
    }

    @Deployment
    @Test
    public void testConcurrentMessageCorrelationTwiceAndTreeCompaction() {
        this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.correlateMessage("Message2");
        ConcurrencyTestHelper.ThreadControl correlateThread = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message1", false));
        correlateThread.reportInterrupts();
        correlateThread.waitForSync();
        correlateThread.makeContinueAndWaitForSync();
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        correlateThread.waitUntilDone();
        Throwable exception = correlateThread.getException();
        Assert.assertNotNull((Object)exception);
        Assert.assertTrue((boolean)(exception instanceof OptimisticLockingException));
    }

    @Deployment
    @Test
    public void testConcurrentEndExecutionListener() {
        InvocationLogListener.reset();
        this.runtimeService.startProcessInstanceByKey("testProcess");
        List tasks = this.runtimeService.createExecutionQuery().messageEventSubscriptionName("Message").list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        ConcurrencyTestHelper.ThreadControl thread1 = this.executeControllableCommand(new ControllableMessageEventReceivedCommand(((Execution)tasks.get(0)).getId(), "Message", true));
        thread1.reportInterrupts();
        thread1.waitForSync();
        Assert.assertEquals((long)1L, (long)InvocationLogListener.getInvocations());
        ConcurrencyTestHelper.ThreadControl thread2 = this.executeControllableCommand(new ControllableMessageEventReceivedCommand(((Execution)tasks.get(1)).getId(), "Message", false));
        thread2.waitForSync();
        thread2.waitUntilDone();
        Assert.assertEquals((long)2L, (long)InvocationLogListener.getInvocations());
        thread1.makeContinueAndWaitForSync();
        Assert.assertEquals((long)2L, (long)InvocationLogListener.getInvocations());
        thread1.waitUntilDone();
        Throwable exception = thread1.getException();
        Assert.assertNotNull((Object)exception);
        Assert.assertTrue((boolean)(exception instanceof OptimisticLockingException));
        Assert.assertEquals((long)2L, (long)InvocationLogListener.getInvocations());
    }

    public static class InvocationLogListener
    implements JavaDelegate {
        protected static AtomicInteger invocations = new AtomicInteger(0);

        public void execute(DelegateExecution execution) throws Exception {
            invocations.incrementAndGet();
        }

        public static void reset() {
            invocations.set(0);
        }

        public static int getInvocations() {
            return invocations.get();
        }
    }

    protected static class ControllableMessageCorrelationCommand
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        protected String messageName;
        protected boolean exclusive;
        protected String processInstanceId;

        public ControllableMessageCorrelationCommand(String messageName, boolean exclusive) {
            this.messageName = messageName;
            this.exclusive = exclusive;
        }

        public ControllableMessageCorrelationCommand(String messageName, String processInstanceId, boolean exclusive) {
            this(messageName, exclusive);
            this.processInstanceId = processInstanceId;
        }

        public Void execute(CommandContext commandContext) {
            this.monitor.sync();
            MessageCorrelationBuilderImpl correlationBuilder = new MessageCorrelationBuilderImpl(commandContext, this.messageName);
            if (this.processInstanceId != null) {
                correlationBuilder.processInstanceId(this.processInstanceId);
            }
            if (this.exclusive) {
                correlationBuilder.correlateExclusively();
            } else {
                correlationBuilder.correlate();
            }
            this.monitor.sync();
            return null;
        }
    }

    public static class ControllableCompleteTaskCommand
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        protected List<Task> tasks;

        public ControllableCompleteTaskCommand(List<Task> tasks) {
            this.tasks = tasks;
        }

        public Void execute(CommandContext commandContext) {
            for (Task task : this.tasks) {
                CompleteTaskCmd completeTaskCmd = new CompleteTaskCmd(task.getId(), null);
                completeTaskCmd.execute(commandContext);
            }
            this.monitor.sync();
            return null;
        }
    }

    protected static class ControllableMessageEventReceivedCommand
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        protected final String executionId;
        protected final String messageName;
        protected final boolean shouldWaitInListener;

        public ControllableMessageEventReceivedCommand(String executionId, String messageName, boolean shouldWaitInListener) {
            this.executionId = executionId;
            this.messageName = messageName;
            this.shouldWaitInListener = shouldWaitInListener;
        }

        public Void execute(CommandContext commandContext) {
            if (this.shouldWaitInListener) {
                WaitingListener.setMonitor(this.monitor);
            }
            MessageEventReceivedCmd receivedCmd = new MessageEventReceivedCmd(this.messageName, this.executionId, null);
            receivedCmd.execute(commandContext);
            this.monitor.sync();
            return null;
        }
    }

    public static class WaitingListener
    implements ExecutionListener {
        protected static ConcurrencyTestHelper.ThreadControl monitor;

        public void notify(DelegateExecution execution) throws Exception {
            if (monitor != null) {
                ConcurrencyTestHelper.ThreadControl localMonitor = monitor;
                monitor = null;
                localMonitor.sync();
            }
        }

        public static void setMonitor(ConcurrencyTestHelper.ThreadControl monitor) {
            WaitingListener.monitor = monitor;
        }
    }
}

