/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.concurrency;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.impl.cmd.DeployCmd;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.repository.DeploymentBuilderImpl;
import org.eximeebpms.bpm.engine.impl.test.RequiredDatabase;
import org.eximeebpms.bpm.engine.repository.Deployment;
import org.eximeebpms.bpm.engine.repository.DeploymentBuilder;
import org.eximeebpms.bpm.engine.repository.DeploymentQuery;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.repository.ProcessDefinitionQuery;
import org.eximeebpms.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.eximeebpms.bpm.engine.test.concurrency.ConcurrencyTestHelper;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.junit.After;
import org.junit.Test;

@RequiredDatabase(excludes={"h2"})
public class ConcurrentDeploymentTest
extends ConcurrencyTestCase {
    private static String processResource;
    protected ConcurrencyTestHelper.ThreadControl thread1;
    protected ConcurrencyTestHelper.ThreadControl thread2;

    @Test
    public void testDuplicateFiltering() throws InterruptedException {
        this.deployOnTwoConcurrentThreads(this.createDeploymentBuilder().enableDuplicateFiltering(false), this.createDeploymentBuilder().enableDuplicateFiltering(false));
        Assertions.assertThat((Throwable)this.thread1.getException()).isNull();
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery();
        Assertions.assertThat((long)deploymentQuery.count()).isEqualTo(1L);
    }

    @Test
    public void testVersioning() throws InterruptedException {
        this.deployOnTwoConcurrentThreads(this.createDeploymentBuilder(), this.createDeploymentBuilder());
        List processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().asc()).list();
        Assertions.assertThat((int)processDefinitions.size()).isEqualTo(2);
        Assertions.assertThat((int)((ProcessDefinition)processDefinitions.get(0)).getVersion()).isEqualTo(1);
        Assertions.assertThat((int)((ProcessDefinition)processDefinitions.get(1)).getVersion()).isEqualTo(2);
    }

    protected DeploymentBuilder createDeploymentBuilder() {
        return new DeploymentBuilderImpl(null).name("some-deployment-name").addString("foo.bpmn", processResource);
    }

    protected void deployOnTwoConcurrentThreads(DeploymentBuilder deploymentOne, DeploymentBuilder deploymentTwo) throws InterruptedException {
        Assertions.assertThat((Object)deploymentOne).as("you can not use the same deployment builder for both deployments", new Object[0]).isNotEqualTo((Object)deploymentTwo);
        this.thread1 = this.executeControllableCommand(new ControllableDeployCommand(deploymentOne));
        this.thread1.reportInterrupts();
        this.thread1.waitForSync();
        this.thread2 = this.executeControllableCommand(new ControllableDeployCommand(deploymentTwo));
        this.thread2.reportInterrupts();
        this.thread2.waitForSync();
        this.thread1.makeContinue();
        this.thread1.waitForSync();
        this.thread2.makeContinue();
        Thread.sleep(2000L);
        this.thread1.waitUntilDone();
        this.thread2.waitForSync();
        this.thread2.waitUntilDone();
    }

    @After
    public void tearDown() throws Exception {
        for (Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
        this.processEngineConfiguration.getDeploymentCache().purgeCache();
    }

    static {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess().startEvent().done();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Bpmn.writeModelToStream((OutputStream)outputStream, (BpmnModelInstance)modelInstance);
        processResource = new String(outputStream.toByteArray());
    }

    protected static class ControllableDeployCommand
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        private final DeploymentBuilder deploymentBuilder;

        public ControllableDeployCommand(DeploymentBuilder deploymentBuilder) {
            this.deploymentBuilder = deploymentBuilder;
        }

        public Void execute(CommandContext commandContext) {
            this.monitor.sync();
            new DeployCmd((DeploymentBuilderImpl)this.deploymentBuilder).execute(commandContext);
            this.monitor.sync();
            return null;
        }
    }
}

