/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.concurrency;

import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.impl.BootstrapEngineCommand;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.JobEntity;
import org.eximeebpms.bpm.engine.test.concurrency.ConcurrencyTestHelper;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class ConcurrentHistoryCleanupReconfigureTest
extends ConcurrencyTestHelper {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> configuration.setHistoryCleanupBatchWindowStartTime("12:00"));
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected HistoryService historyService;

    @Before
    public void initializeProcessEngine() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.historyService = this.engineRule.getHistoryService();
    }

    @After
    public void tearDown() throws Exception {
        this.testRule.deleteHistoryCleanupJobs();
        this.clearDatabase();
    }

    @Test
    public void testReconfigureCleanupJobs() {
        String jobId = this.historyService.cleanUpHistoryAsync(true).getId();
        this.makeEverLivingJobFail(jobId);
        ConcurrencyTestHelper.ThreadControl engineOne = this.executeControllableCommand(new EngineOne());
        engineOne.reportInterrupts();
        ConcurrencyTestHelper.ThreadControl engineTwo = this.executeControllableCommand(new EngineTwo());
        engineTwo.reportInterrupts();
        engineTwo.waitForSync();
        engineOne.makeContinue();
        engineOne.join();
        engineTwo.makeContinue();
        engineTwo.join();
        Assertions.assertThat((Throwable)engineOne.getException()).isNull();
        Assertions.assertThat((Throwable)engineTwo.getException()).isNull();
    }

    protected void clearDatabase() {
        this.testRule.deleteHistoryCleanupJobs();
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute(commandContext -> {
            commandContext.getMeterLogManager().deleteAll();
            commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("history-cleanup");
            return null;
        });
    }

    protected void makeEverLivingJobFail(String jobId) {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute(commandContext -> {
            JobEntity job = commandContext.getJobManager().findJobById(jobId);
            job.setExceptionStacktrace("foo");
            return null;
        });
    }

    public class EngineOne
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        public Void execute(CommandContext commandContext) {
            new BootstrapEngineCommand().execute(commandContext);
            return null;
        }
    }

    public class EngineTwo
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        public Void execute(CommandContext commandContext) {
            ConcurrentHistoryCleanupReconfigureTest.this.historyService.findHistoryCleanupJobs();
            this.monitor.sync();
            new BootstrapEngineCommand().execute(commandContext);
            return null;
        }
    }
}

