/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.concurrency.partitioning;

import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.impl.db.DbEntity;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.AttachmentEntity;
import org.eximeebpms.bpm.engine.task.Attachment;
import org.eximeebpms.bpm.engine.test.concurrency.ConcurrencyTestHelper;
import org.eximeebpms.bpm.engine.test.concurrency.partitioning.AbstractPartitioningTest;
import org.junit.Test;

public class CompetingHistoricAttachmentPartitioningTest
extends AbstractPartitioningTest {
    @Test
    public void shouldSuppressOleOnConcurrentFetchAndDelete() {
        String processInstanceId = this.deployAndStartProcess(this.PROCESS_WITH_USERTASK).getId();
        Attachment attachment = this.taskService.createAttachment("anAttachmentType", null, processInstanceId, "anAttachmentName", null, "http://eximeebpms.com");
        ConcurrencyTestHelper.ThreadControl asyncThread = this.executeControllableCommand(new AsyncThread(attachment.getId()));
        asyncThread.reportInterrupts();
        asyncThread.waitForSync();
        Assertions.assertThat((Object)this.taskService.getAttachment(attachment.getId())).isNotNull();
        this.commandExecutor.execute(commandContext -> {
            commandContext.getAttachmentManager().delete((DbEntity)((AttachmentEntity)attachment));
            return null;
        });
        asyncThread.makeContinue();
        asyncThread.waitUntilDone();
        Assertions.assertThat((Object)this.taskService.getAttachment(attachment.getId())).isNull();
    }

    public class AsyncThread
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        String attachmentId;

        AsyncThread(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        public Void execute(CommandContext commandContext) {
            commandContext.getDbEntityManager().selectById(AttachmentEntity.class, this.attachmentId);
            this.monitor.sync();
            AttachmentEntity changedAttachmentEntity = new AttachmentEntity();
            changedAttachmentEntity.setId(this.attachmentId);
            CompetingHistoricAttachmentPartitioningTest.this.taskService.saveAttachment((Attachment)changedAttachmentEntity);
            return null;
        }
    }
}

