/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.history;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.impl.history.event.HistoryEvent;
import org.eximeebpms.bpm.engine.impl.history.handler.CompositeDbHistoryEventHandler;
import org.eximeebpms.bpm.engine.impl.history.handler.CompositeHistoryEventHandler;
import org.eximeebpms.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DefaultHistoryEventHandlerTest {
    @Parameterized.Parameter
    public boolean isDefaultHandlerEnabled;
    @Rule
    public ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> {
        configuration.setEnableDefaultDbHistoryEventHandler(this.isDefaultHandlerEnabled);
        configuration.setCustomHistoryEventHandlers(Collections.singletonList(new CustomHistoryEventHandler()));
    });
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule(this.bootstrapRule);

    @Parameterized.Parameters
    public static Iterable<Object> parameters() {
        return Arrays.asList(true, false);
    }

    @Test
    public void shouldUseInstanceOfCompositeHistoryEventHandler() {
        boolean useDefaultDbHandler = this.engineRule.getProcessEngineConfiguration().isEnableDefaultDbHistoryEventHandler();
        HistoryEventHandler defaultHandler = this.engineRule.getProcessEngineConfiguration().getHistoryEventHandler();
        Assertions.assertThat((boolean)useDefaultDbHandler).isNotNull();
        if (useDefaultDbHandler) {
            Assertions.assertThat((Object)defaultHandler).isInstanceOf(CompositeDbHistoryEventHandler.class);
        } else {
            Assertions.assertThat((Object)defaultHandler).isInstanceOf(CompositeHistoryEventHandler.class);
        }
    }

    @Test
    public void shouldProvideCustomHistoryEventHandlers() {
        List eventHandlers = this.engineRule.getProcessEngineConfiguration().getCustomHistoryEventHandlers();
        Assertions.assertThat((List)eventHandlers).hasSize(1);
        Assertions.assertThat((Object)((HistoryEventHandler)eventHandlers.get(0))).isInstanceOf(CustomHistoryEventHandler.class);
    }

    public class CustomHistoryEventHandler
    implements HistoryEventHandler {
        public void handleEvent(HistoryEvent historyEvent) {
        }

        public void handleEvents(List<HistoryEvent> historyEvents) {
        }
    }
}

