/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.history;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.eximeebpms.bpm.engine.exception.NullValueException;
import org.eximeebpms.bpm.engine.history.HistoricActivityStatistics;
import org.eximeebpms.bpm.engine.history.HistoricActivityStatisticsQuery;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.Execution;
import org.eximeebpms.bpm.engine.runtime.Incident;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

@RequiredHistoryLevel(value="audit")
public class HistoricActivityStatisticsQueryTest
extends PluggableProcessEngineTest {
    private SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testSingleTask.bpmn20.xml"})
    @Test
    public void testNoRunningProcessInstances() {
        String processDefinitionId = this.getProcessDefinitionId();
        HistoricActivityStatisticsQuery query = this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId);
        List statistics = query.list();
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)statistics.size());
    }

    @Deployment
    @Test
    public void testSingleTask() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(5);
        HistoricActivityStatisticsQuery query = this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId);
        List statistics = query.list();
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((long)1L, (long)statistics.size());
        HistoricActivityStatistics statistic = (HistoricActivityStatistics)statistics.get(0);
        Assert.assertEquals((Object)"task", (Object)statistic.getId());
        Assert.assertEquals((long)5L, (long)statistic.getInstances());
        this.completeProcessInstances();
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testSingleTask.bpmn20.xml"})
    @Test
    public void testFinishedProcessInstances() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(5);
        this.completeProcessInstances();
        HistoricActivityStatisticsQuery query = this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId);
        List statistics = query.list();
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)statistics.size());
    }

    @Deployment
    @Test
    public void testMultipleRunningTasks() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(5);
        HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).orderByActivityId().asc();
        List statistics = query.list();
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertEquals((long)4L, (long)statistics.size());
        HistoricActivityStatistics innerTask = (HistoricActivityStatistics)statistics.get(0);
        Assert.assertEquals((Object)"innerTask", (Object)innerTask.getId());
        Assert.assertEquals((long)25L, (long)innerTask.getInstances());
        HistoricActivityStatistics subProcess = (HistoricActivityStatistics)statistics.get(1);
        Assert.assertEquals((Object)"subprocess", (Object)subProcess.getId());
        Assert.assertEquals((long)25L, (long)subProcess.getInstances());
        HistoricActivityStatistics subProcessMiBody = (HistoricActivityStatistics)statistics.get(2);
        Assert.assertEquals((Object)"subprocess#multiInstanceBody", (Object)subProcessMiBody.getId());
        Assert.assertEquals((long)5L, (long)subProcessMiBody.getInstances());
        HistoricActivityStatistics task = (HistoricActivityStatistics)statistics.get(3);
        Assert.assertEquals((Object)"task", (Object)task.getId());
        Assert.assertEquals((long)5L, (long)task.getInstances());
        this.completeProcessInstances();
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testWithCallActivity.bpmn20.xml", "org/eximeebpms/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.calledProcess.bpmn20.xml"})
    @Test
    public void testMultipleProcessDefinitions() {
        String processId = this.getProcessDefinitionId();
        String calledProcessId = this.getProcessDefinitionIdByKey("calledProcess");
        this.startProcesses(5);
        this.startProcessesByKey(10, "calledProcess");
        HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processId).orderByActivityId().asc();
        List statistics = query.list();
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((long)1L, (long)statistics.size());
        HistoricActivityStatistics calledActivity = (HistoricActivityStatistics)statistics.get(0);
        Assert.assertEquals((Object)"callActivity", (Object)calledActivity.getId());
        Assert.assertEquals((long)5L, (long)calledActivity.getInstances());
        query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(calledProcessId).orderByActivityId().asc();
        statistics = query.list();
        Assert.assertEquals((long)2L, (long)query.count());
        Assert.assertEquals((long)2L, (long)statistics.size());
        HistoricActivityStatistics task1 = (HistoricActivityStatistics)statistics.get(0);
        Assert.assertEquals((Object)"task1", (Object)task1.getId());
        Assert.assertEquals((long)15L, (long)task1.getInstances());
        HistoricActivityStatistics task2 = (HistoricActivityStatistics)statistics.get(1);
        Assert.assertEquals((Object)"task2", (Object)task2.getId());
        Assert.assertEquals((long)15L, (long)task2.getInstances());
        this.completeProcessInstances();
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testSingleTask.bpmn20.xml"})
    @Test
    public void testQueryByFinished() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(5);
        HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeFinished().orderByActivityId().asc();
        List statistics = query.list();
        Assert.assertEquals((long)2L, (long)query.count());
        Assert.assertEquals((long)2L, (long)statistics.size());
        HistoricActivityStatistics start = (HistoricActivityStatistics)statistics.get(0);
        Assert.assertEquals((Object)"start", (Object)start.getId());
        Assert.assertEquals((long)0L, (long)start.getInstances());
        Assert.assertEquals((long)5L, (long)start.getFinished());
        HistoricActivityStatistics task = (HistoricActivityStatistics)statistics.get(1);
        Assert.assertEquals((Object)"task", (Object)task.getId());
        Assert.assertEquals((long)5L, (long)task.getInstances());
        Assert.assertEquals((long)0L, (long)task.getFinished());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testSingleTask.bpmn20.xml"})
    @Test
    public void testQueryByFinishedAfterFinishingSomeInstances() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(5);
        List tasks = this.taskService.createTaskQuery().list();
        for (int i = 0; i < 2; ++i) {
            this.taskService.complete(((Task)tasks.get(i)).getId());
        }
        HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeFinished().orderByActivityId().asc();
        List statistics = query.list();
        Assert.assertEquals((long)3L, (long)query.count());
        Assert.assertEquals((long)3L, (long)statistics.size());
        HistoricActivityStatistics end = (HistoricActivityStatistics)statistics.get(0);
        Assert.assertEquals((Object)"end", (Object)end.getId());
        Assert.assertEquals((long)0L, (long)end.getInstances());
        Assert.assertEquals((long)2L, (long)end.getFinished());
        HistoricActivityStatistics start = (HistoricActivityStatistics)statistics.get(1);
        Assert.assertEquals((Object)"start", (Object)start.getId());
        Assert.assertEquals((long)0L, (long)start.getInstances());
        Assert.assertEquals((long)5L, (long)start.getFinished());
        HistoricActivityStatistics task = (HistoricActivityStatistics)statistics.get(2);
        Assert.assertEquals((Object)"task", (Object)task.getId());
        Assert.assertEquals((long)3L, (long)task.getInstances());
        Assert.assertEquals((long)2L, (long)task.getFinished());
        this.completeProcessInstances();
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testMultipleRunningTasks.bpmn20.xml"})
    @Test
    public void testQueryByFinishedMultipleRunningTasks() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(5);
        List tasks = this.taskService.createTaskQuery().taskDefinitionKey("innerTask").list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeFinished().orderByActivityId().asc();
        List statistics = query.list();
        Assert.assertEquals((long)9L, (long)query.count());
        Assert.assertEquals((long)9L, (long)statistics.size());
        HistoricActivityStatistics end1 = (HistoricActivityStatistics)statistics.get(0);
        Assert.assertEquals((Object)"end1", (Object)end1.getId());
        Assert.assertEquals((long)0L, (long)end1.getInstances());
        Assert.assertEquals((long)5L, (long)end1.getFinished());
        HistoricActivityStatistics gtw = (HistoricActivityStatistics)statistics.get(1);
        Assert.assertEquals((Object)"gtw", (Object)gtw.getId());
        Assert.assertEquals((long)0L, (long)gtw.getInstances());
        Assert.assertEquals((long)5L, (long)gtw.getFinished());
        HistoricActivityStatistics innerEnd = (HistoricActivityStatistics)statistics.get(2);
        Assert.assertEquals((Object)"innerEnd", (Object)innerEnd.getId());
        Assert.assertEquals((long)0L, (long)innerEnd.getInstances());
        Assert.assertEquals((long)25L, (long)innerEnd.getFinished());
        HistoricActivityStatistics innerStart = (HistoricActivityStatistics)statistics.get(3);
        Assert.assertEquals((Object)"innerStart", (Object)innerStart.getId());
        Assert.assertEquals((long)0L, (long)innerStart.getInstances());
        Assert.assertEquals((long)25L, (long)innerStart.getFinished());
        HistoricActivityStatistics innerTask = (HistoricActivityStatistics)statistics.get(4);
        Assert.assertEquals((Object)"innerTask", (Object)innerTask.getId());
        Assert.assertEquals((long)0L, (long)innerTask.getInstances());
        Assert.assertEquals((long)25L, (long)innerTask.getFinished());
        HistoricActivityStatistics start = (HistoricActivityStatistics)statistics.get(5);
        Assert.assertEquals((Object)"start", (Object)start.getId());
        Assert.assertEquals((long)0L, (long)start.getInstances());
        Assert.assertEquals((long)5L, (long)start.getFinished());
        HistoricActivityStatistics subProcess = (HistoricActivityStatistics)statistics.get(6);
        Assert.assertEquals((Object)"subprocess", (Object)subProcess.getId());
        Assert.assertEquals((long)0L, (long)subProcess.getInstances());
        Assert.assertEquals((long)25L, (long)subProcess.getFinished());
        HistoricActivityStatistics subProcessMiBody = (HistoricActivityStatistics)statistics.get(7);
        Assert.assertEquals((Object)"subprocess#multiInstanceBody", (Object)subProcessMiBody.getId());
        Assert.assertEquals((long)0L, (long)subProcessMiBody.getInstances());
        Assert.assertEquals((long)5L, (long)subProcessMiBody.getFinished());
        HistoricActivityStatistics task = (HistoricActivityStatistics)statistics.get(8);
        Assert.assertEquals((Object)"task", (Object)task.getId());
        Assert.assertEquals((long)5L, (long)task.getInstances());
        Assert.assertEquals((long)0L, (long)task.getFinished());
        this.completeProcessInstances();
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testSingleTask.bpmn20.xml"})
    @Test
    public void testQueryByCompleteScope() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(5);
        this.completeProcessInstances();
        HistoricActivityStatisticsQuery query = this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeCompleteScope();
        List statistics = query.list();
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((long)1L, (long)statistics.size());
        HistoricActivityStatistics end = (HistoricActivityStatistics)statistics.get(0);
        Assert.assertEquals((Object)"end", (Object)end.getId());
        Assert.assertEquals((long)0L, (long)end.getInstances());
        Assert.assertEquals((long)5L, (long)end.getCompleteScope());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testSingleTask.bpmn20.xml"})
    @Test
    public void testQueryByCompleteScopeAfterFinishingSomeInstances() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(5);
        List tasks = this.taskService.createTaskQuery().list();
        for (int i = 0; i < 2; ++i) {
            this.taskService.complete(((Task)tasks.get(i)).getId());
        }
        HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeCompleteScope().orderByActivityId().asc();
        List statistics = query.list();
        Assert.assertEquals((long)2L, (long)query.count());
        Assert.assertEquals((long)2L, (long)statistics.size());
        HistoricActivityStatistics end = (HistoricActivityStatistics)statistics.get(0);
        Assert.assertEquals((Object)"end", (Object)end.getId());
        Assert.assertEquals((long)0L, (long)end.getInstances());
        Assert.assertEquals((long)2L, (long)end.getCompleteScope());
        HistoricActivityStatistics task = (HistoricActivityStatistics)statistics.get(1);
        Assert.assertEquals((Object)"task", (Object)task.getId());
        Assert.assertEquals((long)3L, (long)task.getInstances());
        Assert.assertEquals((long)0L, (long)task.getCompleteScope());
        this.completeProcessInstances();
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testMultipleRunningTasks.bpmn20.xml"})
    @Test
    public void testQueryByCompleteScopeMultipleRunningTasks() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(5);
        List tasks = this.taskService.createTaskQuery().taskDefinitionKey("innerTask").list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeCompleteScope().orderByActivityId().asc();
        List statistics = query.list();
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertEquals((long)4L, (long)statistics.size());
        HistoricActivityStatistics end1 = (HistoricActivityStatistics)statistics.get(0);
        Assert.assertEquals((Object)"end1", (Object)end1.getId());
        Assert.assertEquals((long)0L, (long)end1.getInstances());
        Assert.assertEquals((long)5L, (long)end1.getCompleteScope());
        HistoricActivityStatistics innerEnd = (HistoricActivityStatistics)statistics.get(1);
        Assert.assertEquals((Object)"innerEnd", (Object)innerEnd.getId());
        Assert.assertEquals((long)0L, (long)innerEnd.getInstances());
        Assert.assertEquals((long)25L, (long)innerEnd.getCompleteScope());
        HistoricActivityStatistics subprocess = (HistoricActivityStatistics)statistics.get(2);
        Assert.assertEquals((Object)"subprocess", (Object)subprocess.getId());
        Assert.assertEquals((long)0L, (long)subprocess.getInstances());
        Assert.assertEquals((long)25L, (long)subprocess.getCompleteScope());
        HistoricActivityStatistics task = (HistoricActivityStatistics)statistics.get(3);
        Assert.assertEquals((Object)"task", (Object)task.getId());
        Assert.assertEquals((long)5L, (long)task.getInstances());
        Assert.assertEquals((long)0L, (long)task.getCompleteScope());
        this.completeProcessInstances();
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testSingleTask.bpmn20.xml"})
    @Test
    public void testQueryByCanceled() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(5);
        this.cancelProcessInstances();
        HistoricActivityStatisticsQuery query = this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeCanceled();
        List statistics = query.list();
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((long)1L, (long)statistics.size());
        HistoricActivityStatistics task = (HistoricActivityStatistics)statistics.get(0);
        Assert.assertEquals((Object)"task", (Object)task.getId());
        Assert.assertEquals((long)0L, (long)task.getInstances());
        Assert.assertEquals((long)5L, (long)task.getCanceled());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testSingleTask.bpmn20.xml"})
    @Test
    public void testQueryByCanceledAfterCancelingSomeInstances() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(3);
        List processInstances = this.runtimeService.createProcessInstanceQuery().list();
        for (ProcessInstance processInstance : processInstances) {
            this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        }
        this.startProcesses(2);
        HistoricActivityStatisticsQuery query = this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeCanceled();
        List statistics = query.list();
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((long)1L, (long)statistics.size());
        HistoricActivityStatistics task = (HistoricActivityStatistics)statistics.get(0);
        Assert.assertEquals((Object)"task", (Object)task.getId());
        Assert.assertEquals((long)2L, (long)task.getInstances());
        Assert.assertEquals((long)3L, (long)task.getCanceled());
        this.completeProcessInstances();
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testSingleTask.bpmn20.xml"})
    @Test
    public void testQueryByCanceledAndFinished() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(2);
        List processInstances = this.runtimeService.createProcessInstanceQuery().list();
        for (Object processInstance : processInstances) {
            this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        }
        this.startProcesses(2);
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.startProcesses(2);
        HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeCanceled().includeFinished().orderByActivityId().asc();
        List statistics = query.list();
        Assert.assertEquals((long)3L, (long)query.count());
        Assert.assertEquals((long)3L, (long)statistics.size());
        HistoricActivityStatistics end = (HistoricActivityStatistics)statistics.get(0);
        Assert.assertEquals((Object)"end", (Object)end.getId());
        Assert.assertEquals((long)0L, (long)end.getInstances());
        Assert.assertEquals((long)0L, (long)end.getCanceled());
        Assert.assertEquals((long)2L, (long)end.getFinished());
        HistoricActivityStatistics start = (HistoricActivityStatistics)statistics.get(1);
        Assert.assertEquals((Object)"start", (Object)start.getId());
        Assert.assertEquals((long)0L, (long)start.getInstances());
        Assert.assertEquals((long)0L, (long)start.getCanceled());
        Assert.assertEquals((long)6L, (long)start.getFinished());
        HistoricActivityStatistics task = (HistoricActivityStatistics)statistics.get(2);
        Assert.assertEquals((Object)"task", (Object)task.getId());
        Assert.assertEquals((long)2L, (long)task.getInstances());
        Assert.assertEquals((long)2L, (long)task.getCanceled());
        Assert.assertEquals((long)4L, (long)task.getFinished());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testSingleTask.bpmn20.xml"})
    @Test
    public void testQueryByCanceledAndFinishedByPeriods() throws ParseException {
        try {
            ClockUtil.setCurrentTime((Date)this.sdf.parse("15.01.2016 12:00:00"));
            this.startProcesses(2);
            ClockUtil.setCurrentTime((Date)this.sdf.parse("15.02.2016 12:00:00"));
            List processInstances = this.runtimeService.createProcessInstanceQuery().list();
            for (Object processInstance : processInstances) {
                this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
            }
            ClockUtil.setCurrentTime((Date)this.sdf.parse("01.02.2016 12:00:00"));
            this.startProcesses(2);
            ClockUtil.setCurrentTime((Date)this.sdf.parse("25.02.2016 12:00:00"));
            List tasks = this.taskService.createTaskQuery().list();
            for (Task task : tasks) {
                this.taskService.complete(task.getId());
            }
            ClockUtil.setCurrentTime((Date)this.sdf.parse("15.03.2016 12:00:00"));
            this.startProcesses(2);
            ClockUtil.setCurrentTime((Date)this.sdf.parse("25.03.2016 12:00:00"));
            String processDefinitionId = this.getProcessDefinitionId();
            HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeCanceled().includeFinished().startedAfter(this.sdf.parse("01.01.2016 00:00:00")).startedBefore(this.sdf.parse("31.01.2016 23:59:59")).orderByActivityId().asc();
            List statistics = query.list();
            Assert.assertEquals((long)2L, (long)query.count());
            Assert.assertEquals((long)2L, (long)statistics.size());
            this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(0), "start", 0L, 0L, 2L);
            this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(1), "task", 0L, 2L, 2L);
            query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeCanceled().includeFinished().finishedAfter(this.sdf.parse("01.01.2016 00:00:00")).finishedBefore(this.sdf.parse("31.01.2016 23:59:59")).orderByActivityId().asc();
            statistics = query.list();
            Assert.assertEquals((long)0L, (long)query.count());
            Assert.assertEquals((long)0L, (long)statistics.size());
            query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeCanceled().includeFinished().startedAfter(this.sdf.parse("01.02.2016 00:00:00")).startedBefore(this.sdf.parse("28.02.2016 23:59:59")).orderByActivityId().asc();
            statistics = query.list();
            Assert.assertEquals((long)3L, (long)query.count());
            Assert.assertEquals((long)3L, (long)statistics.size());
            this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(0), "end", 0L, 0L, 2L);
            this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(1), "start", 0L, 0L, 2L);
            this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(2), "task", 0L, 0L, 2L);
            query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeCanceled().includeFinished().finishedAfter(this.sdf.parse("01.02.2016 00:00:00")).finishedBefore(this.sdf.parse("28.02.2016 23:59:59")).orderByActivityId().asc();
            statistics = query.list();
            Assert.assertEquals((long)3L, (long)query.count());
            Assert.assertEquals((long)3L, (long)statistics.size());
            this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(0), "end", 0L, 0L, 2L);
            this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(1), "start", 0L, 0L, 4L);
            this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(2), "task", 0L, 2L, 4L);
            query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeCanceled().includeFinished().startedAfter(this.sdf.parse("01.03.2016 00:00:00")).orderByActivityId().asc();
            statistics = query.list();
            Assert.assertEquals((long)2L, (long)query.count());
            Assert.assertEquals((long)2L, (long)statistics.size());
            this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(0), "start", 0L, 0L, 2L);
            this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(1), "task", 2L, 0L, 0L);
            query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeCanceled().includeFinished().finishedAfter(this.sdf.parse("01.03.2016 00:00:00")).orderByActivityId().asc();
            statistics = query.list();
            Assert.assertEquals((long)0L, (long)query.count());
            Assert.assertEquals((long)0L, (long)statistics.size());
            query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeCanceled().includeFinished().startedAfter(this.sdf.parse("01.01.2016 00:00:00")).orderByActivityId().asc();
            statistics = query.list();
            Assert.assertEquals((long)3L, (long)query.count());
            Assert.assertEquals((long)3L, (long)statistics.size());
            this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(0), "end", 0L, 0L, 2L);
            this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(1), "start", 0L, 0L, 6L);
            this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(2), "task", 2L, 2L, 4L);
        }
        finally {
            ClockUtil.reset();
        }
    }

    protected void assertActivityStatistics(HistoricActivityStatistics activity, String activityName, long instances, long canceled, long finished) {
        Assert.assertEquals((Object)activityName, (Object)activity.getId());
        Assert.assertEquals((long)instances, (long)activity.getInstances());
        Assert.assertEquals((long)canceled, (long)activity.getCanceled());
        Assert.assertEquals((long)finished, (long)activity.getFinished());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testSingleTask.bpmn20.xml"})
    @Test
    public void testQueryByCanceledAndCompleteScope() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(2);
        List processInstances = this.runtimeService.createProcessInstanceQuery().list();
        for (Object processInstance : processInstances) {
            this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        }
        this.startProcesses(2);
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.startProcesses(2);
        HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeCanceled().includeCompleteScope().orderByActivityId().asc();
        List statistics = query.list();
        Assert.assertEquals((long)2L, (long)query.count());
        Assert.assertEquals((long)2L, (long)statistics.size());
        HistoricActivityStatistics end = (HistoricActivityStatistics)statistics.get(0);
        Assert.assertEquals((Object)"end", (Object)end.getId());
        Assert.assertEquals((long)0L, (long)end.getInstances());
        Assert.assertEquals((long)0L, (long)end.getCanceled());
        Assert.assertEquals((long)2L, (long)end.getCompleteScope());
        HistoricActivityStatistics task = (HistoricActivityStatistics)statistics.get(1);
        Assert.assertEquals((Object)"task", (Object)task.getId());
        Assert.assertEquals((long)2L, (long)task.getInstances());
        Assert.assertEquals((long)2L, (long)task.getCanceled());
        Assert.assertEquals((long)0L, (long)task.getCompleteScope());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testSingleTask.bpmn20.xml"})
    @Test
    public void testQueryByFinishedAndCompleteScope() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(2);
        List processInstances = this.runtimeService.createProcessInstanceQuery().list();
        for (Object processInstance : processInstances) {
            this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        }
        this.startProcesses(2);
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.startProcesses(2);
        HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeFinished().includeCompleteScope().orderByActivityId().asc();
        List statistics = query.list();
        Assert.assertEquals((long)3L, (long)query.count());
        Assert.assertEquals((long)3L, (long)statistics.size());
        HistoricActivityStatistics end = (HistoricActivityStatistics)statistics.get(0);
        Assert.assertEquals((Object)"end", (Object)end.getId());
        Assert.assertEquals((long)0L, (long)end.getInstances());
        Assert.assertEquals((long)2L, (long)end.getFinished());
        Assert.assertEquals((long)2L, (long)end.getCompleteScope());
        HistoricActivityStatistics start = (HistoricActivityStatistics)statistics.get(1);
        Assert.assertEquals((Object)"start", (Object)start.getId());
        Assert.assertEquals((long)0L, (long)start.getInstances());
        Assert.assertEquals((long)6L, (long)start.getFinished());
        Assert.assertEquals((long)0L, (long)start.getCompleteScope());
        HistoricActivityStatistics task = (HistoricActivityStatistics)statistics.get(2);
        Assert.assertEquals((Object)"task", (Object)task.getId());
        Assert.assertEquals((long)2L, (long)task.getInstances());
        Assert.assertEquals((long)4L, (long)task.getFinished());
        Assert.assertEquals((long)0L, (long)task.getCompleteScope());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testSingleTask.bpmn20.xml"})
    @Test
    public void testQueryByFinishedAndCompleteScopeAndCanceled() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(2);
        List processInstances = this.runtimeService.createProcessInstanceQuery().list();
        for (Object processInstance : processInstances) {
            this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        }
        this.startProcesses(2);
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.startProcesses(2);
        HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeFinished().includeCompleteScope().includeCanceled().orderByActivityId().asc();
        List statistics = query.list();
        Assert.assertEquals((long)3L, (long)query.count());
        Assert.assertEquals((long)3L, (long)statistics.size());
        HistoricActivityStatistics end = (HistoricActivityStatistics)statistics.get(0);
        Assert.assertEquals((Object)"end", (Object)end.getId());
        Assert.assertEquals((long)0L, (long)end.getInstances());
        Assert.assertEquals((long)0L, (long)end.getCanceled());
        Assert.assertEquals((long)2L, (long)end.getFinished());
        Assert.assertEquals((long)2L, (long)end.getCompleteScope());
        HistoricActivityStatistics start = (HistoricActivityStatistics)statistics.get(1);
        Assert.assertEquals((Object)"start", (Object)start.getId());
        Assert.assertEquals((long)0L, (long)start.getInstances());
        Assert.assertEquals((long)0L, (long)start.getCanceled());
        Assert.assertEquals((long)6L, (long)start.getFinished());
        Assert.assertEquals((long)0L, (long)start.getCompleteScope());
        HistoricActivityStatistics task = (HistoricActivityStatistics)statistics.get(2);
        Assert.assertEquals((Object)"task", (Object)task.getId());
        Assert.assertEquals((long)2L, (long)task.getInstances());
        Assert.assertEquals((long)2L, (long)task.getCanceled());
        Assert.assertEquals((long)4L, (long)task.getFinished());
        Assert.assertEquals((long)0L, (long)task.getCompleteScope());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testSingleTask.bpmn20.xml"})
    @Test
    public void testQueryByProcessInstanceIds() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(3);
        List processInstances = this.runtimeService.createProcessInstanceQuery().list();
        String cancelledInstance = ((ProcessInstance)processInstances.get(0)).getId();
        String completedInstance = ((ProcessInstance)processInstances.get(1)).getId();
        this.runtimeService.deleteProcessInstance(cancelledInstance, "test");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(completedInstance).singleResult();
        this.taskService.complete(task.getId());
        HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).processInstanceIdIn(new String[]{cancelledInstance, completedInstance}).includeFinished().includeCompleteScope().includeCanceled().orderByActivityId().asc();
        List statistics = query.list();
        HistoricActivityStatistics endStats = (HistoricActivityStatistics)statistics.get(0);
        Assert.assertEquals((Object)"end", (Object)endStats.getId());
        Assert.assertEquals((long)0L, (long)endStats.getInstances());
        Assert.assertEquals((long)0L, (long)endStats.getCanceled());
        Assert.assertEquals((long)1L, (long)endStats.getFinished());
        Assert.assertEquals((long)1L, (long)endStats.getCompleteScope());
        HistoricActivityStatistics startStats = (HistoricActivityStatistics)statistics.get(1);
        Assert.assertEquals((Object)"start", (Object)startStats.getId());
        Assert.assertEquals((long)0L, (long)startStats.getInstances());
        Assert.assertEquals((long)0L, (long)startStats.getCanceled());
        Assert.assertEquals((long)2L, (long)startStats.getFinished());
        Assert.assertEquals((long)0L, (long)startStats.getCompleteScope());
        HistoricActivityStatistics taskStats = (HistoricActivityStatistics)statistics.get(2);
        Assert.assertEquals((Object)"task", (Object)taskStats.getId());
        Assert.assertEquals((long)0L, (long)taskStats.getInstances());
        Assert.assertEquals((long)1L, (long)taskStats.getCanceled());
        Assert.assertEquals((long)2L, (long)taskStats.getFinished());
        Assert.assertEquals((long)0L, (long)taskStats.getCompleteScope());
    }

    @Test
    public void testCheckProcessInstanceIdsForNull() {
        HistoricActivityStatisticsQuery query = this.historyService.createHistoricActivityStatisticsQuery("foo");
        try {
            query.processInstanceIdIn((String[])null);
            Assert.fail((String)"exception expected");
        }
        catch (NullValueException e) {
            this.testRule.assertTextPresent("processInstanceIds is null", e.getMessage());
        }
        try {
            query.processInstanceIdIn(new String[]{null});
            Assert.fail((String)"exception expected");
        }
        catch (NullValueException e) {
            this.testRule.assertTextPresent("processInstanceIds contains null value", e.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testSingleTask.bpmn20.xml"})
    @Test
    public void testSorting() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(5);
        HistoricActivityStatisticsQuery query = this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId);
        Assert.assertEquals((long)1L, (long)((HistoricActivityStatisticsQuery)query.orderByActivityId().asc()).list().size());
        Assert.assertEquals((long)1L, (long)((HistoricActivityStatisticsQuery)query.orderByActivityId().desc()).list().size());
        Assert.assertEquals((long)1L, (long)((HistoricActivityStatisticsQuery)query.orderByActivityId().asc()).count());
        Assert.assertEquals((long)1L, (long)((HistoricActivityStatisticsQuery)query.orderByActivityId().desc()).count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testSingleTask.bpmn20.xml", "org/eximeebpms/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testAnotherSingleTask.bpmn20.xml"})
    @Test
    public void testDifferentProcessesWithSameActivityId() {
        String processDefinitionId = this.getProcessDefinitionId();
        String anotherProcessDefinitionId = this.getProcessDefinitionIdByKey("anotherProcess");
        this.startProcesses(5);
        this.startProcessesByKey(10, "anotherProcess");
        HistoricActivityStatisticsQuery query = this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId);
        List statistics = query.list();
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((long)1L, (long)statistics.size());
        HistoricActivityStatistics task = (HistoricActivityStatistics)statistics.get(0);
        Assert.assertEquals((long)5L, (long)task.getInstances());
        query = this.historyService.createHistoricActivityStatisticsQuery(anotherProcessDefinitionId);
        statistics = query.list();
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((long)1L, (long)statistics.size());
        task = (HistoricActivityStatistics)statistics.get(0);
        Assert.assertEquals((long)10L, (long)task.getInstances());
    }

    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testSingleTask.bpmn20.xml"})
    @Test
    public void testQueryIncludeIncidents() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(4);
        List processInstances = this.runtimeService.createProcessInstanceQuery().list();
        String processInstanceWithResolvedIncidents = ((ProcessInstance)processInstances.get(1)).getId();
        String processInstanceWithDeletedIncident = ((ProcessInstance)processInstances.get(2)).getId();
        String processInstanceWithOpenIncident = ((ProcessInstance)processInstances.get(3)).getId();
        Incident resolvedIncident = this.createIncident(processInstanceWithResolvedIncidents);
        this.runtimeService.resolveIncident(resolvedIncident.getId());
        resolvedIncident = this.createIncident(processInstanceWithResolvedIncidents);
        this.runtimeService.resolveIncident(resolvedIncident.getId());
        this.createIncident(processInstanceWithDeletedIncident);
        this.runtimeService.deleteProcessInstance(((ProcessInstance)processInstances.get(2)).getId(), "test");
        this.createIncident(processInstanceWithOpenIncident);
        HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeFinished().includeCanceled().includeIncidents().orderByActivityId().asc();
        List statistics = query.list();
        Assert.assertEquals((long)2L, (long)statistics.size());
        this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(0), "start", 0, 0, 4, 0, 0, 0);
        this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(1), "task", 3, 1, 1, 1, 2, 1);
    }

    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testSingleTask.bpmn20.xml"})
    @Test
    public void testQueryIncludeIncidentsDeletedOnlyAndProcessInstanceIds() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(3);
        List processInstances = this.runtimeService.createProcessInstanceQuery().list();
        String processInstanceWithResolvedIncident = ((ProcessInstance)processInstances.get(1)).getId();
        String processInstanceWithDeletedIncident = ((ProcessInstance)processInstances.get(2)).getId();
        this.runtimeService.resolveIncident(this.createIncident(processInstanceWithResolvedIncident).getId());
        this.createIncident(processInstanceWithDeletedIncident);
        this.createIncident(processInstanceWithDeletedIncident);
        this.createIncident(processInstanceWithDeletedIncident);
        this.runtimeService.deleteProcessInstance(processInstanceWithDeletedIncident, "test");
        HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).processInstanceIdIn(new String[]{processInstanceWithDeletedIncident}).includeFinished().includeCompleteScope().includeCanceled().includeIncidents().orderByActivityId().asc();
        List statistics = query.list();
        Assert.assertEquals((long)2L, (long)statistics.size());
        this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(0), "start", 0, 0, 1, 0, 0, 0);
        this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(1), "task", 0, 1, 1, 0, 0, 3);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testSingleTask.bpmn20.xml"})
    @Test
    public void testQueryIncludeIncidentsWhenNoIncidents() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(2);
        List processInstances = this.runtimeService.createProcessInstanceQuery().list();
        this.runtimeService.deleteProcessInstance(((ProcessInstance)processInstances.get(0)).getId(), null);
        HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeFinished().includeCompleteScope().includeCanceled().includeIncidents().orderByActivityId().asc();
        List statistics = query.list();
        Assert.assertEquals((long)2L, (long)statistics.size());
        this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(0), "start", 0, 0, 2, 0, 0, 0);
        this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(1), "task", 1, 1, 1, 0, 0, 0);
    }

    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testMultipleRunningTasks.bpmn20.xml"})
    @Test
    public void testQueryIncludeIncidentsMultipleRunningTasksDeletedOnly() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(2);
        List processInstances = this.runtimeService.createProcessInstanceQuery().list();
        String cancelledInstanceWithIncident = ((ProcessInstance)processInstances.get(0)).getId();
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(cancelledInstanceWithIncident).activityId("innerTask").active().list();
        this.runtimeService.createIncident("foo1", ((Execution)executions.get(0)).getId(), ((ExecutionEntity)executions.get(0)).getActivityId(), "bar1");
        this.runtimeService.createIncident("foo2", ((Execution)executions.get(1)).getId(), ((ExecutionEntity)executions.get(1)).getActivityId(), "bar2");
        this.runtimeService.deleteProcessInstance(cancelledInstanceWithIncident, "test");
        HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeFinished().includeCompleteScope().includeCanceled().includeIncidents().orderByActivityId().asc();
        List statistics = query.list();
        Assert.assertEquals((long)7L, (long)statistics.size());
        this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(0), "gtw", 0, 0, 2, 0, 0, 0);
        this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(1), "innerStart", 0, 0, 10, 0, 0, 0);
        this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(2), "innerTask", 5, 5, 5, 0, 0, 2);
        this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(3), "start", 0, 0, 2, 0, 0, 0);
        this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(4), "subprocess", 5, 5, 5, 0, 0, 0);
        this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(5), "subprocess#multiInstanceBody", 1, 1, 1, 0, 0, 0);
        this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(6), "task", 1, 1, 1, 0, 0, 0);
    }

    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testMultipleRunningTasks.bpmn20.xml"})
    @Test
    public void testQueryIncludeIncidentsMultipleRunningTasksOpenOnly() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(2);
        List processInstances = this.runtimeService.createProcessInstanceQuery().list();
        String cancelledInstanceWithIncident = ((ProcessInstance)processInstances.get(0)).getId();
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(cancelledInstanceWithIncident).activityId("innerTask").active().list();
        this.runtimeService.createIncident("foo1", ((Execution)executions.get(0)).getId(), ((ExecutionEntity)executions.get(0)).getActivityId(), "bar1");
        this.runtimeService.createIncident("foo1", ((Execution)executions.get(0)).getId(), ((ExecutionEntity)executions.get(0)).getActivityId(), "bar1");
        this.runtimeService.createIncident("foo2", ((Execution)executions.get(1)).getId(), ((ExecutionEntity)executions.get(1)).getActivityId(), "bar2");
        executions = this.runtimeService.createExecutionQuery().processInstanceId(cancelledInstanceWithIncident).activityId("task").active().list();
        this.runtimeService.createIncident("foo", ((Execution)executions.get(0)).getId(), ((ExecutionEntity)executions.get(0)).getActivityId(), "bar");
        HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeIncidents().orderByActivityId().asc();
        List statistics = query.list();
        Assert.assertEquals((long)4L, (long)statistics.size());
        this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(0), "innerTask", 10, 0, 0, 3, 0, 0);
        this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(1), "subprocess", 10, 0, 0, 0, 0, 0);
        this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(2), "subprocess#multiInstanceBody", 2, 0, 0, 0, 0, 0);
        this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(3), "task", 2, 0, 0, 1, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testSingleTask.bpmn20.xml"})
    @Test
    public void testQueryCancelledIncludeIncidentsDeletedOnly() throws ParseException {
        try {
            String processDefinitionId = this.getProcessDefinitionId();
            ClockUtil.setCurrentTime((Date)this.sdf.parse("5.10.2019 12:00:00"));
            this.startProcessesByKey(2, "process");
            List processInstances = this.runtimeService.createProcessInstanceQuery().list();
            String firstInstance = ((ProcessInstance)processInstances.get(0)).getId();
            this.createIncident(firstInstance);
            this.cancelProcessInstances();
            ClockUtil.setCurrentTime((Date)this.sdf.parse("20.10.2019 12:00:00"));
            this.startProcessesByKey(2, "process");
            processInstances = this.runtimeService.createProcessInstanceQuery().list();
            String thirdInstance = ((ProcessInstance)processInstances.get(0)).getId();
            String fourthInstance = ((ProcessInstance)processInstances.get(1)).getId();
            this.createIncident(thirdInstance);
            this.createIncident(fourthInstance);
            this.cancelProcessInstances();
            HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).startedAfter(this.sdf.parse("01.10.2019 12:00:00")).startedBefore(this.sdf.parse("10.10.2019 12:00:00")).includeFinished().includeCompleteScope().includeCanceled().includeIncidents().orderByActivityId().asc();
            List statistics = query.list();
            Assert.assertEquals((long)2L, (long)statistics.size());
            this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(0), "start", 0, 0, 2, 0, 0, 0);
            this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(1), "task", 0, 2, 2, 0, 0, 1);
        }
        finally {
            ClockUtil.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testSingleTask.bpmn20.xml"})
    @Test
    public void testQueryCompletedIncludeIncidentsDeletedOnly() throws ParseException {
        try {
            String processDefinitionId = this.getProcessDefinitionId();
            ClockUtil.setCurrentTime((Date)this.sdf.parse("5.10.2019 12:00:00"));
            this.startProcessesByKey(2, "process");
            List processInstances = this.runtimeService.createProcessInstanceQuery().list();
            String firstInstance = ((ProcessInstance)processInstances.get(0)).getId();
            this.createIncident(firstInstance);
            this.completeProcessInstances();
            ClockUtil.setCurrentTime((Date)this.sdf.parse("20.10.2019 12:00:00"));
            this.startProcessesByKey(2, "process");
            processInstances = this.runtimeService.createProcessInstanceQuery().list();
            String thirdInstance = ((ProcessInstance)processInstances.get(0)).getId();
            this.createIncident(thirdInstance);
            this.completeProcessInstances();
            HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).finishedAfter(this.sdf.parse("10.10.2019 12:00:00")).finishedBefore(this.sdf.parse("30.10.2019 12:00:00")).includeFinished().includeCompleteScope().includeCanceled().includeIncidents().orderByActivityId().asc();
            List statistics = query.list();
            Assert.assertEquals((long)3L, (long)statistics.size());
            this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(0), "end", 0, 0, 2, 0, 0, 0);
            this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(1), "start", 0, 0, 2, 0, 0, 0);
            this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(2), "task", 0, 0, 2, 0, 0, 1);
        }
        finally {
            ClockUtil.reset();
        }
    }

    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/repository/failingProcessCreateOneIncident.bpmn20.xml"})
    @Test
    public void testQueryIncludeIncidentsWhenNoHistoricActivityInstanceDeletedOnly() {
        this.startProcessesByKey(3, "failingProcess");
        List list = this.managementService.createJobQuery().list();
        for (Job job : list) {
            this.managementService.setJobRetries(job.getId(), 0);
        }
        List processInstances = this.runtimeService.createProcessInstanceQuery().list();
        String cancelledInstance1 = ((ProcessInstance)processInstances.get(1)).getId();
        String cancelledInstance2 = ((ProcessInstance)processInstances.get(2)).getId();
        String processDefinitionId = ((ProcessInstance)processInstances.get(0)).getProcessDefinitionId();
        this.runtimeService.deleteProcessInstances(Arrays.asList(cancelledInstance1, cancelledInstance2), "test", false, false);
        HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeFinished().includeIncidents().orderByActivityId().asc();
        List statistics = query.list();
        Assert.assertEquals((long)2L, (long)statistics.size());
        this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(0), "serviceTask", 0, 0, 0, 1, 0, 2);
        this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(1), "start", 0, 0, 3, 0, 0, 0);
    }

    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/repository/failingProcessCreateOneIncident.bpmn20.xml"})
    @Test
    public void testQueryIncludeIncidentsWhenNoHistoricActivityInstanceWithoutFilters() {
        this.startProcessesByKey(3, "failingProcess");
        List list = this.managementService.createJobQuery().list();
        for (Job job : list) {
            this.managementService.setJobRetries(job.getId(), 0);
        }
        List processInstances = this.runtimeService.createProcessInstanceQuery().list();
        String cancelledInstance1 = ((ProcessInstance)processInstances.get(1)).getId();
        String cancelledInstance2 = ((ProcessInstance)processInstances.get(2)).getId();
        String processDefinitionId = ((ProcessInstance)processInstances.get(0)).getProcessDefinitionId();
        this.runtimeService.deleteProcessInstances(Arrays.asList(cancelledInstance1, cancelledInstance2), "test", false, false);
        HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeIncidents().orderByActivityId().asc();
        List statistics = query.list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        this.assertActivityStatistics((HistoricActivityStatistics)statistics.get(0), "serviceTask", 0, 0, 0, 1, 0, 2);
    }

    protected void completeProcessInstances() {
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
    }

    protected void cancelProcessInstances() {
        List processInstances = this.runtimeService.createProcessInstanceQuery().list();
        for (ProcessInstance pi : processInstances) {
            this.runtimeService.deleteProcessInstance(pi.getId(), "test");
        }
    }

    protected void startProcesses(int numberOfInstances) {
        this.startProcessesByKey(numberOfInstances, "process");
    }

    protected void startProcessesByKey(int numberOfInstances, String key) {
        for (int i = 0; i < numberOfInstances; ++i) {
            this.runtimeService.startProcessInstanceByKey(key);
        }
    }

    protected String getProcessDefinitionIdByKey(String key) {
        return ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(key).singleResult()).getId();
    }

    protected String getProcessDefinitionId() {
        return this.getProcessDefinitionIdByKey("process");
    }

    protected Incident createIncident(String instanceId) {
        ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().processInstanceId(instanceId).active().singleResult();
        return this.runtimeService.createIncident("foo", execution.getId(), execution.getActivityId(), "exec" + execution.getId());
    }

    protected void assertActivityStatistics(HistoricActivityStatistics activity, String activityName, int instances, int canceled, int finished, int openIncidents, int resolvedIncidents, int deletedIncidents) {
        this.assertActivityStatistics(activity, activityName, instances, canceled, finished);
        Assert.assertEquals((long)openIncidents, (long)activity.getOpenIncidents());
        Assert.assertEquals((long)resolvedIncidents, (long)activity.getResolvedIncidents());
        Assert.assertEquals((long)deletedIncidents, (long)activity.getDeletedIncidents());
    }
}

