/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.history;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.CaseService;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.exception.NullValueException;
import org.eximeebpms.bpm.engine.history.HistoricCaseActivityStatistics;
import org.eximeebpms.bpm.engine.history.HistoricCaseActivityStatisticsQuery;
import org.eximeebpms.bpm.engine.repository.CaseDefinition;
import org.eximeebpms.bpm.engine.runtime.CaseExecution;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@RequiredHistoryLevel(value="activity")
public class HistoricCaseActivityStatisticsQueryTest {
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected HistoryService historyService;
    protected CaseService caseService;
    protected RepositoryService repositoryService;

    @Before
    public void setUp() {
        this.historyService = this.engineRule.getHistoryService();
        this.caseService = this.engineRule.getCaseService();
        this.repositoryService = this.engineRule.getRepositoryService();
    }

    @Test
    public void testCaseDefinitionNull() {
        try {
            this.historyService.createHistoricCaseActivityStatisticsQuery(null).list();
            Assert.fail((String)"It should not be possible to query for statistics by null.");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testNoCaseActivityInstances() {
        String caseDefinitionId = this.getCaseDefinition().getId();
        HistoricCaseActivityStatisticsQuery query = this.historyService.createHistoricCaseActivityStatisticsQuery(caseDefinitionId);
        Assert.assertEquals((long)0L, (long)query.count());
        Assertions.assertThat((List)query.list()).hasSize(0);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testSingleTask() {
        String caseDefinitionId = this.getCaseDefinition().getId();
        this.createCaseByKey(5, "oneTaskCase");
        HistoricCaseActivityStatisticsQuery query = this.historyService.createHistoricCaseActivityStatisticsQuery(caseDefinitionId);
        List statistics = query.list();
        Assert.assertEquals((long)1L, (long)query.count());
        Assertions.assertThat((List)statistics).hasSize(1);
        this.assertStatisitcs((HistoricCaseActivityStatistics)statistics.get(0), "PI_HumanTask_1", 5L, 0L, 0L, 0L, 0L, 0L);
    }

    @Test
    @Deployment
    public void testMultipleTasks() {
        String caseDefinitionId = this.getCaseDefinition().getId();
        this.createCaseByKey(5, "case");
        this.disableByActivity("DISABLED");
        this.completeByActivity("COMPLETED");
        this.terminateByActivity("TERMINATED");
        HistoricCaseActivityStatisticsQuery query = this.historyService.createHistoricCaseActivityStatisticsQuery(caseDefinitionId);
        List statistics = query.list();
        Assertions.assertThat((List)statistics).hasSize(6);
        Assert.assertEquals((long)query.count(), (long)6L);
        this.assertStatisitcs((HistoricCaseActivityStatistics)statistics.get(0), "ACTIVE", 5L, 0L, 0L, 0L, 0L, 0L);
        this.assertStatisitcs((HistoricCaseActivityStatistics)statistics.get(1), "AVAILABLE", 0L, 5L, 0L, 0L, 0L, 0L);
        this.assertStatisitcs((HistoricCaseActivityStatistics)statistics.get(2), "COMPLETED", 0L, 0L, 5L, 0L, 0L, 0L);
        this.assertStatisitcs((HistoricCaseActivityStatistics)statistics.get(3), "DISABLED", 0L, 0L, 0L, 5L, 0L, 0L);
        this.assertStatisitcs((HistoricCaseActivityStatistics)statistics.get(4), "ENABLED", 0L, 0L, 0L, 0L, 5L, 0L);
        this.assertStatisitcs((HistoricCaseActivityStatistics)statistics.get(5), "TERMINATED", 0L, 0L, 0L, 0L, 0L, 5L);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricCaseActivityStatisticsQueryTest.testMultipleTasks.cmmn"})
    public void testStateCount() {
        String caseDefinitionId = this.getCaseDefinition().getId();
        this.createCaseByKey(3, "case");
        this.completeByActivity("ACTIVE");
        this.manuallyStartByActivity("AVAILABLE");
        this.completeByActivity("AVAILABLE");
        this.createCaseByKey(5, "case");
        this.completeByActivity("ACTIVE");
        this.disableByActivity("AVAILABLE");
        this.reenableByActivity("AVAILABLE");
        this.manuallyStartByActivity("AVAILABLE");
        this.terminateByActivity("AVAILABLE");
        this.createCaseByKey(5, "case");
        this.terminateByActivity("ACTIVE");
        this.manuallyStartByActivity("ENABLED");
        this.completeByActivity("ENABLED");
        this.manuallyStartByActivity("DISABLED");
        this.terminateByActivity("DISABLED");
        this.createCaseByKey(2, "case");
        this.disableByActivity("DISABLED");
        HistoricCaseActivityStatisticsQuery query = this.historyService.createHistoricCaseActivityStatisticsQuery(caseDefinitionId);
        List statistics = query.list();
        Assertions.assertThat((List)statistics).hasSize(6);
        Assert.assertEquals((long)query.count(), (long)6L);
        this.assertStatisitcs((HistoricCaseActivityStatistics)statistics.get(0), "ACTIVE", 2L, 0L, 8L, 0L, 0L, 5L);
        this.assertStatisitcs((HistoricCaseActivityStatistics)statistics.get(1), "AVAILABLE", 0L, 7L, 3L, 0L, 0L, 5L);
        this.assertStatisitcs((HistoricCaseActivityStatistics)statistics.get(2), "COMPLETED", 15L, 0L, 0L, 0L, 0L, 0L);
        this.assertStatisitcs((HistoricCaseActivityStatistics)statistics.get(3), "DISABLED", 0L, 0L, 0L, 2L, 0L, 13L);
        this.assertStatisitcs((HistoricCaseActivityStatistics)statistics.get(4), "ENABLED", 0L, 0L, 13L, 0L, 2L, 0L);
        this.assertStatisitcs((HistoricCaseActivityStatistics)statistics.get(5), "TERMINATED", 15L, 0L, 0L, 0L, 0L, 0L);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn", "org/eximeebpms/bpm/engine/test/history/HistoricCaseActivityStatisticsQueryTest.testMultipleTasks.cmmn"})
    public void testMultipleCaseDefinitions() {
        String caseDefinitionId1 = this.getCaseDefinition("oneTaskCase").getId();
        String caseDefinitionId2 = this.getCaseDefinition("case").getId();
        this.createCaseByKey(5, "oneTaskCase");
        this.createCaseByKey(10, "case");
        HistoricCaseActivityStatisticsQuery query1 = this.historyService.createHistoricCaseActivityStatisticsQuery(caseDefinitionId1);
        HistoricCaseActivityStatisticsQuery query2 = this.historyService.createHistoricCaseActivityStatisticsQuery(caseDefinitionId2);
        Assertions.assertThat((List)query1.list()).hasSize(1);
        Assertions.assertThat((List)query2.list()).hasSize(6);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricCaseActivityStatisticsQueryTest.testMultipleTasks.cmmn"})
    public void testPagination() {
        String caseDefinitionId = this.getCaseDefinition().getId();
        this.createCaseByKey(5, "case");
        List statistics = this.historyService.createHistoricCaseActivityStatisticsQuery(caseDefinitionId).listPage(2, 1);
        Assertions.assertThat((List)statistics).hasSize(1);
        Assertions.assertThat((String)((HistoricCaseActivityStatistics)statistics.get(0)).getId()).isEqualTo((Object)"COMPLETED");
    }

    protected void assertStatisitcs(HistoricCaseActivityStatistics statistics, String id, long active, long availabe, long completed, long disabled, long enabled, long terminated) {
        Assertions.assertThat((String)statistics.getId()).isEqualTo((Object)id);
        Assert.assertEquals((long)active, (long)statistics.getActive());
        Assert.assertEquals((long)availabe, (long)statistics.getAvailable());
        Assert.assertEquals((long)completed, (long)statistics.getCompleted());
        Assert.assertEquals((long)disabled, (long)statistics.getDisabled());
        Assert.assertEquals((long)enabled, (long)statistics.getEnabled());
        Assert.assertEquals((long)terminated, (long)statistics.getTerminated());
    }

    protected void createCaseByKey(int numberOfInstances, String key) {
        for (int i = 0; i < numberOfInstances; ++i) {
            this.caseService.createCaseInstanceByKey(key);
        }
    }

    protected CaseDefinition getCaseDefinition() {
        return (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
    }

    protected CaseDefinition getCaseDefinition(String key) {
        return (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(key).singleResult();
    }

    protected List<CaseExecution> getCaseExecutionsByActivity(String activityId) {
        return this.caseService.createCaseExecutionQuery().activityId(activityId).list();
    }

    protected void disableByActivity(String activityId) {
        List<CaseExecution> executions = this.getCaseExecutionsByActivity(activityId);
        for (CaseExecution caseExecution : executions) {
            this.caseService.disableCaseExecution(caseExecution.getId());
        }
    }

    protected void reenableByActivity(String activityId) {
        List<CaseExecution> executions = this.getCaseExecutionsByActivity(activityId);
        for (CaseExecution caseExecution : executions) {
            this.caseService.reenableCaseExecution(caseExecution.getId());
        }
    }

    protected void manuallyStartByActivity(String activityId) {
        List<CaseExecution> executions = this.getCaseExecutionsByActivity(activityId);
        for (CaseExecution caseExecution : executions) {
            this.caseService.manuallyStartCaseExecution(caseExecution.getId());
        }
    }

    protected void completeByActivity(String activityId) {
        List<CaseExecution> executions = this.getCaseExecutionsByActivity(activityId);
        for (CaseExecution caseExecution : executions) {
            this.caseService.completeCaseExecution(caseExecution.getId());
        }
    }

    protected void terminateByActivity(String activityId) {
        List<CaseExecution> executions = this.getCaseExecutionsByActivity(activityId);
        for (CaseExecution caseExecution : executions) {
            this.caseService.terminateCaseExecution(caseExecution.getId());
        }
    }
}

