/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.history;

import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ExternalTaskService;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.exception.NotValidException;
import org.eximeebpms.bpm.engine.externaltask.ExternalTask;
import org.eximeebpms.bpm.engine.externaltask.LockedExternalTask;
import org.eximeebpms.bpm.engine.history.HistoricActivityInstance;
import org.eximeebpms.bpm.engine.history.HistoricExternalTaskLog;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.models.builder.DefaultExternalTaskModelBuilder;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class HistoricExternalTaskLogQueryTest {
    protected final String WORKER_ID = "aWorkerId";
    protected final long LOCK_DURATION = 300000L;
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule).around((TestRule)this.testHelper);
    protected ProcessInstance processInstance;
    protected RuntimeService runtimeService;
    protected HistoryService historyService;
    protected ExternalTaskService externalTaskService;

    @Before
    public void setUp() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
        this.externalTaskService = this.engineRule.getExternalTaskService();
    }

    @Test
    public void testQuery() {
        ExternalTask task = this.startExternalTaskProcess();
        HistoricExternalTaskLog log = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().singleResult();
        TestCase.assertNotNull((Object)log);
        Assertions.assertThat((String)log.getExternalTaskId()).isEqualTo((Object)task.getId());
    }

    @Test
    public void testQueryById() {
        this.startExternalTaskProcesses(2);
        String logId = this.retrieveFirstHistoricExternalTaskLog().getId();
        HistoricExternalTaskLog log = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().logId(logId).singleResult();
        TestCase.assertNotNull((Object)log);
        Assertions.assertThat((String)log.getId()).isEqualTo((Object)logId);
    }

    @Test
    public void testQueryFailsByInvalidId() {
        this.startExternalTaskProcess();
        Assertions.assertThatThrownBy(() -> this.historyService.createHistoricExternalTaskLogQuery().logId(null).singleResult()).isInstanceOf(NotValidException.class);
    }

    @Test
    public void testQueryByNonExistingId() {
        this.startExternalTaskProcess();
        HistoricExternalTaskLog log = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().logId("foo").singleResult();
        TestCase.assertNull((Object)log);
    }

    @Test
    public void testQueryByExternalTaskId() {
        this.startExternalTaskProcesses(2);
        String logExternalTaskId = this.retrieveFirstHistoricExternalTaskLog().getExternalTaskId();
        HistoricExternalTaskLog log = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().externalTaskId(logExternalTaskId).singleResult();
        TestCase.assertNotNull((Object)log);
        Assertions.assertThat((String)log.getExternalTaskId()).isEqualTo((Object)logExternalTaskId);
    }

    @Test
    public void testQueryFailsByInvalidExternalTaskId() {
        this.startExternalTaskProcess();
        Assertions.assertThatThrownBy(() -> this.historyService.createHistoricExternalTaskLogQuery().externalTaskId(null).singleResult()).isInstanceOf(NotValidException.class);
    }

    @Test
    public void testQueryByNonExistingExternalTaskId() {
        this.startExternalTaskProcess();
        HistoricExternalTaskLog log = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().externalTaskId("foo").singleResult();
        TestCase.assertNull((Object)log);
    }

    @Test
    public void testQueryByTopicName() {
        String dummyTopic = "dummy";
        this.startExternalTaskProcessGivenTopicName(dummyTopic);
        ExternalTask task = this.startExternalTaskProcess();
        HistoricExternalTaskLog log = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().topicName("foo").singleResult();
        TestCase.assertNotNull((Object)log);
        Assertions.assertThat((String)log.getExternalTaskId()).isEqualTo((Object)task.getId());
    }

    @Test
    public void testQueryFailsByInvalidTopicName() {
        this.startExternalTaskProcess();
        Assertions.assertThatThrownBy(() -> this.historyService.createHistoricExternalTaskLogQuery().topicName(null).singleResult()).isInstanceOf(NotValidException.class);
    }

    @Test
    public void testQueryByNonExistingTopicName() {
        this.startExternalTaskProcess();
        HistoricExternalTaskLog log = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().topicName("foo bar").singleResult();
        TestCase.assertNull((Object)log);
    }

    @Test
    public void testQueryByWorkerId() {
        List<ExternalTask> taskList = this.startExternalTaskProcesses(2);
        ExternalTask taskToCheck = taskList.get(1);
        this.completeExternalTaskWithWorker(taskList.get(0).getId(), "dummyWorker");
        this.completeExternalTaskWithWorker(taskToCheck.getId(), "aWorkerId");
        HistoricExternalTaskLog log = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().workerId("aWorkerId").singleResult();
        TestCase.assertNotNull((Object)log);
        Assertions.assertThat((String)log.getExternalTaskId()).isEqualTo((Object)taskToCheck.getId());
    }

    @Test
    public void testQueryFailsByInvalidWorkerId() {
        ExternalTask task = this.startExternalTaskProcess();
        this.completeExternalTask(task.getId());
        Assertions.assertThatThrownBy(() -> this.historyService.createHistoricExternalTaskLogQuery().workerId(null).singleResult()).isInstanceOf(NotValidException.class);
    }

    @Test
    public void testQueryByNonExistingWorkerId() {
        ExternalTask task = this.startExternalTaskProcess();
        this.completeExternalTask(task.getId());
        HistoricExternalTaskLog log = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().workerId("foo").singleResult();
        TestCase.assertNull((Object)log);
    }

    @Test
    public void testQueryByErrorMessage() {
        List<ExternalTask> taskList = this.startExternalTaskProcesses(2);
        String errorMessage = "This is an important error!";
        this.reportExternalTaskFailure(taskList.get(0).getId(), "Dummy error message");
        this.reportExternalTaskFailure(taskList.get(1).getId(), errorMessage);
        HistoricExternalTaskLog log = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().errorMessage(errorMessage).singleResult();
        TestCase.assertNotNull((Object)log);
        Assertions.assertThat((String)log.getExternalTaskId()).isEqualTo((Object)taskList.get(1).getId());
    }

    @Test
    public void testQueryFailsByInvalidErrorMessage() {
        this.startExternalTaskProcess();
        Assertions.assertThatThrownBy(() -> this.historyService.createHistoricExternalTaskLogQuery().errorMessage(null).singleResult()).isInstanceOf(NotValidException.class);
    }

    @Test
    public void testQueryByNonExistingErrorMessage() {
        this.startExternalTaskProcess();
        HistoricExternalTaskLog log = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().errorMessage("asdfasdf").singleResult();
        TestCase.assertNull((Object)log);
    }

    @Test
    public void testQueryByActivityId() {
        this.startExternalTaskProcessGivenActivityId("dummyName");
        ExternalTask task = this.startExternalTaskProcess();
        HistoricExternalTaskLog log = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().activityIdIn(new String[]{"externalTask"}).singleResult();
        TestCase.assertNotNull((Object)log);
        Assertions.assertThat((String)log.getExternalTaskId()).isEqualTo((Object)task.getId());
    }

    @Test
    public void testQueryFailsByActivityIdsIsNull() {
        this.startExternalTaskProcess();
        Assertions.assertThatThrownBy(() -> this.historyService.createHistoricExternalTaskLogQuery().activityIdIn((String[])null).singleResult()).isInstanceOf(NotValidException.class);
    }

    @Test
    public void testQueryFailsByActivityIdsContainNull() {
        this.startExternalTaskProcess();
        String[] activityIdsContainNull = new String[]{"a", null, "b"};
        Assertions.assertThatThrownBy(() -> this.historyService.createHistoricExternalTaskLogQuery().activityIdIn(activityIdsContainNull).singleResult()).isInstanceOf(NotValidException.class);
    }

    @Test
    public void testQueryFailsByActivityIdsContainEmptyString() {
        this.startExternalTaskProcess();
        String[] activityIdsContainEmptyString = new String[]{"a", "", "b"};
        Assertions.assertThatThrownBy(() -> this.historyService.createHistoricExternalTaskLogQuery().activityIdIn(activityIdsContainEmptyString).singleResult()).isInstanceOf(NotValidException.class);
    }

    @Test
    public void testQueryByNonExistingActivityIds() {
        this.startExternalTaskProcess();
        HistoricExternalTaskLog log = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().activityIdIn(new String[]{"foo"}).singleResult();
        TestCase.assertNull((Object)log);
    }

    @Test
    public void testQueryByActivityInstanceIds() {
        this.startExternalTaskProcessGivenActivityId("dummyName");
        ExternalTask task = this.startExternalTaskProcess();
        String activityInstanceId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("externalTask").singleResult()).getId();
        HistoricExternalTaskLog log = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().activityInstanceIdIn(new String[]{activityInstanceId}).singleResult();
        TestCase.assertNotNull((Object)log);
        Assertions.assertThat((String)log.getExternalTaskId()).isEqualTo((Object)task.getId());
    }

    @Test
    public void testQueryFailsByActivityInstanceIdsIsNull() {
        this.startExternalTaskProcess();
        Assertions.assertThatThrownBy(() -> this.historyService.createHistoricExternalTaskLogQuery().activityInstanceIdIn((String[])null).singleResult()).isInstanceOf(NotValidException.class);
    }

    @Test
    public void testQueryFailsByActivityInstanceIdsContainNull() {
        this.startExternalTaskProcess();
        String[] activityIdsContainNull = new String[]{"a", null, "b"};
        Assertions.assertThatThrownBy(() -> this.historyService.createHistoricExternalTaskLogQuery().activityInstanceIdIn(activityIdsContainNull).singleResult()).isInstanceOf(NotValidException.class);
    }

    @Test
    public void testQueryFailsByActivityInstanceIdsContainEmptyString() {
        this.startExternalTaskProcess();
        String[] activityIdsContainEmptyString = new String[]{"a", "", "b"};
        Assertions.assertThatThrownBy(() -> this.historyService.createHistoricExternalTaskLogQuery().activityInstanceIdIn(activityIdsContainEmptyString).singleResult()).isInstanceOf(NotValidException.class);
    }

    @Test
    public void testQueryByNonExistingActivityInstanceIds() {
        this.startExternalTaskProcess();
        HistoricExternalTaskLog log = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().activityInstanceIdIn(new String[]{"foo"}).singleResult();
        TestCase.assertNull((Object)log);
    }

    @Test
    public void testQueryByExecutionIds() {
        this.startExternalTaskProcesses(2);
        HistoricExternalTaskLog taskLog = this.retrieveFirstHistoricExternalTaskLog();
        HistoricExternalTaskLog log = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().executionIdIn(new String[]{taskLog.getExecutionId()}).singleResult();
        TestCase.assertNotNull((Object)log);
        Assertions.assertThat((String)log.getId()).isEqualTo((Object)taskLog.getId());
    }

    @Test
    public void testQueryFailsByExecutionIdsIsNull() {
        this.startExternalTaskProcess();
        Assertions.assertThatThrownBy(() -> this.historyService.createHistoricExternalTaskLogQuery().executionIdIn((String[])null).singleResult()).isInstanceOf(NotValidException.class);
    }

    @Test
    public void testQueryFailsByExecutionIdsContainNull() {
        this.startExternalTaskProcess();
        String[] activityIdsContainNull = new String[]{"a", null, "b"};
        Assertions.assertThatThrownBy(() -> this.historyService.createHistoricExternalTaskLogQuery().executionIdIn(activityIdsContainNull).singleResult()).isInstanceOf(NotValidException.class);
    }

    @Test
    public void testQueryFailsByExecutionIdsContainEmptyString() {
        this.startExternalTaskProcess();
        String[] activityIdsContainEmptyString = new String[]{"a", "", "b"};
        Assertions.assertThatThrownBy(() -> this.historyService.createHistoricExternalTaskLogQuery().executionIdIn(activityIdsContainEmptyString).singleResult()).isInstanceOf(NotValidException.class);
    }

    @Test
    public void testQueryByNonExistingExecutionIds() {
        this.startExternalTaskProcess();
        HistoricExternalTaskLog log = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().executionIdIn(new String[]{"foo"}).singleResult();
        TestCase.assertNull((Object)log);
    }

    @Test
    public void testQueryByProcessInstanceId() {
        this.startExternalTaskProcesses(2);
        String processInstanceId = this.retrieveFirstHistoricExternalTaskLog().getProcessInstanceId();
        HistoricExternalTaskLog log = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().processInstanceId(processInstanceId).singleResult();
        TestCase.assertNotNull((Object)log);
        Assertions.assertThat((String)log.getProcessInstanceId()).isEqualTo((Object)processInstanceId);
    }

    @Test
    public void testQueryFailsByInvalidProcessInstanceId() {
        this.startExternalTaskProcess();
        Assertions.assertThatThrownBy(() -> this.historyService.createHistoricExternalTaskLogQuery().processInstanceId(null).singleResult()).isInstanceOf(NotValidException.class);
    }

    @Test
    public void testQueryByNonExistingProcessInstanceId() {
        this.startExternalTaskProcess();
        HistoricExternalTaskLog log = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().processInstanceId("foo").singleResult();
        TestCase.assertNull((Object)log);
    }

    @Test
    public void testQueryByProcessDefinitionId() {
        this.startExternalTaskProcesses(2);
        String definitionId = this.retrieveFirstHistoricExternalTaskLog().getProcessDefinitionId();
        HistoricExternalTaskLog log = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().processDefinitionId(definitionId).singleResult();
        TestCase.assertNotNull((Object)log);
        Assertions.assertThat((String)log.getProcessDefinitionId()).isEqualTo((Object)definitionId);
    }

    @Test
    public void testQueryFailsByInvalidProcessDefinitionId() {
        this.startExternalTaskProcess();
        Assertions.assertThatThrownBy(() -> this.historyService.createHistoricExternalTaskLogQuery().processDefinitionId(null).singleResult()).isInstanceOf(NotValidException.class);
    }

    @Test
    public void testQueryByNonExistingProcessDefinitionId() {
        this.startExternalTaskProcess();
        HistoricExternalTaskLog log = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().processDefinitionId("foo").singleResult();
        TestCase.assertNull((Object)log);
    }

    @Test
    public void testQueryByProcessDefinitionKey() {
        this.startExternalTaskProcessGivenProcessDefinitionKey("dummyProcess");
        ExternalTask task = this.startExternalTaskProcessGivenProcessDefinitionKey("Process");
        HistoricExternalTaskLog log = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().processDefinitionKey(task.getProcessDefinitionKey()).singleResult();
        TestCase.assertNotNull((Object)log);
        Assertions.assertThat((String)log.getExternalTaskId()).isEqualTo((Object)task.getId());
    }

    @Test
    public void testQueryFailsByInvalidProcessDefinitionKey() {
        this.startExternalTaskProcess();
        Assertions.assertThatThrownBy(() -> this.historyService.createHistoricExternalTaskLogQuery().processDefinitionKey(null).singleResult()).isInstanceOf(NotValidException.class);
    }

    @Test
    public void testQueryByNonExistingProcessDefinitionKey() {
        this.startExternalTaskProcess();
        HistoricExternalTaskLog log = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().processDefinitionKey("foo").singleResult();
        TestCase.assertNull((Object)log);
    }

    @Test
    public void testQueryByCreationLog() {
        ExternalTask task = this.startExternalTaskProcess();
        this.completeExternalTask(task.getId());
        HistoricExternalTaskLog log = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().creationLog().singleResult();
        TestCase.assertNotNull((Object)log);
        Assertions.assertThat((String)log.getExternalTaskId()).isEqualTo((Object)task.getId());
    }

    @Test
    public void testQueryByFailureLog() {
        ExternalTask task = this.startExternalTaskProcess();
        this.reportExternalTaskFailure(task.getId(), "Dummy error message!");
        HistoricExternalTaskLog log = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().failureLog().singleResult();
        TestCase.assertNotNull((Object)log);
        Assertions.assertThat((String)log.getExternalTaskId()).isEqualTo((Object)task.getId());
    }

    @Test
    public void testQueryBySuccessLog() {
        ExternalTask task = this.startExternalTaskProcess();
        this.completeExternalTask(task.getId());
        HistoricExternalTaskLog log = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().successLog().singleResult();
        TestCase.assertNotNull((Object)log);
        Assertions.assertThat((String)log.getExternalTaskId()).isEqualTo((Object)task.getId());
    }

    @Test
    public void testQueryByDeletionLog() {
        ExternalTask task = this.startExternalTaskProcess();
        this.runtimeService.deleteProcessInstance(task.getProcessInstanceId(), null);
        HistoricExternalTaskLog log = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().deletionLog().singleResult();
        TestCase.assertNotNull((Object)log);
        Assertions.assertThat((String)log.getExternalTaskId()).isEqualTo((Object)task.getId());
    }

    @Test
    public void testQueryByLowerThanOrEqualAPriority() {
        this.startExternalTaskProcesses(5);
        List externalTaskLogs = this.historyService.createHistoricExternalTaskLogQuery().priorityLowerThanOrEquals(2L).list();
        Assertions.assertThat((int)externalTaskLogs.size()).isEqualTo(3);
        for (HistoricExternalTaskLog log : externalTaskLogs) {
            TestCase.assertTrue((log.getPriority() <= 2L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testQueryByHigherThanOrEqualAPriority() {
        this.startExternalTaskProcesses(5);
        List externalTaskLogs = this.historyService.createHistoricExternalTaskLogQuery().priorityHigherThanOrEquals(2L).list();
        Assertions.assertThat((int)externalTaskLogs.size()).isEqualTo(3);
        for (HistoricExternalTaskLog log : externalTaskLogs) {
            TestCase.assertTrue((log.getPriority() >= 2L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testQueryByPriorityRange() {
        this.startExternalTaskProcesses(5);
        List externalTaskLogs = this.historyService.createHistoricExternalTaskLogQuery().priorityLowerThanOrEquals(3L).priorityHigherThanOrEquals(1L).list();
        Assertions.assertThat((int)externalTaskLogs.size()).isEqualTo(3);
        for (HistoricExternalTaskLog log : externalTaskLogs) {
            TestCase.assertTrue((log.getPriority() <= 3L && log.getPriority() >= 1L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testQueryByDisjunctivePriorityStatements() {
        this.startExternalTaskProcesses(5);
        List externalTaskLogs = this.historyService.createHistoricExternalTaskLogQuery().priorityLowerThanOrEquals(1L).priorityHigherThanOrEquals(4L).list();
        Assertions.assertThat((int)externalTaskLogs.size()).isEqualTo(0);
    }

    protected HistoricExternalTaskLog retrieveFirstHistoricExternalTaskLog() {
        return (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().list().get(0);
    }

    protected void completeExternalTaskWithWorker(String externalTaskId, String workerId) {
        this.completeExternalTask(externalTaskId, "foo", workerId, false);
    }

    protected void completeExternalTask(String externalTaskId) {
        this.completeExternalTask(externalTaskId, "foo", "aWorkerId", false);
    }

    protected void completeExternalTask(String externalTaskId, String topic, String workerId, boolean usePriority) {
        List list = this.externalTaskService.fetchAndLock(100, workerId, usePriority).topic(topic, 300000L).execute();
        this.externalTaskService.complete(externalTaskId, workerId);
        for (LockedExternalTask lockedExternalTask : list) {
            if (lockedExternalTask.getId().equals(externalTaskId)) continue;
            this.externalTaskService.unlock(lockedExternalTask.getId());
        }
    }

    protected void reportExternalTaskFailure(String externalTaskId, String errorMessage) {
        this.reportExternalTaskFailure(externalTaskId, "foo", "aWorkerId", 1, false, errorMessage);
    }

    protected void reportExternalTaskFailure(String externalTaskId, String topic, String workerId, Integer retries, boolean usePriority, String errorMessage) {
        List list = this.externalTaskService.fetchAndLock(100, workerId, usePriority).topic(topic, 300000L).execute();
        this.externalTaskService.handleFailure(externalTaskId, workerId, errorMessage, retries.intValue(), 0L);
        for (LockedExternalTask lockedExternalTask : list) {
            this.externalTaskService.unlock(lockedExternalTask.getId());
        }
    }

    protected List<ExternalTask> startExternalTaskProcesses(int count) {
        LinkedList<ExternalTask> list = new LinkedList<ExternalTask>();
        for (int ithPrio = 0; ithPrio < count; ++ithPrio) {
            list.add(this.startExternalTaskProcessGivenPriority(ithPrio));
        }
        return list;
    }

    protected ExternalTask startExternalTaskProcessGivenTopicName(String topicName) {
        BpmnModelInstance processModelWithCustomTopic = DefaultExternalTaskModelBuilder.createDefaultExternalTaskModel().topic(topicName).build();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(processModelWithCustomTopic);
        ProcessInstance pi = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        return (ExternalTask)this.externalTaskService.createExternalTaskQuery().processInstanceId(pi.getId()).singleResult();
    }

    protected ExternalTask startExternalTaskProcessGivenActivityId(String activityId) {
        BpmnModelInstance processModelWithCustomActivityId = DefaultExternalTaskModelBuilder.createDefaultExternalTaskModel().externalTaskName(activityId).build();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(processModelWithCustomActivityId);
        ProcessInstance pi = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        return (ExternalTask)this.externalTaskService.createExternalTaskQuery().processInstanceId(pi.getId()).singleResult();
    }

    protected ExternalTask startExternalTaskProcessGivenProcessDefinitionKey(String processDefinitionKey) {
        BpmnModelInstance processModelWithCustomKey = DefaultExternalTaskModelBuilder.createDefaultExternalTaskModel().processKey(processDefinitionKey).build();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(processModelWithCustomKey);
        ProcessInstance pi = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        return (ExternalTask)this.externalTaskService.createExternalTaskQuery().processInstanceId(pi.getId()).singleResult();
    }

    protected ExternalTask startExternalTaskProcessGivenPriority(int priority) {
        BpmnModelInstance processModelWithCustomPriority = DefaultExternalTaskModelBuilder.createDefaultExternalTaskModel().priority(priority).build();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(processModelWithCustomPriority);
        ProcessInstance pi = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        return (ExternalTask)this.externalTaskService.createExternalTaskQuery().processInstanceId(pi.getId()).singleResult();
    }

    protected ExternalTask startExternalTaskProcess() {
        BpmnModelInstance oneExternalTaskProcess = DefaultExternalTaskModelBuilder.createDefaultExternalTaskModel().build();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(oneExternalTaskProcess);
        ProcessInstance pi = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        return (ExternalTask)this.externalTaskService.createExternalTaskQuery().processInstanceId(pi.getId()).singleResult();
    }
}

