/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.history;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.eximeebpms.bpm.engine.history.HistoricIdentityLinkLog;
import org.eximeebpms.bpm.engine.history.HistoricIdentityLinkLogQuery;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

@RequiredHistoryLevel(value="full")
public class HistoricIdentityLinkLogQueryTest
extends PluggableProcessEngineTest {
    private static final String A_USER_ID = "aUserId";
    private static final String A_GROUP_ID = "aGroupId";
    private static final int numberOfUsers = 3;
    private static final String A_ASSIGNER_ID = "aAssignerId";
    private static final String INVALID_USER_ID = "InvalidUserId";
    private static final String INVALID_TASK_ID = "InvalidTask";
    private static final String INVALID_GROUP_ID = "InvalidGroupId";
    private static final String INVALID_ASSIGNER_ID = "InvalidAssignerId";
    private static final String INVALID_HISTORY_EVENT_TYPE = "InvalidEventType";
    private static final String INVALID_IDENTITY_LINK_TYPE = "InvalidIdentityLinkType";
    private static final String INVALID_PROCESS_DEFINITION_ID = "InvalidProcessDefinitionId";
    private static final String INVALID_PROCESS_DEFINITION_KEY = "InvalidProcessDefinitionKey";
    private static final String GROUP_1 = "Group1";
    private static final String USER_1 = "User1";
    private static String PROCESS_DEFINITION_KEY = "oneTaskProcess";
    private static String PROCESS_DEFINITION_KEY_MULTIPLE_CANDIDATE_USER = "oneTaskProcessForHistoricIdentityLinkWithMultipleCanidateUser";
    private static final String IDENTITY_LINK_ADD = "add";
    private static final String IDENTITY_LINK_DELETE = "delete";

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryAddTaskCandidateforAddIdentityLink() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)0L);
        ProcessInstance processInstance = this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId(A_ASSIGNER_ID);
        this.taskService.addCandidateUser(taskId, A_USER_ID);
        HistoricIdentityLinkLog historicIdentityLink = (HistoricIdentityLinkLog)this.historyService.createHistoricIdentityLinkLogQuery().singleResult();
        Assert.assertEquals((Object)historicIdentityLink.getUserId(), (Object)A_USER_ID);
        Assert.assertEquals((Object)historicIdentityLink.getTaskId(), (Object)taskId);
        Assert.assertEquals((Object)historicIdentityLink.getType(), (Object)"candidate");
        Assert.assertEquals((Object)historicIdentityLink.getAssignerId(), (Object)A_ASSIGNER_ID);
        Assert.assertEquals((Object)historicIdentityLink.getGroupId(), null);
        Assert.assertEquals((Object)historicIdentityLink.getOperationType(), (Object)IDENTITY_LINK_ADD);
        Assert.assertEquals((Object)historicIdentityLink.getProcessDefinitionId(), (Object)processInstance.getProcessDefinitionId());
        Assert.assertEquals((Object)historicIdentityLink.getProcessDefinitionKey(), (Object)PROCESS_DEFINITION_KEY);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testGroupQueryTaskCandidateForAddAndDeleteIdentityLink() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)0L);
        ProcessInstance processInstance = this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId(A_ASSIGNER_ID);
        this.taskService.addCandidateGroup(taskId, A_GROUP_ID);
        HistoricIdentityLinkLog historicIdentityLink = (HistoricIdentityLinkLog)this.historyService.createHistoricIdentityLinkLogQuery().singleResult();
        Assert.assertEquals((Object)historicIdentityLink.getUserId(), null);
        Assert.assertEquals((Object)historicIdentityLink.getTaskId(), (Object)taskId);
        Assert.assertEquals((Object)historicIdentityLink.getType(), (Object)"candidate");
        Assert.assertEquals((Object)historicIdentityLink.getAssignerId(), (Object)A_ASSIGNER_ID);
        Assert.assertEquals((Object)historicIdentityLink.getGroupId(), (Object)A_GROUP_ID);
        Assert.assertEquals((Object)historicIdentityLink.getOperationType(), (Object)IDENTITY_LINK_ADD);
        Assert.assertEquals((Object)historicIdentityLink.getProcessDefinitionId(), (Object)processInstance.getProcessDefinitionId());
        Assert.assertEquals((Object)historicIdentityLink.getProcessDefinitionKey(), (Object)PROCESS_DEFINITION_KEY);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testValidIndividualQueryTaskCandidateForAddAndDeleteIdentityLink() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)0L);
        ProcessInstance processInstance = this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId(A_ASSIGNER_ID);
        this.taskService.addCandidateUser(taskId, A_USER_ID);
        this.taskService.deleteCandidateUser(taskId, A_USER_ID);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.taskId(taskId).count(), (long)2L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.type("candidate").count(), (long)2L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.userId(A_USER_ID).count(), (long)2L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.assignerId(A_ASSIGNER_ID).count(), (long)2L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.operationType(IDENTITY_LINK_DELETE).count(), (long)1L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.operationType(IDENTITY_LINK_ADD).count(), (long)1L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.processDefinitionId(processInstance.getProcessDefinitionId()).count(), (long)2L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.processDefinitionKey(PROCESS_DEFINITION_KEY).count(), (long)2L);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testValidGroupQueryTaskCandidateForAddAndDeleteIdentityLink() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)0L);
        ProcessInstance processInstance = this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId(A_ASSIGNER_ID);
        this.taskService.addCandidateUser(taskId, A_USER_ID);
        this.taskService.deleteCandidateUser(taskId, A_USER_ID);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.taskId(taskId).count(), (long)2L);
        Assert.assertEquals((long)query.type("candidate").count(), (long)2L);
        Assert.assertEquals((long)query.userId(A_USER_ID).count(), (long)2L);
        Assert.assertEquals((long)query.assignerId(A_ASSIGNER_ID).count(), (long)2L);
        Assert.assertEquals((long)query.processDefinitionId(processInstance.getProcessDefinitionId()).count(), (long)2L);
        Assert.assertEquals((long)query.processDefinitionKey(PROCESS_DEFINITION_KEY).count(), (long)2L);
        Assert.assertEquals((long)query.operationType(IDENTITY_LINK_DELETE).count(), (long)1L);
        Assert.assertEquals((long)query.operationType(IDENTITY_LINK_ADD).count(), (long)1L);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testInvalidIndividualQueryTaskCandidateForAddAndDeleteIdentityLink() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)0L);
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId(A_ASSIGNER_ID);
        this.taskService.addCandidateUser(taskId, A_USER_ID);
        this.taskService.deleteCandidateUser(taskId, A_USER_ID);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.taskId(INVALID_TASK_ID).count(), (long)0L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.type(INVALID_IDENTITY_LINK_TYPE).count(), (long)0L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.userId(INVALID_USER_ID).count(), (long)0L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.groupId(INVALID_GROUP_ID).count(), (long)0L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.assignerId(INVALID_ASSIGNER_ID).count(), (long)0L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.operationType(INVALID_HISTORY_EVENT_TYPE).count(), (long)0L);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testInvalidGroupQueryTaskCandidateForAddAndDeleteIdentityLink() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)0L);
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId(A_ASSIGNER_ID);
        this.taskService.addCandidateUser(taskId, A_USER_ID);
        this.taskService.deleteCandidateUser(taskId, A_USER_ID);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.taskId(INVALID_TASK_ID).count(), (long)0L);
        Assert.assertEquals((long)query.type(INVALID_IDENTITY_LINK_TYPE).count(), (long)0L);
        Assert.assertEquals((long)query.userId(INVALID_USER_ID).count(), (long)0L);
        Assert.assertEquals((long)query.groupId(INVALID_GROUP_ID).count(), (long)0L);
        Assert.assertEquals((long)query.assignerId(INVALID_ASSIGNER_ID).count(), (long)0L);
        Assert.assertEquals((long)query.operationType(INVALID_HISTORY_EVENT_TYPE).count(), (long)0L);
        Assert.assertEquals((long)query.processDefinitionId(INVALID_PROCESS_DEFINITION_ID).count(), (long)0L);
        Assert.assertEquals((long)query.processDefinitionKey(INVALID_PROCESS_DEFINITION_KEY).count(), (long)0L);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testShouldAddTaskOwnerForAddandDeleteIdentityLinkByTimeStamp() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)0L);
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        ClockUtil.setCurrentTime((Date)this.newYearMorning(0));
        this.identityService.setAuthenticatedUserId(A_ASSIGNER_ID);
        this.addUserIdentityLinks(taskId);
        ClockUtil.setCurrentTime((Date)this.newYearNoon(0));
        this.deleteUserIdentityLinks(taskId);
        ClockUtil.setCurrentTime((Date)this.newYearNoon(30));
        this.addUserIdentityLinks(taskId);
        ClockUtil.setCurrentTime((Date)this.newYearEvening());
        this.deleteUserIdentityLinks(taskId);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.dateBefore(this.newYearNoon(20)).count(), (long)6L);
        Assert.assertEquals((long)query.operationType(IDENTITY_LINK_ADD).count(), (long)3L);
        Assert.assertEquals((long)query.operationType(IDENTITY_LINK_DELETE).count(), (long)3L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.dateBefore(this.newYearNoon(0)).count(), (long)6L);
        Assert.assertEquals((long)query.dateAfter(this.newYearMorning(1)).count(), (long)1L);
        Assert.assertEquals((long)query.operationType(IDENTITY_LINK_ADD).count(), (long)0L);
        Assert.assertEquals((long)query.operationType(IDENTITY_LINK_DELETE).count(), (long)1L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.dateAfter(this.newYearNoon(45)).count(), (long)1L);
        Assert.assertEquals((long)query.operationType(IDENTITY_LINK_ADD).count(), (long)0L);
        Assert.assertEquals((long)query.operationType(IDENTITY_LINK_DELETE).count(), (long)1L);
        ClockUtil.setCurrentTime((Date)new Date());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryAddAndRemoveIdentityLinksForProcessDefinition() throws Exception {
        ProcessDefinition latestProcessDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).singleResult();
        Assert.assertNotNull((Object)latestProcessDef);
        List links = this.repositoryService.getIdentityLinksForProcessDefinition(latestProcessDef.getId());
        Assert.assertEquals((long)0L, (long)links.size());
        this.repositoryService.addCandidateStarterGroup(latestProcessDef.getId(), GROUP_1);
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)1L);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.processDefinitionId(latestProcessDef.getId()).count(), (long)1L);
        Assert.assertEquals((long)query.operationType(IDENTITY_LINK_ADD).count(), (long)1L);
        Assert.assertEquals((long)query.groupId(GROUP_1).count(), (long)1L);
        this.repositoryService.addCandidateStarterUser(latestProcessDef.getId(), USER_1);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.processDefinitionId(latestProcessDef.getId()).count(), (long)2L);
        Assert.assertEquals((long)query.processDefinitionKey(latestProcessDef.getKey()).count(), (long)2L);
        Assert.assertEquals((long)query.operationType(IDENTITY_LINK_ADD).count(), (long)2L);
        Assert.assertEquals((long)query.userId(USER_1).count(), (long)1L);
        this.repositoryService.deleteCandidateStarterGroup(latestProcessDef.getId(), GROUP_1);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.processDefinitionId(latestProcessDef.getId()).count(), (long)3L);
        Assert.assertEquals((long)query.processDefinitionKey(latestProcessDef.getKey()).count(), (long)3L);
        Assert.assertEquals((long)query.groupId(GROUP_1).count(), (long)2L);
        Assert.assertEquals((long)query.operationType(IDENTITY_LINK_DELETE).count(), (long)1L);
        this.repositoryService.deleteCandidateStarterUser(latestProcessDef.getId(), USER_1);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.processDefinitionId(latestProcessDef.getId()).count(), (long)4L);
        Assert.assertEquals((long)query.processDefinitionKey(latestProcessDef.getKey()).count(), (long)4L);
        Assert.assertEquals((long)query.userId(USER_1).count(), (long)2L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.operationType(IDENTITY_LINK_DELETE).count(), (long)2L);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/OneTaskProcessWithMultipleCandidateUser.bpmn20.xml"})
    @Test
    public void testHistoricIdentityLinkQueryPaging() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY_MULTIPLE_CANDIDATE_USER);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)4L, (long)query.listPage(0, 4).size());
        Assert.assertEquals((long)1L, (long)query.listPage(2, 1).size());
        Assert.assertEquals((long)2L, (long)query.listPage(1, 2).size());
        Assert.assertEquals((long)3L, (long)query.listPage(1, 4).size());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/OneTaskProcessWithMultipleCandidateUser.bpmn20.xml"})
    @Test
    public void testHistoricIdentityLinkQuerySorting() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)0L);
        this.startProcessInstance(PROCESS_DEFINITION_KEY_MULTIPLE_CANDIDATE_USER);
        Assert.assertEquals((long)4L, (long)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByAssignerId().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByTime().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByGroupId().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByType().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByOperationType().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByProcessDefinitionId().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByProcessDefinitionKey().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByTaskId().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByUserId().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByTenantId().asc()).list().size());
        Assert.assertEquals((Object)"aUser", (Object)((HistoricIdentityLinkLog)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByUserId().asc()).list().get(0)).getUserId());
        Assert.assertEquals((Object)"dUser", (Object)((HistoricIdentityLinkLog)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByUserId().asc()).list().get(3)).getUserId());
        Assert.assertEquals((long)4L, (long)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByAssignerId().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByTime().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByGroupId().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByType().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByOperationType().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByProcessDefinitionId().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByProcessDefinitionKey().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByTaskId().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByUserId().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByTenantId().desc()).list().size());
        Assert.assertEquals((Object)"dUser", (Object)((HistoricIdentityLinkLog)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByUserId().desc()).list().get(0)).getUserId());
        Assert.assertEquals((Object)"aUser", (Object)((HistoricIdentityLinkLog)((HistoricIdentityLinkLogQuery)this.historyService.createHistoricIdentityLinkLogQuery().orderByUserId().desc()).list().get(3)).getUserId());
    }

    public void addUserIdentityLinks(String taskId) {
        for (int userIndex = 1; userIndex <= 3; ++userIndex) {
            this.taskService.addUserIdentityLink(taskId, A_USER_ID + userIndex, "assignee");
        }
    }

    public void deleteUserIdentityLinks(String taskId) {
        for (int userIndex = 1; userIndex <= 3; ++userIndex) {
            this.taskService.deleteUserIdentityLink(taskId, A_USER_ID + userIndex, "assignee");
        }
    }

    public Date newYearMorning(int minutes) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(1, 2016);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, minutes);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date morning = calendar.getTime();
        return morning;
    }

    public Date newYearNoon(int minutes) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(1, 2016);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, 12);
        calendar.set(12, minutes);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date morning = calendar.getTime();
        return morning;
    }

    public Date newYearEvening() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(1, 2016);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, 21);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date morning = calendar.getTime();
        return morning;
    }

    protected ProcessInstance startProcessInstance(String key) {
        return this.runtimeService.startProcessInstanceByKey(key);
    }
}

