/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.history;

import org.eximeebpms.bpm.engine.history.HistoricTaskInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

@RequiredHistoryLevel(value="activity")
public class HistoricTaskInstanceUpdateTest
extends PluggableProcessEngineTest {
    @Deployment
    @Test
    public void testHistoricTaskInstanceUpdate() {
        this.runtimeService.startProcessInstanceByKey("HistoricTaskInstanceTest").getId();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        task.setPriority(12345);
        task.setDescription("Updated description");
        task.setName("Updated name");
        task.setAssignee("gonzo");
        this.taskService.saveTask(task);
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().count());
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult();
        Assert.assertEquals((Object)"Updated name", (Object)historicTaskInstance.getName());
        Assert.assertEquals((Object)"Updated description", (Object)historicTaskInstance.getDescription());
        Assert.assertEquals((Object)"gonzo", (Object)historicTaskInstance.getAssignee());
        Assert.assertEquals((Object)"task", (Object)historicTaskInstance.getTaskDefinitionKey());
    }
}

