/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.history;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.assertj.core.groups.Tuple;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.exception.NullValueException;
import org.eximeebpms.bpm.engine.history.HistoricActivityInstance;
import org.eximeebpms.bpm.engine.history.HistoricDetail;
import org.eximeebpms.bpm.engine.history.HistoricDetailQuery;
import org.eximeebpms.bpm.engine.history.HistoricFormField;
import org.eximeebpms.bpm.engine.history.HistoricProcessInstance;
import org.eximeebpms.bpm.engine.history.HistoricTaskInstance;
import org.eximeebpms.bpm.engine.history.HistoricVariableInstance;
import org.eximeebpms.bpm.engine.history.HistoricVariableInstanceQuery;
import org.eximeebpms.bpm.engine.history.HistoricVariableUpdate;
import org.eximeebpms.bpm.engine.history.NativeHistoricVariableInstanceQuery;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.history.HistoryLevel;
import org.eximeebpms.bpm.engine.impl.history.event.HistoryEvent;
import org.eximeebpms.bpm.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.impl.util.CollectionUtil;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.CaseExecution;
import org.eximeebpms.bpm.engine.runtime.CaseInstance;
import org.eximeebpms.bpm.engine.runtime.Execution;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.runtime.VariableInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.task.TaskQuery;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.api.runtime.TestOrderingUtil;
import org.eximeebpms.bpm.engine.test.api.runtime.util.CustomSerializable;
import org.eximeebpms.bpm.engine.test.api.runtime.util.FailingSerializable;
import org.eximeebpms.bpm.engine.test.cmmn.decisiontask.TestPojo;
import org.eximeebpms.bpm.engine.test.history.RemoveAndUpdateValueDelegate;
import org.eximeebpms.bpm.engine.test.history.SubProcessActivityStartListener;
import org.eximeebpms.bpm.engine.test.history.UpdateAndReplaceValueDelegate;
import org.eximeebpms.bpm.engine.test.history.UpdateHistoricDetailValueDelegate;
import org.eximeebpms.bpm.engine.test.history.UpdateHistoricValueDelegate;
import org.eximeebpms.bpm.engine.test.history.UpdateValueDelegate;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.eximeebpms.bpm.engine.variable.type.ValueType;
import org.eximeebpms.bpm.engine.variable.value.FileValue;
import org.eximeebpms.bpm.engine.variable.value.ObjectValue;
import org.eximeebpms.bpm.engine.variable.value.TypedValue;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.CallActivityBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.StartEventBuilder;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@RequiredHistoryLevel(value="audit")
public class HistoricVariableInstanceTest
extends PluggableProcessEngineTest {
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/orderProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/history/checkCreditProcess.bpmn20.xml"})
    @Test
    public void testOrderProcessWithCallActivity() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("orderProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task verifyCreditTask = (Task)taskQuery.singleResult();
        Assert.assertEquals((Object)"Verify credit history", (Object)verifyCreditTask.getName());
        ProcessInstance subProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(pi.getId()).singleResult();
        Assert.assertNotNull((Object)subProcessInstance);
        Assert.assertEquals((Object)pi.getId(), (Object)((ProcessInstance)this.runtimeService.createProcessInstanceQuery().subProcessInstanceId(subProcessInstance.getId()).singleResult()).getId());
        this.taskService.complete(verifyCreditTask.getId(), CollectionUtil.singletonMap((String)"creditApproved", (Object)true));
        Task prepareAndShipTask = (Task)taskQuery.singleResult();
        Assert.assertEquals((Object)"Prepare and Ship", (Object)prepareAndShipTask.getName());
    }

    @Deployment
    @Test
    public void testSimple() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("myProc");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task userTask = (Task)taskQuery.singleResult();
        Assert.assertEquals((Object)"userTask1", (Object)userTask.getName());
        this.taskService.complete(userTask.getId(), CollectionUtil.singletonMap((String)"myVar", (Object)"test789"));
        this.testRule.assertProcessEnded(processInstance.getId());
        List variables = this.historyService.createHistoricVariableInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)variables.size());
        HistoricVariableInstanceEntity historicVariable = (HistoricVariableInstanceEntity)variables.get(0);
        Assert.assertEquals((Object)"test456", (Object)historicVariable.getTextValue());
        Assert.assertEquals((long)5L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
        if (this.isFullHistoryEnabled()) {
            Assert.assertEquals((long)3L, (long)this.historyService.createHistoricDetailQuery().count());
        }
    }

    @Deployment
    @Test
    public void testSimpleNoWaitState() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("myProc");
        this.testRule.assertProcessEnded(processInstance.getId());
        List variables = this.historyService.createHistoricVariableInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)variables.size());
        HistoricVariableInstanceEntity historicVariable = (HistoricVariableInstanceEntity)variables.get(0);
        Assert.assertEquals((Object)"test456", (Object)historicVariable.getTextValue());
        Assert.assertEquals((long)4L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
        if (this.isFullHistoryEnabled()) {
            Assert.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().count());
        }
    }

    @Deployment
    @Test
    public void testParallel() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("myProc");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task userTask = (Task)taskQuery.singleResult();
        Assert.assertEquals((Object)"userTask1", (Object)userTask.getName());
        this.taskService.complete(userTask.getId(), CollectionUtil.singletonMap((String)"myVar", (Object)"test789"));
        this.testRule.assertProcessEnded(processInstance.getId());
        List variables = ((HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByVariableName().asc()).list();
        Assert.assertEquals((long)2L, (long)variables.size());
        HistoricVariableInstanceEntity historicVariable = (HistoricVariableInstanceEntity)variables.get(0);
        Assert.assertEquals((Object)"myVar", (Object)historicVariable.getName());
        Assert.assertEquals((Object)"test789", (Object)historicVariable.getTextValue());
        HistoricVariableInstanceEntity historicVariable1 = (HistoricVariableInstanceEntity)variables.get(1);
        Assert.assertEquals((Object)"myVar1", (Object)historicVariable1.getName());
        Assert.assertEquals((Object)"test456", (Object)historicVariable1.getTextValue());
        Assert.assertEquals((long)8L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
        if (this.isFullHistoryEnabled()) {
            Assert.assertEquals((long)5L, (long)this.historyService.createHistoricDetailQuery().count());
        }
    }

    @Deployment
    @Test
    public void testParallelNoWaitState() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("myProc");
        this.testRule.assertProcessEnded(processInstance.getId());
        List variables = this.historyService.createHistoricVariableInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)variables.size());
        HistoricVariableInstanceEntity historicVariable = (HistoricVariableInstanceEntity)variables.get(0);
        Assert.assertEquals((Object)"test456", (Object)historicVariable.getTextValue());
        Assert.assertEquals((long)7L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
        if (this.isFullHistoryEnabled()) {
            Assert.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().count());
        }
    }

    @Deployment
    @Test
    public void testTwoSubProcessInParallelWithinSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("twoSubProcessInParallelWithinSubProcess");
        this.testRule.assertProcessEnded(processInstance.getId());
        List variables = ((HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByVariableName().asc()).list();
        Assert.assertEquals((long)2L, (long)variables.size());
        HistoricVariableInstanceEntity historicVariable = (HistoricVariableInstanceEntity)variables.get(0);
        Assert.assertEquals((Object)"myVar", (Object)historicVariable.getName());
        Assert.assertEquals((Object)"test101112", (Object)historicVariable.getTextValue());
        Assert.assertEquals((Object)"string", (Object)historicVariable.getVariableTypeName());
        Assert.assertEquals((Object)"string", (Object)historicVariable.getTypeName());
        HistoricVariableInstanceEntity historicVariable1 = (HistoricVariableInstanceEntity)variables.get(1);
        Assert.assertEquals((Object)"myVar1", (Object)historicVariable1.getName());
        Assert.assertEquals((Object)"test789", (Object)historicVariable1.getTextValue());
        Assert.assertEquals((Object)"string", (Object)historicVariable1.getVariableTypeName());
        Assert.assertEquals((Object)"string", (Object)historicVariable1.getTypeName());
        Assert.assertEquals((long)18L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
        if (this.isFullHistoryEnabled()) {
            Assert.assertEquals((long)7L, (long)this.historyService.createHistoricDetailQuery().count());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricVariableInstanceTest.testCallSimpleSubProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/history/simpleSubProcess.bpmn20.xml"})
    @Test
    public void testHistoricVariableInstanceQuery() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callSimpleSubProcess");
        this.testRule.assertProcessEnded(processInstance.getId());
        Assert.assertEquals((long)5L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        Assert.assertEquals((long)5L, (long)this.historyService.createHistoricVariableInstanceQuery().list().size());
        Assert.assertEquals((long)5L, (long)((HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByProcessInstanceId().asc()).count());
        Assert.assertEquals((long)5L, (long)((HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByProcessInstanceId().asc()).list().size());
        Assert.assertEquals((long)5L, (long)((HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByVariableName().asc()).count());
        Assert.assertEquals((long)5L, (long)((HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByVariableName().asc()).list().size());
        Assert.assertEquals((long)5L, (long)((HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByTenantId().asc()).count());
        Assert.assertEquals((long)5L, (long)((HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByTenantId().asc()).list().size());
        Assert.assertEquals((long)5L, (long)((HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByVariableId().asc()).count());
        Assert.assertEquals((long)5L, (long)((HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByVariableId().asc()).list().size());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).count());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).list().size());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().variableName("myVar").count());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().variableName("myVar").list().size());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().variableNameLike("myVar1").count());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().variableNameLike("myVar1").list().size());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableNameLike("my\\_Var%").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableNameLike("my\\_Var%").list().size());
        List variables = this.historyService.createHistoricVariableInstanceQuery().list();
        Assert.assertEquals((long)5L, (long)variables.size());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("myVar", (Object)"test123").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("myVar", (Object)"test123").list().size());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("myVar1", (Object)"test456").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("myVar1", (Object)"test456").list().size());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("myVar", (Object)"test666").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("myVar", (Object)"test666").list().size());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("myVar1", (Object)"test666").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("myVar1", (Object)"test666").list().size());
        Assert.assertEquals((long)8L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
        if (this.isFullHistoryEnabled()) {
            Assert.assertEquals((long)6L, (long)this.historyService.createHistoricDetailQuery().count());
        }
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().variableId("non-existing").count());
        List variable = this.historyService.createHistoricVariableInstanceQuery().listPage(0, 1);
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableId(((HistoricVariableInstance)variable.get(0)).getId()).count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricVariableInstanceTest.testCallSubProcessSettingVariableOnStart.bpmn20.xml", "org/eximeebpms/bpm/engine/test/history/subProcessSetVariableOnStart.bpmn20.xml"})
    @Test
    public void testCallSubProcessSettingVariableOnStart() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callSubProcess");
        this.testRule.assertProcessEnded(processInstance.getId());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("aVariable", (Object)"aValue").count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testHistoricProcessVariableOnDeletion() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("testVar", "Hallo Christian");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "deleted");
        this.testRule.assertProcessEnded(processInstance.getId());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).variableValueEquals("testVar", (Object)"Hallo Christian").count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/standalone/history/FullHistoryTest.testVariableUpdatesAreLinkedToActivity.bpmn20.xml"})
    @Test
    public void testVariableUpdatesLinkedToActivity() throws Exception {
        if (this.isFullHistoryEnabled()) {
            ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("ProcessWithSubProcess");
            Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("test", "1");
            this.taskService.complete(task.getId(), variables);
            task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
            variables.clear();
            variables.put("test", "2");
            this.taskService.complete(task.getId(), variables);
            this.testRule.assertProcessEnded(pi.getId());
            List updates = this.historyService.createHistoricDetailQuery().variableUpdates().list();
            Assert.assertEquals((long)2L, (long)updates.size());
            HashMap<String, HistoricVariableUpdate> updatesMap = new HashMap<String, HistoricVariableUpdate>();
            HistoricVariableUpdate update = (HistoricVariableUpdate)updates.get(0);
            updatesMap.put((String)update.getValue(), update);
            update = (HistoricVariableUpdate)updates.get(1);
            updatesMap.put((String)update.getValue(), update);
            HistoricVariableUpdate update1 = (HistoricVariableUpdate)updatesMap.get("1");
            HistoricVariableUpdate update2 = (HistoricVariableUpdate)updatesMap.get("2");
            Assert.assertNotNull((Object)update1.getActivityInstanceId());
            Assert.assertNotNull((Object)update1.getExecutionId());
            HistoricActivityInstance historicActivityInstance1 = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityInstanceId(update1.getActivityInstanceId()).singleResult();
            Assert.assertEquals((Object)historicActivityInstance1.getExecutionId(), (Object)update1.getExecutionId());
            Assert.assertEquals((Object)"usertask1", (Object)historicActivityInstance1.getActivityId());
            Assert.assertNotNull((Object)update2.getActivityInstanceId());
            HistoricActivityInstance historicActivityInstance2 = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityInstanceId(update2.getActivityInstanceId()).singleResult();
            Assert.assertEquals((Object)"usertask2", (Object)historicActivityInstance2.getActivityId());
            Assert.assertFalse((boolean)historicActivityInstance2.getExecutionId().equals(update2.getExecutionId()));
        }
    }

    @Deployment
    @Test
    public void testHistoricProcessInstanceDeleteCascadesCorrectly() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("var1", "value1");
        variables.put("var2", "value2");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("myProcess", variables);
        Assert.assertNotNull((Object)processInstance);
        variables = new HashMap();
        variables.put("var3", "value3");
        variables.put("var4", "value4");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("myProcess", variables);
        Assert.assertNotNull((Object)processInstance2);
        long count = this.historyService.createHistoricVariableInstanceQuery().count();
        Assert.assertEquals((long)4L, (long)count);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "reason 1");
        this.historyService.deleteHistoricProcessInstance(processInstance.getId());
        count = this.historyService.createHistoricVariableInstanceQuery().count();
        Assert.assertEquals((long)2L, (long)count);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricVariableInstanceTest.testParallel.bpmn20.xml"})
    @Test
    public void testHistoricVariableInstanceQueryByTaskIds() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("myProc");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task userTask = (Task)taskQuery.singleResult();
        Assert.assertEquals((Object)"userTask1", (Object)userTask.getName());
        this.taskService.setVariableLocal(userTask.getId(), "taskVariable", (Object)"aCustomValue");
        this.taskService.complete(userTask.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
        List tasks = this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstance.getProcessInstanceId()).list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().taskIdIn(new String[]{((HistoricTaskInstance)tasks.get(0)).getId()}).list().size());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().taskIdIn(new String[]{((HistoricTaskInstance)tasks.get(0)).getId()}).count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricVariableInstanceTest.testParallel.bpmn20.xml"})
    @Test
    public void testHistoricVariableInstanceQueryByProcessIdIn() {
        HashMap vars = new HashMap();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("myProc", vars);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("myProc", vars);
        Assert.assertEquals((long)4L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getProcessInstanceId(), processInstance2.getProcessInstanceId()}).count());
        Assert.assertEquals((long)4L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getProcessInstanceId(), processInstance2.getProcessInstanceId()}).list().size());
        String notExistingSearch = processInstance.getProcessInstanceId() + "-notExisting";
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceIdIn(new String[]{notExistingSearch, processInstance2.getProcessInstanceId()}).count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricVariableInstanceTest.testParallel.bpmn20.xml"})
    @Test
    public void testHistoricVariableInstanceQueryByInvalidProcessIdIn() {
        HashMap vars = new HashMap();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("myProc", vars);
        try {
            this.historyService.createHistoricVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getProcessInstanceId(), null});
            Assert.fail((String)"Search by process instance ID was finished");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.historyService.createHistoricVariableInstanceQuery().processInstanceIdIn(new String[]{null, processInstance.getProcessInstanceId()});
            Assert.fail((String)"Search by process instance ID was finished");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testHistoricVariableInstanceQueryByExecutionIds() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("stringVar", "test");
        variables1.put("myVar", "test123");
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery().executionIdIn(new String[]{processInstance1.getId()});
        Assert.assertEquals((long)2L, (long)query.count());
        List variableInstances = query.list();
        Assert.assertEquals((long)2L, (long)variableInstances.size());
        for (HistoricVariableInstance variableInstance : variableInstances) {
            Assert.assertEquals((Object)processInstance1.getId(), (Object)variableInstance.getExecutionId());
        }
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("myVar", "test123");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        query = this.historyService.createHistoricVariableInstanceQuery().executionIdIn(new String[]{processInstance1.getId(), processInstance2.getId()});
        Assert.assertEquals((long)3L, (long)query.list().size());
        Assert.assertEquals((long)3L, (long)query.count());
    }

    @Test
    public void testQueryByInvalidExecutionIdIn() {
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery().executionIdIn(new String[]{"invalid"});
        Assert.assertEquals((long)0L, (long)query.count());
        try {
            this.historyService.createHistoricVariableInstanceQuery().executionIdIn((String[])null);
            Assert.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.historyService.createHistoricVariableInstanceQuery().executionIdIn(new String[]{null});
            Assert.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByInvalidTaskIdIn() {
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery().taskIdIn(new String[]{"invalid"});
        Assert.assertEquals((long)0L, (long)query.count());
        try {
            this.historyService.createHistoricVariableInstanceQuery().taskIdIn((String[])null);
            Assert.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.historyService.createHistoricVariableInstanceQuery().taskIdIn(new String[]{null});
            Assert.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryByActivityInstanceIdIn() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("stringVar", "test");
        variables1.put("myVar", "test123");
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        query.activityInstanceIdIn(new String[]{processInstance1.getId()});
        Assert.assertEquals((long)2L, (long)query.list().size());
        Assert.assertEquals((long)2L, (long)query.count());
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("myVar", "test123");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        query.activityInstanceIdIn(new String[]{processInstance1.getId(), processInstance2.getId()});
        Assert.assertEquals((long)3L, (long)query.list().size());
        Assert.assertEquals((long)3L, (long)query.count());
    }

    @Test
    public void testQueryByInvalidActivityInstanceIdIn() {
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        query.taskIdIn(new String[]{"invalid"});
        Assert.assertEquals((long)0L, (long)query.count());
        try {
            query.taskIdIn((String[])null);
            Assert.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            query.taskIdIn(new String[]{null});
            Assert.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryByVariableTypeIn() {
        HashMap<String, Object> variables1 = new HashMap<String, Object>();
        variables1.put("stringVar", "test");
        variables1.put("boolVar", true);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery().variableTypeIn(new String[]{"string"});
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((Object)((HistoricVariableInstance)query.list().get(0)).getName(), (Object)"stringVar");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryByVariableTypeInWithCapitalLetter() {
        HashMap<String, Object> variables1 = new HashMap<String, Object>();
        variables1.put("stringVar", "test");
        variables1.put("boolVar", true);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        query.variableTypeIn(new String[]{"Boolean"});
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((Object)((HistoricVariableInstance)query.list().get(0)).getName(), (Object)"boolVar");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryByVariableTypeInWithSeveralTypes() {
        HashMap<String, Object> variables1 = new HashMap<String, Object>();
        variables1.put("stringVar", "test");
        variables1.put("boolVar", true);
        variables1.put("intVar", 5);
        variables1.put("nullVar", null);
        variables1.put("pojoVar", new TestPojo("str", 0.0));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        query.variableTypeIn(new String[]{"BooLEAN", "string", "Serializable"});
        Assert.assertEquals((long)3L, (long)query.list().size());
        Assert.assertEquals((long)3L, (long)query.count());
    }

    @Test
    public void testQueryByInvalidVariableTypeIn() {
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        query.variableTypeIn(new String[]{"invalid"});
        Assert.assertEquals((long)0L, (long)query.count());
        try {
            query.variableTypeIn((String[])null);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            query.variableTypeIn(new String[]{null});
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testBinaryFetchingEnabled() {
        Task newTask = this.taskService.newTask();
        this.taskService.saveTask(newTask);
        String variableName = "binaryVariableName";
        this.taskService.setVariable(newTask.getId(), variableName, (Object)"some bytes".getBytes());
        HistoricVariableInstance variableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName(variableName).singleResult();
        Assert.assertNotNull((Object)variableInstance.getValue());
        this.taskService.deleteTask(newTask.getId(), true);
    }

    @Test
    public void testBinaryFetchingDisabled() {
        Task newTask = this.taskService.newTask();
        this.taskService.saveTask(newTask);
        String variableName = "binaryVariableName";
        this.taskService.setVariable(newTask.getId(), variableName, (Object)"some bytes".getBytes());
        HistoricVariableInstance variableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName(variableName).disableBinaryFetching().singleResult();
        Assert.assertNull((Object)variableInstance.getValue());
        this.taskService.deleteTask(newTask.getId(), true);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDisableBinaryFetchingForFileValues() {
        String fileName = "text.txt";
        String encoding = "crazy-encoding";
        String mimeType = "martini/dry";
        FileValue fileValue = (FileValue)Variables.fileValue((String)fileName).file("ABC".getBytes()).encoding(encoding).mimeType(mimeType).create();
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValueTyped("fileVar", (TypedValue)fileValue));
        HistoricVariableInstance fileVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)fileVariableInstance.getValue());
        fileVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().disableBinaryFetching().singleResult();
        Assert.assertNotNull((Object)fileVariableInstance);
        Assert.assertEquals((Object)"fileVar", (Object)fileVariableInstance.getName());
        Assert.assertNull((Object)fileVariableInstance.getValue());
        FileValue typedValue = (FileValue)fileVariableInstance.getTypedValue();
        Assert.assertNull((Object)typedValue.getValue());
        Assert.assertEquals((Object)ValueType.FILE, (Object)typedValue.getType());
        Assert.assertEquals((Object)fileName, (Object)typedValue.getFilename());
        Assert.assertEquals((Object)encoding, (Object)typedValue.getEncoding());
        Assert.assertEquals((Object)mimeType, (Object)typedValue.getMimeType());
    }

    @Test
    public void testDisableCustomObjectDeserialization() {
        Task newTask = this.taskService.newTask();
        this.taskService.saveTask(newTask);
        HashMap<String, Serializable> variables = new HashMap<String, Serializable>();
        variables.put("customSerializable", new CustomSerializable());
        variables.put("failingSerializable", new FailingSerializable());
        this.taskService.setVariables(newTask.getId(), variables);
        List variableInstances = this.historyService.createHistoricVariableInstanceQuery().disableCustomObjectDeserialization().list();
        Assert.assertEquals((long)2L, (long)variableInstances.size());
        for (HistoricVariableInstance variableInstance : variableInstances) {
            Assert.assertNull((Object)variableInstance.getErrorMessage());
            ObjectValue typedValue = (ObjectValue)variableInstance.getTypedValue();
            Assert.assertNotNull((Object)typedValue);
            Assert.assertFalse((boolean)typedValue.isDeserialized());
            try {
                typedValue.getValue();
            }
            catch (IllegalStateException e) {
                this.testRule.assertTextPresent("Object is not deserialized", e.getMessage());
            }
            Assert.assertNotNull((Object)typedValue.getValueSerialized());
        }
        this.taskService.deleteTask(newTask.getId(), true);
    }

    @Test
    public void testDisableCustomObjectDeserializationNativeQuery() {
        Task newTask = this.taskService.newTask();
        this.taskService.saveTask(newTask);
        HashMap<String, Serializable> variables = new HashMap<String, Serializable>();
        variables.put("customSerializable", new CustomSerializable());
        variables.put("failingSerializable", new FailingSerializable());
        this.taskService.setVariables(newTask.getId(), variables);
        List variableInstances = ((NativeHistoricVariableInstanceQuery)this.historyService.createNativeHistoricVariableInstanceQuery().sql("SELECT * from " + this.managementService.getTableName(HistoricVariableInstance.class))).disableCustomObjectDeserialization().list();
        Assert.assertEquals((long)2L, (long)variableInstances.size());
        for (HistoricVariableInstance variableInstance : variableInstances) {
            Assert.assertNull((Object)variableInstance.getErrorMessage());
            ObjectValue typedValue = (ObjectValue)variableInstance.getTypedValue();
            Assert.assertNotNull((Object)typedValue);
            Assert.assertFalse((boolean)typedValue.isDeserialized());
            try {
                typedValue.getValue();
            }
            catch (IllegalStateException e) {
                this.testRule.assertTextPresent("Object is not deserialized", e.getMessage());
            }
            Assert.assertNotNull((Object)typedValue.getValueSerialized());
        }
        this.taskService.deleteTask(newTask.getId(), true);
    }

    @Test
    public void testErrorMessage() {
        Task newTask = this.taskService.newTask();
        this.taskService.saveTask(newTask);
        String variableName = "failingSerializable";
        this.taskService.setVariable(newTask.getId(), variableName, (Object)new FailingSerializable());
        HistoricVariableInstance variableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName(variableName).singleResult();
        Assert.assertNull((Object)variableInstance.getValue());
        Assert.assertNotNull((Object)variableInstance.getErrorMessage());
        this.taskService.deleteTask(newTask.getId(), true);
    }

    @Deployment
    @Test
    public void testHistoricVariableInstanceRevision() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.testRule.assertProcessEnded(processInstance.getId());
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)variable);
        HistoricVariableInstanceEntity variableEntity = (HistoricVariableInstanceEntity)variable;
        Assert.assertEquals((long)0L, (long)variableEntity.getRevision());
        if (this.isFullHistoryEnabled()) {
            List details = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().orderByVariableRevision().asc()).list();
            for (HistoricDetail detail : details) {
                HistoricVariableUpdate variableDetail = (HistoricVariableUpdate)detail;
                Assert.assertEquals((long)0L, (long)variableDetail.getRevision());
            }
        }
    }

    @Deployment
    @Test
    public void testHistoricVariableInstanceRevisionAsync() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.testRule.executeAvailableJobs();
        this.testRule.assertProcessEnded(processInstance.getId());
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)variable);
        HistoricVariableInstanceEntity variableEntity = (HistoricVariableInstanceEntity)variable;
        Assert.assertEquals((long)2L, (long)variableEntity.getRevision());
        if (this.isFullHistoryEnabled()) {
            List details = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().orderByVariableRevision().asc()).list();
            int i = 0;
            for (HistoricDetail detail : details) {
                HistoricVariableUpdate variableDetail = (HistoricVariableUpdate)detail;
                Assert.assertEquals((long)i, (long)variableDetail.getRevision());
                ++i;
            }
        }
    }

    @Deployment
    @Test
    public void testImplicitVariableUpdate() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("serviceTaskProcess", (Map)Variables.createVariables().putValue("listVar", new ArrayList()).putValue("delegate", (Object)new UpdateValueDelegate()));
        List list = (List)this.runtimeService.getVariable(instance.getId(), "listVar");
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"new element", list.get(0));
        HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("listVar").singleResult();
        List historicList = (List)historicVariableInstance.getValue();
        Assert.assertNotNull((Object)historicList);
        Assert.assertEquals((long)1L, (long)historicList.size());
        Assert.assertEquals((Object)"new element", historicList.get(0));
        if (this.isFullHistoryEnabled()) {
            List historicDetails = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().variableInstanceId(historicVariableInstance.getId()).orderPartiallyByOccurrence().asc()).list();
            Assert.assertEquals((long)2L, (long)historicDetails.size());
            HistoricVariableUpdate update1 = (HistoricVariableUpdate)historicDetails.get(0);
            HistoricVariableUpdate update2 = (HistoricVariableUpdate)historicDetails.get(1);
            List value1 = (List)update1.getValue();
            Assert.assertNotNull((Object)value1);
            Assert.assertTrue((boolean)value1.isEmpty());
            List value2 = (List)update2.getValue();
            Assert.assertNotNull((Object)value2);
            Assert.assertEquals((long)1L, (long)value2.size());
            Assert.assertEquals((Object)"new element", value2.get(0));
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricVariableInstanceTest.testImplicitVariableUpdate.bpmn20.xml"})
    @Ignore
    @Test
    public void testImplicitVariableUpdateActivityInstanceId() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("serviceTaskProcess", (Map)Variables.createVariables().putValue("listVar", new ArrayList()).putValue("delegate", (Object)new UpdateValueDelegate()));
        HistoricActivityInstance historicServiceTask = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("task").singleResult();
        List list = (List)this.runtimeService.getVariable(instance.getId(), "listVar");
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"new element", list.get(0));
        HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("listVar").singleResult();
        Assert.assertEquals((Object)historicServiceTask.getId(), (Object)historicVariableInstance.getActivityInstanceId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricVariableInstanceTest.testImplicitVariableUpdate.bpmn20.xml"})
    @Ignore
    @Test
    public void testImplicitVariableUpdateAndReplacementInOneTransaction() {
        this.runtimeService.startProcessInstanceByKey("serviceTaskProcess", (Map)Variables.createVariables().putValue("listVar", new ArrayList()).putValue("delegate", (Object)new UpdateAndReplaceValueDelegate()));
        HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("listVar").singleResult();
        List historicList = (List)historicVariableInstance.getValue();
        Assert.assertNotNull((Object)historicList);
        Assert.assertEquals((long)0L, (long)historicList.size());
        if (this.isFullHistoryEnabled()) {
            List historicDetails = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().variableInstanceId(historicVariableInstance.getId()).orderPartiallyByOccurrence().asc()).list();
            Assert.assertEquals((long)3L, (long)historicDetails.size());
            HistoricVariableUpdate update1 = (HistoricVariableUpdate)historicDetails.get(0);
            HistoricVariableUpdate update2 = (HistoricVariableUpdate)historicDetails.get(1);
            HistoricVariableUpdate update3 = (HistoricVariableUpdate)historicDetails.get(2);
            List value1 = (List)update1.getValue();
            Assert.assertNotNull((Object)value1);
            Assert.assertTrue((boolean)value1.isEmpty());
            List value2 = (List)update2.getValue();
            Assert.assertNotNull((Object)value2);
            Assert.assertEquals((long)1L, (long)value2.size());
            Assert.assertEquals((Object)"new element", value2.get(0));
            List value3 = (List)update3.getValue();
            Assert.assertNotNull((Object)value3);
            Assert.assertTrue((boolean)value3.isEmpty());
        }
    }

    @RequiredHistoryLevel(value="full")
    @Test
    public void testImplicitVariableUpdateAndScopeDestroyedInOneTransaction() {
        this.testRule.deploy(((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process1").startEvent("start").serviceTask("task1").camundaExpression("${var.setValue(\"newValue\")}")).endEvent("end").done());
        this.processEngine.getRuntimeService().startProcessInstanceByKey("process1", (Map)Variables.createVariables().putValue("var", (Object)new CustomVar("initialValue")));
        HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.processEngine.getHistoryService().createHistoricVariableInstanceQuery().list().get(0);
        CustomVar var = (CustomVar)historicVariableInstance.getTypedValue().getValue();
        Assert.assertEquals((Object)"newValue", (Object)var.getValue());
        List historicDetails = ((HistoricDetailQuery)this.processEngine.getHistoryService().createHistoricDetailQuery().orderPartiallyByOccurrence().desc()).list();
        HistoricDetail historicDetail = (HistoricDetail)historicDetails.get(0);
        CustomVar typedValue = (CustomVar)((HistoricVariableUpdate)historicDetail).getTypedValue().getValue();
        Assert.assertEquals((Object)"newValue", (Object)typedValue.getValue());
    }

    @Deployment
    @Test
    public void testNoImplicitUpdateOnHistoricValues() {
        this.runtimeService.startProcessInstanceByKey("serviceTaskProcess", (Map)Variables.createVariables().putValue("listVar", new ArrayList()).putValue("delegate", (Object)new UpdateHistoricValueDelegate()));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("listVar").singleResult();
        List historicList = (List)historicVariableInstance.getValue();
        Assert.assertNotNull((Object)historicList);
        Assert.assertEquals((long)0L, (long)historicList.size());
        if (this.isFullHistoryEnabled()) {
            Assert.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().count());
            List historicDetails = this.historyService.createHistoricDetailQuery().variableUpdates().variableInstanceId(historicVariableInstance.getId()).list();
            Assert.assertEquals((long)1L, (long)historicDetails.size());
            HistoricVariableUpdate update1 = (HistoricVariableUpdate)historicDetails.get(0);
            List value1 = (List)update1.getValue();
            Assert.assertNotNull((Object)value1);
            Assert.assertTrue((boolean)value1.isEmpty());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricVariableInstanceTest.testImplicitVariableUpdate.bpmn20.xml"})
    @Test
    public void testImplicitVariableRemoveAndUpdateInOneTransaction() {
        this.runtimeService.startProcessInstanceByKey("serviceTaskProcess", (Map)Variables.createVariables().putValue("listVar", new ArrayList()).putValue("delegate", (Object)new RemoveAndUpdateValueDelegate()));
        if (this.isFullHistoryEnabled()) {
            List historicDetails = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderPartiallyByOccurrence().asc()).list();
            Iterator detailsIt = historicDetails.iterator();
            while (detailsIt.hasNext()) {
                if ("listVar".equals(((HistoricVariableUpdate)detailsIt.next()).getVariableName())) continue;
                detailsIt.remove();
            }
            Assert.assertEquals((long)2L, (long)historicDetails.size());
            HistoricVariableUpdate update1 = (HistoricVariableUpdate)historicDetails.get(0);
            List value1 = (List)update1.getValue();
            Assert.assertNotNull((Object)value1);
            Assert.assertTrue((boolean)value1.isEmpty());
            HistoricVariableUpdate update2 = (HistoricVariableUpdate)historicDetails.get(1);
            Assert.assertNull((Object)update2.getValue());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricVariableInstanceTest.testNoImplicitUpdateOnHistoricValues.bpmn20.xml"})
    @Test
    public void testNoImplicitUpdateOnHistoricDetailValues() {
        if (!this.isFullHistoryEnabled()) {
            return;
        }
        this.runtimeService.startProcessInstanceByKey("serviceTaskProcess", (Map)Variables.createVariables().putValue("listVar", new ArrayList()).putValue("delegate", (Object)new UpdateHistoricDetailValueDelegate()));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("listVar").singleResult();
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().count());
        List historicDetails = this.historyService.createHistoricDetailQuery().variableUpdates().variableInstanceId(historicVariableInstance.getId()).list();
        Assert.assertEquals((long)1L, (long)historicDetails.size());
        HistoricVariableUpdate update1 = (HistoricVariableUpdate)historicDetails.get(0);
        List value1 = (List)update1.getValue();
        Assert.assertNotNull((Object)value1);
        Assert.assertTrue((boolean)value1.isEmpty());
    }

    protected boolean isFullHistoryEnabled() {
        return this.processEngineConfiguration.getHistoryLevel().equals(HistoryLevel.HISTORY_LEVEL_FULL);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricVariableInstanceTest.testHistoricVariableInstanceRevision.bpmn20.xml"})
    @Test
    public void testVariableUpdateOrder() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.testRule.assertProcessEnded(processInstance.getId());
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)variable);
        if (this.isFullHistoryEnabled()) {
            List details = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableInstanceId(variable.getId()).orderPartiallyByOccurrence().asc()).list();
            Assert.assertEquals((long)3L, (long)details.size());
            HistoricVariableUpdate firstUpdate = (HistoricVariableUpdate)details.get(0);
            Assert.assertEquals((Object)1, (Object)firstUpdate.getValue());
            HistoricVariableUpdate secondUpdate = (HistoricVariableUpdate)details.get(1);
            Assert.assertEquals((Object)2, (Object)secondUpdate.getValue());
            Assert.assertTrue((((HistoryEvent)secondUpdate).getSequenceCounter() > ((HistoryEvent)firstUpdate).getSequenceCounter() ? 1 : 0) != 0);
            HistoricVariableUpdate thirdUpdate = (HistoricVariableUpdate)details.get(2);
            Assert.assertEquals((Object)3, (Object)thirdUpdate.getValue());
            Assert.assertTrue((((HistoryEvent)thirdUpdate).getSequenceCounter() > ((HistoryEvent)secondUpdate).getSequenceCounter() ? 1 : 0) != 0);
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricVariableInstanceTest.testHistoricVariableInstanceRevisionAsync.bpmn20.xml"})
    @Test
    public void testVariableUpdateOrderAsync() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.testRule.executeAvailableJobs();
        this.testRule.assertProcessEnded(processInstance.getId());
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)variable);
        if (this.isFullHistoryEnabled()) {
            List details = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableInstanceId(variable.getId()).orderPartiallyByOccurrence().asc()).list();
            Assert.assertEquals((long)3L, (long)details.size());
            HistoricVariableUpdate firstUpdate = (HistoricVariableUpdate)details.get(0);
            Assert.assertEquals((Object)1, (Object)firstUpdate.getValue());
            HistoricVariableUpdate secondUpdate = (HistoricVariableUpdate)details.get(1);
            Assert.assertEquals((Object)2, (Object)secondUpdate.getValue());
            Assert.assertTrue((((HistoryEvent)secondUpdate).getSequenceCounter() > ((HistoryEvent)firstUpdate).getSequenceCounter() ? 1 : 0) != 0);
            HistoricVariableUpdate thirdUpdate = (HistoricVariableUpdate)details.get(2);
            Assert.assertEquals((Object)3, (Object)thirdUpdate.getValue());
            Assert.assertTrue((((HistoryEvent)thirdUpdate).getSequenceCounter() > ((HistoryEvent)secondUpdate).getSequenceCounter() ? 1 : 0) != 0);
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testTaskVariableUpdateOrder() {
        HistoricVariableUpdate fourthUpdate;
        HistoricVariableUpdate thirdUpdate;
        HistoricVariableUpdate secondUpdate;
        HistoricVariableUpdate firstUpdate;
        List details;
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariableLocal(taskId, "myVariable", (Object)1);
        this.taskService.setVariableLocal(taskId, "myVariable", (Object)2);
        this.taskService.setVariableLocal(taskId, "myVariable", (Object)3);
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)variable);
        String variableInstanceId = variable.getId();
        if (this.isFullHistoryEnabled()) {
            details = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableInstanceId(variableInstanceId).orderPartiallyByOccurrence().asc()).list();
            Assert.assertEquals((long)3L, (long)details.size());
            firstUpdate = (HistoricVariableUpdate)details.get(0);
            Assert.assertEquals((Object)1, (Object)firstUpdate.getValue());
            secondUpdate = (HistoricVariableUpdate)details.get(1);
            Assert.assertEquals((Object)2, (Object)secondUpdate.getValue());
            Assert.assertTrue((((HistoryEvent)secondUpdate).getSequenceCounter() > ((HistoryEvent)firstUpdate).getSequenceCounter() ? 1 : 0) != 0);
            thirdUpdate = (HistoricVariableUpdate)details.get(2);
            Assert.assertEquals((Object)3, (Object)thirdUpdate.getValue());
            Assert.assertTrue((((HistoryEvent)thirdUpdate).getSequenceCounter() > ((HistoryEvent)secondUpdate).getSequenceCounter() ? 1 : 0) != 0);
        }
        this.taskService.setVariableLocal(taskId, "myVariable", (Object)"abc");
        variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)variable);
        if (this.isFullHistoryEnabled()) {
            details = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableInstanceId(variableInstanceId).orderPartiallyByOccurrence().asc()).list();
            Assert.assertEquals((long)4L, (long)details.size());
            firstUpdate = (HistoricVariableUpdate)details.get(0);
            Assert.assertEquals((Object)1, (Object)firstUpdate.getValue());
            secondUpdate = (HistoricVariableUpdate)details.get(1);
            Assert.assertEquals((Object)2, (Object)secondUpdate.getValue());
            Assert.assertTrue((((HistoryEvent)secondUpdate).getSequenceCounter() > ((HistoryEvent)firstUpdate).getSequenceCounter() ? 1 : 0) != 0);
            thirdUpdate = (HistoricVariableUpdate)details.get(2);
            Assert.assertEquals((Object)3, (Object)thirdUpdate.getValue());
            Assert.assertTrue((((HistoryEvent)thirdUpdate).getSequenceCounter() > ((HistoryEvent)secondUpdate).getSequenceCounter() ? 1 : 0) != 0);
            fourthUpdate = (HistoricVariableUpdate)details.get(3);
            Assert.assertEquals((Object)"abc", (Object)fourthUpdate.getValue());
            Assert.assertTrue((((HistoryEvent)fourthUpdate).getSequenceCounter() > ((HistoryEvent)thirdUpdate).getSequenceCounter() ? 1 : 0) != 0);
        }
        this.taskService.removeVariable(taskId, "myVariable");
        variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        Assert.assertNull((Object)variable);
        if (this.isFullHistoryEnabled()) {
            details = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableInstanceId(variableInstanceId).orderPartiallyByOccurrence().asc()).list();
            Assert.assertEquals((long)5L, (long)details.size());
            firstUpdate = (HistoricVariableUpdate)details.get(0);
            Assert.assertEquals((Object)1, (Object)firstUpdate.getValue());
            secondUpdate = (HistoricVariableUpdate)details.get(1);
            Assert.assertEquals((Object)2, (Object)secondUpdate.getValue());
            Assert.assertTrue((((HistoryEvent)secondUpdate).getSequenceCounter() > ((HistoryEvent)firstUpdate).getSequenceCounter() ? 1 : 0) != 0);
            thirdUpdate = (HistoricVariableUpdate)details.get(2);
            Assert.assertEquals((Object)3, (Object)thirdUpdate.getValue());
            Assert.assertTrue((((HistoryEvent)thirdUpdate).getSequenceCounter() > ((HistoryEvent)secondUpdate).getSequenceCounter() ? 1 : 0) != 0);
            fourthUpdate = (HistoricVariableUpdate)details.get(3);
            Assert.assertEquals((Object)"abc", (Object)fourthUpdate.getValue());
            Assert.assertTrue((((HistoryEvent)fourthUpdate).getSequenceCounter() > ((HistoryEvent)thirdUpdate).getSequenceCounter() ? 1 : 0) != 0);
            HistoricVariableUpdate fifthUpdate = (HistoricVariableUpdate)details.get(4);
            Assert.assertNull((Object)fifthUpdate.getValue());
            Assert.assertTrue((((HistoryEvent)fifthUpdate).getSequenceCounter() > ((HistoryEvent)fourthUpdate).getSequenceCounter() ? 1 : 0) != 0);
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCaseVariableUpdateOrder() {
        HistoricVariableUpdate fourthUpdate;
        HistoricVariableUpdate thirdUpdate;
        HistoricVariableUpdate secondUpdate;
        HistoricVariableUpdate firstUpdate;
        List details;
        String caseInstanceId = this.caseService.createCaseInstanceByKey("oneTaskCase").getId();
        this.caseService.setVariable(caseInstanceId, "myVariable", (Object)1);
        this.caseService.setVariable(caseInstanceId, "myVariable", (Object)2);
        this.caseService.setVariable(caseInstanceId, "myVariable", (Object)3);
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)variable);
        String variableInstanceId = variable.getId();
        if (this.isFullHistoryEnabled()) {
            details = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableInstanceId(variableInstanceId).orderPartiallyByOccurrence().asc()).list();
            Assert.assertEquals((long)3L, (long)details.size());
            firstUpdate = (HistoricVariableUpdate)details.get(0);
            Assert.assertEquals((Object)1, (Object)firstUpdate.getValue());
            secondUpdate = (HistoricVariableUpdate)details.get(1);
            Assert.assertEquals((Object)2, (Object)secondUpdate.getValue());
            Assert.assertTrue((((HistoryEvent)secondUpdate).getSequenceCounter() > ((HistoryEvent)firstUpdate).getSequenceCounter() ? 1 : 0) != 0);
            thirdUpdate = (HistoricVariableUpdate)details.get(2);
            Assert.assertEquals((Object)3, (Object)thirdUpdate.getValue());
            Assert.assertTrue((((HistoryEvent)thirdUpdate).getSequenceCounter() > ((HistoryEvent)secondUpdate).getSequenceCounter() ? 1 : 0) != 0);
        }
        this.caseService.setVariable(caseInstanceId, "myVariable", (Object)"abc");
        variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)variable);
        if (this.isFullHistoryEnabled()) {
            details = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableInstanceId(variableInstanceId).orderPartiallyByOccurrence().asc()).list();
            Assert.assertEquals((long)4L, (long)details.size());
            firstUpdate = (HistoricVariableUpdate)details.get(0);
            Assert.assertEquals((Object)1, (Object)firstUpdate.getValue());
            secondUpdate = (HistoricVariableUpdate)details.get(1);
            Assert.assertEquals((Object)2, (Object)secondUpdate.getValue());
            Assert.assertTrue((((HistoryEvent)secondUpdate).getSequenceCounter() > ((HistoryEvent)firstUpdate).getSequenceCounter() ? 1 : 0) != 0);
            thirdUpdate = (HistoricVariableUpdate)details.get(2);
            Assert.assertEquals((Object)3, (Object)thirdUpdate.getValue());
            Assert.assertTrue((((HistoryEvent)thirdUpdate).getSequenceCounter() > ((HistoryEvent)secondUpdate).getSequenceCounter() ? 1 : 0) != 0);
            fourthUpdate = (HistoricVariableUpdate)details.get(3);
            Assert.assertEquals((Object)"abc", (Object)fourthUpdate.getValue());
            Assert.assertTrue((((HistoryEvent)fourthUpdate).getSequenceCounter() > ((HistoryEvent)thirdUpdate).getSequenceCounter() ? 1 : 0) != 0);
        }
        this.caseService.removeVariable(caseInstanceId, "myVariable");
        variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        Assert.assertNull((Object)variable);
        if (this.isFullHistoryEnabled()) {
            details = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableInstanceId(variableInstanceId).orderPartiallyByOccurrence().asc()).list();
            Assert.assertEquals((long)5L, (long)details.size());
            firstUpdate = (HistoricVariableUpdate)details.get(0);
            Assert.assertEquals((Object)1, (Object)firstUpdate.getValue());
            secondUpdate = (HistoricVariableUpdate)details.get(1);
            Assert.assertEquals((Object)2, (Object)secondUpdate.getValue());
            Assert.assertTrue((((HistoryEvent)secondUpdate).getSequenceCounter() > ((HistoryEvent)firstUpdate).getSequenceCounter() ? 1 : 0) != 0);
            thirdUpdate = (HistoricVariableUpdate)details.get(2);
            Assert.assertEquals((Object)3, (Object)thirdUpdate.getValue());
            Assert.assertTrue((((HistoryEvent)thirdUpdate).getSequenceCounter() > ((HistoryEvent)secondUpdate).getSequenceCounter() ? 1 : 0) != 0);
            fourthUpdate = (HistoricVariableUpdate)details.get(3);
            Assert.assertEquals((Object)"abc", (Object)fourthUpdate.getValue());
            Assert.assertTrue((((HistoryEvent)fourthUpdate).getSequenceCounter() > ((HistoryEvent)thirdUpdate).getSequenceCounter() ? 1 : 0) != 0);
            HistoricVariableUpdate fifthUpdate = (HistoricVariableUpdate)details.get(4);
            Assert.assertNull((Object)fifthUpdate.getValue());
            Assert.assertTrue((((HistoryEvent)fifthUpdate).getSequenceCounter() > ((HistoryEvent)fourthUpdate).getSequenceCounter() ? 1 : 0) != 0);
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testSetSameVariableUpdateOrder() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariable(taskId, "myVariable", (Object)1);
        this.taskService.setVariable(taskId, "myVariable", (Object)1);
        this.taskService.setVariable(taskId, "myVariable", (Object)2);
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)variable);
        String variableInstanceId = variable.getId();
        if (this.isFullHistoryEnabled()) {
            List details = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableInstanceId(variableInstanceId).orderPartiallyByOccurrence().asc()).list();
            Assert.assertEquals((long)3L, (long)details.size());
            HistoricVariableUpdate firstUpdate = (HistoricVariableUpdate)details.get(0);
            Assert.assertEquals((Object)1, (Object)firstUpdate.getValue());
            HistoricVariableUpdate secondUpdate = (HistoricVariableUpdate)details.get(1);
            Assert.assertEquals((Object)1, (Object)secondUpdate.getValue());
            Assert.assertTrue((((HistoryEvent)secondUpdate).getSequenceCounter() > ((HistoryEvent)firstUpdate).getSequenceCounter() ? 1 : 0) != 0);
            HistoricVariableUpdate thirdUpdate = (HistoricVariableUpdate)details.get(2);
            Assert.assertEquals((Object)2, (Object)thirdUpdate.getValue());
            Assert.assertTrue((((HistoryEvent)thirdUpdate).getSequenceCounter() > ((HistoryEvent)secondUpdate).getSequenceCounter() ? 1 : 0) != 0);
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessDefinitionProperty() {
        String key = "oneTaskProcess";
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(key);
        String processInstanceId = processInstance.getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.runtimeService.setVariable(processInstanceId, "aVariable", (Object)"aValue");
        this.taskService.setVariableLocal(taskId, "aLocalVariable", (Object)"anotherValue");
        HistoricVariableInstance instance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstanceId).variableName("aVariable").singleResult();
        Assert.assertNotNull((Object)instance.getProcessDefinitionKey());
        Assert.assertEquals((Object)key, (Object)instance.getProcessDefinitionKey());
        Assert.assertNotNull((Object)instance.getProcessDefinitionId());
        Assert.assertEquals((Object)processInstance.getProcessDefinitionId(), (Object)instance.getProcessDefinitionId());
        Assert.assertNull((Object)instance.getCaseDefinitionKey());
        Assert.assertNull((Object)instance.getCaseDefinitionId());
        instance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstanceId).variableName("aLocalVariable").singleResult();
        Assert.assertNotNull((Object)instance.getProcessDefinitionKey());
        Assert.assertEquals((Object)key, (Object)instance.getProcessDefinitionKey());
        Assert.assertNotNull((Object)instance.getProcessDefinitionId());
        Assert.assertEquals((Object)processInstance.getProcessDefinitionId(), (Object)instance.getProcessDefinitionId());
        Assert.assertNull((Object)instance.getCaseDefinitionKey());
        Assert.assertNull((Object)instance.getCaseDefinitionId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCaseDefinitionProperty() {
        String key = "oneTaskCase";
        CaseInstance caseInstance = this.caseService.createCaseInstanceByKey(key);
        String caseInstanceId = caseInstance.getId();
        ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.caseService.setVariable(caseInstanceId, "aVariable", (Object)"aValue");
        this.taskService.setVariableLocal(taskId, "aLocalVariable", (Object)"anotherValue");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).variableName("aVariable").singleResult();
        Assert.assertNotNull((Object)variable);
        HistoricVariableInstance instance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().caseInstanceId(caseInstanceId).variableName("aVariable").singleResult();
        this.assertCaseVariable(key, caseInstance, instance);
        instance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().caseInstanceId(caseInstanceId).variableName("aLocalVariable").singleResult();
        this.assertCaseVariable(key, caseInstance, instance);
        instance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().caseInstanceId(caseInstanceId).variableId(variable.getId()).singleResult();
        Assert.assertNotNull((Object)instance);
        this.assertCaseVariable(key, caseInstance, instance);
    }

    protected void assertCaseVariable(String key, CaseInstance caseInstance, HistoricVariableInstance instance) {
        Assert.assertNotNull((Object)instance.getCaseDefinitionKey());
        Assert.assertEquals((Object)key, (Object)instance.getCaseDefinitionKey());
        Assert.assertNotNull((Object)instance.getCaseDefinitionId());
        Assert.assertEquals((Object)caseInstance.getCaseDefinitionId(), (Object)instance.getCaseDefinitionId());
        Assert.assertNull((Object)instance.getProcessDefinitionKey());
        Assert.assertNull((Object)instance.getProcessDefinitionId());
    }

    @Test
    public void testStandaloneTaskDefinitionProperties() {
        String taskId = "myTask";
        Task task = this.taskService.newTask(taskId);
        this.taskService.saveTask(task);
        this.taskService.setVariable(taskId, "aVariable", (Object)"anotherValue");
        HistoricVariableInstance instance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().taskIdIn(new String[]{taskId}).variableName("aVariable").singleResult();
        Assert.assertNull((Object)instance.getProcessDefinitionKey());
        Assert.assertNull((Object)instance.getProcessDefinitionId());
        Assert.assertNull((Object)instance.getCaseDefinitionKey());
        Assert.assertNull((Object)instance.getCaseDefinitionId());
        this.taskService.deleteTask(taskId, true);
    }

    @Test
    public void testTaskIdProperty() {
        String taskId = "myTask";
        Task task = this.taskService.newTask(taskId);
        this.taskService.saveTask(task);
        this.taskService.setVariable(taskId, "aVariable", (Object)"anotherValue");
        HistoricVariableInstance instance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().taskIdIn(new String[]{taskId}).variableName("aVariable").singleResult();
        Assert.assertEquals((Object)taskId, (Object)instance.getTaskId());
        this.taskService.deleteTask(taskId, true);
    }

    @Deployment
    @Test
    public void testJoinParallelGatewayLocalVariableOnLastJoiningExecution() {
        this.runtimeService.startProcessInstanceByKey("process");
        Assert.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().count());
        HistoricVariableInstance historicVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)historicVariable);
        Assert.assertEquals((Object)"testVar", (Object)historicVariable.getName());
    }

    @Deployment
    @Test
    public void testNestedJoinParallelGatewayLocalVariableOnLastJoiningExecution() {
        this.runtimeService.startProcessInstanceByKey("process");
        Assert.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().count());
        HistoricVariableInstance historicVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)historicVariable);
        Assert.assertEquals((Object)"testVar", (Object)historicVariable.getName());
    }

    @Deployment
    @Test
    public void testJoinInclusiveGatewayLocalVariableOnLastJoiningExecution() {
        this.runtimeService.startProcessInstanceByKey("process");
        Assert.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().count());
        HistoricVariableInstance historicVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)historicVariable);
        Assert.assertEquals((Object)"testVar", (Object)historicVariable.getName());
    }

    @Deployment
    @Test
    public void testNestedJoinInclusiveGatewayLocalVariableOnLastJoiningExecution() {
        this.runtimeService.startProcessInstanceByKey("process");
        Assert.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().count());
        HistoricVariableInstance historicVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)historicVariable);
        Assert.assertEquals((Object)"testVar", (Object)historicVariable.getName());
    }

    @Deployment
    @Test
    public void testForkParallelGatewayTreeCompaction() {
        this.runtimeService.startProcessInstanceByKey("process");
        Task task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task2").singleResult();
        this.runtimeService.setVariableLocal(task2Execution.getId(), "foo", (Object)"bar");
        this.taskService.complete(task1.getId());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createVariableInstanceQuery().count());
        HistoricVariableInstance historicVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)historicVariable);
        Assert.assertEquals((Object)"foo", (Object)historicVariable.getName());
    }

    @Deployment
    @Test
    public void testNestedForkParallelGatewayTreeCompaction() {
        this.runtimeService.startProcessInstanceByKey("process");
        Task task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task2").singleResult();
        this.runtimeService.setVariableLocal(task2Execution.getId(), "foo", (Object)"bar");
        this.taskService.complete(task1.getId());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createVariableInstanceQuery().count());
        HistoricVariableInstance historicVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)historicVariable);
        Assert.assertEquals((Object)"foo", (Object)historicVariable.getName());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByCaseActivityId() {
        this.caseService.createCaseInstanceByKey("oneTaskCase", (Map)Variables.putValue((String)"foo", (Object)"bar"));
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        this.caseService.setVariableLocal(caseExecution.getId(), "bar", (Object)"foo");
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery().caseActivityIdIn(new String[]{"PI_HumanTask_1"});
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((Object)"bar", (Object)((HistoricVariableInstance)query.singleResult()).getName());
        Assert.assertEquals((Object)"foo", (Object)((HistoricVariableInstance)query.singleResult()).getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    @Test
    public void testQueryByCaseActivityIds() {
        this.caseService.createCaseInstanceByKey("twoTaskCase");
        CaseExecution caseExecution1 = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        this.caseService.setVariableLocal(caseExecution1.getId(), "foo", (Object)"bar");
        CaseExecution caseExecution2 = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2").singleResult();
        this.caseService.setVariableLocal(caseExecution2.getId(), "bar", (Object)"foo");
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery().caseActivityIdIn(new String[]{"PI_HumanTask_1", "PI_HumanTask_2"});
        Assert.assertEquals((long)2L, (long)query.count());
    }

    @Test
    public void testQueryByInvalidCaseActivityIds() {
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        query.caseActivityIdIn(new String[]{"invalid"});
        Assert.assertEquals((long)0L, (long)query.count());
        try {
            query.caseActivityIdIn((String[])null);
            Assert.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
        try {
            query.caseActivityIdIn(new String[]{null});
            Assert.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
        try {
            String[] values = new String[]{"a", null, "b"};
            query.caseActivityIdIn(values);
            Assert.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    public void testSetVariableInSubProcessStartEventWithEndListener() throws Exception {
        BpmnModelInstance topProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"topProcess").startEvent().callActivity().calledElement("subProcess")).camundaIn("executionListenerCounter", "executionListenerCounter")).endEvent().done();
        BpmnModelInstance subProcess = ((StartEventBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"subProcess").startEvent().camundaAsyncBefore()).camundaExecutionListenerClass("end", "org.eximeebpms.bpm.engine.test.history.SubProcessActivityStartListener")).endEvent().done();
        org.eximeebpms.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addModelInstance("process.bpmn", topProcess).addModelInstance("subProcess.bpmn", subProcess).deploy();
        this.runtimeService.startProcessInstanceByKey("topProcess", (Map)Variables.createVariables().putValue("executionListenerCounter", (Object)1));
        this.managementService.executeJob(((Job)this.managementService.createJobQuery().active().singleResult()).getId());
        Assertions.assertThat((long)this.historyService.createHistoricVariableInstanceQuery().count()).isEqualTo(3L);
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Test
    public void testSetVariableInEndListenerOfAsyncStartEvent() throws Exception {
        BpmnModelInstance subProcess = ((StartEventBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().camundaAsyncBefore()).camundaExecutionListenerClass("end", SubProcessActivityStartListener.class.getName())).endEvent().done();
        org.eximeebpms.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addModelInstance("process.bpmn", subProcess).deploy();
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("executionListenerCounter", (Object)1));
        this.managementService.executeJob(((Job)this.managementService.createJobQuery().active().singleResult()).getId());
        Assertions.assertThat((long)this.historyService.createHistoricVariableInstanceQuery().count()).isEqualTo(2L);
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Test
    public void testSetVariableInStartListenerOfAsyncStartEvent() throws Exception {
        BpmnModelInstance subProcess = ((StartEventBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().camundaAsyncBefore()).camundaExecutionListenerClass("start", SubProcessActivityStartListener.class.getName())).endEvent().done();
        org.eximeebpms.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addModelInstance("process.bpmn", subProcess).deploy();
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("executionListenerCounter", (Object)1));
        this.managementService.executeJob(((Job)this.managementService.createJobQuery().active().singleResult()).getId());
        Assertions.assertThat((long)this.historyService.createHistoricVariableInstanceQuery().count()).isEqualTo(2L);
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/async/AsyncStartEventTest.testAsyncStartEvent.bpmn20.xml"})
    @Test
    public void testAsyncStartEventHistory() {
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            this.runtimeService.startProcessInstanceByKey("asyncStartEvent");
            HistoricProcessInstance historicInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
            Assert.assertNotNull((Object)historicInstance);
            Assert.assertNotNull((Object)historicInstance.getStartTime());
            HistoricActivityInstance historicStartEvent = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().singleResult();
            Assert.assertNull((Object)historicStartEvent);
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/async/AsyncStartEventTest.testAsyncStartEvent.bpmn20.xml"})
    @Test
    public void testAsyncStartEventVariableHistory() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("foo", "bar");
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("asyncStartEvent", variables).getId();
        VariableInstance variableFoo = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)variableFoo);
        Assert.assertEquals((Object)"foo", (Object)variableFoo.getName());
        Assert.assertEquals((Object)"bar", (Object)variableFoo.getValue());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.testRule.executeAvailableJobs();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
            Assert.assertNotNull((Object)variable);
            Assert.assertEquals((Object)"foo", (Object)variable.getName());
            Assert.assertEquals((Object)"bar", (Object)variable.getValue());
            Assert.assertEquals((Object)processInstanceId, (Object)variable.getActivityInstanceId());
            if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
                HistoricDetail historicDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().singleResult();
                Assert.assertNotNull((Object)historicDetail);
                Assert.assertEquals((Object)historicDetail.getProcessInstanceId(), (Object)historicDetail.getActivityInstanceId());
            }
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/async/AsyncStartEventTest.testMultipleAsyncStartEvents.bpmn20.xml"})
    @Test
    public void testMultipleAsyncStartEventsVariableHistory() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("foo", "bar");
        this.runtimeService.correlateMessage("newInvoiceMessage", new HashMap(), variables);
        VariableInstance variableFoo = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)variableFoo);
        Assert.assertEquals((Object)"foo", (Object)variableFoo.getName());
        Assert.assertEquals((Object)"bar", (Object)variableFoo.getValue());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.testRule.executeAvailableJobs();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            String processInstanceId = ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult()).getId();
            HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
            Assert.assertNotNull((Object)variable);
            Assert.assertEquals((Object)"foo", (Object)variable.getName());
            Assert.assertEquals((Object)"bar", (Object)variable.getValue());
            Assert.assertEquals((Object)processInstanceId, (Object)variable.getActivityInstanceId());
            if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
                HistoricDetail historicDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().singleResult();
                Assert.assertNotNull((Object)historicDetail);
                Assert.assertEquals((Object)historicDetail.getProcessInstanceId(), (Object)historicDetail.getActivityInstanceId());
            }
        }
    }

    @Test
    public void testAsyncStartEventWithAddedVariable() {
        this.testRule.deploy(((StartEventBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().camundaAsyncBefore()).endEvent().done());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)Variables.putValue((String)"var1", (Object)"foo"));
        this.runtimeService.setVariable(processInstance.getId(), "var2", (Object)"bar");
        this.testRule.executeAvailableJobs();
        this.testRule.assertProcessEnded(processInstance.getId());
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
            Assert.assertEquals((long)query.count(), (long)2L);
            HistoricVariableInstance firstVariable = (HistoricVariableInstance)query.variableName("var1").singleResult();
            Assert.assertNotNull((Object)firstVariable);
            Assert.assertEquals((Object)firstVariable.getValue(), (Object)"foo");
            Assert.assertNotNull((Object)firstVariable.getActivityInstanceId());
            HistoricVariableInstance secondVariable = (HistoricVariableInstance)query.variableName("var2").singleResult();
            Assert.assertNotNull((Object)secondVariable);
            Assert.assertEquals((Object)secondVariable.getValue(), (Object)"bar");
            Assert.assertNotNull((Object)secondVariable.getActivityInstanceId());
        }
    }

    @Test
    public void testAsyncStartEventWithChangedVariable() {
        this.testRule.deploy(((StartEventBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().camundaAsyncBefore()).endEvent().done());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)Variables.putValue((String)"var", (Object)"foo"));
        this.runtimeService.setVariable(processInstance.getId(), "var", (Object)"bar");
        this.testRule.executeAvailableJobs();
        this.testRule.assertProcessEnded(processInstance.getId());
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
            Assert.assertEquals((long)query.count(), (long)1L);
            HistoricVariableInstance variable = (HistoricVariableInstance)query.singleResult();
            Assert.assertEquals((Object)variable.getValue(), (Object)"bar");
            Assert.assertNotNull((Object)variable.getActivityInstanceId());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/async/AsyncStartEventTest.testAsyncStartEvent.bpmn20.xml"})
    @Test
    public void testSubmitForm() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("asyncStartEvent").singleResult()).getId();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("foo", "bar");
        this.formService.submitStartForm(processDefinitionId, properties);
        VariableInstance variableFoo = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)variableFoo);
        Assert.assertEquals((Object)"foo", (Object)variableFoo.getName());
        Assert.assertEquals((Object)"bar", (Object)variableFoo.getValue());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.testRule.executeAvailableJobs();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            String processInstanceId = ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult()).getId();
            HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
            Assert.assertNotNull((Object)variable);
            Assert.assertEquals((Object)"foo", (Object)variable.getName());
            Assert.assertEquals((Object)"bar", (Object)variable.getValue());
            Assert.assertEquals((Object)processInstanceId, (Object)variable.getActivityInstanceId());
            if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
                HistoricFormField historicFormUpdate = (HistoricFormField)this.historyService.createHistoricDetailQuery().formFields().singleResult();
                Assert.assertNotNull((Object)historicFormUpdate);
                Assert.assertEquals((Object)"bar", (Object)historicFormUpdate.getFieldValue());
                HistoricVariableUpdate historicVariableUpdate = (HistoricVariableUpdate)this.historyService.createHistoricDetailQuery().variableUpdates().singleResult();
                Assert.assertNotNull((Object)historicVariableUpdate);
                Assert.assertEquals((Object)historicVariableUpdate.getProcessInstanceId(), (Object)historicVariableUpdate.getActivityInstanceId());
                Assert.assertEquals((Object)"bar", (Object)historicVariableUpdate.getValue());
            }
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/async/AsyncStartEventTest.testAsyncStartEvent.bpmn20.xml"})
    @Ignore(value="CAM-2828")
    @Test
    public void testSubmitFormHistoricUpdates() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("asyncStartEvent").singleResult()).getId();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("foo", "bar");
        this.formService.submitStartForm(processDefinitionId, properties);
        this.testRule.executeAvailableJobs();
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            String theStartActivityInstanceId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("startEvent").singleResult()).getId();
            HistoricDetail historicFormUpdate = (HistoricDetail)this.historyService.createHistoricDetailQuery().formFields().singleResult();
            Assert.assertNotNull((Object)historicFormUpdate);
            Assert.assertEquals((Object)theStartActivityInstanceId, (Object)historicFormUpdate.getActivityInstanceId());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/twoTasksProcess.bpmn20.xml"})
    @Test
    public void testSetDifferentStates() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("twoTasksProcess", (Map)Variables.createVariables().putValue("initial", (Object)"foo"));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setVariables(task.getId(), (Map)Variables.createVariables().putValue("bar", (Object)"abc"));
        this.taskService.complete(task.getId());
        this.runtimeService.removeVariable(processInstance.getId(), "bar");
        List variables = this.historyService.createHistoricVariableInstanceQuery().includeDeleted().list();
        Assert.assertEquals((long)2L, (long)variables.size());
        int createdCounter = 0;
        int deletedCounter = 0;
        for (HistoricVariableInstance variable : variables) {
            if (variable.getName().equals("initial")) {
                Assert.assertEquals((Object)"CREATED", (Object)variable.getState());
                ++createdCounter;
                continue;
            }
            if (!variable.getName().equals("bar")) continue;
            Assert.assertEquals((Object)"DELETED", (Object)variable.getState());
            ++deletedCounter;
        }
        Assert.assertEquals((long)1L, (long)createdCounter);
        Assert.assertEquals((long)1L, (long)deletedCounter);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/twoTasksProcess.bpmn20.xml"})
    @Test
    public void testQueryNotIncludeDeleted() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("twoTasksProcess", (Map)Variables.createVariables().putValue("initial", (Object)"foo"));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setVariables(task.getId(), (Map)Variables.createVariables().putValue("bar", (Object)"abc"));
        this.taskService.complete(task.getId());
        this.runtimeService.removeVariable(processInstance.getId(), "bar");
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        Assert.assertEquals((Object)"CREATED", (Object)variable.getState());
        Assert.assertEquals((Object)"initial", (Object)variable.getName());
        Assert.assertEquals((Object)"foo", (Object)variable.getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/twoTasksProcess.bpmn20.xml"})
    @Test
    public void testQueryByProcessDefinitionId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("twoTasksProcess", (Map)Variables.createVariables().putValue("initial", (Object)"foo"));
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)"initial", (Object)variable.getName());
        Assert.assertEquals((Object)"foo", (Object)variable.getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/twoTasksProcess.bpmn20.xml"})
    @Test
    public void testQueryByProcessDefinitionKey() {
        this.runtimeService.startProcessInstanceByKey("twoTasksProcess", (Map)Variables.createVariables().putValue("initial", (Object)"foo"));
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().processDefinitionKey("twoTasksProcess").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)"initial", (Object)variable.getName());
        Assert.assertEquals((Object)"foo", (Object)variable.getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/twoTasksProcess.bpmn20.xml"})
    @Test
    public void testQueryByProcessDefinitionKeyTwoInstances() {
        this.runtimeService.startProcessInstanceByKey("twoTasksProcess", (Map)Variables.createVariables().putValue("initial", (Object)"foo").putValue("vegie", (Object)"cucumber"));
        this.runtimeService.startProcessInstanceByKey("twoTasksProcess", (Map)Variables.createVariables().putValue("initial", (Object)"bar").putValue("fruit", (Object)"marakuia"));
        List variables = this.historyService.createHistoricVariableInstanceQuery().processDefinitionKey("twoTasksProcess").list();
        Assert.assertNotNull((Object)variables);
        Assert.assertEquals((long)4L, (long)variables.size());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/twoTasksProcess.bpmn20.xml"})
    @Test
    public void testQueryByProcessDefinitionKeyTwoDefinitions() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("initial", (Object)"bar"));
        this.runtimeService.startProcessInstanceByKey("twoTasksProcess", (Map)Variables.createVariables().putValue("initial", (Object)"foo"));
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().processDefinitionKey("twoTasksProcess").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)"initial", (Object)variable.getName());
        Assert.assertEquals((Object)"foo", (Object)variable.getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryByProcessInstanceIdAndVariableId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("initial", (Object)"bar"));
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("initial").singleResult();
        Assert.assertNotNull((Object)variable);
        HistoricVariableInstance historyVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).variableId(variable.getId()).singleResult();
        Assert.assertNotNull((Object)historyVariable);
        Assert.assertEquals((Object)"initial", (Object)historyVariable.getName());
        Assert.assertEquals((Object)"bar", (Object)historyVariable.getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testVariableCreateTime() throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss.SSS");
        Date fixedDate = sdf.parse("01/01/2001 01:01:01.000");
        ClockUtil.setCurrentTime((Date)fixedDate);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        Assert.assertEquals((Object)fixedDate, (Object)variable.getCreateTime());
        ClockUtil.setCurrentTime((Date)new Date());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testVariableNameEqualsIgnoreCase() {
        HashMap<String, String> variables = new HashMap<String, String>();
        String variableName = "variableName";
        variables.put(variableName, "variableValue");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        HistoricVariableInstance instance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName(variableName).singleResult();
        HistoricVariableInstance instanceIgnoreCase = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName(variableName.toLowerCase()).singleResult();
        HistoricVariableInstance instanceIgnoreCaseMatchIgnoreCase = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName(variableName.toLowerCase()).matchVariableNamesIgnoreCase().singleResult();
        Assertions.assertThat((Object)instance).isNotNull();
        Assertions.assertThat((Object)instanceIgnoreCase).isNull();
        Assertions.assertThat((Object)instanceIgnoreCaseMatchIgnoreCase).isNotNull();
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testVariableValueEqualsIgnoreCase() {
        HashMap<String, String> variables = new HashMap<String, String>();
        String variableName = "variableName";
        String variableValue = "variableValue";
        variables.put(variableName, variableValue);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        HistoricVariableInstance instance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals(variableName, (Object)variableValue).singleResult();
        HistoricVariableInstance instanceIgnoreCase = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals(variableName, (Object)variableValue.toLowerCase()).singleResult();
        HistoricVariableInstance instanceIgnoreCaseMatchIgnoreCase = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals(variableName, (Object)variableValue.toLowerCase()).matchVariableValuesIgnoreCase().singleResult();
        Assertions.assertThat((Object)instance).isNotNull();
        Assertions.assertThat((Object)instanceIgnoreCase).isNull();
        Assertions.assertThat((Object)instanceIgnoreCaseMatchIgnoreCase).isNotNull();
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testVariableNameAndValueEqualsIgnoreCase() {
        HashMap<String, String> variables = new HashMap<String, String>();
        String variableName = "variableName";
        String variableValue = "variableValue";
        variables.put(variableName, variableValue);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        HistoricVariableInstance instance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals(variableName, (Object)variableValue).singleResult();
        HistoricVariableInstance instanceIgnoreCase = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals(variableName.toLowerCase(), (Object)variableValue.toLowerCase()).singleResult();
        HistoricVariableInstance instanceIgnoreCaseMatchNameIgnoreCase = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals(variableName.toLowerCase(), (Object)variableValue.toLowerCase()).matchVariableNamesIgnoreCase().singleResult();
        HistoricVariableInstance instanceIgnoreCaseMatchValueIgnoreCase = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals(variableName.toLowerCase(), (Object)variableValue.toLowerCase()).matchVariableValuesIgnoreCase().singleResult();
        HistoricVariableInstance instanceIgnoreCaseMatchNameAndValueIgnoreCase = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals(variableName.toLowerCase(), (Object)variableValue.toLowerCase()).matchVariableNamesIgnoreCase().matchVariableValuesIgnoreCase().singleResult();
        Assertions.assertThat((Object)instance).isNotNull();
        Assertions.assertThat((Object)instanceIgnoreCase).isNull();
        Assertions.assertThat((Object)instanceIgnoreCaseMatchNameIgnoreCase).isNull();
        Assertions.assertThat((Object)instanceIgnoreCaseMatchValueIgnoreCase).isNull();
        Assertions.assertThat((Object)instanceIgnoreCaseMatchNameAndValueIgnoreCase).isNotNull();
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testVariableNameAndValueEqualsEmptyString() {
        HashMap<String, String> variables = new HashMap<String, String>();
        String variableName = "variableName";
        String variableValue = "";
        variables.put(variableName, variableValue);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        HistoricVariableInstance instance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals(variableName, (Object)variableValue).singleResult();
        Assertions.assertThat((Object)instance).isNotNull();
        Assertions.assertThat((Object)instance.getValue()).isEqualTo((Object)"");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testVariableNameLikeIgnoreCase() {
        HashMap<String, String> variables = new HashMap<String, String>();
        String variableName = "variableName";
        String variableValue = "variableValue";
        variables.put(variableName, variableValue);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        HistoricVariableInstance instance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableNameLike("variableN%").singleResult();
        HistoricVariableInstance instanceIgnoreCase = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableNameLike("variablen%").singleResult();
        HistoricVariableInstance instanceIgnoreCaseMatchNameIgnoreCase = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableNameLike("variablen%").matchVariableNamesIgnoreCase().singleResult();
        Assertions.assertThat((Object)instance).isNotNull();
        Assertions.assertThat((Object)instanceIgnoreCase).isNull();
        Assertions.assertThat((Object)instanceIgnoreCaseMatchNameIgnoreCase).isNotNull();
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void shouldQueryByVariableNamesWithOneVariableName() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("my-variable-name-one", "my-variable-value-one");
        variables.put("my-variable-name-two", "my-variable-value-two");
        variables.put("my-variable-name-three", "my-variable-value-three");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        List instances = this.historyService.createHistoricVariableInstanceQuery().variableNameIn(new String[]{"my-variable-name-one"}).list();
        Assertions.assertThat((List)instances).extracting(new String[]{"name", "value"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"my-variable-name-one", "my-variable-value-one"})});
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void shouldQueryByVariableNamesWithTwoVariableNames() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("my-variable-name-one", "my-variable-value-one");
        variables.put("my-variable-name-two", "my-variable-value-two");
        variables.put("my-variable-name-three", "my-variable-value-three");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        List instances = this.historyService.createHistoricVariableInstanceQuery().variableNameIn(new String[]{"my-variable-name-one", "my-variable-name-two"}).list();
        Assertions.assertThat((List)instances).extracting(new String[]{"name", "value"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"my-variable-name-one", "my-variable-value-one"}), Assertions.tuple((Object[])new Object[]{"my-variable-name-two", "my-variable-value-two"})});
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void shouldThrowExceptionWhenQueryByVariableNamesWithNullString() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ThrowableAssert.ThrowingCallable throwingCallable = () -> this.historyService.createHistoricVariableInstanceQuery().variableNameIn(new String[]{null});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(NullValueException.class)).hasMessage("Variable names contains null value");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void shouldThrowExceptionWhenQueryByVariableNamesWithNullArrayString() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ThrowableAssert.ThrowingCallable throwingCallable = () -> this.historyService.createHistoricVariableInstanceQuery().variableNameIn((String[])null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(NullValueException.class)).hasMessage("Variable names is null");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricVariableInstanceTest.testCallSimpleSubProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/history/simpleSubProcess.bpmn20.xml"})
    @Test
    public void shouldBeCorrectlySortedWhenSortingByVariableId() {
        this.runtimeService.startProcessInstanceByKey("callSimpleSubProcess");
        List historicVariableInstances = ((HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByVariableId().asc()).list();
        Assert.assertEquals((long)5L, (long)historicVariableInstances.size());
        TestOrderingUtil.verifySorting(historicVariableInstances, TestOrderingUtil.propertyComparator(HistoricVariableInstance::getId));
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricVariableInstanceTest.testCallSimpleSubProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/history/simpleSubProcess.bpmn20.xml"})
    @Test
    public void shouldBeCorrectlySortedWhenSortingByVariableCreationTime() {
        this.runtimeService.startProcessInstanceByKey("callSimpleSubProcess");
        List historicVariableInstancesAsc = ((HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByCreationTime().asc()).list();
        List historicVariableInstancesDesc = ((HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByCreationTime().desc()).list();
        Assert.assertEquals((long)5L, (long)historicVariableInstancesAsc.size());
        Assert.assertEquals((long)5L, (long)historicVariableInstancesDesc.size());
        TestOrderingUtil.verifySorting(historicVariableInstancesAsc, TestOrderingUtil.propertyComparator(HistoricVariableInstance::getCreateTime));
        TestOrderingUtil.verifySorting(historicVariableInstancesDesc, TestOrderingUtil.inverted(TestOrderingUtil.propertyComparator(HistoricVariableInstance::getCreateTime)));
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricVariableInstanceTest.testCallSimpleSubProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/history/simpleSubProcess.bpmn20.xml"})
    @Test
    public void shouldQueryByCreatedAfter() {
        Calendar creationDate = Calendar.getInstance();
        ClockUtil.setCurrentTime((Date)creationDate.getTime());
        this.runtimeService.startProcessInstanceByKey("callSimpleSubProcess");
        creationDate.add(10, 1);
        ClockUtil.setCurrentTime((Date)creationDate.getTime());
        this.runtimeService.startProcessInstanceByKey("callSimpleSubProcess");
        List variablesCreatedAfter = this.historyService.createHistoricVariableInstanceQuery().createdAfter(creationDate.getTime()).list();
        List allVariables = this.historyService.createHistoricVariableInstanceQuery().list();
        Assert.assertEquals((long)5L, (long)variablesCreatedAfter.size());
        Assert.assertEquals((long)10L, (long)allVariables.size());
    }

    public static class CustomVar
    implements Serializable {
        private String value;

        public CustomVar(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

