/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.history;

import java.util.Objects;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.eximeebpms.bpm.engine.impl.util.StringUtil;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.history.HistoryEventVerifier;
import org.eximeebpms.bpm.engine.test.history.TestEventHandler;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

@RequiredHistoryLevel(value="full")
public class HistoryEventDataTest {
    private static final TestEventHandler HANDLER = new TestEventHandler();
    @Rule
    public HistoryEventVerifier verifier = new HistoryEventVerifier(HANDLER);
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(c -> c.setHistoryEventHandler((HistoryEventHandler)HANDLER));
    private RuntimeService runtimeService;
    @Rule
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);

    @Before
    public void initServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.verifier.historyEventIs("!= null", Objects::nonNull);
        this.verifier.historyEventHas("processDefinitionId != null", evt -> StringUtil.hasText((String)evt.getProcessDefinitionId()));
        this.verifier.historyEventHas("processDefinitionKey != null", evt -> StringUtil.hasText((String)evt.getProcessDefinitionKey()));
        this.verifier.historyEventHas("processDefinitionName != null", evt -> StringUtil.hasText((String)evt.getProcessDefinitionName()));
        this.verifier.historyEventHas("processDefinitionVersion != null", evt -> evt.getProcessDefinitionVersion() != null);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/threeTasksProcess.bpmn20.xml"})
    public void verify() {
        this.runtimeService.startProcessInstanceByKey("threeTasksProcess");
    }
}

