/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.jobexecutor;

import java.io.FileNotFoundException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.ProcessEngineConfiguration;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.ProcessEngines;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.impl.Page;
import org.eximeebpms.bpm.engine.impl.cmd.AcquireJobsCmd;
import org.eximeebpms.bpm.engine.impl.cmd.DeleteJobsCmd;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandExecutor;
import org.eximeebpms.bpm.engine.impl.jobexecutor.AcquiredJobs;
import org.eximeebpms.bpm.engine.impl.jobexecutor.JobExecutor;
import org.eximeebpms.bpm.engine.impl.persistence.entity.AcquirableJobEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.MessageEntity;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DeploymentAwareJobExecutorTest
extends PluggableProcessEngineTest {
    protected ProcessEngine otherProcessEngine = null;

    @Before
    public void setUp() throws Exception {
        this.processEngineConfiguration.setJobExecutorDeploymentAware(true);
    }

    @After
    public void tearDown() throws Exception {
        this.processEngineConfiguration.setJobExecutorDeploymentAware(false);
        this.closeDownProcessEngine();
    }

    protected void closeDownProcessEngine() {
        if (this.otherProcessEngine != null) {
            this.otherProcessEngine.close();
            ProcessEngines.unregister((ProcessEngine)this.otherProcessEngine);
            this.otherProcessEngine = null;
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml"})
    @Test
    public void testProcessingOfJobsWithMatchingDeployment() {
        String deploymentId = ((org.eximeebpms.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        Set registeredDeployments = this.managementService.getRegisteredDeployments();
        Assert.assertEquals((long)1L, (long)registeredDeployments.size());
        Assert.assertTrue((boolean)registeredDeployments.contains(deploymentId));
        Job executableJob = (Job)this.managementService.createJobQuery().singleResult();
        String otherDeploymentId = this.deployAndInstantiateWithNewEngineConfiguration("org/eximeebpms/bpm/engine/test/jobexecutor/simpleAsyncProcessVersion2.bpmn20.xml");
        List jobs = this.managementService.createJobQuery().list();
        Assert.assertEquals((long)2L, (long)jobs.size());
        HashSet<String> jobDeploymentIds = new HashSet<String>();
        jobDeploymentIds.add(((Job)jobs.get(0)).getDeploymentId());
        jobDeploymentIds.add(((Job)jobs.get(1)).getDeploymentId());
        Assert.assertTrue((boolean)jobDeploymentIds.contains(deploymentId));
        Assert.assertTrue((boolean)jobDeploymentIds.contains(otherDeploymentId));
        AcquiredJobs acquiredJobs = this.getExecutableJobs(this.processEngineConfiguration.getJobExecutor());
        Assert.assertEquals((long)1L, (long)acquiredJobs.size());
        Assert.assertTrue((boolean)acquiredJobs.contains(executableJob.getId()));
        this.repositoryService.deleteDeployment(otherDeploymentId, true);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml"})
    @Test
    public void testExplicitDeploymentRegistration() {
        this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        String otherDeploymentId = this.deployAndInstantiateWithNewEngineConfiguration("org/eximeebpms/bpm/engine/test/jobexecutor/simpleAsyncProcessVersion2.bpmn20.xml");
        this.processEngine.getManagementService().registerDeploymentForJobExecutor(otherDeploymentId);
        List jobs = this.managementService.createJobQuery().list();
        AcquiredJobs acquiredJobs = this.getExecutableJobs(this.processEngineConfiguration.getJobExecutor());
        Assert.assertEquals((long)2L, (long)acquiredJobs.size());
        for (Job job : jobs) {
            Assert.assertTrue((boolean)acquiredJobs.contains(job.getId()));
        }
        this.repositoryService.deleteDeployment(otherDeploymentId, true);
    }

    @Test
    public void testRegistrationOfNonExistingDeployment() {
        String nonExistingDeploymentId = "some non-existing id";
        try {
            this.processEngine.getManagementService().registerDeploymentForJobExecutor(nonExistingDeploymentId);
            Assert.fail((String)"Registering a non-existing deployment should not succeed");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Deployment " + nonExistingDeploymentId + " does not exist", e.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml"})
    @Test
    public void testDeploymentUnregistrationOnUndeployment() {
        String deploymentId = ((org.eximeebpms.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        Assert.assertEquals((long)1L, (long)this.managementService.getRegisteredDeployments().size());
        this.repositoryService.deleteDeployment(deploymentId, true);
        Assert.assertEquals((long)0L, (long)this.managementService.getRegisteredDeployments().size());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml"})
    @Test
    public void testNoUnregistrationOnFailingUndeployment() {
        String deploymentId = ((org.eximeebpms.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        try {
            this.repositoryService.deleteDeployment(deploymentId, false);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((long)1L, (long)this.managementService.getRegisteredDeployments().size());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml"})
    @Test
    public void testExplicitDeploymentUnregistration() {
        String deploymentId = ((org.eximeebpms.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        this.processEngine.getManagementService().unregisterDeploymentForJobExecutor(deploymentId);
        AcquiredJobs acquiredJobs = this.getExecutableJobs(this.processEngineConfiguration.getJobExecutor());
        Assert.assertEquals((long)0L, (long)acquiredJobs.size());
    }

    @Test
    public void testJobsWithoutDeploymentIdAreAlwaysProcessed() {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        String messageId = (String)commandExecutor.execute((Command)new Command<String>(){

            public String execute(CommandContext commandContext) {
                MessageEntity message = new MessageEntity();
                commandContext.getJobManager().send(message);
                return message.getId();
            }
        });
        AcquiredJobs acquiredJobs = this.getExecutableJobs(this.processEngineConfiguration.getJobExecutor());
        Assert.assertEquals((long)1L, (long)acquiredJobs.size());
        Assert.assertTrue((boolean)acquiredJobs.contains(messageId));
        commandExecutor.execute((Command)new DeleteJobsCmd(messageId, true));
    }

    private AcquiredJobs getExecutableJobs(JobExecutor jobExecutor) {
        return (AcquiredJobs)this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new AcquireJobsCmd(jobExecutor));
    }

    private String deployAndInstantiateWithNewEngineConfiguration(String resource) {
        try {
            this.otherProcessEngine = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"eximeebpms.cfg.xml").buildProcessEngine();
        }
        catch (RuntimeException ex) {
            if (ex.getCause() != null && ex.getCause() instanceof FileNotFoundException) {
                this.otherProcessEngine = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"activiti.cfg.xml").buildProcessEngine();
            }
            throw ex;
        }
        RepositoryService otherRepositoryService = this.otherProcessEngine.getRepositoryService();
        String deploymentId = otherRepositoryService.createDeployment().addClasspathResource(resource).deploy().getId();
        ProcessDefinition newDefinition = (ProcessDefinition)otherRepositoryService.createProcessDefinitionQuery().deploymentId(deploymentId).singleResult();
        this.otherProcessEngine.getRuntimeService().startProcessInstanceById(newDefinition.getId());
        return deploymentId;
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/jobexecutor/processWithTimerCatch.bpmn20.xml"})
    @Test
    public void testIntermediateTimerEvent() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Set registeredDeployments = this.processEngineConfiguration.getRegisteredDeployments();
        Job existingJob = (Job)this.managementService.createJobQuery().singleResult();
        ClockUtil.setCurrentTime((Date)new Date(System.currentTimeMillis() + 61000L));
        List<AcquirableJobEntity> acquirableJobs = this.findAcquirableJobs();
        Assert.assertEquals((long)1L, (long)acquirableJobs.size());
        Assert.assertEquals((Object)existingJob.getId(), (Object)acquirableJobs.get(0).getId());
        registeredDeployments.clear();
        acquirableJobs = this.findAcquirableJobs();
        Assert.assertEquals((long)0L, (long)acquirableJobs.size());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/jobexecutor/processWithTimerStart.bpmn20.xml"})
    @Test
    public void testTimerStartEvent() {
        Set registeredDeployments = this.processEngineConfiguration.getRegisteredDeployments();
        Job existingJob = (Job)this.managementService.createJobQuery().singleResult();
        ClockUtil.setCurrentTime((Date)new Date(System.currentTimeMillis() + 1000L));
        List<AcquirableJobEntity> acquirableJobs = this.findAcquirableJobs();
        Assert.assertEquals((long)1L, (long)acquirableJobs.size());
        Assert.assertEquals((Object)existingJob.getId(), (Object)acquirableJobs.get(0).getId());
        registeredDeployments.clear();
        acquirableJobs = this.findAcquirableJobs();
        Assert.assertEquals((long)0L, (long)acquirableJobs.size());
    }

    protected List<AcquirableJobEntity> findAcquirableJobs() {
        return (List)this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<List<AcquirableJobEntity>>(){

            public List<AcquirableJobEntity> execute(CommandContext commandContext) {
                return commandContext.getJobManager().findNextJobsToExecute(new Page(0, 100));
            }
        });
    }
}

