/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.jobexecutor;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eximeebpms.bpm.engine.history.HistoricJobLog;
import org.eximeebpms.bpm.engine.impl.cmd.AcquireJobsCmd;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandExecutor;
import org.eximeebpms.bpm.engine.impl.jobexecutor.AcquiredJobs;
import org.eximeebpms.bpm.engine.impl.jobexecutor.ExecuteJobHelper;
import org.eximeebpms.bpm.engine.impl.jobexecutor.JobExecutor;
import org.eximeebpms.bpm.engine.impl.persistence.entity.MessageEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.TimerEntity;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.test.jobexecutor.JobExecutorTestCase;
import org.junit.Assert;
import org.junit.Test;

public class JobExecutorCmdHappyTest
extends JobExecutorTestCase {
    static final long SOME_TIME = 928374923546L;
    static final long SECOND = 1000L;

    @Test
    public void testJobCommandsWithMessage() {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        JobExecutor jobExecutor = this.processEngineConfiguration.getJobExecutor();
        String jobId = (String)commandExecutor.execute((Command)new Command<String>(){

            public String execute(CommandContext commandContext) {
                MessageEntity message = JobExecutorCmdHappyTest.this.createTweetMessage("i'm coding a test");
                commandContext.getJobManager().send(message);
                return message.getId();
            }
        });
        AcquiredJobs acquiredJobs = (AcquiredJobs)commandExecutor.execute((Command)new AcquireJobsCmd(jobExecutor));
        List jobIdsList = acquiredJobs.getJobIdBatches();
        Assert.assertEquals((long)1L, (long)jobIdsList.size());
        List jobIds = (List)jobIdsList.get(0);
        ArrayList<String> expectedJobIds = new ArrayList<String>();
        expectedJobIds.add(jobId);
        Assert.assertEquals(expectedJobIds, new ArrayList(jobIds));
        Assert.assertEquals((long)0L, (long)this.tweetHandler.getMessages().size());
        ExecuteJobHelper.executeJob((String)jobId, (CommandExecutor)commandExecutor);
        Assert.assertEquals((Object)"i'm coding a test", (Object)this.tweetHandler.getMessages().get(0));
        Assert.assertEquals((long)1L, (long)this.tweetHandler.getMessages().size());
        this.clearDatabase();
    }

    @Test
    public void testJobCommandsWithTimer() {
        ClockUtil.setCurrentTime((Date)new Date(928374923546L));
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        JobExecutor jobExecutor = this.processEngineConfiguration.getJobExecutor();
        String jobId = (String)commandExecutor.execute((Command)new Command<String>(){

            public String execute(CommandContext commandContext) {
                TimerEntity timer = JobExecutorCmdHappyTest.this.createTweetTimer("i'm coding a test", new Date(928374933546L));
                commandContext.getJobManager().schedule(timer);
                return timer.getId();
            }
        });
        AcquiredJobs acquiredJobs = (AcquiredJobs)commandExecutor.execute((Command)new AcquireJobsCmd(jobExecutor));
        List jobIdsList = acquiredJobs.getJobIdBatches();
        Assert.assertEquals((long)0L, (long)jobIdsList.size());
        ArrayList<String> expectedJobIds = new ArrayList<String>();
        ClockUtil.setCurrentTime((Date)new Date(928374943546L));
        acquiredJobs = (AcquiredJobs)commandExecutor.execute((Command)new AcquireJobsCmd(jobExecutor, jobExecutor.getMaxJobsPerAcquisition()));
        jobIdsList = acquiredJobs.getJobIdBatches();
        Assert.assertEquals((long)1L, (long)jobIdsList.size());
        List jobIds = (List)jobIdsList.get(0);
        expectedJobIds.add(jobId);
        Assert.assertEquals(expectedJobIds, new ArrayList(jobIds));
        Assert.assertEquals((long)0L, (long)this.tweetHandler.getMessages().size());
        ExecuteJobHelper.executeJob((String)jobId, (CommandExecutor)commandExecutor);
        Assert.assertEquals((Object)"i'm coding a test", (Object)this.tweetHandler.getMessages().get(0));
        Assert.assertEquals((long)1L, (long)this.tweetHandler.getMessages().size());
        this.clearDatabase();
    }

    protected void clearDatabase() {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                List historicJobLogs = JobExecutorCmdHappyTest.this.processEngineConfiguration.getHistoryService().createHistoricJobLogQuery().list();
                for (HistoricJobLog historicJobLog : historicJobLogs) {
                    commandContext.getHistoricJobLogManager().deleteHistoricJobLogById(historicJobLog.getId());
                }
                return null;
            }
        });
    }
}

